/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTypeVersionsRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListTypeVersionsRequest.Builder, ListTypeVersionsRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListTypeVersionsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(ListTypeVersionsRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListTypeVersionsRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTypeVersionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTypeVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> DEPRECATED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeprecatedStatus").getter(getter(ListTypeVersionsRequest::deprecatedStatusAsString))
            .setter(setter(Builder::deprecatedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecatedStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD,
            ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, DEPRECATED_STATUS_FIELD));

    private final String type;

    private final String typeName;

    private final String arn;

    private final Integer maxResults;

    private final String nextToken;

    private final String deprecatedStatus;

    private ListTypeVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.arn = builder.arn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.deprecatedStatus = builder.deprecatedStatus;
    }

    /**
     * <p>
     * The kind of the type.
     * </p>
     * <p>
     * Currently the only valid value is <code>RESOURCE</code>.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of the type.</p>
     *         <p>
     *         Currently the only valid value is <code>RESOURCE</code>.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * @see RegistryType
     */
    public final RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of the type.
     * </p>
     * <p>
     * Currently the only valid value is <code>RESOURCE</code>.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of the type.</p>
     *         <p>
     *         Currently the only valid value is <code>RESOURCE</code>.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * @see RegistryType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the type for which you want version summary information.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * 
     * @return The name of the type for which you want version summary information.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the type for which you want version summary information.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the type for which you want version summary information.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this
     * maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code>
     * request parameter to get the next set of results.
     * </p>
     * 
     * @return The maximum number of results to be returned with a single call. If the number of available results
     *         exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
     *         <code>NextToken</code> request parameter to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous paginated request didn't return all of the remaining results, the response object's
     * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action
     * again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining
     * results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.
     * </p>
     * 
     * @return If the previous paginated request didn't return all of the remaining results, the response object's
     *         <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this
     *         action again and assign that token to the request object's <code>NextToken</code> parameter. If there are
     *         no remaining results, the previous response object's <code>NextToken</code> parameter is set to
     *         <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The deprecation status of the type versions that you want to get summary information about.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LIVE</code>: The type version is registered and can be used in CloudFormation operations, dependent on its
     * provisioning behavior and visibility scope.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code>: The type version has been deregistered and can no longer be used in CloudFormation
     * operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>LIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deprecatedStatus}
     * will return {@link DeprecatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deprecatedStatusAsString}.
     * </p>
     * 
     * @return The deprecation status of the type versions that you want to get summary information about.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LIVE</code>: The type version is registered and can be used in CloudFormation operations, dependent
     *         on its provisioning behavior and visibility scope.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code>: The type version has been deregistered and can no longer be used in
     *         CloudFormation operations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>LIVE</code>.
     * @see DeprecatedStatus
     */
    public final DeprecatedStatus deprecatedStatus() {
        return DeprecatedStatus.fromValue(deprecatedStatus);
    }

    /**
     * <p>
     * The deprecation status of the type versions that you want to get summary information about.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LIVE</code>: The type version is registered and can be used in CloudFormation operations, dependent on its
     * provisioning behavior and visibility scope.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code>: The type version has been deregistered and can no longer be used in CloudFormation
     * operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>LIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deprecatedStatus}
     * will return {@link DeprecatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deprecatedStatusAsString}.
     * </p>
     * 
     * @return The deprecation status of the type versions that you want to get summary information about.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LIVE</code>: The type version is registered and can be used in CloudFormation operations, dependent
     *         on its provisioning behavior and visibility scope.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code>: The type version has been deregistered and can no longer be used in
     *         CloudFormation operations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>LIVE</code>.
     * @see DeprecatedStatus
     */
    public final String deprecatedStatusAsString() {
        return deprecatedStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(deprecatedStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypeVersionsRequest)) {
            return false;
        }
        ListTypeVersionsRequest other = (ListTypeVersionsRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(arn(), other.arn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(deprecatedStatusAsString(), other.deprecatedStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTypeVersionsRequest").add("Type", typeAsString()).add("TypeName", typeName())
                .add("Arn", arn()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("DeprecatedStatus", deprecatedStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DeprecatedStatus":
            return Optional.ofNullable(clazz.cast(deprecatedStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTypeVersionsRequest, T> g) {
        return obj -> g.apply((ListTypeVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTypeVersionsRequest> {
        /**
         * <p>
         * The kind of the type.
         * </p>
         * <p>
         * Currently the only valid value is <code>RESOURCE</code>.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param type
         *        The kind of the type.</p>
         *        <p>
         *        Currently the only valid value is <code>RESOURCE</code>.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of the type.
         * </p>
         * <p>
         * Currently the only valid value is <code>RESOURCE</code>.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param type
         *        The kind of the type.</p>
         *        <p>
         *        Currently the only valid value is <code>RESOURCE</code>.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the type for which you want version summary information.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param typeName
         *        The name of the type for which you want version summary information.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the type for which you want version summary information.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the type for which you want version summary information.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The maximum number of results to be returned with a single call. If the number of available results exceeds
         * this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         * <code>NextToken</code> request parameter to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned with a single call. If the number of available results
         *        exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         *        <code>NextToken</code> request parameter to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous paginated request didn't return all of the remaining results, the response object's
         * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this
         * action again and assign that token to the request object's <code>NextToken</code> parameter. If there are no
         * remaining results, the previous response object's <code>NextToken</code> parameter is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request didn't return all of the remaining results, the response object's
         *        <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        this action again and assign that token to the request object's <code>NextToken</code> parameter. If
         *        there are no remaining results, the previous response object's <code>NextToken</code> parameter is set
         *        to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The deprecation status of the type versions that you want to get summary information about.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LIVE</code>: The type version is registered and can be used in CloudFormation operations, dependent on
         * its provisioning behavior and visibility scope.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code>: The type version has been deregistered and can no longer be used in CloudFormation
         * operations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>LIVE</code>.
         * </p>
         * 
         * @param deprecatedStatus
         *        The deprecation status of the type versions that you want to get summary information about.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LIVE</code>: The type version is registered and can be used in CloudFormation operations,
         *        dependent on its provisioning behavior and visibility scope.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code>: The type version has been deregistered and can no longer be used in
         *        CloudFormation operations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>LIVE</code>.
         * @see DeprecatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeprecatedStatus
         */
        Builder deprecatedStatus(String deprecatedStatus);

        /**
         * <p>
         * The deprecation status of the type versions that you want to get summary information about.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LIVE</code>: The type version is registered and can be used in CloudFormation operations, dependent on
         * its provisioning behavior and visibility scope.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code>: The type version has been deregistered and can no longer be used in CloudFormation
         * operations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>LIVE</code>.
         * </p>
         * 
         * @param deprecatedStatus
         *        The deprecation status of the type versions that you want to get summary information about.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LIVE</code>: The type version is registered and can be used in CloudFormation operations,
         *        dependent on its provisioning behavior and visibility scope.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code>: The type version has been deregistered and can no longer be used in
         *        CloudFormation operations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>LIVE</code>.
         * @see DeprecatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeprecatedStatus
         */
        Builder deprecatedStatus(DeprecatedStatus deprecatedStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String type;

        private String typeName;

        private String arn;

        private Integer maxResults;

        private String nextToken;

        private String deprecatedStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypeVersionsRequest model) {
            super(model);
            type(model.type);
            typeName(model.typeName);
            arn(model.arn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            deprecatedStatus(model.deprecatedStatus);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getDeprecatedStatus() {
            return deprecatedStatus;
        }

        @Override
        public final Builder deprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
            return this;
        }

        @Override
        public final Builder deprecatedStatus(DeprecatedStatus deprecatedStatus) {
            this.deprecatedStatus(deprecatedStatus == null ? null : deprecatedStatus.toString());
            return this;
        }

        public final void setDeprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTypeVersionsRequest build() {
            return new ListTypeVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
