/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestTypeResponse extends CloudFormationResponse implements
        ToCopyableBuilder<TestTypeResponse.Builder, TestTypeResponse> {
    private static final SdkField<String> TYPE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersionArn").getter(getter(TestTypeResponse::typeVersionArn))
            .setter(setter(Builder::typeVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_VERSION_ARN_FIELD));

    private final String typeVersionArn;

    private TestTypeResponse(BuilderImpl builder) {
        super(builder);
        this.typeVersionArn = builder.typeVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the extension.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the extension.
     */
    public final String typeVersionArn() {
        return typeVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeVersionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestTypeResponse)) {
            return false;
        }
        TestTypeResponse other = (TestTypeResponse) obj;
        return Objects.equals(typeVersionArn(), other.typeVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestTypeResponse").add("TypeVersionArn", typeVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeVersionArn":
            return Optional.ofNullable(clazz.cast(typeVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestTypeResponse, T> g) {
        return obj -> g.apply((TestTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestTypeResponse> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the extension.
         * </p>
         * 
         * @param typeVersionArn
         *        The Amazon Resource Number (ARN) of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionArn(String typeVersionArn);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String typeVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TestTypeResponse model) {
            super(model);
            typeVersionArn(model.typeVersionArn);
        }

        public final String getTypeVersionArn() {
            return typeVersionArn;
        }

        @Override
        public final Builder typeVersionArn(String typeVersionArn) {
            this.typeVersionArn = typeVersionArn;
            return this;
        }

        public final void setTypeVersionArn(String typeVersionArn) {
            this.typeVersionArn = typeVersionArn;
        }

        @Override
        public TestTypeResponse build() {
            return new TestTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
