/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * [Service-managed permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that
 * are added to a target organization or organizational unit (OU).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoDeployment implements SdkPojo, Serializable, ToCopyableBuilder<AutoDeployment.Builder, AutoDeployment> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AutoDeployment::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Boolean> RETAIN_STACKS_ON_ACCOUNT_REMOVAL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RetainStacksOnAccountRemoval")
            .getter(getter(AutoDeployment::retainStacksOnAccountRemoval))
            .setter(setter(Builder::retainStacksOnAccountRemoval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainStacksOnAccountRemoval")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            RETAIN_STACKS_ON_ACCOUNT_REMOVAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Boolean retainStacksOnAccountRemoval;

    private AutoDeployment(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.retainStacksOnAccountRemoval = builder.retainStacksOnAccountRemoval;
    }

    /**
     * <p>
     * If set to <code>true</code>, StackSets automatically deploys additional stack instances to AWS Organizations
     * accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an
     * account is removed from a target organization or OU, StackSets deletes stack instances from the account in the
     * specified Regions.
     * </p>
     * 
     * @return If set to <code>true</code>, StackSets automatically deploys additional stack instances to AWS
     *         Organizations accounts that are added to a target organization or organizational unit (OU) in the
     *         specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack
     *         instances from the account in the specified Regions.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * If set to <code>true</code>, stack resources are retained when an account is removed from a target organization
     * or OU. If set to <code>false</code>, stack resources are deleted. Specify only if <code>Enabled</code> is set to
     * <code>True</code>.
     * </p>
     * 
     * @return If set to <code>true</code>, stack resources are retained when an account is removed from a target
     *         organization or OU. If set to <code>false</code>, stack resources are deleted. Specify only if
     *         <code>Enabled</code> is set to <code>True</code>.
     */
    public final Boolean retainStacksOnAccountRemoval() {
        return retainStacksOnAccountRemoval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(retainStacksOnAccountRemoval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoDeployment)) {
            return false;
        }
        AutoDeployment other = (AutoDeployment) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(retainStacksOnAccountRemoval(), other.retainStacksOnAccountRemoval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoDeployment").add("Enabled", enabled())
                .add("RetainStacksOnAccountRemoval", retainStacksOnAccountRemoval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "RetainStacksOnAccountRemoval":
            return Optional.ofNullable(clazz.cast(retainStacksOnAccountRemoval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoDeployment, T> g) {
        return obj -> g.apply((AutoDeployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoDeployment> {
        /**
         * <p>
         * If set to <code>true</code>, StackSets automatically deploys additional stack instances to AWS Organizations
         * accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an
         * account is removed from a target organization or OU, StackSets deletes stack instances from the account in
         * the specified Regions.
         * </p>
         * 
         * @param enabled
         *        If set to <code>true</code>, StackSets automatically deploys additional stack instances to AWS
         *        Organizations accounts that are added to a target organization or organizational unit (OU) in the
         *        specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack
         *        instances from the account in the specified Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * If set to <code>true</code>, stack resources are retained when an account is removed from a target
         * organization or OU. If set to <code>false</code>, stack resources are deleted. Specify only if
         * <code>Enabled</code> is set to <code>True</code>.
         * </p>
         * 
         * @param retainStacksOnAccountRemoval
         *        If set to <code>true</code>, stack resources are retained when an account is removed from a target
         *        organization or OU. If set to <code>false</code>, stack resources are deleted. Specify only if
         *        <code>Enabled</code> is set to <code>True</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainStacksOnAccountRemoval(Boolean retainStacksOnAccountRemoval);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Boolean retainStacksOnAccountRemoval;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoDeployment model) {
            enabled(model.enabled);
            retainStacksOnAccountRemoval(model.retainStacksOnAccountRemoval);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getRetainStacksOnAccountRemoval() {
            return retainStacksOnAccountRemoval;
        }

        @Override
        public final Builder retainStacksOnAccountRemoval(Boolean retainStacksOnAccountRemoval) {
            this.retainStacksOnAccountRemoval = retainStacksOnAccountRemoval;
            return this;
        }

        public final void setRetainStacksOnAccountRemoval(Boolean retainStacksOnAccountRemoval) {
            this.retainStacksOnAccountRemoval = retainStacksOnAccountRemoval;
        }

        @Override
        public AutoDeployment build() {
            return new AutoDeployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
