/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * [Service-managed permissions] The AWS Organizations accounts to which StackSets deploys. StackSets does not deploy
 * stack instances to the organization management account, even if the organization management account is in your
 * organization or in an OU in your organization.
 * </p>
 * <p>
 * For update operations, you can specify either <code>Accounts</code> or <code>OrganizationalUnitIds</code>. For create
 * and delete operations, specify <code>OrganizationalUnitIds</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentTargets implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentTargets.Builder, DeploymentTargets> {
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Accounts")
            .getter(getter(DeploymentTargets::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCOUNTS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountsUrl").getter(getter(DeploymentTargets::accountsUrl)).setter(setter(Builder::accountsUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountsUrl").build()).build();

    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OrganizationalUnitIds")
            .getter(getter(DeploymentTargets::organizationalUnitIds))
            .setter(setter(Builder::organizationalUnitIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD,
            ACCOUNTS_URL_FIELD, ORGANIZATIONAL_UNIT_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> accounts;

    private final String accountsUrl;

    private final List<String> organizationalUnitIds;

    private DeploymentTargets(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.accountsUrl = builder.accountsUrl;
        this.organizationalUnitIds = builder.organizationalUnitIds;
    }

    /**
     * Returns true if the Accounts property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of one or more AWS accounts for which you want to deploy stack set updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of one or more AWS accounts for which you want to deploy stack set updates.
     */
    public final List<String> accounts() {
        return accounts;
    }

    /**
     * <p>
     * Returns the value of the AccountsUrl property.
     * </p>
     * 
     * @return Returns the value of the AccountsUrl property.
     */
    public final String accountsUrl() {
        return accountsUrl;
    }

    /**
     * Returns true if the OrganizationalUnitIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOrganizationalUnitIds() {
        return organizationalUnitIds != null && !(organizationalUnitIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrganizationalUnitIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
     */
    public final List<String> organizationalUnitIds() {
        return organizationalUnitIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accountsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationalUnitIds() ? organizationalUnitIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentTargets)) {
            return false;
        }
        DeploymentTargets other = (DeploymentTargets) obj;
        return hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts())
                && Objects.equals(accountsUrl(), other.accountsUrl())
                && hasOrganizationalUnitIds() == other.hasOrganizationalUnitIds()
                && Objects.equals(organizationalUnitIds(), other.organizationalUnitIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentTargets").add("Accounts", hasAccounts() ? accounts() : null)
                .add("AccountsUrl", accountsUrl())
                .add("OrganizationalUnitIds", hasOrganizationalUnitIds() ? organizationalUnitIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "AccountsUrl":
            return Optional.ofNullable(clazz.cast(accountsUrl()));
        case "OrganizationalUnitIds":
            return Optional.ofNullable(clazz.cast(organizationalUnitIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentTargets, T> g) {
        return obj -> g.apply((DeploymentTargets) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentTargets> {
        /**
         * <p>
         * The names of one or more AWS accounts for which you want to deploy stack set updates.
         * </p>
         * 
         * @param accounts
         *        The names of one or more AWS accounts for which you want to deploy stack set updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<String> accounts);

        /**
         * <p>
         * The names of one or more AWS accounts for which you want to deploy stack set updates.
         * </p>
         * 
         * @param accounts
         *        The names of one or more AWS accounts for which you want to deploy stack set updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(String... accounts);

        /**
         * <p>
         * Returns the value of the AccountsUrl property.
         * </p>
         * 
         * @param accountsUrl
         *        Returns the value of the AccountsUrl property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsUrl(String accountsUrl);

        /**
         * <p>
         * The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
         * </p>
         * 
         * @param organizationalUnitIds
         *        The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitIds(Collection<String> organizationalUnitIds);

        /**
         * <p>
         * The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
         * </p>
         * 
         * @param organizationalUnitIds
         *        The organization root ID or organizational unit (OU) IDs to which StackSets deploys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitIds(String... organizationalUnitIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();

        private String accountsUrl;

        private List<String> organizationalUnitIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentTargets model) {
            accounts(model.accounts);
            accountsUrl(model.accountsUrl);
            organizationalUnitIds(model.organizationalUnitIds);
        }

        public final Collection<String> getAccounts() {
            if (accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return accounts;
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
        }

        public final String getAccountsUrl() {
            return accountsUrl;
        }

        @Override
        public final Builder accountsUrl(String accountsUrl) {
            this.accountsUrl = accountsUrl;
            return this;
        }

        public final void setAccountsUrl(String accountsUrl) {
            this.accountsUrl = accountsUrl;
        }

        public final Collection<String> getOrganizationalUnitIds() {
            if (organizationalUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationalUnitIds;
        }

        @Override
        public final Builder organizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitIds(String... organizationalUnitIds) {
            organizationalUnitIds(Arrays.asList(organizationalUnitIds));
            return this;
        }

        public final void setOrganizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
        }

        @Override
        public DeploymentTargets build() {
            return new DeploymentTargets(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
