/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifying information for the configuration of a CloudFormation extension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypeConfigurationIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<TypeConfigurationIdentifier.Builder, TypeConfigurationIdentifier> {
    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeArn").getter(getter(TypeConfigurationIdentifier::typeArn)).setter(setter(Builder::typeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()).build();

    private static final SdkField<String> TYPE_CONFIGURATION_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeConfigurationAlias").getter(getter(TypeConfigurationIdentifier::typeConfigurationAlias))
            .setter(setter(Builder::typeConfigurationAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationAlias").build())
            .build();

    private static final SdkField<String> TYPE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeConfigurationArn").getter(getter(TypeConfigurationIdentifier::typeConfigurationArn))
            .setter(setter(Builder::typeConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationArn").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TypeConfigurationIdentifier::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(TypeConfigurationIdentifier::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_ARN_FIELD,
            TYPE_CONFIGURATION_ALIAS_FIELD, TYPE_CONFIGURATION_ARN_FIELD, TYPE_FIELD, TYPE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String typeArn;

    private final String typeConfigurationAlias;

    private final String typeConfigurationArn;

    private final String type;

    private final String typeName;

    private TypeConfigurationIdentifier(BuilderImpl builder) {
        this.typeArn = builder.typeArn;
        this.typeConfigurationAlias = builder.typeConfigurationAlias;
        this.typeConfigurationArn = builder.typeConfigurationArn;
        this.type = builder.type;
        this.typeName = builder.typeName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the extension, in this account and region.
     * </p>
     * <p>
     * For public extensions, this will be the ARN assigned when you <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the
     * type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the
     * type</a> in this account and region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
     *         <p>
     *         For public extensions, this will be the ARN assigned when you <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate
     *         the type</a> in this account and region. For private extensions, this will be the ARN assigned when you
     *         <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register
     *         the type</a> in this account and region.
     */
    public final String typeArn() {
        return typeArn;
    }

    /**
     * <p>
     * The alias specified for this configuration, if one was specified when the configuration was set.
     * </p>
     * 
     * @return The alias specified for this configuration, if one was specified when the configuration was set.
     */
    public final String typeConfigurationAlias() {
        return typeConfigurationAlias;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the configuration, in this account and region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the configuration, in this account and region.
     */
    public final String typeConfigurationArn() {
        return typeConfigurationArn;
    }

    /**
     * <p>
     * The type of extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThirdPartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of extension.
     * @see ThirdPartyType
     */
    public final ThirdPartyType type() {
        return ThirdPartyType.fromValue(type);
    }

    /**
     * <p>
     * The type of extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThirdPartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of extension.
     * @see ThirdPartyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the extension type to which this configuration applies.
     * </p>
     * 
     * @return The name of the extension type to which this configuration applies.
     */
    public final String typeName() {
        return typeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeConfigurationAlias());
        hashCode = 31 * hashCode + Objects.hashCode(typeConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeConfigurationIdentifier)) {
            return false;
        }
        TypeConfigurationIdentifier other = (TypeConfigurationIdentifier) obj;
        return Objects.equals(typeArn(), other.typeArn())
                && Objects.equals(typeConfigurationAlias(), other.typeConfigurationAlias())
                && Objects.equals(typeConfigurationArn(), other.typeConfigurationArn())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(typeName(), other.typeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypeConfigurationIdentifier").add("TypeArn", typeArn())
                .add("TypeConfigurationAlias", typeConfigurationAlias()).add("TypeConfigurationArn", typeConfigurationArn())
                .add("Type", typeAsString()).add("TypeName", typeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeArn":
            return Optional.ofNullable(clazz.cast(typeArn()));
        case "TypeConfigurationAlias":
            return Optional.ofNullable(clazz.cast(typeConfigurationAlias()));
        case "TypeConfigurationArn":
            return Optional.ofNullable(clazz.cast(typeConfigurationArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypeConfigurationIdentifier, T> g) {
        return obj -> g.apply((TypeConfigurationIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypeConfigurationIdentifier> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the extension, in this account and region.
         * </p>
         * <p>
         * For public extensions, this will be the ARN assigned when you <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the
         * type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the
         * type</a> in this account and region.
         * </p>
         * 
         * @param typeArn
         *        The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
         *        <p>
         *        For public extensions, this will be the ARN assigned when you <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html"
         *        >activate the type</a> in this account and region. For private extensions, this will be the ARN
         *        assigned when you <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         *        >register the type</a> in this account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeArn(String typeArn);

        /**
         * <p>
         * The alias specified for this configuration, if one was specified when the configuration was set.
         * </p>
         * 
         * @param typeConfigurationAlias
         *        The alias specified for this configuration, if one was specified when the configuration was set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeConfigurationAlias(String typeConfigurationAlias);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the configuration, in this account and region.
         * </p>
         * 
         * @param typeConfigurationArn
         *        The Amazon Resource Name (ARN) for the configuration, in this account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeConfigurationArn(String typeConfigurationArn);

        /**
         * <p>
         * The type of extension.
         * </p>
         * 
         * @param type
         *        The type of extension.
         * @see ThirdPartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of extension.
         * </p>
         * 
         * @param type
         *        The type of extension.
         * @see ThirdPartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyType
         */
        Builder type(ThirdPartyType type);

        /**
         * <p>
         * The name of the extension type to which this configuration applies.
         * </p>
         * 
         * @param typeName
         *        The name of the extension type to which this configuration applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);
    }

    static final class BuilderImpl implements Builder {
        private String typeArn;

        private String typeConfigurationAlias;

        private String typeConfigurationArn;

        private String type;

        private String typeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeConfigurationIdentifier model) {
            typeArn(model.typeArn);
            typeConfigurationAlias(model.typeConfigurationAlias);
            typeConfigurationArn(model.typeConfigurationArn);
            type(model.type);
            typeName(model.typeName);
        }

        public final String getTypeArn() {
            return typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        public final String getTypeConfigurationAlias() {
            return typeConfigurationAlias;
        }

        @Override
        public final Builder typeConfigurationAlias(String typeConfigurationAlias) {
            this.typeConfigurationAlias = typeConfigurationAlias;
            return this;
        }

        public final void setTypeConfigurationAlias(String typeConfigurationAlias) {
            this.typeConfigurationAlias = typeConfigurationAlias;
        }

        public final String getTypeConfigurationArn() {
            return typeConfigurationArn;
        }

        @Override
        public final Builder typeConfigurationArn(String typeConfigurationArn) {
            this.typeConfigurationArn = typeConfigurationArn;
            return this;
        }

        public final void setTypeConfigurationArn(String typeConfigurationArn) {
            this.typeConfigurationArn = typeConfigurationArn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThirdPartyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public TypeConfigurationIdentifier build() {
            return new TypeConfigurationIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
