/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackDriftDetectionStatusResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackDriftDetectionStatusResponse.Builder, DescribeStackDriftDetectionStatusResponse> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(DescribeStackDriftDetectionStatusResponse::stackId))
            .setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> STACK_DRIFT_DETECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackDriftDetectionId").getter(getter(DescribeStackDriftDetectionStatusResponse::stackDriftDetectionId))
            .setter(setter(Builder::stackDriftDetectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackDriftDetectionId").build())
            .build();

    private static final SdkField<String> STACK_DRIFT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackDriftStatus").getter(getter(DescribeStackDriftDetectionStatusResponse::stackDriftStatusAsString))
            .setter(setter(Builder::stackDriftStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackDriftStatus").build()).build();

    private static final SdkField<String> DETECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectionStatus").getter(getter(DescribeStackDriftDetectionStatusResponse::detectionStatusAsString))
            .setter(setter(Builder::detectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectionStatus").build()).build();

    private static final SdkField<String> DETECTION_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectionStatusReason").getter(getter(DescribeStackDriftDetectionStatusResponse::detectionStatusReason))
            .setter(setter(Builder::detectionStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectionStatusReason").build())
            .build();

    private static final SdkField<Integer> DRIFTED_STACK_RESOURCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("DriftedStackResourceCount")
            .getter(getter(DescribeStackDriftDetectionStatusResponse::driftedStackResourceCount))
            .setter(setter(Builder::driftedStackResourceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftedStackResourceCount").build())
            .build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(DescribeStackDriftDetectionStatusResponse::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            STACK_DRIFT_DETECTION_ID_FIELD, STACK_DRIFT_STATUS_FIELD, DETECTION_STATUS_FIELD, DETECTION_STATUS_REASON_FIELD,
            DRIFTED_STACK_RESOURCE_COUNT_FIELD, TIMESTAMP_FIELD));

    private final String stackId;

    private final String stackDriftDetectionId;

    private final String stackDriftStatus;

    private final String detectionStatus;

    private final String detectionStatusReason;

    private final Integer driftedStackResourceCount;

    private final Instant timestamp;

    private DescribeStackDriftDetectionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.stackDriftDetectionId = builder.stackDriftDetectionId;
        this.stackDriftStatus = builder.stackDriftStatus;
        this.detectionStatus = builder.detectionStatus;
        this.detectionStatusReason = builder.detectionStatusReason;
        this.driftedStackResourceCount = builder.driftedStackResourceCount;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The ID of the stack.
     * </p>
     * 
     * @return The ID of the stack.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The ID of the drift detection results of this operation.
     * </p>
     * <p>
     * CloudFormation generates new results, with a new drift detection ID, each time this operation is run. However,
     * the number of reports CloudFormation retains for any given stack, and for how long, may vary.
     * </p>
     * 
     * @return The ID of the drift detection results of this operation. </p>
     *         <p>
     *         CloudFormation generates new results, with a new drift detection ID, each time this operation is run.
     *         However, the number of reports CloudFormation retains for any given stack, and for how long, may vary.
     */
    public final String stackDriftDetectionId() {
        return stackDriftDetectionId;
    }

    /**
     * <p>
     * Status of the stack's actual configuration compared to its expected configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have
     * drifted if one or more of its resources have drifted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template
     * configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN</code>: This value is reserved for future use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stackDriftStatus}
     * will return {@link StackDriftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stackDriftStatusAsString}.
     * </p>
     * 
     * @return Status of the stack's actual configuration compared to its expected configuration. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered
     *         to have drifted if one or more of its resources have drifted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template
     *         configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN</code>: This value is reserved for future use.
     *         </p>
     *         </li>
     * @see StackDriftStatus
     */
    public final StackDriftStatus stackDriftStatus() {
        return StackDriftStatus.fromValue(stackDriftStatus);
    }

    /**
     * <p>
     * Status of the stack's actual configuration compared to its expected configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have
     * drifted if one or more of its resources have drifted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template
     * configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN</code>: This value is reserved for future use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stackDriftStatus}
     * will return {@link StackDriftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stackDriftStatusAsString}.
     * </p>
     * 
     * @return Status of the stack's actual configuration compared to its expected configuration. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered
     *         to have drifted if one or more of its resources have drifted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template
     *         configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN</code>: This value is reserved for future use.
     *         </p>
     *         </li>
     * @see StackDriftStatus
     */
    public final String stackDriftStatusAsString() {
        return stackDriftStatus;
    }

    /**
     * <p>
     * The status of the stack drift detection operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DETECTION_COMPLETE</code>: The stack drift detection operation has successfully completed for all resources
     * in the stack that support drift detection. (Resources that do not currently support stack detection remain
     * unchecked.)
     * </p>
     * <p>
     * If you specified logical resource IDs for CloudFormation to use as a filter for the stack drift detection
     * operation, only the resources with those logical IDs are checked for drift.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DETECTION_FAILED</code>: The stack drift detection operation has failed for at least one resource in the
     * stack. Results will be available for resources on which CloudFormation successfully completed drift detection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DETECTION_IN_PROGRESS</code>: The stack drift detection operation is currently in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detectionStatus}
     * will return {@link StackDriftDetectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #detectionStatusAsString}.
     * </p>
     * 
     * @return The status of the stack drift detection operation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DETECTION_COMPLETE</code>: The stack drift detection operation has successfully completed for all
     *         resources in the stack that support drift detection. (Resources that do not currently support stack
     *         detection remain unchecked.)
     *         </p>
     *         <p>
     *         If you specified logical resource IDs for CloudFormation to use as a filter for the stack drift detection
     *         operation, only the resources with those logical IDs are checked for drift.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DETECTION_FAILED</code>: The stack drift detection operation has failed for at least one resource
     *         in the stack. Results will be available for resources on which CloudFormation successfully completed
     *         drift detection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DETECTION_IN_PROGRESS</code>: The stack drift detection operation is currently in progress.
     *         </p>
     *         </li>
     * @see StackDriftDetectionStatus
     */
    public final StackDriftDetectionStatus detectionStatus() {
        return StackDriftDetectionStatus.fromValue(detectionStatus);
    }

    /**
     * <p>
     * The status of the stack drift detection operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DETECTION_COMPLETE</code>: The stack drift detection operation has successfully completed for all resources
     * in the stack that support drift detection. (Resources that do not currently support stack detection remain
     * unchecked.)
     * </p>
     * <p>
     * If you specified logical resource IDs for CloudFormation to use as a filter for the stack drift detection
     * operation, only the resources with those logical IDs are checked for drift.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DETECTION_FAILED</code>: The stack drift detection operation has failed for at least one resource in the
     * stack. Results will be available for resources on which CloudFormation successfully completed drift detection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DETECTION_IN_PROGRESS</code>: The stack drift detection operation is currently in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detectionStatus}
     * will return {@link StackDriftDetectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #detectionStatusAsString}.
     * </p>
     * 
     * @return The status of the stack drift detection operation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DETECTION_COMPLETE</code>: The stack drift detection operation has successfully completed for all
     *         resources in the stack that support drift detection. (Resources that do not currently support stack
     *         detection remain unchecked.)
     *         </p>
     *         <p>
     *         If you specified logical resource IDs for CloudFormation to use as a filter for the stack drift detection
     *         operation, only the resources with those logical IDs are checked for drift.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DETECTION_FAILED</code>: The stack drift detection operation has failed for at least one resource
     *         in the stack. Results will be available for resources on which CloudFormation successfully completed
     *         drift detection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DETECTION_IN_PROGRESS</code>: The stack drift detection operation is currently in progress.
     *         </p>
     *         </li>
     * @see StackDriftDetectionStatus
     */
    public final String detectionStatusAsString() {
        return detectionStatus;
    }

    /**
     * <p>
     * The reason the stack drift detection operation has its current status.
     * </p>
     * 
     * @return The reason the stack drift detection operation has its current status.
     */
    public final String detectionStatusReason() {
        return detectionStatusReason;
    }

    /**
     * <p>
     * Total number of stack resources that have drifted. This is NULL until the drift detection operation reaches a
     * status of <code>DETECTION_COMPLETE</code>. This value will be 0 for stacks whose drift status is
     * <code>IN_SYNC</code>.
     * </p>
     * 
     * @return Total number of stack resources that have drifted. This is NULL until the drift detection operation
     *         reaches a status of <code>DETECTION_COMPLETE</code>. This value will be 0 for stacks whose drift status
     *         is <code>IN_SYNC</code>.
     */
    public final Integer driftedStackResourceCount() {
        return driftedStackResourceCount;
    }

    /**
     * <p>
     * Time at which the stack drift detection operation was initiated.
     * </p>
     * 
     * @return Time at which the stack drift detection operation was initiated.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(stackDriftDetectionId());
        hashCode = 31 * hashCode + Objects.hashCode(stackDriftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(detectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(detectionStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(driftedStackResourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackDriftDetectionStatusResponse)) {
            return false;
        }
        DescribeStackDriftDetectionStatusResponse other = (DescribeStackDriftDetectionStatusResponse) obj;
        return Objects.equals(stackId(), other.stackId())
                && Objects.equals(stackDriftDetectionId(), other.stackDriftDetectionId())
                && Objects.equals(stackDriftStatusAsString(), other.stackDriftStatusAsString())
                && Objects.equals(detectionStatusAsString(), other.detectionStatusAsString())
                && Objects.equals(detectionStatusReason(), other.detectionStatusReason())
                && Objects.equals(driftedStackResourceCount(), other.driftedStackResourceCount())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStackDriftDetectionStatusResponse").add("StackId", stackId())
                .add("StackDriftDetectionId", stackDriftDetectionId()).add("StackDriftStatus", stackDriftStatusAsString())
                .add("DetectionStatus", detectionStatusAsString()).add("DetectionStatusReason", detectionStatusReason())
                .add("DriftedStackResourceCount", driftedStackResourceCount()).add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "StackDriftDetectionId":
            return Optional.ofNullable(clazz.cast(stackDriftDetectionId()));
        case "StackDriftStatus":
            return Optional.ofNullable(clazz.cast(stackDriftStatusAsString()));
        case "DetectionStatus":
            return Optional.ofNullable(clazz.cast(detectionStatusAsString()));
        case "DetectionStatusReason":
            return Optional.ofNullable(clazz.cast(detectionStatusReason()));
        case "DriftedStackResourceCount":
            return Optional.ofNullable(clazz.cast(driftedStackResourceCount()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackDriftDetectionStatusResponse, T> g) {
        return obj -> g.apply((DescribeStackDriftDetectionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackDriftDetectionStatusResponse> {
        /**
         * <p>
         * The ID of the stack.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The ID of the drift detection results of this operation.
         * </p>
         * <p>
         * CloudFormation generates new results, with a new drift detection ID, each time this operation is run.
         * However, the number of reports CloudFormation retains for any given stack, and for how long, may vary.
         * </p>
         * 
         * @param stackDriftDetectionId
         *        The ID of the drift detection results of this operation. </p>
         *        <p>
         *        CloudFormation generates new results, with a new drift detection ID, each time this operation is run.
         *        However, the number of reports CloudFormation retains for any given stack, and for how long, may vary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackDriftDetectionId(String stackDriftDetectionId);

        /**
         * <p>
         * Status of the stack's actual configuration compared to its expected configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to
         * have drifted if one or more of its resources have drifted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN</code>: This value is reserved for future use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackDriftStatus
         *        Status of the stack's actual configuration compared to its expected configuration. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is
         *        considered to have drifted if one or more of its resources have drifted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected
         *        template configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN</code>: This value is reserved for future use.
         *        </p>
         *        </li>
         * @see StackDriftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackDriftStatus
         */
        Builder stackDriftStatus(String stackDriftStatus);

        /**
         * <p>
         * Status of the stack's actual configuration compared to its expected configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to
         * have drifted if one or more of its resources have drifted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected template
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN</code>: This value is reserved for future use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackDriftStatus
         *        Status of the stack's actual configuration compared to its expected configuration. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is
         *        considered to have drifted if one or more of its resources have drifted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation has not checked if the stack differs from its expected
         *        template configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The stack's actual configuration matches its expected template configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN</code>: This value is reserved for future use.
         *        </p>
         *        </li>
         * @see StackDriftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackDriftStatus
         */
        Builder stackDriftStatus(StackDriftStatus stackDriftStatus);

        /**
         * <p>
         * The status of the stack drift detection operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DETECTION_COMPLETE</code>: The stack drift detection operation has successfully completed for all
         * resources in the stack that support drift detection. (Resources that do not currently support stack detection
         * remain unchecked.)
         * </p>
         * <p>
         * If you specified logical resource IDs for CloudFormation to use as a filter for the stack drift detection
         * operation, only the resources with those logical IDs are checked for drift.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DETECTION_FAILED</code>: The stack drift detection operation has failed for at least one resource in
         * the stack. Results will be available for resources on which CloudFormation successfully completed drift
         * detection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DETECTION_IN_PROGRESS</code>: The stack drift detection operation is currently in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param detectionStatus
         *        The status of the stack drift detection operation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DETECTION_COMPLETE</code>: The stack drift detection operation has successfully completed for
         *        all resources in the stack that support drift detection. (Resources that do not currently support
         *        stack detection remain unchecked.)
         *        </p>
         *        <p>
         *        If you specified logical resource IDs for CloudFormation to use as a filter for the stack drift
         *        detection operation, only the resources with those logical IDs are checked for drift.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DETECTION_FAILED</code>: The stack drift detection operation has failed for at least one
         *        resource in the stack. Results will be available for resources on which CloudFormation successfully
         *        completed drift detection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DETECTION_IN_PROGRESS</code>: The stack drift detection operation is currently in progress.
         *        </p>
         *        </li>
         * @see StackDriftDetectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackDriftDetectionStatus
         */
        Builder detectionStatus(String detectionStatus);

        /**
         * <p>
         * The status of the stack drift detection operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DETECTION_COMPLETE</code>: The stack drift detection operation has successfully completed for all
         * resources in the stack that support drift detection. (Resources that do not currently support stack detection
         * remain unchecked.)
         * </p>
         * <p>
         * If you specified logical resource IDs for CloudFormation to use as a filter for the stack drift detection
         * operation, only the resources with those logical IDs are checked for drift.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DETECTION_FAILED</code>: The stack drift detection operation has failed for at least one resource in
         * the stack. Results will be available for resources on which CloudFormation successfully completed drift
         * detection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DETECTION_IN_PROGRESS</code>: The stack drift detection operation is currently in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param detectionStatus
         *        The status of the stack drift detection operation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DETECTION_COMPLETE</code>: The stack drift detection operation has successfully completed for
         *        all resources in the stack that support drift detection. (Resources that do not currently support
         *        stack detection remain unchecked.)
         *        </p>
         *        <p>
         *        If you specified logical resource IDs for CloudFormation to use as a filter for the stack drift
         *        detection operation, only the resources with those logical IDs are checked for drift.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DETECTION_FAILED</code>: The stack drift detection operation has failed for at least one
         *        resource in the stack. Results will be available for resources on which CloudFormation successfully
         *        completed drift detection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DETECTION_IN_PROGRESS</code>: The stack drift detection operation is currently in progress.
         *        </p>
         *        </li>
         * @see StackDriftDetectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackDriftDetectionStatus
         */
        Builder detectionStatus(StackDriftDetectionStatus detectionStatus);

        /**
         * <p>
         * The reason the stack drift detection operation has its current status.
         * </p>
         * 
         * @param detectionStatusReason
         *        The reason the stack drift detection operation has its current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectionStatusReason(String detectionStatusReason);

        /**
         * <p>
         * Total number of stack resources that have drifted. This is NULL until the drift detection operation reaches a
         * status of <code>DETECTION_COMPLETE</code>. This value will be 0 for stacks whose drift status is
         * <code>IN_SYNC</code>.
         * </p>
         * 
         * @param driftedStackResourceCount
         *        Total number of stack resources that have drifted. This is NULL until the drift detection operation
         *        reaches a status of <code>DETECTION_COMPLETE</code>. This value will be 0 for stacks whose drift
         *        status is <code>IN_SYNC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftedStackResourceCount(Integer driftedStackResourceCount);

        /**
         * <p>
         * Time at which the stack drift detection operation was initiated.
         * </p>
         * 
         * @param timestamp
         *        Time at which the stack drift detection operation was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String stackId;

        private String stackDriftDetectionId;

        private String stackDriftStatus;

        private String detectionStatus;

        private String detectionStatusReason;

        private Integer driftedStackResourceCount;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackDriftDetectionStatusResponse model) {
            super(model);
            stackId(model.stackId);
            stackDriftDetectionId(model.stackDriftDetectionId);
            stackDriftStatus(model.stackDriftStatus);
            detectionStatus(model.detectionStatus);
            detectionStatusReason(model.detectionStatusReason);
            driftedStackResourceCount(model.driftedStackResourceCount);
            timestamp(model.timestamp);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackDriftDetectionId() {
            return stackDriftDetectionId;
        }

        @Override
        public final Builder stackDriftDetectionId(String stackDriftDetectionId) {
            this.stackDriftDetectionId = stackDriftDetectionId;
            return this;
        }

        public final void setStackDriftDetectionId(String stackDriftDetectionId) {
            this.stackDriftDetectionId = stackDriftDetectionId;
        }

        public final String getStackDriftStatus() {
            return stackDriftStatus;
        }

        @Override
        public final Builder stackDriftStatus(String stackDriftStatus) {
            this.stackDriftStatus = stackDriftStatus;
            return this;
        }

        @Override
        public final Builder stackDriftStatus(StackDriftStatus stackDriftStatus) {
            this.stackDriftStatus(stackDriftStatus == null ? null : stackDriftStatus.toString());
            return this;
        }

        public final void setStackDriftStatus(String stackDriftStatus) {
            this.stackDriftStatus = stackDriftStatus;
        }

        public final String getDetectionStatus() {
            return detectionStatus;
        }

        @Override
        public final Builder detectionStatus(String detectionStatus) {
            this.detectionStatus = detectionStatus;
            return this;
        }

        @Override
        public final Builder detectionStatus(StackDriftDetectionStatus detectionStatus) {
            this.detectionStatus(detectionStatus == null ? null : detectionStatus.toString());
            return this;
        }

        public final void setDetectionStatus(String detectionStatus) {
            this.detectionStatus = detectionStatus;
        }

        public final String getDetectionStatusReason() {
            return detectionStatusReason;
        }

        @Override
        public final Builder detectionStatusReason(String detectionStatusReason) {
            this.detectionStatusReason = detectionStatusReason;
            return this;
        }

        public final void setDetectionStatusReason(String detectionStatusReason) {
            this.detectionStatusReason = detectionStatusReason;
        }

        public final Integer getDriftedStackResourceCount() {
            return driftedStackResourceCount;
        }

        @Override
        public final Builder driftedStackResourceCount(Integer driftedStackResourceCount) {
            this.driftedStackResourceCount = driftedStackResourceCount;
            return this;
        }

        public final void setDriftedStackResourceCount(Integer driftedStackResourceCount) {
            this.driftedStackResourceCount = driftedStackResourceCount;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public DescribeStackDriftDetectionStatusResponse build() {
            return new DescribeStackDriftDetectionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
