/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestTypeRequest extends CloudFormationRequest implements
        ToCopyableBuilder<TestTypeRequest.Builder, TestTypeRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TestTypeRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TestTypeRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(TestTypeRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(TestTypeRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<String> LOG_DELIVERY_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogDeliveryBucket").getter(getter(TestTypeRequest::logDeliveryBucket))
            .setter(setter(Builder::logDeliveryBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryBucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD,
            TYPE_NAME_FIELD, VERSION_ID_FIELD, LOG_DELIVERY_BUCKET_FIELD));

    private final String arn;

    private final String type;

    private final String typeName;

    private final String versionId;

    private final String logDeliveryBucket;

    private TestTypeRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.versionId = builder.versionId;
        this.logDeliveryBucket = builder.logDeliveryBucket;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the extension.
     * </p>
     * <p>
     * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the extension.</p>
     *         <p>
     *         Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of the extension to test.
     * </p>
     * <p>
     * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThirdPartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the extension to test.</p>
     *         <p>
     *         Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * @see ThirdPartyType
     */
    public final ThirdPartyType type() {
        return ThirdPartyType.fromValue(type);
    }

    /**
     * <p>
     * The type of the extension to test.
     * </p>
     * <p>
     * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThirdPartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the extension to test.</p>
     *         <p>
     *         Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * @see ThirdPartyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the extension to test.
     * </p>
     * <p>
     * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * </p>
     * 
     * @return The name of the extension to test.</p>
     *         <p>
     *         Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The version of the extension to test.
     * </p>
     * <p>
     * You can specify the version id with either <code>Arn</code>, or with <code>TypeName</code> and <code>Type</code>.
     * </p>
     * <p>
     * If you do not specify a version, CloudFormation uses the default version of the extension in this account and
     * region for testing.
     * </p>
     * 
     * @return The version of the extension to test.</p>
     *         <p>
     *         You can specify the version id with either <code>Arn</code>, or with <code>TypeName</code> and
     *         <code>Type</code>.
     *         </p>
     *         <p>
     *         If you do not specify a version, CloudFormation uses the default version of the extension in this account
     *         and region for testing.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The S3 bucket to which CloudFormation delivers the contract test execution logs.
     * </p>
     * <p>
     * CloudFormation delivers the logs by the time contract testing has completed and the extension has been assigned a
     * test type status of <code>PASSED</code> or <code>FAILED</code>.
     * </p>
     * <p>
     * The user calling <code>TestType</code> must be able to access items in the specified S3 bucket. Specifically, the
     * user needs the following permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * GetObject
     * </p>
     * </li>
     * <li>
     * <p>
     * PutObject
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources,
     * and Condition Keys for Amazon S3</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.
     * </p>
     * 
     * @return The S3 bucket to which CloudFormation delivers the contract test execution logs.</p>
     *         <p>
     *         CloudFormation delivers the logs by the time contract testing has completed and the extension has been
     *         assigned a test type status of <code>PASSED</code> or <code>FAILED</code>.
     *         </p>
     *         <p>
     *         The user calling <code>TestType</code> must be able to access items in the specified S3 bucket.
     *         Specifically, the user needs the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         GetObject
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PutObject
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions,
     *         Resources, and Condition Keys for Amazon S3</a> in the <i>Amazon Web Services Identity and Access
     *         Management User Guide</i>.
     */
    public final String logDeliveryBucket() {
        return logDeliveryBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(logDeliveryBucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestTypeRequest)) {
            return false;
        }
        TestTypeRequest other = (TestTypeRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(typeName(), other.typeName()) && Objects.equals(versionId(), other.versionId())
                && Objects.equals(logDeliveryBucket(), other.logDeliveryBucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestTypeRequest").add("Arn", arn()).add("Type", typeAsString()).add("TypeName", typeName())
                .add("VersionId", versionId()).add("LogDeliveryBucket", logDeliveryBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "LogDeliveryBucket":
            return Optional.ofNullable(clazz.cast(logDeliveryBucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestTypeRequest, T> g) {
        return obj -> g.apply((TestTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestTypeRequest> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the extension.
         * </p>
         * <p>
         * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Number (ARN) of the extension.</p>
         *        <p>
         *        Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of the extension to test.
         * </p>
         * <p>
         * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * </p>
         * 
         * @param type
         *        The type of the extension to test.</p>
         *        <p>
         *        Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * @see ThirdPartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the extension to test.
         * </p>
         * <p>
         * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * </p>
         * 
         * @param type
         *        The type of the extension to test.</p>
         *        <p>
         *        Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * @see ThirdPartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyType
         */
        Builder type(ThirdPartyType type);

        /**
         * <p>
         * The name of the extension to test.
         * </p>
         * <p>
         * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * </p>
         * 
         * @param typeName
         *        The name of the extension to test.</p>
         *        <p>
         *        Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The version of the extension to test.
         * </p>
         * <p>
         * You can specify the version id with either <code>Arn</code>, or with <code>TypeName</code> and
         * <code>Type</code>.
         * </p>
         * <p>
         * If you do not specify a version, CloudFormation uses the default version of the extension in this account and
         * region for testing.
         * </p>
         * 
         * @param versionId
         *        The version of the extension to test.</p>
         *        <p>
         *        You can specify the version id with either <code>Arn</code>, or with <code>TypeName</code> and
         *        <code>Type</code>.
         *        </p>
         *        <p>
         *        If you do not specify a version, CloudFormation uses the default version of the extension in this
         *        account and region for testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The S3 bucket to which CloudFormation delivers the contract test execution logs.
         * </p>
         * <p>
         * CloudFormation delivers the logs by the time contract testing has completed and the extension has been
         * assigned a test type status of <code>PASSED</code> or <code>FAILED</code>.
         * </p>
         * <p>
         * The user calling <code>TestType</code> must be able to access items in the specified S3 bucket. Specifically,
         * the user needs the following permissions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * GetObject
         * </p>
         * </li>
         * <li>
         * <p>
         * PutObject
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions,
         * Resources, and Condition Keys for Amazon S3</a> in the <i>Amazon Web Services Identity and Access Management
         * User Guide</i>.
         * </p>
         * 
         * @param logDeliveryBucket
         *        The S3 bucket to which CloudFormation delivers the contract test execution logs.</p>
         *        <p>
         *        CloudFormation delivers the logs by the time contract testing has completed and the extension has been
         *        assigned a test type status of <code>PASSED</code> or <code>FAILED</code>.
         *        </p>
         *        <p>
         *        The user calling <code>TestType</code> must be able to access items in the specified S3 bucket.
         *        Specifically, the user needs the following permissions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        GetObject
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PutObject
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions,
         *        Resources, and Condition Keys for Amazon S3</a> in the <i>Amazon Web Services Identity and Access
         *        Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryBucket(String logDeliveryBucket);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String arn;

        private String type;

        private String typeName;

        private String versionId;

        private String logDeliveryBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(TestTypeRequest model) {
            super(model);
            arn(model.arn);
            type(model.type);
            typeName(model.typeName);
            versionId(model.versionId);
            logDeliveryBucket(model.logDeliveryBucket);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThirdPartyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getLogDeliveryBucket() {
            return logDeliveryBucket;
        }

        @Override
        public final Builder logDeliveryBucket(String logDeliveryBucket) {
            this.logDeliveryBucket = logDeliveryBucket;
            return this;
        }

        public final void setLogDeliveryBucket(String logDeliveryBucket) {
            this.logDeliveryBucket = logDeliveryBucket;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestTypeRequest build() {
            return new TestTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
