/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudformation.model.ActivateTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.ActivateTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest;
import software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CfnRegistryException;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationException;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreatedButModifiedException;
import software.amazon.awssdk.services.cloudformation.model.DeactivateTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DeactivateTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribePublisherRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribePublisherResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse;
import software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ImportStacksToStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.InsufficientCapabilitiesException;
import software.amazon.awssdk.services.cloudformation.model.InvalidChangeSetStatusException;
import software.amazon.awssdk.services.cloudformation.model.InvalidOperationException;
import software.amazon.awssdk.services.cloudformation.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.cloudformation.model.LimitExceededException;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypesResponse;
import software.amazon.awssdk.services.cloudformation.model.NameAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.OperationIdAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.OperationInProgressException;
import software.amazon.awssdk.services.cloudformation.model.OperationNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.OperationStatusCheckFailedException;
import software.amazon.awssdk.services.cloudformation.model.PublishTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.PublishTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressResponse;
import software.amazon.awssdk.services.cloudformation.model.RegisterPublisherRequest;
import software.amazon.awssdk.services.cloudformation.model.RegisterPublisherResponse;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.RollbackStackRequest;
import software.amazon.awssdk.services.cloudformation.model.RollbackStackResponse;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationRequest;
import software.amazon.awssdk.services.cloudformation.model.SetTypeConfigurationResponse;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionRequest;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionResponse;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StackNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StackSetNotEmptyException;
import software.amazon.awssdk.services.cloudformation.model.StackSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StaleRequestException;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.TestTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.TestTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.TokenAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.TypeConfigurationNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.TypeNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListImportsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypesIterable;
import software.amazon.awssdk.services.cloudformation.waiters.CloudFormationWaiter;

/**
 * Service client for accessing AWS CloudFormation. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS CloudFormation</fullname>
 * <p>
 * CloudFormation allows you to create and manage Amazon Web Services infrastructure deployments predictably and
 * repeatedly. You can use CloudFormation to leverage Amazon Web Services products, such as Amazon Elastic Compute
 * Cloud, Amazon Elastic Block Store, Amazon Simple Notification Service, Elastic Load Balancing, and Auto Scaling to
 * build highly-reliable, highly scalable, cost-effective applications without creating or configuring the underlying
 * Amazon Web Services infrastructure.
 * </p>
 * <p>
 * With CloudFormation, you declare all of your resources and dependencies in a template file. The template defines a
 * collection of resources as a single unit called a stack. CloudFormation creates and deletes all member resources of
 * the stack together and manages all dependencies between the resources for you.
 * </p>
 * <p>
 * For more information about CloudFormation, see the <a href="http://aws.amazon.com/cloudformation/">CloudFormation
 * Product Page</a>.
 * </p>
 * <p>
 * CloudFormation makes use of other Amazon Web Services products. If you need additional technical information about a
 * specific Amazon Web Services product, you can find the product's technical documentation at <a
 * href="https://docs.aws.amazon.com/"> <code>docs.aws.amazon.com</code> </a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudFormationClient extends SdkClient {
    String SERVICE_NAME = "cloudformation";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudformation";

    /**
     * Create a {@link CloudFormationClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudFormationClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFormationClient}.
     */
    static CloudFormationClientBuilder builder() {
        return new DefaultCloudFormationClientBuilder();
    }

    /**
     * <p>
     * Activates a public third-party extension, making it available for use in stack templates. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html">Using public
     * extensions</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Once you have activated a public third-party extension in your account and region, use <a
     * href="AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration</a> to specify
     * configuration properties for the extension. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param activateTypeRequest
     * @return Result of the ActivateType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ActivateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateType" target="_top">AWS
     *      API Documentation</a>
     */
    default ActivateTypeResponse activateType(ActivateTypeRequest activateTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates a public third-party extension, making it available for use in stack templates. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html">Using public
     * extensions</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Once you have activated a public third-party extension in your account and region, use <a
     * href="AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration</a> to specify
     * configuration properties for the extension. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateTypeRequest.Builder} avoiding the need to
     * create one manually via {@link ActivateTypeRequest#builder()}
     * </p>
     *
     * @param activateTypeRequest
     *        A {@link Consumer} that will call methods on {@link ActivateTypeInput.Builder} to create a request.
     * @return Result of the ActivateType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ActivateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ActivateType" target="_top">AWS
     *      API Documentation</a>
     */
    default ActivateTypeResponse activateType(Consumer<ActivateTypeRequest.Builder> activateTypeRequest)
            throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return activateType(ActivateTypeRequest.builder().applyMutation(activateTypeRequest).build());
    }

    /**
     * <p>
     * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry for the
     * account and region.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param batchDescribeTypeConfigurationsRequest
     * @return Result of the BatchDescribeTypeConfigurations operation returned by the service.
     * @throws TypeConfigurationNotFoundException
     *         The specified extension configuration cannot be found.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.BatchDescribeTypeConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/BatchDescribeTypeConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDescribeTypeConfigurationsResponse batchDescribeTypeConfigurations(
            BatchDescribeTypeConfigurationsRequest batchDescribeTypeConfigurationsRequest)
            throws TypeConfigurationNotFoundException, CfnRegistryException, AwsServiceException, SdkClientException,
            CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration data for the specified CloudFormation extensions, from the CloudFormation registry for the
     * account and region.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDescribeTypeConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDescribeTypeConfigurationsRequest#builder()}
     * </p>
     *
     * @param batchDescribeTypeConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDescribeTypeConfigurationsInput.Builder} to
     *        create a request.
     * @return Result of the BatchDescribeTypeConfigurations operation returned by the service.
     * @throws TypeConfigurationNotFoundException
     *         The specified extension configuration cannot be found.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.BatchDescribeTypeConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/BatchDescribeTypeConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDescribeTypeConfigurationsResponse batchDescribeTypeConfigurations(
            Consumer<BatchDescribeTypeConfigurationsRequest.Builder> batchDescribeTypeConfigurationsRequest)
            throws TypeConfigurationNotFoundException, CfnRegistryException, AwsServiceException, SdkClientException,
            CloudFormationException {
        return batchDescribeTypeConfigurations(BatchDescribeTypeConfigurationsRequest.builder()
                .applyMutation(batchDescribeTypeConfigurationsRequest).build());
    }

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
     * </p>
     * </note>
     *
     * @param cancelUpdateStackRequest
     *        The input for the <a>CancelUpdateStack</a> action.
     * @return Result of the CancelUpdateStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CancelUpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelUpdateStackResponse cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest)
            throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelUpdateStackRequest.Builder} avoiding the need
     * to create one manually via {@link CancelUpdateStackRequest#builder()}
     * </p>
     *
     * @param cancelUpdateStackRequest
     *        A {@link Consumer} that will call methods on {@link CancelUpdateStackInput.Builder} to create a request.
     *        The input for the <a>CancelUpdateStack</a> action.
     * @return Result of the CancelUpdateStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CancelUpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelUpdateStackResponse cancelUpdateStack(Consumer<CancelUpdateStackRequest.Builder> cancelUpdateStackRequest)
            throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        return cancelUpdateStack(CancelUpdateStackRequest.builder().applyMutation(cancelUpdateStackRequest).build());
    }

    /**
     * <p>
     * For a specified stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the
     * <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * > fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working
     * state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.
     * </p>
     * <p>
     * A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when CloudFormation cannot roll back all changes
     * after a failed stack update. For example, you might have a stack that is rolling back to an old database instance
     * that was deleted outside of CloudFormation. Because CloudFormation doesn't know the database was deleted, it
     * assumes that the database instance still exists and attempts to roll back to it, causing the update rollback to
     * fail.
     * </p>
     *
     * @param continueUpdateRollbackRequest
     *        The input for the <a>ContinueUpdateRollback</a> action.
     * @return Result of the ContinueUpdateRollback operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ContinueUpdateRollback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    default ContinueUpdateRollbackResponse continueUpdateRollback(ContinueUpdateRollbackRequest continueUpdateRollbackRequest)
            throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specified stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the
     * <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * > fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working
     * state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.
     * </p>
     * <p>
     * A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when CloudFormation cannot roll back all changes
     * after a failed stack update. For example, you might have a stack that is rolling back to an old database instance
     * that was deleted outside of CloudFormation. Because CloudFormation doesn't know the database was deleted, it
     * assumes that the database instance still exists and attempts to roll back to it, causing the update rollback to
     * fail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ContinueUpdateRollbackRequest.Builder} avoiding the
     * need to create one manually via {@link ContinueUpdateRollbackRequest#builder()}
     * </p>
     *
     * @param continueUpdateRollbackRequest
     *        A {@link Consumer} that will call methods on {@link ContinueUpdateRollbackInput.Builder} to create a
     *        request. The input for the <a>ContinueUpdateRollback</a> action.
     * @return Result of the ContinueUpdateRollback operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ContinueUpdateRollback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    default ContinueUpdateRollbackResponse continueUpdateRollback(
            Consumer<ContinueUpdateRollbackRequest.Builder> continueUpdateRollbackRequest) throws TokenAlreadyExistsException,
            AwsServiceException, SdkClientException, CloudFormationException {
        return continueUpdateRollback(ContinueUpdateRollbackRequest.builder().applyMutation(continueUpdateRollbackRequest)
                .build());
    }

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you
     * create a change set for an existing stack, CloudFormation compares the stack's information with the information
     * that you submit in the change set and lists the differences. Use change sets to understand which resources
     * CloudFormation will create or change, and how it will change resources in an existing stack, before you create or
     * update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. To create a change set for an import operation, specify <code>IMPORT</code>
     * for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes,
     * CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. CloudFormation doesn't make changes until you execute the change set.
     * </p>
     * <p>
     * To create a change set for the entire stack hierachy, set <code>IncludeNestedStacks</code> to <code>True</code>.
     * </p>
     *
     * @param createChangeSetRequest
     *        The input for the <a>CreateChangeSet</a> action.
     * @return Result of the CreateChangeSet operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>CloudFormation User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChangeSetResponse createChangeSet(CreateChangeSetRequest createChangeSetRequest) throws AlreadyExistsException,
            InsufficientCapabilitiesException, LimitExceededException, AwsServiceException, SdkClientException,
            CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you
     * create a change set for an existing stack, CloudFormation compares the stack's information with the information
     * that you submit in the change set and lists the differences. Use change sets to understand which resources
     * CloudFormation will create or change, and how it will change resources in an existing stack, before you create or
     * update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. To create a change set for an import operation, specify <code>IMPORT</code>
     * for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes,
     * CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. CloudFormation doesn't make changes until you execute the change set.
     * </p>
     * <p>
     * To create a change set for the entire stack hierachy, set <code>IncludeNestedStacks</code> to <code>True</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateChangeSetRequest#builder()}
     * </p>
     *
     * @param createChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateChangeSetInput.Builder} to create a request. The
     *        input for the <a>CreateChangeSet</a> action.
     * @return Result of the CreateChangeSet operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>CloudFormation User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChangeSetResponse createChangeSet(Consumer<CreateChangeSetRequest.Builder> createChangeSetRequest)
            throws AlreadyExistsException, InsufficientCapabilitiesException, LimitExceededException, AwsServiceException,
            SdkClientException, CloudFormationException {
        return createChangeSet(CreateChangeSetRequest.builder().applyMutation(createChangeSetRequest).build());
    }

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack via the <a>DescribeStacks</a> API.
     * </p>
     *
     * @param createStackRequest
     *        The input for <a>CreateStack</a> action.
     * @return Result of the CreateStack operation returned by the service.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>CloudFormation User Guide</i>.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStackResponse createStack(CreateStackRequest createStackRequest) throws LimitExceededException,
            AlreadyExistsException, TokenAlreadyExistsException, InsufficientCapabilitiesException, AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack via the <a>DescribeStacks</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackRequest#builder()}
     * </p>
     *
     * @param createStackRequest
     *        A {@link Consumer} that will call methods on {@link CreateStackInput.Builder} to create a request. The
     *        input for <a>CreateStack</a> action.
     * @return Result of the CreateStack operation returned by the service.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>CloudFormation User Guide</i>.
     * @throws AlreadyExistsException
     *         The resource with the name requested already exists.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStackResponse createStack(Consumer<CreateStackRequest.Builder> createStackRequest)
            throws LimitExceededException, AlreadyExistsException, TokenAlreadyExistsException,
            InsufficientCapabilitiesException, AwsServiceException, SdkClientException, CloudFormationException {
        return createStack(CreateStackRequest.builder().applyMutation(createStackRequest).build());
    }

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified Regions. A stack instance refers to a
     * stack in a specific account and Region. You must specify at least one value for either <code>Accounts</code> or
     * <code>DeploymentTargets</code>, and you must specify at least one value for <code>Regions</code>.
     * </p>
     *
     * @param createStackInstancesRequest
     * @return Result of the CreateStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>CloudFormation User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStackInstancesResponse createStackInstances(CreateStackInstancesRequest createStackInstancesRequest)
            throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException,
            StaleRequestException, InvalidOperationException, LimitExceededException, AwsServiceException, SdkClientException,
            CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified Regions. A stack instance refers to a
     * stack in a specific account and Region. You must specify at least one value for either <code>Accounts</code> or
     * <code>DeploymentTargets</code>, and you must specify at least one value for <code>Regions</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStackInstancesRequest#builder()}
     * </p>
     *
     * @param createStackInstancesRequest
     *        A {@link Consumer} that will call methods on {@link CreateStackInstancesInput.Builder} to create a
     *        request.
     * @return Result of the CreateStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>CloudFormation User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStackInstancesResponse createStackInstances(
            Consumer<CreateStackInstancesRequest.Builder> createStackInstancesRequest) throws StackSetNotFoundException,
            OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException,
            LimitExceededException, AwsServiceException, SdkClientException, CloudFormationException {
        return createStackInstances(CreateStackInstancesRequest.builder().applyMutation(createStackInstancesRequest).build());
    }

    /**
     * <p>
     * Creates a stack set.
     * </p>
     *
     * @param createStackSetRequest
     * @return Result of the CreateStackSet operation returned by the service.
     * @throws NameAlreadyExistsException
     *         The specified name is already in use.
     * @throws CreatedButModifiedException
     *         The specified resource exists, but has been changed.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>CloudFormation User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStackSetResponse createStackSet(CreateStackSetRequest createStackSetRequest) throws NameAlreadyExistsException,
            CreatedButModifiedException, LimitExceededException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stack set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackSetRequest#builder()}
     * </p>
     *
     * @param createStackSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateStackSetInput.Builder} to create a request.
     * @return Result of the CreateStackSet operation returned by the service.
     * @throws NameAlreadyExistsException
     *         The specified name is already in use.
     * @throws CreatedButModifiedException
     *         The specified resource exists, but has been changed.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>CloudFormation User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.CreateStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStackSetResponse createStackSet(Consumer<CreateStackSetRequest.Builder> createStackSetRequest)
            throws NameAlreadyExistsException, CreatedButModifiedException, LimitExceededException, AwsServiceException,
            SdkClientException, CloudFormationException {
        return createStackSet(CreateStackSetRequest.builder().applyMutation(createStackSetRequest).build());
    }

    /**
     * <p>
     * Deactivates a public extension that was previously activated in this account and region.
     * </p>
     * <p>
     * Once deactivated, an extension cannot be used in any CloudFormation operation. This includes stack update
     * operations where the stack template includes the extension, even if no updates are being made to the extension.
     * In addition, deactivated extensions are not automatically updated if a new version of the extension is released.
     * </p>
     *
     * @param deactivateTypeRequest
     * @return Result of the DeactivateType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeactivateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeactivateTypeResponse deactivateType(DeactivateTypeRequest deactivateTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates a public extension that was previously activated in this account and region.
     * </p>
     * <p>
     * Once deactivated, an extension cannot be used in any CloudFormation operation. This includes stack update
     * operations where the stack template includes the extension, even if no updates are being made to the extension.
     * In addition, deactivated extensions are not automatically updated if a new version of the extension is released.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeactivateTypeRequest#builder()}
     * </p>
     *
     * @param deactivateTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeactivateTypeInput.Builder} to create a request.
     * @return Result of the DeactivateType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeactivateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeactivateType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeactivateTypeResponse deactivateType(Consumer<DeactivateTypeRequest.Builder> deactivateTypeRequest)
            throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return deactivateType(DeactivateTypeRequest.builder().applyMutation(deactivateTypeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, CloudFormation successfully deleted the change set.
     * </p>
     * <p>
     * If <code>IncludeNestedStacks</code> specifies <code>True</code> during the creation of the nested change set,
     * then <code>DeleteChangeSet</code> will delete all change sets that belong to the stacks hierarchy and will also
     * delete all change sets for nested stacks with the status of <code>REVIEW_IN_PROGRESS</code>.
     * </p>
     *
     * @param deleteChangeSetRequest
     *        The input for the <a>DeleteChangeSet</a> action.
     * @return Result of the DeleteChangeSet operation returned by the service.
     * @throws InvalidChangeSetStatusException
     *         The specified change set can't be used to update the stack. For example, the change set status might be
     *         <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChangeSetResponse deleteChangeSet(DeleteChangeSetRequest deleteChangeSetRequest)
            throws InvalidChangeSetStatusException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, CloudFormation successfully deleted the change set.
     * </p>
     * <p>
     * If <code>IncludeNestedStacks</code> specifies <code>True</code> during the creation of the nested change set,
     * then <code>DeleteChangeSet</code> will delete all change sets that belong to the stacks hierarchy and will also
     * delete all change sets for nested stacks with the status of <code>REVIEW_IN_PROGRESS</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteChangeSetRequest#builder()}
     * </p>
     *
     * @param deleteChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteChangeSetInput.Builder} to create a request. The
     *        input for the <a>DeleteChangeSet</a> action.
     * @return Result of the DeleteChangeSet operation returned by the service.
     * @throws InvalidChangeSetStatusException
     *         The specified change set can't be used to update the stack. For example, the change set status might be
     *         <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChangeSetResponse deleteChangeSet(Consumer<DeleteChangeSetRequest.Builder> deleteChangeSetRequest)
            throws InvalidChangeSetStatusException, AwsServiceException, SdkClientException, CloudFormationException {
        return deleteChangeSet(DeleteChangeSetRequest.builder().applyMutation(deleteChangeSetRequest).build());
    }

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks do not
     * show up in the <a>DescribeStacks</a> API if the deletion has been completed successfully.
     * </p>
     *
     * @param deleteStackRequest
     *        The input for <a>DeleteStack</a> action.
     * @return Result of the DeleteStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteStackResponse deleteStack(DeleteStackRequest deleteStackRequest) throws TokenAlreadyExistsException,
            AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks do not
     * show up in the <a>DescribeStacks</a> API if the deletion has been completed successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackRequest#builder()}
     * </p>
     *
     * @param deleteStackRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStackInput.Builder} to create a request. The
     *        input for <a>DeleteStack</a> action.
     * @return Result of the DeleteStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteStackResponse deleteStack(Consumer<DeleteStackRequest.Builder> deleteStackRequest)
            throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        return deleteStack(DeleteStackRequest.builder().applyMutation(deleteStackRequest).build());
    }

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified Regions.
     * </p>
     *
     * @param deleteStackInstancesRequest
     * @return Result of the DeleteStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStackInstancesResponse deleteStackInstances(DeleteStackInstancesRequest deleteStackInstancesRequest)
            throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException,
            StaleRequestException, InvalidOperationException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStackInstancesRequest#builder()}
     * </p>
     *
     * @param deleteStackInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStackInstancesInput.Builder} to create a
     *        request.
     * @return Result of the DeleteStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStackInstancesResponse deleteStackInstances(
            Consumer<DeleteStackInstancesRequest.Builder> deleteStackInstancesRequest) throws StackSetNotFoundException,
            OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException,
            AwsServiceException, SdkClientException, CloudFormationException {
        return deleteStackInstances(DeleteStackInstancesRequest.builder().applyMutation(deleteStackInstancesRequest).build());
    }

    /**
     * <p>
     * Deletes a stack set. Before you can delete a stack set, all of its member stack instances must be deleted. For
     * more information about how to do this, see <a>DeleteStackInstances</a>.
     * </p>
     *
     * @param deleteStackSetRequest
     * @return Result of the DeleteStackSet operation returned by the service.
     * @throws StackSetNotEmptyException
     *         You can't yet delete this stack set, because it still contains one or more stack instances. Delete all
     *         stack instances from the stack set before deleting the stack set.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteStackSetResponse deleteStackSet(DeleteStackSetRequest deleteStackSetRequest) throws StackSetNotEmptyException,
            OperationInProgressException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a stack set. Before you can delete a stack set, all of its member stack instances must be deleted. For
     * more information about how to do this, see <a>DeleteStackInstances</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackSetRequest#builder()}
     * </p>
     *
     * @param deleteStackSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStackSetInput.Builder} to create a request.
     * @return Result of the DeleteStackSet operation returned by the service.
     * @throws StackSetNotEmptyException
     *         You can't yet delete this stack set, because it still contains one or more stack instances. Delete all
     *         stack instances from the stack set before deleting the stack set.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeleteStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteStackSetResponse deleteStackSet(Consumer<DeleteStackSetRequest.Builder> deleteStackSetRequest)
            throws StackSetNotEmptyException, OperationInProgressException, AwsServiceException, SdkClientException,
            CloudFormationException {
        return deleteStackSet(DeleteStackSetRequest.builder().applyMutation(deleteStackSetRequest).build());
    }

    /**
     * <p>
     * Marks an extension or extension version as <code>DEPRECATED</code> in the CloudFormation registry, removing it
     * from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
     * </p>
     * <p>
     * To deregister an entire extension, you must individually deregister all active versions of that extension. If an
     * extension has only a single active version, deregistering that version results in the extension itself being
     * deregistered and marked as deprecated in the registry.
     * </p>
     * <p>
     * You cannot deregister the default version of an extension if there are other active version of that extension. If
     * you do deregister the default version of an extension, the textensionype itself is deregistered as well and
     * marked as deprecated.
     * </p>
     * <p>
     * To view the deprecation status of an extension or extension version, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * </p>
     *
     * @param deregisterTypeRequest
     * @return Result of the DeregisterType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeregisterType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterTypeResponse deregisterType(DeregisterTypeRequest deregisterTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Marks an extension or extension version as <code>DEPRECATED</code> in the CloudFormation registry, removing it
     * from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations.
     * </p>
     * <p>
     * To deregister an entire extension, you must individually deregister all active versions of that extension. If an
     * extension has only a single active version, deregistering that version results in the extension itself being
     * deregistered and marked as deprecated in the registry.
     * </p>
     * <p>
     * You cannot deregister the default version of an extension if there are other active version of that extension. If
     * you do deregister the default version of an extension, the textensionype itself is deregistered as well and
     * marked as deprecated.
     * </p>
     * <p>
     * To view the deprecation status of an extension or extension version, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeregisterTypeRequest#builder()}
     * </p>
     *
     * @param deregisterTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterTypeInput.Builder} to create a request.
     * @return Result of the DeregisterType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DeregisterType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterTypeResponse deregisterType(Consumer<DeregisterTypeRequest.Builder> deregisterTypeRequest)
            throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return deregisterType(DeregisterTypeRequest.builder().applyMutation(deregisterTypeRequest).build());
    }

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation
     * Limits</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeAccountLimits
     * @see #describeAccountLimits(DescribeAccountLimitsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits() throws AwsServiceException, SdkClientException,
            CloudFormationException {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation
     * Limits</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation
     * Limits</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountLimitsInput.Builder} to create a
     *        request. The input for the <a>DescribeAccountLimits</a> action.
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest).build());
    }

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation
     * Limits</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsIterable responses = client
     *             .describeAccountLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeAccountLimits
     * @see #describeAccountLimitsPaginator(DescribeAccountLimitsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsIterable describeAccountLimitsPaginator() throws AwsServiceException, SdkClientException,
            CloudFormationException {
        return describeAccountLimitsPaginator(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation
     * Limits</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsIterable responses = client
     *             .describeAccountLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsIterable describeAccountLimitsPaginator(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves your account's CloudFormation limits, such as the maximum number of stacks that you can create in your
     * account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">CloudFormation
     * Limits</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsIterable responses = client
     *             .describeAccountLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountLimitsInput.Builder} to create a
     *        request. The input for the <a>DescribeAccountLimits</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsIterable describeAccountLimitsPaginator(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return describeAccountLimitsPaginator(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Updating Stacks Using Change Sets</a> in the CloudFormation User Guide.
     * </p>
     *
     * @param describeChangeSetRequest
     *        The input for the <a>DescribeChangeSet</a> action.
     * @return Result of the DescribeChangeSet operation returned by the service.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChangeSetResponse describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest)
            throws ChangeSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Updating Stacks Using Change Sets</a> in the CloudFormation User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChangeSetRequest#builder()}
     * </p>
     *
     * @param describeChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeChangeSetInput.Builder} to create a request.
     *        The input for the <a>DescribeChangeSet</a> action.
     * @return Result of the DescribeChangeSet operation returned by the service.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChangeSetResponse describeChangeSet(Consumer<DescribeChangeSetRequest.Builder> describeChangeSetRequest)
            throws ChangeSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return describeChangeSet(DescribeChangeSetRequest.builder().applyMutation(describeChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns information about a CloudFormation extension publisher.
     * </p>
     * <p>
     * If you do not supply a <code>PublisherId</code>, and you have registered as an extension publisher,
     * <code>DescribePublisher</code> returns information about your own publisher account.
     * </p>
     * <p>
     * For more information on registering as a publisher, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation CLI User Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describePublisherRequest
     * @return Result of the DescribePublisher operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribePublisher
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribePublisher"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePublisherResponse describePublisher(DescribePublisherRequest describePublisherRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a CloudFormation extension publisher.
     * </p>
     * <p>
     * If you do not supply a <code>PublisherId</code>, and you have registered as an extension publisher,
     * <code>DescribePublisher</code> returns information about your own publisher account.
     * </p>
     * <p>
     * For more information on registering as a publisher, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation CLI User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePublisherRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePublisherRequest#builder()}
     * </p>
     *
     * @param describePublisherRequest
     *        A {@link Consumer} that will call methods on {@link DescribePublisherInput.Builder} to create a request.
     * @return Result of the DescribePublisher operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribePublisher
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribePublisher"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePublisherResponse describePublisher(Consumer<DescribePublisherRequest.Builder> describePublisherRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        return describePublisher(DescribePublisherRequest.builder().applyMutation(describePublisherRequest).build());
    }

    /**
     * <p>
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a
     * stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the
     * stack template and any values specified as template parameters. A stack is considered to have drifted if one or
     * more of its resources have drifted. For more information on stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <a>DetectStackDrift</a> to initiate a stack drift detection operation. <code>DetectStackDrift</code> returns
     * a <code>StackDriftDetectionId</code> you can use to monitor the progress of the operation using
     * <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed, use
     * <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.
     * </p>
     *
     * @param describeStackDriftDetectionStatusRequest
     * @return Result of the DescribeStackDriftDetectionStatus operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackDriftDetectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackDriftDetectionStatusResponse describeStackDriftDetectionStatus(
            DescribeStackDriftDetectionStatusRequest describeStackDriftDetectionStatusRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a
     * stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the
     * stack template and any values specified as template parameters. A stack is considered to have drifted if one or
     * more of its resources have drifted. For more information on stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <a>DetectStackDrift</a> to initiate a stack drift detection operation. <code>DetectStackDrift</code> returns
     * a <code>StackDriftDetectionId</code> you can use to monitor the progress of the operation using
     * <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed, use
     * <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackDriftDetectionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStackDriftDetectionStatusRequest#builder()}
     * </p>
     *
     * @param describeStackDriftDetectionStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackDriftDetectionStatusInput.Builder} to
     *        create a request.
     * @return Result of the DescribeStackDriftDetectionStatus operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackDriftDetectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackDriftDetectionStatusResponse describeStackDriftDetectionStatus(
            Consumer<DescribeStackDriftDetectionStatusRequest.Builder> describeStackDriftDetectionStatusRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return describeStackDriftDetectionStatus(DescribeStackDriftDetectionStatusRequest.builder()
                .applyMutation(describeStackDriftDetectionStatusRequest).build());
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note>
     *
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return Result of the DescribeStackEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackEventsResponse describeStackEvents(DescribeStackEventsRequest describeStackEventsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackEventsRequest#builder()}
     * </p>
     *
     * @param describeStackEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackEventsInput.Builder} to create a request.
     *        The input for <a>DescribeStackEvents</a> action.
     * @return Result of the DescribeStackEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackEventsResponse describeStackEvents(
            Consumer<DescribeStackEventsRequest.Builder> describeStackEventsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return describeStackEvents(DescribeStackEventsRequest.builder().applyMutation(describeStackEventsRequest).build());
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsIterable responses = client.describeStackEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsIterable responses = client
     *             .describeStackEventsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsIterable responses = client.describeStackEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackEventsIterable describeStackEventsPaginator(DescribeStackEventsRequest describeStackEventsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsIterable responses = client.describeStackEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsIterable responses = client
     *             .describeStackEventsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsIterable responses = client.describeStackEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackEventsRequest#builder()}
     * </p>
     *
     * @param describeStackEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackEventsInput.Builder} to create a request.
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackEventsIterable describeStackEventsPaginator(
            Consumer<DescribeStackEventsRequest.Builder> describeStackEventsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return describeStackEventsPaginator(DescribeStackEventsRequest.builder().applyMutation(describeStackEventsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the stack instance that's associated with the specified stack set, Amazon Web Services account, and
     * Region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific stack set, use <a>ListStackInstances</a>.
     * </p>
     *
     * @param describeStackInstanceRequest
     * @return Result of the DescribeStackInstance operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackInstanceResponse describeStackInstance(DescribeStackInstanceRequest describeStackInstanceRequest)
            throws StackSetNotFoundException, StackInstanceNotFoundException, AwsServiceException, SdkClientException,
            CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the stack instance that's associated with the specified stack set, Amazon Web Services account, and
     * Region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific stack set, use <a>ListStackInstances</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackInstanceRequest#builder()}
     * </p>
     *
     * @param describeStackInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackInstanceInput.Builder} to create a
     *        request.
     * @return Result of the DescribeStackInstance operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackInstanceResponse describeStackInstance(
            Consumer<DescribeStackInstanceRequest.Builder> describeStackInstanceRequest) throws StackSetNotFoundException,
            StackInstanceNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return describeStackInstance(DescribeStackInstanceRequest.builder().applyMutation(describeStackInstanceRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param describeStackResourceRequest
     *        The input for <a>DescribeStackResource</a> action.
     * @return Result of the DescribeStackResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourceResponse describeStackResource(DescribeStackResourceRequest describeStackResourceRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackResourceRequest#builder()}
     * </p>
     *
     * @param describeStackResourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackResourceInput.Builder} to create a
     *        request. The input for <a>DescribeStackResource</a> action.
     * @return Result of the DescribeStackResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourceResponse describeStackResource(
            Consumer<DescribeStackResourceRequest.Builder> describeStackResourceRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return describeStackResource(DescribeStackResourceRequest.builder().applyMutation(describeStackResourceRequest).build());
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that haven't yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     * @return Result of the DescribeStackResourceDrifts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourceDriftsResponse describeStackResourceDrifts(
            DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that haven't yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourceDriftsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStackResourceDriftsRequest#builder()}
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackResourceDriftsInput.Builder} to create a
     *        request.
     * @return Result of the DescribeStackResourceDrifts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourceDriftsResponse describeStackResourceDrifts(
            Consumer<DescribeStackResourceDriftsRequest.Builder> describeStackResourceDriftsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return describeStackResourceDrifts(DescribeStackResourceDriftsRequest.builder()
                .applyMutation(describeStackResourceDriftsRequest).build());
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that haven't yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsIterable responses = client.describeStackResourceDriftsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsIterable responses = client
     *             .describeStackResourceDriftsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsIterable responses = client.describeStackResourceDriftsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourceDriftsIterable describeStackResourceDriftsPaginator(
            DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where CloudFormation detects configuration drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that haven't yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsIterable responses = client.describeStackResourceDriftsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsIterable responses = client
     *             .describeStackResourceDriftsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsIterable responses = client.describeStackResourceDriftsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourceDriftsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStackResourceDriftsRequest#builder()}
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackResourceDriftsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResourceDrifts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourceDriftsIterable describeStackResourceDriftsPaginator(
            Consumer<DescribeStackResourceDriftsRequest.Builder> describeStackResourceDriftsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return describeStackResourceDriftsPaginator(DescribeStackResourceDriftsRequest.builder()
                .applyMutation(describeStackResourceDriftsRequest).build());
    }

    /**
     * <p>
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If <code>StackName</code> is
     * specified, all the associated resources that are part of the stack are returned. If
     * <code>PhysicalResourceId</code> is specified, the associated resources of the stack that the resource belongs to
     * are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, go to the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note>
     *
     * @param describeStackResourcesRequest
     *        The input for <a>DescribeStackResources</a> action.
     * @return Result of the DescribeStackResources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourcesResponse describeStackResources(DescribeStackResourcesRequest describeStackResourcesRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns Amazon Web Services resource descriptions for running and deleted stacks. If <code>StackName</code> is
     * specified, all the associated resources that are part of the stack are returned. If
     * <code>PhysicalResourceId</code> is specified, the associated resources of the stack that the resource belongs to
     * are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, go to the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackResourcesRequest#builder()}
     * </p>
     *
     * @param describeStackResourcesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackResourcesInput.Builder} to create a
     *        request. The input for <a>DescribeStackResources</a> action.
     * @return Result of the DescribeStackResources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourcesResponse describeStackResources(
            Consumer<DescribeStackResourcesRequest.Builder> describeStackResourcesRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return describeStackResources(DescribeStackResourcesRequest.builder().applyMutation(describeStackResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns the description of the specified stack set.
     * </p>
     *
     * @param describeStackSetRequest
     * @return Result of the DescribeStackSet operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackSetResponse describeStackSet(DescribeStackSetRequest describeStackSetRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of the specified stack set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStackSetRequest#builder()}
     * </p>
     *
     * @param describeStackSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackSetInput.Builder} to create a request.
     * @return Result of the DescribeStackSet operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackSetResponse describeStackSet(Consumer<DescribeStackSetRequest.Builder> describeStackSetRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return describeStackSet(DescribeStackSetRequest.builder().applyMutation(describeStackSetRequest).build());
    }

    /**
     * <p>
     * Returns the description of the specified stack set operation.
     * </p>
     *
     * @param describeStackSetOperationRequest
     * @return Result of the DescribeStackSetOperation operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackSetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackSetOperationResponse describeStackSetOperation(
            DescribeStackSetOperationRequest describeStackSetOperationRequest) throws StackSetNotFoundException,
            OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of the specified stack set operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackSetOperationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStackSetOperationRequest#builder()}
     * </p>
     *
     * @param describeStackSetOperationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackSetOperationInput.Builder} to create a
     *        request.
     * @return Result of the DescribeStackSetOperation operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStackSetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackSetOperationResponse describeStackSetOperation(
            Consumer<DescribeStackSetOperationRequest.Builder> describeStackSetOperationRequest)
            throws StackSetNotFoundException, OperationNotFoundException, AwsServiceException, SdkClientException,
            CloudFormationException {
        return describeStackSetOperation(DescribeStackSetOperationRequest.builder()
                .applyMutation(describeStackSetOperationRequest).build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStacks
     * @see #describeStacks(DescribeStacksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksResponse describeStacks() throws AwsServiceException, SdkClientException, CloudFormationException {
        return describeStacks(DescribeStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksResponse describeStacks(DescribeStacksRequest describeStacksRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>ValidationError</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStacksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStacksRequest#builder()}
     * </p>
     *
     * @param describeStacksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStacksInput.Builder} to create a request. The
     *        input for <a>DescribeStacks</a> action.
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksResponse describeStacks(Consumer<DescribeStacksRequest.Builder> describeStacksRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return describeStacks(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>ValidationError</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable responses = client.describeStacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable responses = client
     *             .describeStacksPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable responses = client.describeStacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStacks
     * @see #describeStacksPaginator(DescribeStacksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksIterable describeStacksPaginator() throws AwsServiceException, SdkClientException,
            CloudFormationException {
        return describeStacksPaginator(DescribeStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>ValidationError</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable responses = client.describeStacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable responses = client
     *             .describeStacksPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable responses = client.describeStacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksIterable describeStacksPaginator(DescribeStacksRequest describeStacksRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>ValidationError</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable responses = client.describeStacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable responses = client
     *             .describeStacksPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable responses = client.describeStacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStacksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStacksRequest#builder()}
     * </p>
     *
     * @param describeStacksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStacksInput.Builder} to create a request. The
     *        input for <a>DescribeStacks</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksIterable describeStacksPaginator(Consumer<DescribeStacksRequest.Builder> describeStacksRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return describeStacksPaginator(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about an extension that has been registered.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific
     * extension version. Otherwise, it returns information about the default extension version.
     * </p>
     *
     * @param describeTypeRequest
     * @return Result of the DescribeType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTypeResponse describeType(DescribeTypeRequest describeTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about an extension that has been registered.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific
     * extension version. Otherwise, it returns information about the default extension version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTypeRequest#builder()}
     * </p>
     *
     * @param describeTypeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTypeInput.Builder} to create a request.
     * @return Result of the DescribeType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTypeResponse describeType(Consumer<DescribeTypeRequest.Builder> describeTypeRequest)
            throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return describeType(DescribeTypeRequest.builder().applyMutation(describeTypeRequest).build());
    }

    /**
     * <p>
     * Returns information about an extension's registration, including its current status and type and version
     * identifiers.
     * </p>
     * <p>
     * When you initiate a registration request using <code> <a>RegisterType</a> </code>, you can then use
     * <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of that registration request.
     * </p>
     * <p>
     * Once the registration request has completed, use <code> <a>DescribeType</a> </code> to return detailed
     * information about an extension.
     * </p>
     *
     * @param describeTypeRegistrationRequest
     * @return Result of the DescribeTypeRegistration operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeTypeRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTypeRegistrationResponse describeTypeRegistration(
            DescribeTypeRegistrationRequest describeTypeRegistrationRequest) throws CfnRegistryException, AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an extension's registration, including its current status and type and version
     * identifiers.
     * </p>
     * <p>
     * When you initiate a registration request using <code> <a>RegisterType</a> </code>, you can then use
     * <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of that registration request.
     * </p>
     * <p>
     * Once the registration request has completed, use <code> <a>DescribeType</a> </code> to return detailed
     * information about an extension.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTypeRegistrationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTypeRegistrationRequest#builder()}
     * </p>
     *
     * @param describeTypeRegistrationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTypeRegistrationInput.Builder} to create a
     *        request.
     * @return Result of the DescribeTypeRegistration operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DescribeTypeRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTypeRegistrationResponse describeTypeRegistration(
            Consumer<DescribeTypeRegistrationRequest.Builder> describeTypeRegistrationRequest) throws CfnRegistryException,
            AwsServiceException, SdkClientException, CloudFormationException {
        return describeTypeRegistration(DescribeTypeRegistrationRequest.builder().applyMutation(describeTypeRegistrationRequest)
                .build());
    }

    /**
     * <p>
     * Detects whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration,
     * as defined in the stack template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected
     * template configuration. Only resource properties explicitly defined in the stack template are checked for drift.
     * A stack is considered to have drifted if one or more of its resources differ from their expected template
     * configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackDrift</code> to detect drift on all supported resources for a given stack, or
     * <a>DetectStackResourceDrift</a> to detect drift on individual resources.
     * </p>
     * <p>
     * For a list of stack resources that currently support drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * <code>DetectStackDrift</code> can take up to several minutes, depending on the number of resources contained
     * within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack drift
     * operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return
     * drift information about the stack and its resources.
     * </p>
     * <p>
     * When detecting drift on a stack, CloudFormation does not detect drift on any nested stacks belonging to that
     * stack. Perform <code>DetectStackDrift</code> directly on the nested stack itself.
     * </p>
     *
     * @param detectStackDriftRequest
     * @return Result of the DetectStackDrift operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DetectStackDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectStackDriftResponse detectStackDrift(DetectStackDriftRequest detectStackDriftRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration,
     * as defined in the stack template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, CloudFormation compares the actual configuration of the resource with its expected
     * template configuration. Only resource properties explicitly defined in the stack template are checked for drift.
     * A stack is considered to have drifted if one or more of its resources differ from their expected template
     * configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackDrift</code> to detect drift on all supported resources for a given stack, or
     * <a>DetectStackResourceDrift</a> to detect drift on individual resources.
     * </p>
     * <p>
     * For a list of stack resources that currently support drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * <code>DetectStackDrift</code> can take up to several minutes, depending on the number of resources contained
     * within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack drift
     * operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return
     * drift information about the stack and its resources.
     * </p>
     * <p>
     * When detecting drift on a stack, CloudFormation does not detect drift on any nested stacks belonging to that
     * stack. Perform <code>DetectStackDrift</code> directly on the nested stack itself.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectStackDriftRequest.Builder} avoiding the need
     * to create one manually via {@link DetectStackDriftRequest#builder()}
     * </p>
     *
     * @param detectStackDriftRequest
     *        A {@link Consumer} that will call methods on {@link DetectStackDriftInput.Builder} to create a request.
     * @return Result of the DetectStackDrift operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DetectStackDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectStackDriftResponse detectStackDrift(Consumer<DetectStackDriftRequest.Builder> detectStackDriftRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return detectStackDrift(DetectStackDriftRequest.builder().applyMutation(detectStackDriftRequest).build());
    }

    /**
     * <p>
     * Returns information about whether a resource's actual configuration differs, or has <i>drifted</i>, from it's
     * expected configuration, as defined in the stack template and any values specified as template parameters. This
     * information includes actual and expected property values for resources in which CloudFormation detects drift.
     * Only resource properties explicitly defined in the stack template are checked for drift. For more information
     * about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <a>DetectStackDrift</a> to
     * detect drift on all resources in a given stack that support drift detection.
     * </p>
     * <p>
     * Resources that do not currently support drift detection cannot be checked. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     *
     * @param detectStackResourceDriftRequest
     * @return Result of the DetectStackResourceDrift operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DetectStackResourceDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectStackResourceDriftResponse detectStackResourceDrift(
            DetectStackResourceDriftRequest detectStackResourceDriftRequest) throws AwsServiceException, SdkClientException,
            CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about whether a resource's actual configuration differs, or has <i>drifted</i>, from it's
     * expected configuration, as defined in the stack template and any values specified as template parameters. This
     * information includes actual and expected property values for resources in which CloudFormation detects drift.
     * Only resource properties explicitly defined in the stack template are checked for drift. For more information
     * about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <a>DetectStackDrift</a> to
     * detect drift on all resources in a given stack that support drift detection.
     * </p>
     * <p>
     * Resources that do not currently support drift detection cannot be checked. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectStackResourceDriftRequest.Builder} avoiding
     * the need to create one manually via {@link DetectStackResourceDriftRequest#builder()}
     * </p>
     *
     * @param detectStackResourceDriftRequest
     *        A {@link Consumer} that will call methods on {@link DetectStackResourceDriftInput.Builder} to create a
     *        request.
     * @return Result of the DetectStackResourceDrift operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DetectStackResourceDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectStackResourceDriftResponse detectStackResourceDrift(
            Consumer<DetectStackResourceDriftRequest.Builder> detectStackResourceDriftRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return detectStackResourceDrift(DetectStackResourceDriftRequest.builder().applyMutation(detectStackResourceDriftRequest)
                .build());
    }

    /**
     * <p>
     * Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift
     * detection on the stack associated with each stack instance in the stack set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">How CloudFormation
     * Performs Drift Detection on a Stack Set</a>.
     * </p>
     * <p>
     * <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the stack set drift detection operation.
     * Use this operation id with <code> <a>DescribeStackSetOperation</a> </code> to monitor the progress of the drift
     * detection operation. The drift detection operation may take some time, depending on the number of stack instances
     * included in the stack set, as well as the number of resources included in each stack.
     * </p>
     * <p>
     * Once the operation has completed, use the following actions to return drift information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code> <a>DescribeStackSet</a> </code> to return detailed information about the stack set, including detailed
     * information about the last <i>completed</i> drift operation performed on the stack set. (Information about drift
     * operations that are in progress is not included.)
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code> <a>ListStackInstances</a> </code> to return a list of stack instances belonging to the stack set,
     * including the drift status and last drift time checked of each instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code> <a>DescribeStackInstance</a> </code> to return detailed information about a specific stack instance,
     * including its drift status and last drift time checked.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on performing a drift detection operation on a stack set, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged
     * Changes in Stack Sets</a>.
     * </p>
     * <p>
     * You can only run a single drift detection operation on a given stack set at one time.
     * </p>
     * <p>
     * To stop a drift detection stack set operation, use <code> <a>StopStackSetOperation</a> </code>.
     * </p>
     *
     * @param detectStackSetDriftRequest
     * @return Result of the DetectStackSetDrift operation returned by the service.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DetectStackSetDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectStackSetDriftResponse detectStackSetDrift(DetectStackSetDriftRequest detectStackSetDriftRequest)
            throws InvalidOperationException, OperationInProgressException, StackSetNotFoundException, AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift
     * detection on the stack associated with each stack instance in the stack set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">How CloudFormation
     * Performs Drift Detection on a Stack Set</a>.
     * </p>
     * <p>
     * <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the stack set drift detection operation.
     * Use this operation id with <code> <a>DescribeStackSetOperation</a> </code> to monitor the progress of the drift
     * detection operation. The drift detection operation may take some time, depending on the number of stack instances
     * included in the stack set, as well as the number of resources included in each stack.
     * </p>
     * <p>
     * Once the operation has completed, use the following actions to return drift information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code> <a>DescribeStackSet</a> </code> to return detailed information about the stack set, including detailed
     * information about the last <i>completed</i> drift operation performed on the stack set. (Information about drift
     * operations that are in progress is not included.)
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code> <a>ListStackInstances</a> </code> to return a list of stack instances belonging to the stack set,
     * including the drift status and last drift time checked of each instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code> <a>DescribeStackInstance</a> </code> to return detailed information about a specific stack instance,
     * including its drift status and last drift time checked.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on performing a drift detection operation on a stack set, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged
     * Changes in Stack Sets</a>.
     * </p>
     * <p>
     * You can only run a single drift detection operation on a given stack set at one time.
     * </p>
     * <p>
     * To stop a drift detection stack set operation, use <code> <a>StopStackSetOperation</a> </code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectStackSetDriftRequest.Builder} avoiding the
     * need to create one manually via {@link DetectStackSetDriftRequest#builder()}
     * </p>
     *
     * @param detectStackSetDriftRequest
     *        A {@link Consumer} that will call methods on {@link DetectStackSetDriftInput.Builder} to create a request.
     * @return Result of the DetectStackSetDrift operation returned by the service.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.DetectStackSetDrift
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default DetectStackSetDriftResponse detectStackSetDrift(
            Consumer<DetectStackSetDriftRequest.Builder> detectStackSetDriftRequest) throws InvalidOperationException,
            OperationInProgressException, StackSetNotFoundException, AwsServiceException, SdkClientException,
            CloudFormationException {
        return detectStackSetDrift(DetectStackSetDriftRequest.builder().applyMutation(detectStackSetDriftRequest).build());
    }

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly
     * Calculator URL with a query string that describes the resources required to run the template.
     * </p>
     *
     * @param estimateTemplateCostRequest
     *        The input for an <a>EstimateTemplateCost</a> action.
     * @return Result of the EstimateTemplateCost operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.EstimateTemplateCost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    default EstimateTemplateCostResponse estimateTemplateCost(EstimateTemplateCostRequest estimateTemplateCostRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly
     * Calculator URL with a query string that describes the resources required to run the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EstimateTemplateCostRequest.Builder} avoiding the
     * need to create one manually via {@link EstimateTemplateCostRequest#builder()}
     * </p>
     *
     * @param estimateTemplateCostRequest
     *        A {@link Consumer} that will call methods on {@link EstimateTemplateCostInput.Builder} to create a
     *        request. The input for an <a>EstimateTemplateCost</a> action.
     * @return Result of the EstimateTemplateCost operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.EstimateTemplateCost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    default EstimateTemplateCostResponse estimateTemplateCost(
            Consumer<EstimateTemplateCostRequest.Builder> estimateTemplateCostRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return estimateTemplateCost(EstimateTemplateCostRequest.builder().applyMutation(estimateTemplateCostRequest).build());
    }

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, CloudFormation starts updating the stack. Use the <a>DescribeStacks</a> action
     * to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't
     * specify a temporary stack policy that overrides the current policy.
     * </p>
     * <p>
     * To create a change set for the entire stack hierachy, <code>IncludeNestedStacks</code> must have been set to
     * <code>True</code>.
     * </p>
     *
     * @param executeChangeSetRequest
     *        The input for the <a>ExecuteChangeSet</a> action.
     * @return Result of the ExecuteChangeSet operation returned by the service.
     * @throws InvalidChangeSetStatusException
     *         The specified change set can't be used to update the stack. For example, the change set status might be
     *         <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> action.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ExecuteChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteChangeSetResponse executeChangeSet(ExecuteChangeSetRequest executeChangeSetRequest)
            throws InvalidChangeSetStatusException, ChangeSetNotFoundException, InsufficientCapabilitiesException,
            TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, CloudFormation starts updating the stack. Use the <a>DescribeStacks</a> action
     * to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't
     * specify a temporary stack policy that overrides the current policy.
     * </p>
     * <p>
     * To create a change set for the entire stack hierachy, <code>IncludeNestedStacks</code> must have been set to
     * <code>True</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link ExecuteChangeSetRequest#builder()}
     * </p>
     *
     * @param executeChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link ExecuteChangeSetInput.Builder} to create a request.
     *        The input for the <a>ExecuteChangeSet</a> action.
     * @return Result of the ExecuteChangeSet operation returned by the service.
     * @throws InvalidChangeSetStatusException
     *         The specified change set can't be used to update the stack. For example, the change set status might be
     *         <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> action.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ExecuteChangeSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteChangeSetResponse executeChangeSet(Consumer<ExecuteChangeSetRequest.Builder> executeChangeSetRequest)
            throws InvalidChangeSetStatusException, ChangeSetNotFoundException, InsufficientCapabilitiesException,
            TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        return executeChangeSet(ExecuteChangeSetRequest.builder().applyMutation(executeChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     *
     * @param getStackPolicyRequest
     *        The input for the <a>GetStackPolicy</a> action.
     * @return Result of the GetStackPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.GetStackPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetStackPolicyResponse getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStackPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetStackPolicyRequest#builder()}
     * </p>
     *
     * @param getStackPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetStackPolicyInput.Builder} to create a request. The
     *        input for the <a>GetStackPolicy</a> action.
     * @return Result of the GetStackPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.GetStackPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetStackPolicyResponse getStackPolicy(Consumer<GetStackPolicyRequest.Builder> getStackPolicyRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return getStackPolicy(GetStackPolicyRequest.builder().applyMutation(getStackPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, GetTemplate returns the template for up to 90 days after the stack has been deleted.
     * </p>
     * <note>
     * <p>
     * If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @param getTemplateRequest
     *        The input for a <a>GetTemplate</a> action.
     * @return Result of the GetTemplate operation returned by the service.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws ChangeSetNotFoundException,
            AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, GetTemplate returns the template for up to 90 days after the stack has been deleted.
     * </p>
     * <note>
     * <p>
     * If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetTemplateRequest#builder()}
     * </p>
     *
     * @param getTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetTemplateInput.Builder} to create a request. The
     *        input for a <a>GetTemplate</a> action.
     * @return Result of the GetTemplate operation returned by the service.
     * @throws ChangeSetNotFoundException
     *         The specified change set name or ID doesn't exit. To view valid change sets for a stack, use the
     *         <code>ListChangeSets</code> action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTemplateResponse getTemplate(Consumer<GetTemplateRequest.Builder> getTemplateRequest)
            throws ChangeSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return getTemplate(GetTemplateRequest.builder().applyMutation(getTemplateRequest).build());
    }

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or stack set.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a stack set, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     *
     * @param getTemplateSummaryRequest
     *        The input for the <a>GetTemplateSummary</a> action.
     * @return Result of the GetTemplateSummary operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.GetTemplateSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTemplateSummaryResponse getTemplateSummary(GetTemplateSummaryRequest getTemplateSummaryRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or stack set.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a stack set, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetTemplateSummaryRequest#builder()}
     * </p>
     *
     * @param getTemplateSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetTemplateSummaryInput.Builder} to create a request.
     *        The input for the <a>GetTemplateSummary</a> action.
     * @return Result of the GetTemplateSummary operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.GetTemplateSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTemplateSummaryResponse getTemplateSummary(Consumer<GetTemplateSummaryRequest.Builder> getTemplateSummaryRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return getTemplateSummary(GetTemplateSummaryRequest.builder().applyMutation(getTemplateSummaryRequest).build());
    }

    /**
     * <p>
     * Use the stack import operations for self-managed or service-managed StackSets. For self-managed StackSets, the
     * import operation can import stacks in the administrator account or in different target accounts and Amazon Web
     * Services Regions. For service-managed StackSets, the import operation can import any stack in the same AWS
     * Organizations as the management account. The import operation can import up to 10 stacks using inline stack IDs
     * or up to 10,000 stacks using an Amazon S3 object.
     * </p>
     *
     * @param importStacksToStackSetRequest
     * @return Result of the ImportStacksToStackSet operation returned by the service.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>CloudFormation User Guide</i>.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StackNotFoundException
     *         The specified stack ARN doesn’t exist or stack doesn’t exist corresponding to the ARN in input.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ImportStacksToStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ImportStacksToStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportStacksToStackSetResponse importStacksToStackSet(ImportStacksToStackSetRequest importStacksToStackSetRequest)
            throws LimitExceededException, StackSetNotFoundException, InvalidOperationException, OperationInProgressException,
            OperationIdAlreadyExistsException, StackNotFoundException, StaleRequestException, AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use the stack import operations for self-managed or service-managed StackSets. For self-managed StackSets, the
     * import operation can import stacks in the administrator account or in different target accounts and Amazon Web
     * Services Regions. For service-managed StackSets, the import operation can import any stack in the same AWS
     * Organizations as the management account. The import operation can import up to 10 stacks using inline stack IDs
     * or up to 10,000 stacks using an Amazon S3 object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportStacksToStackSetRequest.Builder} avoiding the
     * need to create one manually via {@link ImportStacksToStackSetRequest#builder()}
     * </p>
     *
     * @param importStacksToStackSetRequest
     *        A {@link Consumer} that will call methods on {@link ImportStacksToStackSetInput.Builder} to create a
     *        request.
     * @return Result of the ImportStacksToStackSet operation returned by the service.
     * @throws LimitExceededException
     *         The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>CloudFormation User Guide</i>.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StackNotFoundException
     *         The specified stack ARN doesn’t exist or stack doesn’t exist corresponding to the ARN in input.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ImportStacksToStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ImportStacksToStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportStacksToStackSetResponse importStacksToStackSet(
            Consumer<ImportStacksToStackSetRequest.Builder> importStacksToStackSetRequest) throws LimitExceededException,
            StackSetNotFoundException, InvalidOperationException, OperationInProgressException,
            OperationIdAlreadyExistsException, StackNotFoundException, StaleRequestException, AwsServiceException,
            SdkClientException, CloudFormationException {
        return importStacksToStackSet(ImportStacksToStackSetRequest.builder().applyMutation(importStacksToStackSetRequest)
                .build());
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets
     * that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     *
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return Result of the ListChangeSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChangeSetsResponse listChangeSets(ListChangeSetsRequest listChangeSetsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets
     * that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     * </p>
     *
     * @param listChangeSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListChangeSetsInput.Builder} to create a request. The
     *        input for the <a>ListChangeSets</a> action.
     * @return Result of the ListChangeSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChangeSetsResponse listChangeSets(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return listChangeSets(ListChangeSetsRequest.builder().applyMutation(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets
     * that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsIterable responses = client.listChangeSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsIterable responses = client
     *             .listChangeSetsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsIterable responses = client.listChangeSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChangeSetsIterable listChangeSetsPaginator(ListChangeSetsRequest listChangeSetsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets
     * that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsIterable responses = client.listChangeSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsIterable responses = client
     *             .listChangeSetsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsIterable responses = client.listChangeSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     * </p>
     *
     * @param listChangeSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListChangeSetsInput.Builder} to create a request. The
     *        input for the <a>ListChangeSets</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListChangeSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChangeSetsIterable listChangeSetsPaginator(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return listChangeSetsPaginator(ListChangeSetsRequest.builder().applyMutation(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     *
     * @return Result of the ListExports operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListExports
     * @see #listExports(ListExportsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExportsResponse listExports() throws AwsServiceException, SdkClientException, CloudFormationException {
        return listExports(ListExportsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     *
     * @param listExportsRequest
     * @return Result of the ListExports operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportsInput.Builder} to create a request.
     * @return Result of the ListExports operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExportsResponse listExports(Consumer<ListExportsRequest.Builder> listExportsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return listExports(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable responses = client
     *             .listExportsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListExports
     * @see #listExportsPaginator(ListExportsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExportsIterable listExportsPaginator() throws AwsServiceException, SdkClientException, CloudFormationException {
        return listExportsPaginator(ListExportsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable responses = client
     *             .listExportsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @param listExportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExportsIterable listExportsPaginator(ListExportsRequest listExportsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html">
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable responses = client
     *             .listExportsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExportsIterable listExportsPaginator(Consumer<ListExportsRequest.Builder> listExportsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return listExportsPaginator(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     *
     * @param listImportsRequest
     * @return Result of the ListImports operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsInput.Builder} to create a request.
     * @return Result of the ListImports operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportsResponse listImports(Consumer<ListImportsRequest.Builder> listImportsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return listImports(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListImportsIterable responses = client
     *             .listImportsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListImportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportsIterable listImportsPaginator(ListImportsRequest listImportsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListImportsIterable responses = client
     *             .listImportsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListImportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportsIterable listImportsPaginator(Consumer<ListImportsRequest.Builder> listImportsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return listImportsPaginator(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or
     * that have a specific status.
     * </p>
     *
     * @param listStackInstancesRequest
     * @return Result of the ListStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackInstancesResponse listStackInstances(ListStackInstancesRequest listStackInstancesRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or
     * that have a specific status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackInstancesRequest#builder()}
     * </p>
     *
     * @param listStackInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListStackInstancesInput.Builder} to create a request.
     * @return Result of the ListStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackInstancesResponse listStackInstances(Consumer<ListStackInstancesRequest.Builder> listStackInstancesRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return listStackInstances(ListStackInstancesRequest.builder().applyMutation(listStackInstancesRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or
     * that have a specific status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesIterable responses = client.listStackInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesIterable responses = client
     *             .listStackInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesIterable responses = client.listStackInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackInstancesIterable listStackInstancesPaginator(ListStackInstancesRequest listStackInstancesRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or
     * that have a specific status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesIterable responses = client.listStackInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesIterable responses = client
     *             .listStackInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesIterable responses = client.listStackInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackInstancesRequest#builder()}
     * </p>
     *
     * @param listStackInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListStackInstancesInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackInstancesIterable listStackInstancesPaginator(
            Consumer<ListStackInstancesRequest.Builder> listStackInstancesRequest) throws StackSetNotFoundException,
            AwsServiceException, SdkClientException, CloudFormationException {
        return listStackInstancesPaginator(ListStackInstancesRequest.builder().applyMutation(listStackInstancesRequest).build());
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return Result of the ListStackResources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackResourcesResponse listStackResources(ListStackResourcesRequest listStackResourcesRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackResourcesRequest#builder()}
     * </p>
     *
     * @param listStackResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListStackResourcesInput.Builder} to create a request.
     *        The input for the <a>ListStackResource</a> action.
     * @return Result of the ListStackResources operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackResourcesResponse listStackResources(Consumer<ListStackResourcesRequest.Builder> listStackResourcesRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return listStackResources(ListStackResourcesRequest.builder().applyMutation(listStackResourcesRequest).build());
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesIterable responses = client.listStackResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesIterable responses = client
     *             .listStackResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesIterable responses = client.listStackResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackResourcesIterable listStackResourcesPaginator(ListStackResourcesRequest listStackResourcesRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesIterable responses = client.listStackResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesIterable responses = client
     *             .listStackResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesIterable responses = client.listStackResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackResourcesRequest#builder()}
     * </p>
     *
     * @param listStackResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListStackResourcesInput.Builder} to create a request.
     *        The input for the <a>ListStackResource</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackResourcesIterable listStackResourcesPaginator(
            Consumer<ListStackResourcesRequest.Builder> listStackResourcesRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return listStackResourcesPaginator(ListStackResourcesRequest.builder().applyMutation(listStackResourcesRequest).build());
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     * @return Result of the ListStackSetOperationResults operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationResultsResponse listStackSetOperationResults(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) throws StackSetNotFoundException,
            OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationResultsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStackSetOperationResultsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetOperationResultsInput.Builder} to create a
     *        request.
     * @return Result of the ListStackSetOperationResults operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationResultsResponse listStackSetOperationResults(
            Consumer<ListStackSetOperationResultsRequest.Builder> listStackSetOperationResultsRequest)
            throws StackSetNotFoundException, OperationNotFoundException, AwsServiceException, SdkClientException,
            CloudFormationException {
        return listStackSetOperationResults(ListStackSetOperationResultsRequest.builder()
                .applyMutation(listStackSetOperationResultsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsIterable responses = client.listStackSetOperationResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsIterable responses = client
     *             .listStackSetOperationResultsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsIterable responses = client.listStackSetOperationResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationResultsIterable listStackSetOperationResultsPaginator(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) throws StackSetNotFoundException,
            OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsIterable responses = client.listStackSetOperationResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsIterable responses = client
     *             .listStackSetOperationResultsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsIterable responses = client.listStackSetOperationResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationResultsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStackSetOperationResultsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetOperationResultsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationResultsIterable listStackSetOperationResultsPaginator(
            Consumer<ListStackSetOperationResultsRequest.Builder> listStackSetOperationResultsRequest)
            throws StackSetNotFoundException, OperationNotFoundException, AwsServiceException, SdkClientException,
            CloudFormationException {
        return listStackSetOperationResultsPaginator(ListStackSetOperationResultsRequest.builder()
                .applyMutation(listStackSetOperationResultsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     *
     * @param listStackSetOperationsRequest
     * @return Result of the ListStackSetOperations operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationsResponse listStackSetOperations(ListStackSetOperationsRequest listStackSetOperationsRequest)
            throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackSetOperationsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetOperationsInput.Builder} to create a
     *        request.
     * @return Result of the ListStackSetOperations operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationsResponse listStackSetOperations(
            Consumer<ListStackSetOperationsRequest.Builder> listStackSetOperationsRequest) throws StackSetNotFoundException,
            AwsServiceException, SdkClientException, CloudFormationException {
        return listStackSetOperations(ListStackSetOperationsRequest.builder().applyMutation(listStackSetOperationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsIterable responses = client.listStackSetOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsIterable responses = client
     *             .listStackSetOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsIterable responses = client.listStackSetOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackSetOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationsIterable listStackSetOperationsPaginator(
            ListStackSetOperationsRequest listStackSetOperationsRequest) throws StackSetNotFoundException, AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsIterable responses = client.listStackSetOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsIterable responses = client
     *             .listStackSetOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsIterable responses = client.listStackSetOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackSetOperationsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetOperationsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSetOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationsIterable listStackSetOperationsPaginator(
            Consumer<ListStackSetOperationsRequest.Builder> listStackSetOperationsRequest) throws StackSetNotFoundException,
            AwsServiceException, SdkClientException, CloudFormationException {
        return listStackSetOperationsPaginator(ListStackSetOperationsRequest.builder()
                .applyMutation(listStackSetOperationsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed stack sets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all stack sets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all stack sets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     *
     * @return Result of the ListStackSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSets
     * @see #listStackSets(ListStackSetsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsResponse listStackSets() throws AwsServiceException, SdkClientException, CloudFormationException {
        return listStackSets(ListStackSetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed stack sets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all stack sets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all stack sets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     *
     * @param listStackSetsRequest
     * @return Result of the ListStackSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsResponse listStackSets(ListStackSetsRequest listStackSetsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed stack sets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all stack sets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all stack sets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStackSetsRequest#builder()}
     * </p>
     *
     * @param listStackSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetsInput.Builder} to create a request.
     * @return Result of the ListStackSets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsResponse listStackSets(Consumer<ListStackSetsRequest.Builder> listStackSetsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return listStackSets(ListStackSetsRequest.builder().applyMutation(listStackSetsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed stack sets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all stack sets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all stack sets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsIterable responses = client.listStackSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsIterable responses = client
     *             .listStackSetsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsIterable responses = client.listStackSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSets
     * @see #listStackSetsPaginator(ListStackSetsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsIterable listStackSetsPaginator() throws AwsServiceException, SdkClientException,
            CloudFormationException {
        return listStackSetsPaginator(ListStackSetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed stack sets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all stack sets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all stack sets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsIterable responses = client.listStackSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsIterable responses = client
     *             .listStackSetsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsIterable responses = client.listStackSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation.</b>
     * </p>
     *
     * @param listStackSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsIterable listStackSetsPaginator(ListStackSetsRequest listStackSetsRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <ul>
     * <li>
     * <p>
     * [Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in to
     * your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed stack sets in your Amazon
     * Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
     * to the organization's management account, <code>ListStackSets</code> returns all stack sets in the management
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * [Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code> while
     * signed in to your member account, <code>ListStackSets</code> returns all stack sets with service-managed
     * permissions in the management account.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsIterable responses = client.listStackSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsIterable responses = client
     *             .listStackSetsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsIterable responses = client.listStackSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStackSetsRequest#builder()}
     * </p>
     *
     * @param listStackSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStackSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsIterable listStackSetsPaginator(Consumer<ListStackSetsRequest.Builder> listStackSetsRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return listStackSetsPaginator(ListStackSetsRequest.builder().applyMutation(listStackSetsRequest).build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     *
     * @return Result of the ListStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStacks
     * @see #listStacks(ListStacksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksResponse listStacks() throws AwsServiceException, SdkClientException, CloudFormationException {
        return listStacks(ListStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     *
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return Result of the ListStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksResponse listStacks(ListStacksRequest listStacksRequest) throws AwsServiceException, SdkClientException,
            CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListStacksRequest#builder()}
     * </p>
     *
     * @param listStacksRequest
     *        A {@link Consumer} that will call methods on {@link ListStacksInput.Builder} to create a request. The
     *        input for <a>ListStacks</a> action.
     * @return Result of the ListStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksResponse listStacks(Consumer<ListStacksRequest.Builder> listStacksRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return listStacks(ListStacksRequest.builder().applyMutation(listStacksRequest).build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable responses = client.listStacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable responses = client.listStacksPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable responses = client.listStacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStacks
     * @see #listStacksPaginator(ListStacksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksIterable listStacksPaginator() throws AwsServiceException, SdkClientException, CloudFormationException {
        return listStacksPaginator(ListStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable responses = client.listStacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable responses = client.listStacksPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable responses = client.listStacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)} operation.</b>
     * </p>
     *
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksIterable listStacksPaginator(ListStacksRequest listStacksRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable responses = client.listStacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable responses = client.listStacksPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListStacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable responses = client.listStacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListStacksRequest#builder()}
     * </p>
     *
     * @param listStacksRequest
     *        A {@link Consumer} that will call methods on {@link ListStacksInput.Builder} to create a request. The
     *        input for <a>ListStacks</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksIterable listStacksPaginator(Consumer<ListStacksRequest.Builder> listStacksRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return listStacksPaginator(ListStacksRequest.builder().applyMutation(listStacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified extension(s).
     * </p>
     *
     * @param listTypeRegistrationsRequest
     * @return Result of the ListTypeRegistrations operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeRegistrationsResponse listTypeRegistrations(ListTypeRegistrationsRequest listTypeRegistrationsRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified extension(s).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTypeRegistrationsRequest#builder()}
     * </p>
     *
     * @param listTypeRegistrationsRequest
     *        A {@link Consumer} that will call methods on {@link ListTypeRegistrationsInput.Builder} to create a
     *        request.
     * @return Result of the ListTypeRegistrations operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeRegistrationsResponse listTypeRegistrations(
            Consumer<ListTypeRegistrationsRequest.Builder> listTypeRegistrationsRequest) throws CfnRegistryException,
            AwsServiceException, SdkClientException, CloudFormationException {
        return listTypeRegistrations(ListTypeRegistrationsRequest.builder().applyMutation(listTypeRegistrationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified extension(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsIterable responses = client.listTypeRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsIterable responses = client
     *             .listTypeRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsIterable responses = client.listTypeRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypeRegistrationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeRegistrationsIterable listTypeRegistrationsPaginator(ListTypeRegistrationsRequest listTypeRegistrationsRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified extension(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsIterable responses = client.listTypeRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsIterable responses = client
     *             .listTypeRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsIterable responses = client.listTypeRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTypeRegistrationsRequest#builder()}
     * </p>
     *
     * @param listTypeRegistrationsRequest
     *        A {@link Consumer} that will call methods on {@link ListTypeRegistrationsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypeRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeRegistrationsIterable listTypeRegistrationsPaginator(
            Consumer<ListTypeRegistrationsRequest.Builder> listTypeRegistrationsRequest) throws CfnRegistryException,
            AwsServiceException, SdkClientException, CloudFormationException {
        return listTypeRegistrationsPaginator(ListTypeRegistrationsRequest.builder().applyMutation(listTypeRegistrationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns summary information about the versions of an extension.
     * </p>
     *
     * @param listTypeVersionsRequest
     * @return Result of the ListTypeVersions operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeVersionsResponse listTypeVersions(ListTypeVersionsRequest listTypeVersionsRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the versions of an extension.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTypeVersionsRequest#builder()}
     * </p>
     *
     * @param listTypeVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTypeVersionsInput.Builder} to create a request.
     * @return Result of the ListTypeVersions operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeVersionsResponse listTypeVersions(Consumer<ListTypeVersionsRequest.Builder> listTypeVersionsRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        return listTypeVersions(ListTypeVersionsRequest.builder().applyMutation(listTypeVersionsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about the versions of an extension.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsIterable responses = client.listTypeVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsIterable responses = client
     *             .listTypeVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsIterable responses = client.listTypeVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypeVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeVersionsIterable listTypeVersionsPaginator(ListTypeVersionsRequest listTypeVersionsRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the versions of an extension.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsIterable responses = client.listTypeVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsIterable responses = client
     *             .listTypeVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsIterable responses = client.listTypeVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTypeVersionsRequest#builder()}
     * </p>
     *
     * @param listTypeVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTypeVersionsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeVersionsIterable listTypeVersionsPaginator(Consumer<ListTypeVersionsRequest.Builder> listTypeVersionsRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        return listTypeVersionsPaginator(ListTypeVersionsRequest.builder().applyMutation(listTypeVersionsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about extension that have been registered with CloudFormation.
     * </p>
     *
     * @param listTypesRequest
     * @return Result of the ListTypes operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesResponse listTypes(ListTypesRequest listTypesRequest) throws CfnRegistryException, AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about extension that have been registered with CloudFormation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTypesRequest#builder()}
     * </p>
     *
     * @param listTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListTypesInput.Builder} to create a request.
     * @return Result of the ListTypes operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesResponse listTypes(Consumer<ListTypesRequest.Builder> listTypesRequest) throws CfnRegistryException,
            AwsServiceException, SdkClientException, CloudFormationException {
        return listTypes(ListTypesRequest.builder().applyMutation(listTypesRequest).build());
    }

    /**
     * <p>
     * Returns summary information about extension that have been registered with CloudFormation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)} operation.</b>
     * </p>
     *
     * @param listTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesIterable listTypesPaginator(ListTypesRequest listTypesRequest) throws CfnRegistryException,
            AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about extension that have been registered with CloudFormation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cloudformation.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     *     for (software.amazon.awssdk.services.cloudformation.model.ListTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTypesRequest#builder()}
     * </p>
     *
     * @param listTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListTypesInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesIterable listTypesPaginator(Consumer<ListTypesRequest.Builder> listTypesRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        return listTypesPaginator(ListTypesRequest.builder().applyMutation(listTypesRequest).build());
    }

    /**
     * <p>
     * Publishes the specified extension to the CloudFormation registry as a public extension in this region. Public
     * extensions are available for use by all CloudFormation users. For more information on publishing extensions, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>.
     * </p>
     *
     * @param publishTypeRequest
     * @return Result of the PublishType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.PublishType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/PublishType" target="_top">AWS
     *      API Documentation</a>
     */
    default PublishTypeResponse publishType(PublishTypeRequest publishTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes the specified extension to the CloudFormation registry as a public extension in this region. Public
     * extensions are available for use by all CloudFormation users. For more information on publishing extensions, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html">
     * RegisterPublisher</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishTypeRequest.Builder} avoiding the need to
     * create one manually via {@link PublishTypeRequest#builder()}
     * </p>
     *
     * @param publishTypeRequest
     *        A {@link Consumer} that will call methods on {@link PublishTypeInput.Builder} to create a request.
     * @return Result of the PublishType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.PublishType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/PublishType" target="_top">AWS
     *      API Documentation</a>
     */
    default PublishTypeResponse publishType(Consumer<PublishTypeRequest.Builder> publishTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return publishType(PublishTypeRequest.builder().applyMutation(publishTypeRequest).build());
    }

    /**
     * <p>
     * Reports progress of a resource handler to CloudFormation.
     * </p>
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>. Do not use this API in your code.
     * </p>
     *
     * @param recordHandlerProgressRequest
     * @return Result of the RecordHandlerProgress operation returned by the service.
     * @throws InvalidStateTransitionException
     *         Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation does not return this error to users.
     * @throws OperationStatusCheckFailedException
     *         Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation does not return this error to users.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RecordHandlerProgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress"
     *      target="_top">AWS API Documentation</a>
     */
    default RecordHandlerProgressResponse recordHandlerProgress(RecordHandlerProgressRequest recordHandlerProgressRequest)
            throws InvalidStateTransitionException, OperationStatusCheckFailedException, AwsServiceException, SdkClientException,
            CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reports progress of a resource handler to CloudFormation.
     * </p>
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>. Do not use this API in your code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RecordHandlerProgressRequest.Builder} avoiding the
     * need to create one manually via {@link RecordHandlerProgressRequest#builder()}
     * </p>
     *
     * @param recordHandlerProgressRequest
     *        A {@link Consumer} that will call methods on {@link RecordHandlerProgressInput.Builder} to create a
     *        request.
     * @return Result of the RecordHandlerProgress operation returned by the service.
     * @throws InvalidStateTransitionException
     *         Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation does not return this error to users.
     * @throws OperationStatusCheckFailedException
     *         Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation does not return this error to users.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RecordHandlerProgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress"
     *      target="_top">AWS API Documentation</a>
     */
    default RecordHandlerProgressResponse recordHandlerProgress(
            Consumer<RecordHandlerProgressRequest.Builder> recordHandlerProgressRequest) throws InvalidStateTransitionException,
            OperationStatusCheckFailedException, AwsServiceException, SdkClientException, CloudFormationException {
        return recordHandlerProgress(RecordHandlerProgressRequest.builder().applyMutation(recordHandlerProgressRequest).build());
    }

    /**
     * <p>
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are
     * available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web
     * Services Regions.
     * </p>
     * <p>
     * For information on requirements for registering as a public extension publisher, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs"
     * >Registering your account to publish CloudFormation extensions</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p/>
     *
     * @param registerPublisherRequest
     * @return Result of the RegisterPublisher operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RegisterPublisher
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterPublisher"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterPublisherResponse registerPublisher(RegisterPublisherRequest registerPublisherRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers your account as a publisher of public extensions in the CloudFormation registry. Public extensions are
     * available for use by all CloudFormation users. This publisher ID applies to your account in all Amazon Web
     * Services Regions.
     * </p>
     * <p>
     * For information on requirements for registering as a public extension publisher, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs"
     * >Registering your account to publish CloudFormation extensions</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterPublisherRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterPublisherRequest#builder()}
     * </p>
     *
     * @param registerPublisherRequest
     *        A {@link Consumer} that will call methods on {@link RegisterPublisherInput.Builder} to create a request.
     * @return Result of the RegisterPublisher operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RegisterPublisher
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterPublisher"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterPublisherResponse registerPublisher(Consumer<RegisterPublisherRequest.Builder> registerPublisherRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        return registerPublisher(RegisterPublisherRequest.builder().applyMutation(registerPublisherRequest).build());
    }

    /**
     * <p>
     * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in
     * CloudFormation templates in your Amazon Web Services account, and includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Validating the extension schema
     * </p>
     * </li>
     * <li>
     * <p>
     * Determining which handlers, if any, have been specified for the extension
     * </p>
     * </li>
     * <li>
     * <p>
     * Making the extension available for use in your account
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on how to develop extensions and ready them for registeration, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating Resource
     * Providers</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and
     * per region. Use <a href="AWSCloudFormation/latest/APIReference/API_DeregisterType.html">DeregisterType</a> to
     * deregister specific extension versions if necessary.
     * </p>
     * <p>
     * Once you have initiated a registration request using <code> <a>RegisterType</a> </code>, you can use
     * <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of the registration request.
     * </p>
     * <p>
     * Once you have registered a private extension in your account and region, use <a
     * href="AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration</a> to specify
     * configuration properties for the extension. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     *
     * @param registerTypeRequest
     * @return Result of the RegisterType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RegisterType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterTypeResponse registerType(RegisterTypeRequest registerTypeRequest) throws CfnRegistryException,
            AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an extension with the CloudFormation service. Registering an extension makes it available for use in
     * CloudFormation templates in your Amazon Web Services account, and includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Validating the extension schema
     * </p>
     * </li>
     * <li>
     * <p>
     * Determining which handlers, if any, have been specified for the extension
     * </p>
     * </li>
     * <li>
     * <p>
     * Making the extension available for use in your account
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on how to develop extensions and ready them for registeration, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating Resource
     * Providers</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and
     * per region. Use <a href="AWSCloudFormation/latest/APIReference/API_DeregisterType.html">DeregisterType</a> to
     * deregister specific extension versions if necessary.
     * </p>
     * <p>
     * Once you have initiated a registration request using <code> <a>RegisterType</a> </code>, you can use
     * <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of the registration request.
     * </p>
     * <p>
     * Once you have registered a private extension in your account and region, use <a
     * href="AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration</a> to specify
     * configuration properties for the extension. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterTypeRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterTypeRequest#builder()}
     * </p>
     *
     * @param registerTypeRequest
     *        A {@link Consumer} that will call methods on {@link RegisterTypeInput.Builder} to create a request.
     * @return Result of the RegisterType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RegisterType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterTypeResponse registerType(Consumer<RegisterTypeRequest.Builder> registerTypeRequest)
            throws CfnRegistryException, AwsServiceException, SdkClientException, CloudFormationException {
        return registerType(RegisterTypeRequest.builder().applyMutation(registerTypeRequest).build());
    }

    /**
     * <p>
     * When specifying <code>RollbackStack</code>, you preserve the state of previously provisioned resources when an
     * operation fails. You can check the status of the stack through the <a>DescribeStacks</a> API.
     * </p>
     * <p>
     * Rolls back the specified stack to the last known stable state from <code>CREATE_FAILED</code> or
     * <code>UPDATE_FAILED</code> stack statuses.
     * </p>
     * <p>
     * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state
     * includes any status in a <code>*_COMPLETE</code>. This includes the following stack statuses.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param rollbackStackRequest
     * @return Result of the RollbackStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RollbackStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackStack" target="_top">AWS
     *      API Documentation</a>
     */
    default RollbackStackResponse rollbackStack(RollbackStackRequest rollbackStackRequest) throws TokenAlreadyExistsException,
            AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When specifying <code>RollbackStack</code>, you preserve the state of previously provisioned resources when an
     * operation fails. You can check the status of the stack through the <a>DescribeStacks</a> API.
     * </p>
     * <p>
     * Rolls back the specified stack to the last known stable state from <code>CREATE_FAILED</code> or
     * <code>UPDATE_FAILED</code> stack statuses.
     * </p>
     * <p>
     * This operation will delete a stack if it doesn't contain a last known stable state. A last known stable state
     * includes any status in a <code>*_COMPLETE</code>. This includes the following stack statuses.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORT_ROLLBACK_COMPLETE</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RollbackStackRequest.Builder} avoiding the need to
     * create one manually via {@link RollbackStackRequest#builder()}
     * </p>
     *
     * @param rollbackStackRequest
     *        A {@link Consumer} that will call methods on {@link RollbackStackInput.Builder} to create a request.
     * @return Result of the RollbackStack operation returned by the service.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.RollbackStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RollbackStack" target="_top">AWS
     *      API Documentation</a>
     */
    default RollbackStackResponse rollbackStack(Consumer<RollbackStackRequest.Builder> rollbackStackRequest)
            throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        return rollbackStack(RollbackStackRequest.builder().applyMutation(rollbackStackRequest).build());
    }

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     *
     * @param setStackPolicyRequest
     *        The input for the <a>SetStackPolicy</a> action.
     * @return Result of the SetStackPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SetStackPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default SetStackPolicyResponse setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetStackPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link SetStackPolicyRequest#builder()}
     * </p>
     *
     * @param setStackPolicyRequest
     *        A {@link Consumer} that will call methods on {@link SetStackPolicyInput.Builder} to create a request. The
     *        input for the <a>SetStackPolicy</a> action.
     * @return Result of the SetStackPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SetStackPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default SetStackPolicyResponse setStackPolicy(Consumer<SetStackPolicyRequest.Builder> setStackPolicyRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return setStackPolicy(SetStackPolicyRequest.builder().applyMutation(setStackPolicyRequest).build());
    }

    /**
     * <p>
     * Specifies the configuration data for a registered CloudFormation extension, in the given account and region.
     * </p>
     * <p>
     * To view the current configuration data for an extension, refer to the <code>ConfigurationSchema</code> element of
     * <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <important>
     * <p>
     * It is strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such
     * as third-party credentials. For more details on dynamic references, see <a
     * href="https://docs.aws.amazon.com/">Using dynamic references to specify template values</a> in the
     * <i>CloudFormation User Guide</i>.
     * </p>
     * </important>
     *
     * @param setTypeConfigurationRequest
     * @return Result of the SetTypeConfiguration operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SetTypeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default SetTypeConfigurationResponse setTypeConfiguration(SetTypeConfigurationRequest setTypeConfigurationRequest)
            throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies the configuration data for a registered CloudFormation extension, in the given account and region.
     * </p>
     * <p>
     * To view the current configuration data for an extension, refer to the <code>ConfigurationSchema</code> element of
     * <a href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <important>
     * <p>
     * It is strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such
     * as third-party credentials. For more details on dynamic references, see <a
     * href="https://docs.aws.amazon.com/">Using dynamic references to specify template values</a> in the
     * <i>CloudFormation User Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTypeConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link SetTypeConfigurationRequest#builder()}
     * </p>
     *
     * @param setTypeConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link SetTypeConfigurationInput.Builder} to create a
     *        request.
     * @return Result of the SetTypeConfiguration operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SetTypeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default SetTypeConfigurationResponse setTypeConfiguration(
            Consumer<SetTypeConfigurationRequest.Builder> setTypeConfigurationRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return setTypeConfiguration(SetTypeConfigurationRequest.builder().applyMutation(setTypeConfigurationRequest).build());
    }

    /**
     * <p>
     * Specify the default version of an extension. The default version of an extension will be used in CloudFormation
     * operations.
     * </p>
     *
     * @param setTypeDefaultVersionRequest
     * @return Result of the SetTypeDefaultVersion operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SetTypeDefaultVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default SetTypeDefaultVersionResponse setTypeDefaultVersion(SetTypeDefaultVersionRequest setTypeDefaultVersionRequest)
            throws CfnRegistryException, TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify the default version of an extension. The default version of an extension will be used in CloudFormation
     * operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTypeDefaultVersionRequest.Builder} avoiding the
     * need to create one manually via {@link SetTypeDefaultVersionRequest#builder()}
     * </p>
     *
     * @param setTypeDefaultVersionRequest
     *        A {@link Consumer} that will call methods on {@link SetTypeDefaultVersionInput.Builder} to create a
     *        request.
     * @return Result of the SetTypeDefaultVersion operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SetTypeDefaultVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default SetTypeDefaultVersionResponse setTypeDefaultVersion(
            Consumer<SetTypeDefaultVersionRequest.Builder> setTypeDefaultVersionRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return setTypeDefaultVersion(SetTypeDefaultVersionRequest.builder().applyMutation(setTypeDefaultVersionRequest).build());
    }

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the SignalResource API in
     * conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or
     * update until resources receive the required number of signals or the timeout period is exceeded. The
     * SignalResource API is useful in cases where you want to send signals from anywhere other than an Amazon EC2
     * instance.
     * </p>
     *
     * @param signalResourceRequest
     *        The input for the <a>SignalResource</a> action.
     * @return Result of the SignalResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SignalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    default SignalResourceResponse signalResource(SignalResourceRequest signalResourceRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the SignalResource API in
     * conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or
     * update until resources receive the required number of signals or the timeout period is exceeded. The
     * SignalResource API is useful in cases where you want to send signals from anywhere other than an Amazon EC2
     * instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SignalResourceRequest.Builder} avoiding the need to
     * create one manually via {@link SignalResourceRequest#builder()}
     * </p>
     *
     * @param signalResourceRequest
     *        A {@link Consumer} that will call methods on {@link SignalResourceInput.Builder} to create a request. The
     *        input for the <a>SignalResource</a> action.
     * @return Result of the SignalResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.SignalResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    default SignalResourceResponse signalResource(Consumer<SignalResourceRequest.Builder> signalResourceRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return signalResource(SignalResourceRequest.builder().applyMutation(signalResourceRequest).build());
    }

    /**
     * <p>
     * Stops an in-progress operation on a stack set and its associated stack instances.
     * </p>
     *
     * @param stopStackSetOperationRequest
     * @return Result of the StopStackSetOperation operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.StopStackSetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StopStackSetOperationResponse stopStackSetOperation(StopStackSetOperationRequest stopStackSetOperationRequest)
            throws StackSetNotFoundException, OperationNotFoundException, InvalidOperationException, AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an in-progress operation on a stack set and its associated stack instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopStackSetOperationRequest.Builder} avoiding the
     * need to create one manually via {@link StopStackSetOperationRequest#builder()}
     * </p>
     *
     * @param stopStackSetOperationRequest
     *        A {@link Consumer} that will call methods on {@link StopStackSetOperationInput.Builder} to create a
     *        request.
     * @return Result of the StopStackSetOperation operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationNotFoundException
     *         The specified ID refers to an operation that doesn't exist.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.StopStackSetOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StopStackSetOperationResponse stopStackSetOperation(
            Consumer<StopStackSetOperationRequest.Builder> stopStackSetOperationRequest) throws StackSetNotFoundException,
            OperationNotFoundException, InvalidOperationException, AwsServiceException, SdkClientException,
            CloudFormationException {
        return stopStackSetOperation(StopStackSetOperationRequest.builder().applyMutation(stopStackSetOperationRequest).build());
    }

    /**
     * <p>
     * Tests a registered extension to make sure it meets all necessary requirements for being published in the
     * CloudFormation registry.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For resource types, this includes passing all contracts tests defined for the type.
     * </p>
     * </li>
     * <li>
     * <p>
     * For modules, this includes determining if the module's model meets all necessary requirements.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing"
     * >Testing your public extension prior to publishing</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * If you do not specify a version, CloudFormation uses the default version of the extension in your account and
     * region for testing.
     * </p>
     * <p>
     * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more
     * information, see <a href="AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * <p>
     * Once you've initiated testing on an extension using <code>TestType</code>, you can use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>
     * to monitor the current test status and test status description for the extension.
     * </p>
     * <p>
     * An extension must have a test status of <code>PASSED</code> before it can be published. For more information, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     *
     * @param testTypeRequest
     * @return Result of the TestType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.TestType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TestType" target="_top">AWS API
     *      Documentation</a>
     */
    default TestTypeResponse testType(TestTypeRequest testTypeRequest) throws CfnRegistryException, TypeNotFoundException,
            AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests a registered extension to make sure it meets all necessary requirements for being published in the
     * CloudFormation registry.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For resource types, this includes passing all contracts tests defined for the type.
     * </p>
     * </li>
     * <li>
     * <p>
     * For modules, this includes determining if the module's model meets all necessary requirements.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing"
     * >Testing your public extension prior to publishing</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * If you do not specify a version, CloudFormation uses the default version of the extension in your account and
     * region for testing.
     * </p>
     * <p>
     * To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more
     * information, see <a href="AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * <p>
     * Once you've initiated testing on an extension using <code>TestType</code>, you can use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a>
     * to monitor the current test status and test status description for the extension.
     * </p>
     * <p>
     * An extension must have a test status of <code>PASSED</code> before it can be published. For more information, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestTypeRequest.Builder} avoiding the need to
     * create one manually via {@link TestTypeRequest#builder()}
     * </p>
     *
     * @param testTypeRequest
     *        A {@link Consumer} that will call methods on {@link TestTypeInput.Builder} to create a request.
     * @return Result of the TestType operation returned by the service.
     * @throws CfnRegistryException
     *         An error occurred during a CloudFormation registry operation.
     * @throws TypeNotFoundException
     *         The specified extension does not exist in the CloudFormation registry.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.TestType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TestType" target="_top">AWS API
     *      Documentation</a>
     */
    default TestTypeResponse testType(Consumer<TestTypeRequest.Builder> testTypeRequest) throws CfnRegistryException,
            TypeNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        return testType(TestTypeRequest.builder().applyMutation(testTypeRequest).build());
    }

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack via the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about creating an update template, updating a stack, and monitoring the progress of the
     * update, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
     * Stack</a>.
     * </p>
     *
     * @param updateStackRequest
     *        The input for an <a>UpdateStack</a> action.
     * @return Result of the UpdateStack operation returned by the service.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateStackResponse updateStack(UpdateStackRequest updateStackRequest) throws InsufficientCapabilitiesException,
            TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack via the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about creating an update template, updating a stack, and monitoring the progress of the
     * update, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
     * Stack</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackRequest#builder()}
     * </p>
     *
     * @param updateStackRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStackInput.Builder} to create a request. The
     *        input for an <a>UpdateStack</a> action.
     * @return Result of the UpdateStack operation returned by the service.
     * @throws InsufficientCapabilitiesException
     *         The template contains resources with capabilities that weren't specified in the Capabilities parameter.
     * @throws TokenAlreadyExistsException
     *         A client request token already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateStackResponse updateStack(Consumer<UpdateStackRequest.Builder> updateStackRequest)
            throws InsufficientCapabilitiesException, TokenAlreadyExistsException, AwsServiceException, SdkClientException,
            CloudFormationException {
        return updateStack(UpdateStackRequest.builder().applyMutation(updateStackRequest).build());
    }

    /**
     * <p>
     * Updates the parameter values for stack instances for the specified accounts, within the specified Regions. A
     * stack instance refers to a stack in a specific account and Region.
     * </p>
     * <p>
     * You can only update stack instances in Regions and accounts where they already exist; to create additional stack
     * instances, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html"
     * >CreateStackInstances</a>.
     * </p>
     * <p>
     * During stack set updates, any parameters overridden for a stack instance are not updated, but retain their
     * overridden value.
     * </p>
     * <p>
     * You can only update the parameter <i>values</i> that are specified in the stack set; to add or delete a parameter
     * itself, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet
     * </a> to update the stack set template. If you add a parameter to a template, before you can override the
     * parameter value specified in the stack set you must first use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     * >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the
     * stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter
     * value using <code>UpdateStackInstances</code>.
     * </p>
     *
     * @param updateStackInstancesRequest
     * @return Result of the UpdateStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStackInstancesResponse updateStackInstances(UpdateStackInstancesRequest updateStackInstancesRequest)
            throws StackSetNotFoundException, StackInstanceNotFoundException, OperationInProgressException,
            OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException, AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the parameter values for stack instances for the specified accounts, within the specified Regions. A
     * stack instance refers to a stack in a specific account and Region.
     * </p>
     * <p>
     * You can only update stack instances in Regions and accounts where they already exist; to create additional stack
     * instances, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html"
     * >CreateStackInstances</a>.
     * </p>
     * <p>
     * During stack set updates, any parameters overridden for a stack instance are not updated, but retain their
     * overridden value.
     * </p>
     * <p>
     * You can only update the parameter <i>values</i> that are specified in the stack set; to add or delete a parameter
     * itself, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet
     * </a> to update the stack set template. If you add a parameter to a template, before you can override the
     * parameter value specified in the stack set you must first use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     * >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the
     * stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter
     * value using <code>UpdateStackInstances</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStackInstancesRequest#builder()}
     * </p>
     *
     * @param updateStackInstancesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStackInstancesInput.Builder} to create a
     *        request.
     * @return Result of the UpdateStackInstances operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateStackInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStackInstancesResponse updateStackInstances(
            Consumer<UpdateStackInstancesRequest.Builder> updateStackInstancesRequest) throws StackSetNotFoundException,
            StackInstanceNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException,
            StaleRequestException, InvalidOperationException, AwsServiceException, SdkClientException, CloudFormationException {
        return updateStackInstances(UpdateStackInstancesRequest.builder().applyMutation(updateStackInstancesRequest).build());
    }

    /**
     * <p>
     * Updates the stack set, and associated stack instances in the specified accounts and Regions.
     * </p>
     * <p>
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above
     * a specified failure tolerance), the stack set is updated with your changes. Subsequent
     * <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.
     * </p>
     *
     * @param updateStackSetRequest
     * @return Result of the UpdateStackSet operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateStackSetResponse updateStackSet(UpdateStackSetRequest updateStackSetRequest) throws StackSetNotFoundException,
            OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException,
            StackInstanceNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the stack set, and associated stack instances in the specified accounts and Regions.
     * </p>
     * <p>
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above
     * a specified failure tolerance), the stack set is updated with your changes. Subsequent
     * <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackSetRequest#builder()}
     * </p>
     *
     * @param updateStackSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStackSetInput.Builder} to create a request.
     * @return Result of the UpdateStackSet operation returned by the service.
     * @throws StackSetNotFoundException
     *         The specified stack set doesn't exist.
     * @throws OperationInProgressException
     *         Another operation is currently in progress for this stack set. Only one operation can be performed for a
     *         stack set at a given time.
     * @throws OperationIdAlreadyExistsException
     *         The specified operation ID already exists.
     * @throws StaleRequestException
     *         Another operation has been performed on this stack set since the specified operation was performed.
     * @throws InvalidOperationException
     *         The specified operation isn't valid.
     * @throws StackInstanceNotFoundException
     *         The specified stack instance doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateStackSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateStackSetResponse updateStackSet(Consumer<UpdateStackSetRequest.Builder> updateStackSetRequest)
            throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException,
            StaleRequestException, InvalidOperationException, StackInstanceNotFoundException, AwsServiceException,
            SdkClientException, CloudFormationException {
        return updateStackSet(UpdateStackSetRequest.builder().applyMutation(updateStackSetRequest).build());
    }

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack.
     * </p>
     *
     * @param updateTerminationProtectionRequest
     * @return Result of the UpdateTerminationProtection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateTerminationProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTerminationProtectionResponse updateTerminationProtection(
            UpdateTerminationProtectionRequest updateTerminationProtectionRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTerminationProtectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTerminationProtectionRequest#builder()}
     * </p>
     *
     * @param updateTerminationProtectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTerminationProtectionInput.Builder} to create a
     *        request.
     * @return Result of the UpdateTerminationProtection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.UpdateTerminationProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTerminationProtectionResponse updateTerminationProtection(
            Consumer<UpdateTerminationProtectionRequest.Builder> updateTerminationProtectionRequest) throws AwsServiceException,
            SdkClientException, CloudFormationException {
        return updateTerminationProtection(UpdateTerminationProtectionRequest.builder()
                .applyMutation(updateTerminationProtectionRequest).build());
    }

    /**
     * <p>
     * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't,
     * CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template
     * validation error.
     * </p>
     *
     * @param validateTemplateRequest
     *        The input for <a>ValidateTemplate</a> action.
     * @return Result of the ValidateTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ValidateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateTemplateResponse validateTemplate(ValidateTemplateRequest validateTemplateRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't,
     * CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template
     * validation error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link ValidateTemplateRequest#builder()}
     * </p>
     *
     * @param validateTemplateRequest
     *        A {@link Consumer} that will call methods on {@link ValidateTemplateInput.Builder} to create a request.
     *        The input for <a>ValidateTemplate</a> action.
     * @return Result of the ValidateTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFormationClient.ValidateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ValidateTemplateResponse validateTemplate(Consumer<ValidateTemplateRequest.Builder> validateTemplateRequest)
            throws AwsServiceException, SdkClientException, CloudFormationException {
        return validateTemplate(ValidateTemplateRequest.builder().applyMutation(validateTemplateRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    /**
     * Create an instance of {@link CloudFormationWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link CloudFormationWaiter}
     */
    default CloudFormationWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
