/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies target details for an activated hook.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeSetHookTargetDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ChangeSetHookTargetDetails.Builder, ChangeSetHookTargetDetails> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(ChangeSetHookTargetDetails::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<ChangeSetHookResourceTargetDetails> RESOURCE_TARGET_DETAILS_FIELD = SdkField
            .<ChangeSetHookResourceTargetDetails> builder(MarshallingType.SDK_POJO).memberName("ResourceTargetDetails")
            .getter(getter(ChangeSetHookTargetDetails::resourceTargetDetails)).setter(setter(Builder::resourceTargetDetails))
            .constructor(ChangeSetHookResourceTargetDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTargetDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD,
            RESOURCE_TARGET_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetType;

    private final ChangeSetHookResourceTargetDetails resourceTargetDetails;

    private ChangeSetHookTargetDetails(BuilderImpl builder) {
        this.targetType = builder.targetType;
        this.resourceTargetDetails = builder.resourceTargetDetails;
    }

    /**
     * <p>
     * The name of the type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link HookTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The name of the type.
     * @see HookTargetType
     */
    public final HookTargetType targetType() {
        return HookTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The name of the type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link HookTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The name of the type.
     * @see HookTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * Required if <code>TargetType</code> is <code>RESOURCE</code>.
     * </p>
     * 
     * @return Required if <code>TargetType</code> is <code>RESOURCE</code>.
     */
    public final ChangeSetHookResourceTargetDetails resourceTargetDetails() {
        return resourceTargetDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTargetDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetHookTargetDetails)) {
            return false;
        }
        ChangeSetHookTargetDetails other = (ChangeSetHookTargetDetails) obj;
        return Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(resourceTargetDetails(), other.resourceTargetDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeSetHookTargetDetails").add("TargetType", targetTypeAsString())
                .add("ResourceTargetDetails", resourceTargetDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "ResourceTargetDetails":
            return Optional.ofNullable(clazz.cast(resourceTargetDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeSetHookTargetDetails, T> g) {
        return obj -> g.apply((ChangeSetHookTargetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeSetHookTargetDetails> {
        /**
         * <p>
         * The name of the type.
         * </p>
         * 
         * @param targetType
         *        The name of the type.
         * @see HookTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The name of the type.
         * </p>
         * 
         * @param targetType
         *        The name of the type.
         * @see HookTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookTargetType
         */
        Builder targetType(HookTargetType targetType);

        /**
         * <p>
         * Required if <code>TargetType</code> is <code>RESOURCE</code>.
         * </p>
         * 
         * @param resourceTargetDetails
         *        Required if <code>TargetType</code> is <code>RESOURCE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTargetDetails(ChangeSetHookResourceTargetDetails resourceTargetDetails);

        /**
         * <p>
         * Required if <code>TargetType</code> is <code>RESOURCE</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link ChangeSetHookResourceTargetDetails.Builder}
         * avoiding the need to create one manually via {@link ChangeSetHookResourceTargetDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChangeSetHookResourceTargetDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceTargetDetails(ChangeSetHookResourceTargetDetails)}.
         * 
         * @param resourceTargetDetails
         *        a consumer that will call methods on {@link ChangeSetHookResourceTargetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTargetDetails(ChangeSetHookResourceTargetDetails)
         */
        default Builder resourceTargetDetails(Consumer<ChangeSetHookResourceTargetDetails.Builder> resourceTargetDetails) {
            return resourceTargetDetails(ChangeSetHookResourceTargetDetails.builder().applyMutation(resourceTargetDetails)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String targetType;

        private ChangeSetHookResourceTargetDetails resourceTargetDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetHookTargetDetails model) {
            targetType(model.targetType);
            resourceTargetDetails(model.resourceTargetDetails);
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        @Transient
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        @Transient
        public final Builder targetType(HookTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final ChangeSetHookResourceTargetDetails.Builder getResourceTargetDetails() {
            return resourceTargetDetails != null ? resourceTargetDetails.toBuilder() : null;
        }

        public final void setResourceTargetDetails(ChangeSetHookResourceTargetDetails.BuilderImpl resourceTargetDetails) {
            this.resourceTargetDetails = resourceTargetDetails != null ? resourceTargetDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceTargetDetails(ChangeSetHookResourceTargetDetails resourceTargetDetails) {
            this.resourceTargetDetails = resourceTargetDetails;
            return this;
        }

        @Override
        public ChangeSetHookTargetDetails build() {
            return new ChangeSetHookTargetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
