/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeTypeConfigurationsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<BatchDescribeTypeConfigurationsResponse.Builder, BatchDescribeTypeConfigurationsResponse> {
    private static final SdkField<List<BatchDescribeTypeConfigurationsError>> ERRORS_FIELD = SdkField
            .<List<BatchDescribeTypeConfigurationsError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchDescribeTypeConfigurationsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDescribeTypeConfigurationsError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDescribeTypeConfigurationsError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TypeConfigurationIdentifier>> UNPROCESSED_TYPE_CONFIGURATIONS_FIELD = SdkField
            .<List<TypeConfigurationIdentifier>> builder(MarshallingType.LIST)
            .memberName("UnprocessedTypeConfigurations")
            .getter(getter(BatchDescribeTypeConfigurationsResponse::unprocessedTypeConfigurations))
            .setter(setter(Builder::unprocessedTypeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedTypeConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypeConfigurationIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypeConfigurationIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TypeConfigurationDetails>> TYPE_CONFIGURATIONS_FIELD = SdkField
            .<List<TypeConfigurationDetails>> builder(MarshallingType.LIST)
            .memberName("TypeConfigurations")
            .getter(getter(BatchDescribeTypeConfigurationsResponse::typeConfigurations))
            .setter(setter(Builder::typeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypeConfigurationDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypeConfigurationDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD,
            UNPROCESSED_TYPE_CONFIGURATIONS_FIELD, TYPE_CONFIGURATIONS_FIELD));

    private final List<BatchDescribeTypeConfigurationsError> errors;

    private final List<TypeConfigurationIdentifier> unprocessedTypeConfigurations;

    private final List<TypeConfigurationDetails> typeConfigurations;

    private BatchDescribeTypeConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.unprocessedTypeConfigurations = builder.unprocessedTypeConfigurations;
        this.typeConfigurations = builder.typeConfigurations;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of information concerning any errors generated during the setting of the specified configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of information concerning any errors generated during the setting of the specified configurations.
     */
    public final List<BatchDescribeTypeConfigurationsError> errors() {
        return errors;
    }

    /**
     * Returns true if the UnprocessedTypeConfigurations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasUnprocessedTypeConfigurations() {
        return unprocessedTypeConfigurations != null && !(unprocessedTypeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of any of the specified extension configurations that CloudFormation could not process for any reason.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedTypeConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of any of the specified extension configurations that CloudFormation could not process for any
     *         reason.
     */
    public final List<TypeConfigurationIdentifier> unprocessedTypeConfigurations() {
        return unprocessedTypeConfigurations;
    }

    /**
     * Returns true if the TypeConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTypeConfigurations() {
        return typeConfigurations != null && !(typeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of any of the specified extension configurations from the CloudFormation registry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTypeConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of any of the specified extension configurations from the CloudFormation registry.
     */
    public final List<TypeConfigurationDetails> typeConfigurations() {
        return typeConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedTypeConfigurations() ? unprocessedTypeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTypeConfigurations() ? typeConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeTypeConfigurationsResponse)) {
            return false;
        }
        BatchDescribeTypeConfigurationsResponse other = (BatchDescribeTypeConfigurationsResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasUnprocessedTypeConfigurations() == other.hasUnprocessedTypeConfigurations()
                && Objects.equals(unprocessedTypeConfigurations(), other.unprocessedTypeConfigurations())
                && hasTypeConfigurations() == other.hasTypeConfigurations()
                && Objects.equals(typeConfigurations(), other.typeConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchDescribeTypeConfigurationsResponse")
                .add("Errors", hasErrors() ? errors() : null)
                .add("UnprocessedTypeConfigurations", hasUnprocessedTypeConfigurations() ? unprocessedTypeConfigurations() : null)
                .add("TypeConfigurations", hasTypeConfigurations() ? typeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "UnprocessedTypeConfigurations":
            return Optional.ofNullable(clazz.cast(unprocessedTypeConfigurations()));
        case "TypeConfigurations":
            return Optional.ofNullable(clazz.cast(typeConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeTypeConfigurationsResponse, T> g) {
        return obj -> g.apply((BatchDescribeTypeConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDescribeTypeConfigurationsResponse> {
        /**
         * <p>
         * A list of information concerning any errors generated during the setting of the specified configurations.
         * </p>
         * 
         * @param errors
         *        A list of information concerning any errors generated during the setting of the specified
         *        configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchDescribeTypeConfigurationsError> errors);

        /**
         * <p>
         * A list of information concerning any errors generated during the setting of the specified configurations.
         * </p>
         * 
         * @param errors
         *        A list of information concerning any errors generated during the setting of the specified
         *        configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchDescribeTypeConfigurationsError... errors);

        /**
         * <p>
         * A list of information concerning any errors generated during the setting of the specified configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <BatchDescribeTypeConfigurationsError>.Builder} avoiding the need to create one manually via {@link List
         * <BatchDescribeTypeConfigurationsError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchDescribeTypeConfigurationsError>.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchDescribeTypeConfigurationsError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchDescribeTypeConfigurationsError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchDescribeTypeConfigurationsError>)
         */
        Builder errors(Consumer<BatchDescribeTypeConfigurationsError.Builder>... errors);

        /**
         * <p>
         * A list of any of the specified extension configurations that CloudFormation could not process for any reason.
         * </p>
         * 
         * @param unprocessedTypeConfigurations
         *        A list of any of the specified extension configurations that CloudFormation could not process for any
         *        reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedTypeConfigurations(Collection<TypeConfigurationIdentifier> unprocessedTypeConfigurations);

        /**
         * <p>
         * A list of any of the specified extension configurations that CloudFormation could not process for any reason.
         * </p>
         * 
         * @param unprocessedTypeConfigurations
         *        A list of any of the specified extension configurations that CloudFormation could not process for any
         *        reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedTypeConfigurations(TypeConfigurationIdentifier... unprocessedTypeConfigurations);

        /**
         * <p>
         * A list of any of the specified extension configurations that CloudFormation could not process for any reason.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TypeConfigurationIdentifier>.Builder}
         * avoiding the need to create one manually via {@link List<TypeConfigurationIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TypeConfigurationIdentifier>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #unprocessedTypeConfigurations(List<TypeConfigurationIdentifier>)}.
         * 
         * @param unprocessedTypeConfigurations
         *        a consumer that will call methods on {@link List<TypeConfigurationIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedTypeConfigurations(List<TypeConfigurationIdentifier>)
         */
        Builder unprocessedTypeConfigurations(Consumer<TypeConfigurationIdentifier.Builder>... unprocessedTypeConfigurations);

        /**
         * <p>
         * A list of any of the specified extension configurations from the CloudFormation registry.
         * </p>
         * 
         * @param typeConfigurations
         *        A list of any of the specified extension configurations from the CloudFormation registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeConfigurations(Collection<TypeConfigurationDetails> typeConfigurations);

        /**
         * <p>
         * A list of any of the specified extension configurations from the CloudFormation registry.
         * </p>
         * 
         * @param typeConfigurations
         *        A list of any of the specified extension configurations from the CloudFormation registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeConfigurations(TypeConfigurationDetails... typeConfigurations);

        /**
         * <p>
         * A list of any of the specified extension configurations from the CloudFormation registry.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TypeConfigurationDetails>.Builder} avoiding
         * the need to create one manually via {@link List<TypeConfigurationDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TypeConfigurationDetails>.Builder#build()} is called
         * immediately and its result is passed to {@link #typeConfigurations(List<TypeConfigurationDetails>)}.
         * 
         * @param typeConfigurations
         *        a consumer that will call methods on {@link List<TypeConfigurationDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeConfigurations(List<TypeConfigurationDetails>)
         */
        Builder typeConfigurations(Consumer<TypeConfigurationDetails.Builder>... typeConfigurations);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<BatchDescribeTypeConfigurationsError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<TypeConfigurationIdentifier> unprocessedTypeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<TypeConfigurationDetails> typeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeTypeConfigurationsResponse model) {
            super(model);
            errors(model.errors);
            unprocessedTypeConfigurations(model.unprocessedTypeConfigurations);
            typeConfigurations(model.typeConfigurations);
        }

        public final List<BatchDescribeTypeConfigurationsError.Builder> getErrors() {
            List<BatchDescribeTypeConfigurationsError.Builder> result = BatchDescribeTypeConfigurationsErrorsCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDescribeTypeConfigurationsError.BuilderImpl> errors) {
            this.errors = BatchDescribeTypeConfigurationsErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        @Transient
        public final Builder errors(Collection<BatchDescribeTypeConfigurationsError> errors) {
            this.errors = BatchDescribeTypeConfigurationsErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(BatchDescribeTypeConfigurationsError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(Consumer<BatchDescribeTypeConfigurationsError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchDescribeTypeConfigurationsError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TypeConfigurationIdentifier.Builder> getUnprocessedTypeConfigurations() {
            List<TypeConfigurationIdentifier.Builder> result = UnprocessedTypeConfigurationsCopier
                    .copyToBuilder(this.unprocessedTypeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedTypeConfigurations(
                Collection<TypeConfigurationIdentifier.BuilderImpl> unprocessedTypeConfigurations) {
            this.unprocessedTypeConfigurations = UnprocessedTypeConfigurationsCopier
                    .copyFromBuilder(unprocessedTypeConfigurations);
        }

        @Override
        @Transient
        public final Builder unprocessedTypeConfigurations(Collection<TypeConfigurationIdentifier> unprocessedTypeConfigurations) {
            this.unprocessedTypeConfigurations = UnprocessedTypeConfigurationsCopier.copy(unprocessedTypeConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unprocessedTypeConfigurations(TypeConfigurationIdentifier... unprocessedTypeConfigurations) {
            unprocessedTypeConfigurations(Arrays.asList(unprocessedTypeConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unprocessedTypeConfigurations(
                Consumer<TypeConfigurationIdentifier.Builder>... unprocessedTypeConfigurations) {
            unprocessedTypeConfigurations(Stream.of(unprocessedTypeConfigurations)
                    .map(c -> TypeConfigurationIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TypeConfigurationDetails.Builder> getTypeConfigurations() {
            List<TypeConfigurationDetails.Builder> result = TypeConfigurationDetailsListCopier
                    .copyToBuilder(this.typeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTypeConfigurations(Collection<TypeConfigurationDetails.BuilderImpl> typeConfigurations) {
            this.typeConfigurations = TypeConfigurationDetailsListCopier.copyFromBuilder(typeConfigurations);
        }

        @Override
        @Transient
        public final Builder typeConfigurations(Collection<TypeConfigurationDetails> typeConfigurations) {
            this.typeConfigurations = TypeConfigurationDetailsListCopier.copy(typeConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder typeConfigurations(TypeConfigurationDetails... typeConfigurations) {
            typeConfigurations(Arrays.asList(typeConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder typeConfigurations(Consumer<TypeConfigurationDetails.Builder>... typeConfigurations) {
            typeConfigurations(Stream.of(typeConfigurations)
                    .map(c -> TypeConfigurationDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDescribeTypeConfigurationsResponse build() {
            return new BatchDescribeTypeConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
