/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for <a>ListStacks</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStacksResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListStacksResponse.Builder, ListStacksResponse> {
    private static final SdkField<List<StackSummary>> STACK_SUMMARIES_FIELD = SdkField
            .<List<StackSummary>> builder(MarshallingType.LIST)
            .memberName("StackSummaries")
            .getter(getter(ListStacksResponse::stackSummaries))
            .setter(setter(Builder::stackSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStacksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StackSummary> stackSummaries;

    private final String nextToken;

    private ListStacksResponse(BuilderImpl builder) {
        super(builder);
        this.stackSummaries = builder.stackSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the StackSummaries property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStackSummaries() {
        return stackSummaries != null && !(stackSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>StackSummary</code> structures containing information about the specified stacks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>StackSummary</code> structures containing information about the specified stacks.
     */
    public final List<StackSummary> stackSummaries() {
        return stackSummaries;
    }

    /**
     * <p>
     * If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional page
     * exists, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional
     *         page exists, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStackSummaries() ? stackSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksResponse)) {
            return false;
        }
        ListStacksResponse other = (ListStacksResponse) obj;
        return hasStackSummaries() == other.hasStackSummaries() && Objects.equals(stackSummaries(), other.stackSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStacksResponse").add("StackSummaries", hasStackSummaries() ? stackSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSummaries":
            return Optional.ofNullable(clazz.cast(stackSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStacksResponse, T> g) {
        return obj -> g.apply((ListStacksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStacksResponse> {
        /**
         * <p>
         * A list of <code>StackSummary</code> structures containing information about the specified stacks.
         * </p>
         * 
         * @param stackSummaries
         *        A list of <code>StackSummary</code> structures containing information about the specified stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSummaries(Collection<StackSummary> stackSummaries);

        /**
         * <p>
         * A list of <code>StackSummary</code> structures containing information about the specified stacks.
         * </p>
         * 
         * @param stackSummaries
         *        A list of <code>StackSummary</code> structures containing information about the specified stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSummaries(StackSummary... stackSummaries);

        /**
         * <p>
         * A list of <code>StackSummary</code> structures containing information about the specified stacks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StackSummary>.Builder} avoiding the need to
         * create one manually via {@link List<StackSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #stackSummaries(List<StackSummary>)}.
         * 
         * @param stackSummaries
         *        a consumer that will call methods on {@link List<StackSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackSummaries(List<StackSummary>)
         */
        Builder stackSummaries(Consumer<StackSummary.Builder>... stackSummaries);

        /**
         * <p>
         * If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional page
         * exists, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional
         *        page exists, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackSummary> stackSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStacksResponse model) {
            super(model);
            stackSummaries(model.stackSummaries);
            nextToken(model.nextToken);
        }

        public final List<StackSummary.Builder> getStackSummaries() {
            List<StackSummary.Builder> result = StackSummariesCopier.copyToBuilder(this.stackSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackSummaries(Collection<StackSummary.BuilderImpl> stackSummaries) {
            this.stackSummaries = StackSummariesCopier.copyFromBuilder(stackSummaries);
        }

        @Override
        @Transient
        public final Builder stackSummaries(Collection<StackSummary> stackSummaries) {
            this.stackSummaries = StackSummariesCopier.copy(stackSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stackSummaries(StackSummary... stackSummaries) {
            stackSummaries(Arrays.asList(stackSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stackSummaries(Consumer<StackSummary.Builder>... stackSummaries) {
            stackSummaries(Stream.of(stackSummaries).map(c -> StackSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStacksResponse build() {
            return new ListStacksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
