/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChangeSetHooksResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeChangeSetHooksResponse.Builder, DescribeChangeSetHooksResponse> {
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetId").getter(getter(DescribeChangeSetHooksResponse::changeSetId))
            .setter(setter(Builder::changeSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()).build();

    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetName").getter(getter(DescribeChangeSetHooksResponse::changeSetName))
            .setter(setter(Builder::changeSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()).build();

    private static final SdkField<List<ChangeSetHook>> HOOKS_FIELD = SdkField
            .<List<ChangeSetHook>> builder(MarshallingType.LIST)
            .memberName("Hooks")
            .getter(getter(DescribeChangeSetHooksResponse::hooks))
            .setter(setter(Builder::hooks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hooks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeSetHook> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeSetHook::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeChangeSetHooksResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeChangeSetHooksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(DescribeChangeSetHooksResponse::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(DescribeChangeSetHooksResponse::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_SET_ID_FIELD,
            CHANGE_SET_NAME_FIELD, HOOKS_FIELD, STATUS_FIELD, NEXT_TOKEN_FIELD, STACK_ID_FIELD, STACK_NAME_FIELD));

    private final String changeSetId;

    private final String changeSetName;

    private final List<ChangeSetHook> hooks;

    private final String status;

    private final String nextToken;

    private final String stackId;

    private final String stackName;

    private DescribeChangeSetHooksResponse(BuilderImpl builder) {
        super(builder);
        this.changeSetId = builder.changeSetId;
        this.changeSetName = builder.changeSetName;
        this.hooks = builder.hooks;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
    }

    /**
     * <p>
     * The change set identifier (stack ID).
     * </p>
     * 
     * @return The change set identifier (stack ID).
     */
    public final String changeSetId() {
        return changeSetId;
    }

    /**
     * <p>
     * The change set name.
     * </p>
     * 
     * @return The change set name.
     */
    public final String changeSetName() {
        return changeSetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Hooks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasHooks() {
        return hooks != null && !(hooks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of hook objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHooks} method.
     * </p>
     * 
     * @return List of hook objects.
     */
    public final List<ChangeSetHook> hooks() {
        return hooks;
    }

    /**
     * <p>
     * Provides the status of the change set hook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeSetHooksStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Provides the status of the change set hook.
     * @see ChangeSetHooksStatus
     */
    public final ChangeSetHooksStatus status() {
        return ChangeSetHooksStatus.fromValue(status);
    }

    /**
     * <p>
     * Provides the status of the change set hook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeSetHooksStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Provides the status of the change set hook.
     * @see ChangeSetHooksStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Pagination token, <code>null</code> or empty if no more results.
     * </p>
     * 
     * @return Pagination token, <code>null</code> or empty if no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The stack identifier (stack ID).
     * </p>
     * 
     * @return The stack identifier (stack ID).
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The stack name.
     * </p>
     * 
     * @return The stack name.
     */
    public final String stackName() {
        return stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasHooks() ? hooks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChangeSetHooksResponse)) {
            return false;
        }
        DescribeChangeSetHooksResponse other = (DescribeChangeSetHooksResponse) obj;
        return Objects.equals(changeSetId(), other.changeSetId()) && Objects.equals(changeSetName(), other.changeSetName())
                && hasHooks() == other.hasHooks() && Objects.equals(hooks(), other.hooks())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(stackId(), other.stackId()) && Objects.equals(stackName(), other.stackName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeChangeSetHooksResponse").add("ChangeSetId", changeSetId())
                .add("ChangeSetName", changeSetName()).add("Hooks", hasHooks() ? hooks() : null).add("Status", statusAsString())
                .add("NextToken", nextToken()).add("StackId", stackId()).add("StackName", stackName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeSetId":
            return Optional.ofNullable(clazz.cast(changeSetId()));
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "Hooks":
            return Optional.ofNullable(clazz.cast(hooks()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChangeSetHooksResponse, T> g) {
        return obj -> g.apply((DescribeChangeSetHooksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChangeSetHooksResponse> {
        /**
         * <p>
         * The change set identifier (stack ID).
         * </p>
         * 
         * @param changeSetId
         *        The change set identifier (stack ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetId(String changeSetId);

        /**
         * <p>
         * The change set name.
         * </p>
         * 
         * @param changeSetName
         *        The change set name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * List of hook objects.
         * </p>
         * 
         * @param hooks
         *        List of hook objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hooks(Collection<ChangeSetHook> hooks);

        /**
         * <p>
         * List of hook objects.
         * </p>
         * 
         * @param hooks
         *        List of hook objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hooks(ChangeSetHook... hooks);

        /**
         * <p>
         * List of hook objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ChangeSetHook>.Builder} avoiding the need
         * to create one manually via {@link List<ChangeSetHook>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChangeSetHook>.Builder#build()} is called immediately and
         * its result is passed to {@link #hooks(List<ChangeSetHook>)}.
         * 
         * @param hooks
         *        a consumer that will call methods on {@link List<ChangeSetHook>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hooks(List<ChangeSetHook>)
         */
        Builder hooks(Consumer<ChangeSetHook.Builder>... hooks);

        /**
         * <p>
         * Provides the status of the change set hook.
         * </p>
         * 
         * @param status
         *        Provides the status of the change set hook.
         * @see ChangeSetHooksStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetHooksStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Provides the status of the change set hook.
         * </p>
         * 
         * @param status
         *        Provides the status of the change set hook.
         * @see ChangeSetHooksStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetHooksStatus
         */
        Builder status(ChangeSetHooksStatus status);

        /**
         * <p>
         * Pagination token, <code>null</code> or empty if no more results.
         * </p>
         * 
         * @param nextToken
         *        Pagination token, <code>null</code> or empty if no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The stack identifier (stack ID).
         * </p>
         * 
         * @param stackId
         *        The stack identifier (stack ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The stack name.
         * </p>
         * 
         * @param stackName
         *        The stack name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String changeSetId;

        private String changeSetName;

        private List<ChangeSetHook> hooks = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String nextToken;

        private String stackId;

        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChangeSetHooksResponse model) {
            super(model);
            changeSetId(model.changeSetId);
            changeSetName(model.changeSetName);
            hooks(model.hooks);
            status(model.status);
            nextToken(model.nextToken);
            stackId(model.stackId);
            stackName(model.stackName);
        }

        public final String getChangeSetId() {
            return changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        @Transient
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        @Transient
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final List<ChangeSetHook.Builder> getHooks() {
            List<ChangeSetHook.Builder> result = ChangeSetHooksCopier.copyToBuilder(this.hooks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHooks(Collection<ChangeSetHook.BuilderImpl> hooks) {
            this.hooks = ChangeSetHooksCopier.copyFromBuilder(hooks);
        }

        @Override
        @Transient
        public final Builder hooks(Collection<ChangeSetHook> hooks) {
            this.hooks = ChangeSetHooksCopier.copy(hooks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hooks(ChangeSetHook... hooks) {
            hooks(Arrays.asList(hooks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hooks(Consumer<ChangeSetHook.Builder>... hooks) {
            hooks(Stream.of(hooks).map(c -> ChangeSetHook.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ChangeSetHooksStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        @Transient
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        @Transient
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        @Override
        public DescribeChangeSetHooksResponse build() {
            return new DescribeChangeSetHooksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
