/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for <a>ValidateTemplate</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateTemplateRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ValidateTemplateRequest.Builder, ValidateTemplateRequest> {
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateBody").getter(getter(ValidateTemplateRequest::templateBody))
            .setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateURL").getter(getter(ValidateTemplateRequest::templateURL)).setter(setter(Builder::templateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_BODY_FIELD,
            TEMPLATE_URL_FIELD));

    private final String templateBody;

    private final String templateURL;

    private ValidateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
    }

    /**
     * <p>
     * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For
     * more information, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed, only
     * <code>TemplateBody</code> is used.
     * </p>
     * 
     * @return Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
     *         bytes. For more information, go to <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed,
     *         only <code>TemplateBody</code> is used.
     */
    public final String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is
     * located in an Amazon S3 bucket or a Systems Manager document. For more information, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed, only
     * <code>TemplateBody</code> is used.
     * </p>
     * 
     * @return Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
     *         that is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed,
     *         only <code>TemplateBody</code> is used.
     */
    public final String templateURL() {
        return templateURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateTemplateRequest)) {
            return false;
        }
        ValidateTemplateRequest other = (ValidateTemplateRequest) obj;
        return Objects.equals(templateBody(), other.templateBody()) && Objects.equals(templateURL(), other.templateURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidateTemplateRequest").add("TemplateBody", templateBody()).add("TemplateURL", templateURL())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateURL":
            return Optional.ofNullable(clazz.cast(templateURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateTemplateRequest, T> g) {
        return obj -> g.apply((ValidateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ValidateTemplateRequest> {
        /**
         * <p>
         * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         * For more information, go to <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed, only
         * <code>TemplateBody</code> is used.
         * </p>
         * 
         * @param templateBody
         *        Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
         *        bytes. For more information, go to <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed,
         *        only <code>TemplateBody</code> is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
         * that is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed, only
         * <code>TemplateBody</code> is used.
         * </p>
         * 
         * @param templateURL
         *        Location of file containing the template body. The URL must point to a template (max size: 460,800
         *        bytes) that is located in an Amazon S3 bucket or a Systems Manager document. For more information, go
         *        to <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed,
         *        only <code>TemplateBody</code> is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String templateBody;

        private String templateURL;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateTemplateRequest model) {
            super(model);
            templateBody(model.templateBody);
            templateURL(model.templateURL);
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        @Transient
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        @Transient
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidateTemplateRequest build() {
            return new ValidateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
