/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter criteria to use in determining which extensions to return.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypeFilters implements SdkPojo, Serializable, ToCopyableBuilder<TypeFilters.Builder, TypeFilters> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(TypeFilters::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherId").getter(getter(TypeFilters::publisherId)).setter(setter(Builder::publisherId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()).build();

    private static final SdkField<String> TYPE_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeNamePrefix").getter(getter(TypeFilters::typeNamePrefix)).setter(setter(Builder::typeNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeNamePrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            PUBLISHER_ID_FIELD, TYPE_NAME_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String category;

    private final String publisherId;

    private final String typeNamePrefix;

    private TypeFilters(BuilderImpl builder) {
        this.category = builder.category;
        this.publisherId = builder.publisherId;
        this.typeNamePrefix = builder.typeNamePrefix;
    }

    /**
     * <p>
     * The category of extensions to return.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REGISTERED</code>: Private extensions that have been registered for this account and region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Private extensions registered in the account.
     * </p>
     * </li>
     * <li>
     * <p>
     * Public extensions from publishers other than Amazon, whether activated or not.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>AWS_TYPES</code>: Extensions available for use from Amazon.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link Category#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of extensions to return.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REGISTERED</code>: Private extensions that have been registered for this account and region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This includes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Private extensions registered in the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Public extensions from publishers other than Amazon, whether activated or not.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_TYPES</code>: Extensions available for use from Amazon.
     *         </p>
     *         </li>
     * @see Category
     */
    public final Category category() {
        return Category.fromValue(category);
    }

    /**
     * <p>
     * The category of extensions to return.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REGISTERED</code>: Private extensions that have been registered for this account and region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Private extensions registered in the account.
     * </p>
     * </li>
     * <li>
     * <p>
     * Public extensions from publishers other than Amazon, whether activated or not.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>AWS_TYPES</code>: Extensions available for use from Amazon.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link Category#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of extensions to return.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REGISTERED</code>: Private extensions that have been registered for this account and region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This includes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Private extensions registered in the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Public extensions from publishers other than Amazon, whether activated or not.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_TYPES</code>: Extensions available for use from Amazon.
     *         </p>
     *         </li>
     * @see Category
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The id of the publisher of the extension.
     * </p>
     * <p>
     * Extensions published by Amazon aren't assigned a publisher ID. Use the <code>AWS_TYPES</code> category to specify
     * a list of types published by Amazon.
     * </p>
     * 
     * @return The id of the publisher of the extension.</p>
     *         <p>
     *         Extensions published by Amazon aren't assigned a publisher ID. Use the <code>AWS_TYPES</code> category to
     *         specify a list of types published by Amazon.
     */
    public final String publisherId() {
        return publisherId;
    }

    /**
     * <p>
     * A prefix to use as a filter for results.
     * </p>
     * 
     * @return A prefix to use as a filter for results.
     */
    public final String typeNamePrefix() {
        return typeNamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(typeNamePrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeFilters)) {
            return false;
        }
        TypeFilters other = (TypeFilters) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString()) && Objects.equals(publisherId(), other.publisherId())
                && Objects.equals(typeNamePrefix(), other.typeNamePrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypeFilters").add("Category", categoryAsString()).add("PublisherId", publisherId())
                .add("TypeNamePrefix", typeNamePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "PublisherId":
            return Optional.ofNullable(clazz.cast(publisherId()));
        case "TypeNamePrefix":
            return Optional.ofNullable(clazz.cast(typeNamePrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypeFilters, T> g) {
        return obj -> g.apply((TypeFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypeFilters> {
        /**
         * <p>
         * The category of extensions to return.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTERED</code>: Private extensions that have been registered for this account and region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This includes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Private extensions registered in the account.
         * </p>
         * </li>
         * <li>
         * <p>
         * Public extensions from publishers other than Amazon, whether activated or not.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>AWS_TYPES</code>: Extensions available for use from Amazon.
         * </p>
         * </li>
         * </ul>
         * 
         * @param category
         *        The category of extensions to return.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REGISTERED</code>: Private extensions that have been registered for this account and region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This
         *        includes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Private extensions registered in the account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Public extensions from publishers other than Amazon, whether activated or not.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_TYPES</code>: Extensions available for use from Amazon.
         *        </p>
         *        </li>
         * @see Category
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Category
         */
        Builder category(String category);

        /**
         * <p>
         * The category of extensions to return.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTERED</code>: Private extensions that have been registered for this account and region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This includes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Private extensions registered in the account.
         * </p>
         * </li>
         * <li>
         * <p>
         * Public extensions from publishers other than Amazon, whether activated or not.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>AWS_TYPES</code>: Extensions available for use from Amazon.
         * </p>
         * </li>
         * </ul>
         * 
         * @param category
         *        The category of extensions to return.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REGISTERED</code>: Private extensions that have been registered for this account and region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATED</code>: Public extensions that have been activated for this account and region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THIRD_PARTY</code>: Extensions available for use from publishers other than Amazon. This
         *        includes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Private extensions registered in the account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Public extensions from publishers other than Amazon, whether activated or not.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_TYPES</code>: Extensions available for use from Amazon.
         *        </p>
         *        </li>
         * @see Category
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Category
         */
        Builder category(Category category);

        /**
         * <p>
         * The id of the publisher of the extension.
         * </p>
         * <p>
         * Extensions published by Amazon aren't assigned a publisher ID. Use the <code>AWS_TYPES</code> category to
         * specify a list of types published by Amazon.
         * </p>
         * 
         * @param publisherId
         *        The id of the publisher of the extension.</p>
         *        <p>
         *        Extensions published by Amazon aren't assigned a publisher ID. Use the <code>AWS_TYPES</code> category
         *        to specify a list of types published by Amazon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisherId(String publisherId);

        /**
         * <p>
         * A prefix to use as a filter for results.
         * </p>
         * 
         * @param typeNamePrefix
         *        A prefix to use as a filter for results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeNamePrefix(String typeNamePrefix);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private String publisherId;

        private String typeNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeFilters model) {
            category(model.category);
            publisherId(model.publisherId);
            typeNamePrefix(model.typeNamePrefix);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        @Transient
        public final Builder category(Category category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getPublisherId() {
            return publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        @Transient
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final String getTypeNamePrefix() {
            return typeNamePrefix;
        }

        public final void setTypeNamePrefix(String typeNamePrefix) {
            this.typeNamePrefix = typeNamePrefix;
        }

        @Override
        @Transient
        public final Builder typeNamePrefix(String typeNamePrefix) {
            this.typeNamePrefix = typeNamePrefix;
            return this;
        }

        @Override
        public TypeFilters build() {
            return new TypeFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
