/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivateTypeRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ActivateTypeRequest.Builder, ActivateTypeRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ActivateTypeRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PUBLIC_TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicTypeArn").getter(getter(ActivateTypeRequest::publicTypeArn))
            .setter(setter(Builder::publicTypeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicTypeArn").build()).build();

    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherId").getter(getter(ActivateTypeRequest::publisherId)).setter(setter(Builder::publisherId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(ActivateTypeRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> TYPE_NAME_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeNameAlias").getter(getter(ActivateTypeRequest::typeNameAlias))
            .setter(setter(Builder::typeNameAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeNameAlias").build()).build();

    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoUpdate").getter(getter(ActivateTypeRequest::autoUpdate)).setter(setter(Builder::autoUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdate").build()).build();

    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField
            .<LoggingConfig> builder(MarshallingType.SDK_POJO).memberName("LoggingConfig")
            .getter(getter(ActivateTypeRequest::loggingConfig)).setter(setter(Builder::loggingConfig))
            .constructor(LoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfig").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(ActivateTypeRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> VERSION_BUMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionBump").getter(getter(ActivateTypeRequest::versionBumpAsString))
            .setter(setter(Builder::versionBump))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionBump").build()).build();

    private static final SdkField<Long> MAJOR_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MajorVersion").getter(getter(ActivateTypeRequest::majorVersion)).setter(setter(Builder::majorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            PUBLIC_TYPE_ARN_FIELD, PUBLISHER_ID_FIELD, TYPE_NAME_FIELD, TYPE_NAME_ALIAS_FIELD, AUTO_UPDATE_FIELD,
            LOGGING_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD, VERSION_BUMP_FIELD, MAJOR_VERSION_FIELD));

    private final String type;

    private final String publicTypeArn;

    private final String publisherId;

    private final String typeName;

    private final String typeNameAlias;

    private final Boolean autoUpdate;

    private final LoggingConfig loggingConfig;

    private final String executionRoleArn;

    private final String versionBump;

    private final Long majorVersion;

    private ActivateTypeRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.publicTypeArn = builder.publicTypeArn;
        this.publisherId = builder.publisherId;
        this.typeName = builder.typeName;
        this.typeNameAlias = builder.typeNameAlias;
        this.autoUpdate = builder.autoUpdate;
        this.loggingConfig = builder.loggingConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.versionBump = builder.versionBump;
        this.majorVersion = builder.majorVersion;
    }

    /**
     * <p>
     * The extension type.
     * </p>
     * <p>
     * Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>, and
     * <code>PublisherId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThirdPartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The extension type.</p>
     *         <p>
     *         Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>,
     *         and <code>PublisherId</code>.
     * @see ThirdPartyType
     */
    public final ThirdPartyType type() {
        return ThirdPartyType.fromValue(type);
    }

    /**
     * <p>
     * The extension type.
     * </p>
     * <p>
     * Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>, and
     * <code>PublisherId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThirdPartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The extension type.</p>
     *         <p>
     *         Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>,
     *         and <code>PublisherId</code>.
     * @see ThirdPartyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the public extension.
     * </p>
     * <p>
     * Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>, and
     * <code>PublisherId</code>.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the public extension.</p>
     *         <p>
     *         Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>,
     *         and <code>PublisherId</code>.
     */
    public final String publicTypeArn() {
        return publicTypeArn;
    }

    /**
     * <p>
     * The ID of the extension publisher.
     * </p>
     * <p>
     * Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>, and
     * <code>PublisherId</code>.
     * </p>
     * 
     * @return The ID of the extension publisher.</p>
     *         <p>
     *         Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>,
     *         and <code>PublisherId</code>.
     */
    public final String publisherId() {
        return publisherId;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * <p>
     * Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>, and
     * <code>PublisherId</code>.
     * </p>
     * 
     * @return The name of the extension.</p>
     *         <p>
     *         Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>,
     *         and <code>PublisherId</code>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * An alias to assign to the public extension, in this account and region. If you specify an alias for the
     * extension, CloudFormation treats the alias as the extension type name within this account and region. You must
     * use the alias to refer to the extension in your templates, API calls, and CloudFormation console.
     * </p>
     * <p>
     * An extension alias must be unique within a given account and region. You can activate the same public resource
     * multiple times in the same account and region, using different type name aliases.
     * </p>
     * 
     * @return An alias to assign to the public extension, in this account and region. If you specify an alias for the
     *         extension, CloudFormation treats the alias as the extension type name within this account and region. You
     *         must use the alias to refer to the extension in your templates, API calls, and CloudFormation
     *         console.</p>
     *         <p>
     *         An extension alias must be unique within a given account and region. You can activate the same public
     *         resource multiple times in the same account and region, using different type name aliases.
     */
    public final String typeNameAlias() {
        return typeNameAlias;
    }

    /**
     * <p>
     * Whether to automatically update the extension in this account and region when a new <i>minor</i> version is
     * published by the extension publisher. Major versions released by the publisher must be manually updated.
     * </p>
     * <p>
     * The default is <code>true</code>.
     * </p>
     * 
     * @return Whether to automatically update the extension in this account and region when a new <i>minor</i> version
     *         is published by the extension publisher. Major versions released by the publisher must be manually
     *         updated.</p>
     *         <p>
     *         The default is <code>true</code>.
     */
    public final Boolean autoUpdate() {
        return autoUpdate;
    }

    /**
     * Returns the value of the LoggingConfig property for this object.
     * 
     * @return The value of the LoggingConfig property for this object.
     */
    public final LoggingConfig loggingConfig() {
        return loggingConfig;
    }

    /**
     * <p>
     * The name of the IAM execution role to use to activate the extension.
     * </p>
     * 
     * @return The name of the IAM execution role to use to activate the extension.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * Manually updates a previously-activated type to a new major or minor version, if available. You can also use this
     * parameter to update the value of <code>AutoUpdate</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MAJOR</code>: CloudFormation updates the extension to the newest major version, if one is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MINOR</code>: CloudFormation updates the extension to the newest minor version, if one is available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionBump} will
     * return {@link VersionBump#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionBumpAsString}.
     * </p>
     * 
     * @return Manually updates a previously-activated type to a new major or minor version, if available. You can also
     *         use this parameter to update the value of <code>AutoUpdate</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MAJOR</code>: CloudFormation updates the extension to the newest major version, if one is
     *         available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MINOR</code>: CloudFormation updates the extension to the newest minor version, if one is
     *         available.
     *         </p>
     *         </li>
     * @see VersionBump
     */
    public final VersionBump versionBump() {
        return VersionBump.fromValue(versionBump);
    }

    /**
     * <p>
     * Manually updates a previously-activated type to a new major or minor version, if available. You can also use this
     * parameter to update the value of <code>AutoUpdate</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MAJOR</code>: CloudFormation updates the extension to the newest major version, if one is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MINOR</code>: CloudFormation updates the extension to the newest minor version, if one is available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionBump} will
     * return {@link VersionBump#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionBumpAsString}.
     * </p>
     * 
     * @return Manually updates a previously-activated type to a new major or minor version, if available. You can also
     *         use this parameter to update the value of <code>AutoUpdate</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MAJOR</code>: CloudFormation updates the extension to the newest major version, if one is
     *         available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MINOR</code>: CloudFormation updates the extension to the newest minor version, if one is
     *         available.
     *         </p>
     *         </li>
     * @see VersionBump
     */
    public final String versionBumpAsString() {
        return versionBump;
    }

    /**
     * <p>
     * The major version of this extension you want to activate, if multiple major versions are available. The default
     * is the latest major version. CloudFormation uses the latest available <i>minor</i> version of the major version
     * selected.
     * </p>
     * <p>
     * You can specify <code>MajorVersion</code> or <code>VersionBump</code>, but not both.
     * </p>
     * 
     * @return The major version of this extension you want to activate, if multiple major versions are available. The
     *         default is the latest major version. CloudFormation uses the latest available <i>minor</i> version of the
     *         major version selected.</p>
     *         <p>
     *         You can specify <code>MajorVersion</code> or <code>VersionBump</code>, but not both.
     */
    public final Long majorVersion() {
        return majorVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publicTypeArn());
        hashCode = 31 * hashCode + Objects.hashCode(publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeNameAlias());
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionBumpAsString());
        hashCode = 31 * hashCode + Objects.hashCode(majorVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateTypeRequest)) {
            return false;
        }
        ActivateTypeRequest other = (ActivateTypeRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(publicTypeArn(), other.publicTypeArn())
                && Objects.equals(publisherId(), other.publisherId()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(typeNameAlias(), other.typeNameAlias()) && Objects.equals(autoUpdate(), other.autoUpdate())
                && Objects.equals(loggingConfig(), other.loggingConfig())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(versionBumpAsString(), other.versionBumpAsString())
                && Objects.equals(majorVersion(), other.majorVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActivateTypeRequest").add("Type", typeAsString()).add("PublicTypeArn", publicTypeArn())
                .add("PublisherId", publisherId()).add("TypeName", typeName()).add("TypeNameAlias", typeNameAlias())
                .add("AutoUpdate", autoUpdate()).add("LoggingConfig", loggingConfig())
                .add("ExecutionRoleArn", executionRoleArn()).add("VersionBump", versionBumpAsString())
                .add("MajorVersion", majorVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "PublicTypeArn":
            return Optional.ofNullable(clazz.cast(publicTypeArn()));
        case "PublisherId":
            return Optional.ofNullable(clazz.cast(publisherId()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "TypeNameAlias":
            return Optional.ofNullable(clazz.cast(typeNameAlias()));
        case "AutoUpdate":
            return Optional.ofNullable(clazz.cast(autoUpdate()));
        case "LoggingConfig":
            return Optional.ofNullable(clazz.cast(loggingConfig()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "VersionBump":
            return Optional.ofNullable(clazz.cast(versionBumpAsString()));
        case "MajorVersion":
            return Optional.ofNullable(clazz.cast(majorVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivateTypeRequest, T> g) {
        return obj -> g.apply((ActivateTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ActivateTypeRequest> {
        /**
         * <p>
         * The extension type.
         * </p>
         * <p>
         * Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>, and
         * <code>PublisherId</code>.
         * </p>
         * 
         * @param type
         *        The extension type.</p>
         *        <p>
         *        Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>,
         *        and <code>PublisherId</code>.
         * @see ThirdPartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyType
         */
        Builder type(String type);

        /**
         * <p>
         * The extension type.
         * </p>
         * <p>
         * Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>, and
         * <code>PublisherId</code>.
         * </p>
         * 
         * @param type
         *        The extension type.</p>
         *        <p>
         *        Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>,
         *        and <code>PublisherId</code>.
         * @see ThirdPartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyType
         */
        Builder type(ThirdPartyType type);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the public extension.
         * </p>
         * <p>
         * Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>, and
         * <code>PublisherId</code>.
         * </p>
         * 
         * @param publicTypeArn
         *        The Amazon Resource Number (ARN) of the public extension.</p>
         *        <p>
         *        Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>,
         *        and <code>PublisherId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicTypeArn(String publicTypeArn);

        /**
         * <p>
         * The ID of the extension publisher.
         * </p>
         * <p>
         * Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>, and
         * <code>PublisherId</code>.
         * </p>
         * 
         * @param publisherId
         *        The ID of the extension publisher.</p>
         *        <p>
         *        Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>,
         *        and <code>PublisherId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisherId(String publisherId);

        /**
         * <p>
         * The name of the extension.
         * </p>
         * <p>
         * Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>, and
         * <code>PublisherId</code>.
         * </p>
         * 
         * @param typeName
         *        The name of the extension.</p>
         *        <p>
         *        Conditional: You must specify <code>PublicTypeArn</code>, or <code>TypeName</code>, <code>Type</code>,
         *        and <code>PublisherId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * An alias to assign to the public extension, in this account and region. If you specify an alias for the
         * extension, CloudFormation treats the alias as the extension type name within this account and region. You
         * must use the alias to refer to the extension in your templates, API calls, and CloudFormation console.
         * </p>
         * <p>
         * An extension alias must be unique within a given account and region. You can activate the same public
         * resource multiple times in the same account and region, using different type name aliases.
         * </p>
         * 
         * @param typeNameAlias
         *        An alias to assign to the public extension, in this account and region. If you specify an alias for
         *        the extension, CloudFormation treats the alias as the extension type name within this account and
         *        region. You must use the alias to refer to the extension in your templates, API calls, and
         *        CloudFormation console.</p>
         *        <p>
         *        An extension alias must be unique within a given account and region. You can activate the same public
         *        resource multiple times in the same account and region, using different type name aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeNameAlias(String typeNameAlias);

        /**
         * <p>
         * Whether to automatically update the extension in this account and region when a new <i>minor</i> version is
         * published by the extension publisher. Major versions released by the publisher must be manually updated.
         * </p>
         * <p>
         * The default is <code>true</code>.
         * </p>
         * 
         * @param autoUpdate
         *        Whether to automatically update the extension in this account and region when a new <i>minor</i>
         *        version is published by the extension publisher. Major versions released by the publisher must be
         *        manually updated.</p>
         *        <p>
         *        The default is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdate(Boolean autoUpdate);

        /**
         * Sets the value of the LoggingConfig property for this object.
         *
         * @param loggingConfig
         *        The new value for the LoggingConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfig(LoggingConfig loggingConfig);

        /**
         * Sets the value of the LoggingConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LoggingConfig.Builder} avoiding the need
         * to create one manually via {@link LoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingConfig(LoggingConfig)}.
         * 
         * @param loggingConfig
         *        a consumer that will call methods on {@link LoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfig(LoggingConfig)
         */
        default Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return loggingConfig(LoggingConfig.builder().applyMutation(loggingConfig).build());
        }

        /**
         * <p>
         * The name of the IAM execution role to use to activate the extension.
         * </p>
         * 
         * @param executionRoleArn
         *        The name of the IAM execution role to use to activate the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * Manually updates a previously-activated type to a new major or minor version, if available. You can also use
         * this parameter to update the value of <code>AutoUpdate</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MAJOR</code>: CloudFormation updates the extension to the newest major version, if one is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MINOR</code>: CloudFormation updates the extension to the newest minor version, if one is available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param versionBump
         *        Manually updates a previously-activated type to a new major or minor version, if available. You can
         *        also use this parameter to update the value of <code>AutoUpdate</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MAJOR</code>: CloudFormation updates the extension to the newest major version, if one is
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MINOR</code>: CloudFormation updates the extension to the newest minor version, if one is
         *        available.
         *        </p>
         *        </li>
         * @see VersionBump
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionBump
         */
        Builder versionBump(String versionBump);

        /**
         * <p>
         * Manually updates a previously-activated type to a new major or minor version, if available. You can also use
         * this parameter to update the value of <code>AutoUpdate</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MAJOR</code>: CloudFormation updates the extension to the newest major version, if one is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MINOR</code>: CloudFormation updates the extension to the newest minor version, if one is available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param versionBump
         *        Manually updates a previously-activated type to a new major or minor version, if available. You can
         *        also use this parameter to update the value of <code>AutoUpdate</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MAJOR</code>: CloudFormation updates the extension to the newest major version, if one is
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MINOR</code>: CloudFormation updates the extension to the newest minor version, if one is
         *        available.
         *        </p>
         *        </li>
         * @see VersionBump
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionBump
         */
        Builder versionBump(VersionBump versionBump);

        /**
         * <p>
         * The major version of this extension you want to activate, if multiple major versions are available. The
         * default is the latest major version. CloudFormation uses the latest available <i>minor</i> version of the
         * major version selected.
         * </p>
         * <p>
         * You can specify <code>MajorVersion</code> or <code>VersionBump</code>, but not both.
         * </p>
         * 
         * @param majorVersion
         *        The major version of this extension you want to activate, if multiple major versions are available.
         *        The default is the latest major version. CloudFormation uses the latest available <i>minor</i> version
         *        of the major version selected.</p>
         *        <p>
         *        You can specify <code>MajorVersion</code> or <code>VersionBump</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorVersion(Long majorVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String type;

        private String publicTypeArn;

        private String publisherId;

        private String typeName;

        private String typeNameAlias;

        private Boolean autoUpdate;

        private LoggingConfig loggingConfig;

        private String executionRoleArn;

        private String versionBump;

        private Long majorVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateTypeRequest model) {
            super(model);
            type(model.type);
            publicTypeArn(model.publicTypeArn);
            publisherId(model.publisherId);
            typeName(model.typeName);
            typeNameAlias(model.typeNameAlias);
            autoUpdate(model.autoUpdate);
            loggingConfig(model.loggingConfig);
            executionRoleArn(model.executionRoleArn);
            versionBump(model.versionBump);
            majorVersion(model.majorVersion);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ThirdPartyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPublicTypeArn() {
            return publicTypeArn;
        }

        public final void setPublicTypeArn(String publicTypeArn) {
            this.publicTypeArn = publicTypeArn;
        }

        @Override
        @Transient
        public final Builder publicTypeArn(String publicTypeArn) {
            this.publicTypeArn = publicTypeArn;
            return this;
        }

        public final String getPublisherId() {
            return publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        @Transient
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        @Transient
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeNameAlias() {
            return typeNameAlias;
        }

        public final void setTypeNameAlias(String typeNameAlias) {
            this.typeNameAlias = typeNameAlias;
        }

        @Override
        @Transient
        public final Builder typeNameAlias(String typeNameAlias) {
            this.typeNameAlias = typeNameAlias;
            return this;
        }

        public final Boolean getAutoUpdate() {
            return autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        @Transient
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return loggingConfig != null ? loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        @Transient
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getVersionBump() {
            return versionBump;
        }

        public final void setVersionBump(String versionBump) {
            this.versionBump = versionBump;
        }

        @Override
        @Transient
        public final Builder versionBump(String versionBump) {
            this.versionBump = versionBump;
            return this;
        }

        @Override
        @Transient
        public final Builder versionBump(VersionBump versionBump) {
            this.versionBump(versionBump == null ? null : versionBump.toString());
            return this;
        }

        public final Long getMajorVersion() {
            return majorVersion;
        }

        public final void setMajorVersion(Long majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        @Transient
        public final Builder majorVersion(Long majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivateTypeRequest build() {
            return new ActivateTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
