/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>DescribeStackEvents</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackEventsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackEventsResponse.Builder, DescribeStackEventsResponse> {
    private static final SdkField<List<StackEvent>> STACK_EVENTS_FIELD = SdkField
            .<List<StackEvent>> builder(MarshallingType.LIST)
            .memberName("StackEvents")
            .getter(getter(DescribeStackEventsResponse::stackEvents))
            .setter(setter(Builder::stackEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeStackEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_EVENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StackEvent> stackEvents;

    private final String nextToken;

    private DescribeStackEventsResponse(BuilderImpl builder) {
        super(builder);
        this.stackEvents = builder.stackEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StackEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStackEvents() {
        return stackEvents != null && !(stackEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>StackEvents</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackEvents} method.
     * </p>
     * 
     * @return A list of <code>StackEvents</code> structures.
     */
    public final List<StackEvent> stackEvents() {
        return stackEvents;
    }

    /**
     * <p>
     * If the output exceeds 1 MB in size, a string that identifies the next page of events. If no additional page
     * exists, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB in size, a string that identifies the next page of events. If no additional
     *         page exists, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStackEvents() ? stackEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackEventsResponse)) {
            return false;
        }
        DescribeStackEventsResponse other = (DescribeStackEventsResponse) obj;
        return hasStackEvents() == other.hasStackEvents() && Objects.equals(stackEvents(), other.stackEvents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStackEventsResponse").add("StackEvents", hasStackEvents() ? stackEvents() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackEvents":
            return Optional.ofNullable(clazz.cast(stackEvents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackEventsResponse, T> g) {
        return obj -> g.apply((DescribeStackEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackEventsResponse> {
        /**
         * <p>
         * A list of <code>StackEvents</code> structures.
         * </p>
         * 
         * @param stackEvents
         *        A list of <code>StackEvents</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackEvents(Collection<StackEvent> stackEvents);

        /**
         * <p>
         * A list of <code>StackEvents</code> structures.
         * </p>
         * 
         * @param stackEvents
         *        A list of <code>StackEvents</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackEvents(StackEvent... stackEvents);

        /**
         * <p>
         * A list of <code>StackEvents</code> structures.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StackEvent>.Builder} avoiding the
         * need to create one manually via {@link List<StackEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackEvent>.Builder#build()} is called immediately and its
         * result is passed to {@link #stackEvents(List<StackEvent>)}.
         * 
         * @param stackEvents
         *        a consumer that will call methods on {@link List<StackEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackEvents(List<StackEvent>)
         */
        Builder stackEvents(Consumer<StackEvent.Builder>... stackEvents);

        /**
         * <p>
         * If the output exceeds 1 MB in size, a string that identifies the next page of events. If no additional page
         * exists, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB in size, a string that identifies the next page of events. If no additional
         *        page exists, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackEvent> stackEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackEventsResponse model) {
            super(model);
            stackEvents(model.stackEvents);
            nextToken(model.nextToken);
        }

        public final List<StackEvent.Builder> getStackEvents() {
            List<StackEvent.Builder> result = StackEventsCopier.copyToBuilder(this.stackEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackEvents(Collection<StackEvent.BuilderImpl> stackEvents) {
            this.stackEvents = StackEventsCopier.copyFromBuilder(stackEvents);
        }

        @Override
        @Transient
        public final Builder stackEvents(Collection<StackEvent> stackEvents) {
            this.stackEvents = StackEventsCopier.copy(stackEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stackEvents(StackEvent... stackEvents) {
            stackEvents(Arrays.asList(stackEvents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stackEvents(Consumer<StackEvent.Builder>... stackEvents) {
            stackEvents(Stream.of(stackEvents).map(c -> StackEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStackEventsResponse build() {
            return new DescribeStackEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
