/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackSetOperationResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackSetOperationResponse.Builder, DescribeStackSetOperationResponse> {
    private static final SdkField<StackSetOperation> STACK_SET_OPERATION_FIELD = SdkField
            .<StackSetOperation> builder(MarshallingType.SDK_POJO).memberName("StackSetOperation")
            .getter(getter(DescribeStackSetOperationResponse::stackSetOperation)).setter(setter(Builder::stackSetOperation))
            .constructor(StackSetOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetOperation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_OPERATION_FIELD));

    private final StackSetOperation stackSetOperation;

    private DescribeStackSetOperationResponse(BuilderImpl builder) {
        super(builder);
        this.stackSetOperation = builder.stackSetOperation;
    }

    /**
     * <p>
     * The specified stack set operation.
     * </p>
     * 
     * @return The specified stack set operation.
     */
    public final StackSetOperation stackSetOperation() {
        return stackSetOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackSetOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSetOperationResponse)) {
            return false;
        }
        DescribeStackSetOperationResponse other = (DescribeStackSetOperationResponse) obj;
        return Objects.equals(stackSetOperation(), other.stackSetOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStackSetOperationResponse").add("StackSetOperation", stackSetOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetOperation":
            return Optional.ofNullable(clazz.cast(stackSetOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackSetOperationResponse, T> g) {
        return obj -> g.apply((DescribeStackSetOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackSetOperationResponse> {
        /**
         * <p>
         * The specified stack set operation.
         * </p>
         * 
         * @param stackSetOperation
         *        The specified stack set operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetOperation(StackSetOperation stackSetOperation);

        /**
         * <p>
         * The specified stack set operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link StackSetOperation.Builder} avoiding the
         * need to create one manually via {@link StackSetOperation#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackSetOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #stackSetOperation(StackSetOperation)}.
         * 
         * @param stackSetOperation
         *        a consumer that will call methods on {@link StackSetOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackSetOperation(StackSetOperation)
         */
        default Builder stackSetOperation(Consumer<StackSetOperation.Builder> stackSetOperation) {
            return stackSetOperation(StackSetOperation.builder().applyMutation(stackSetOperation).build());
        }
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private StackSetOperation stackSetOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSetOperationResponse model) {
            super(model);
            stackSetOperation(model.stackSetOperation);
        }

        public final StackSetOperation.Builder getStackSetOperation() {
            return stackSetOperation != null ? stackSetOperation.toBuilder() : null;
        }

        public final void setStackSetOperation(StackSetOperation.BuilderImpl stackSetOperation) {
            this.stackSetOperation = stackSetOperation != null ? stackSetOperation.build() : null;
        }

        @Override
        @Transient
        public final Builder stackSetOperation(StackSetOperation stackSetOperation) {
            this.stackSetOperation = stackSetOperation;
            return this;
        }

        @Override
        public DescribeStackSetOperationResponse build() {
            return new DescribeStackSetOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
