/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackSetOperationResultsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListStackSetOperationResultsResponse.Builder, ListStackSetOperationResultsResponse> {
    private static final SdkField<List<StackSetOperationResultSummary>> SUMMARIES_FIELD = SdkField
            .<List<StackSetOperationResultSummary>> builder(MarshallingType.LIST)
            .memberName("Summaries")
            .getter(getter(ListStackSetOperationResultsResponse::summaries))
            .setter(setter(Builder::summaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackSetOperationResultSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackSetOperationResultSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStackSetOperationResultsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StackSetOperationResultSummary> summaries;

    private final String nextToken;

    private ListStackSetOperationResultsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Summaries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSummaries() {
        return summaries != null && !(summaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>StackSetOperationResultSummary</code> structures that contain information about the specified
     * operation results, for accounts and Amazon Web Services Regions that are included in the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSummaries} method.
     * </p>
     * 
     * @return A list of <code>StackSetOperationResultSummary</code> structures that contain information about the
     *         specified operation results, for accounts and Amazon Web Services Regions that are included in the
     *         operation.
     */
    public final List<StackSetOperationResultSummary> summaries() {
        return summaries;
    }

    /**
     * <p>
     * If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the next set of
     * results, call <code>ListOperationResults</code> again and assign that token to the request object's
     * <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the next
     *         set of results, call <code>ListOperationResults</code> again and assign that token to the request
     *         object's <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is
     *         set to <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSummaries() ? summaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackSetOperationResultsResponse)) {
            return false;
        }
        ListStackSetOperationResultsResponse other = (ListStackSetOperationResultsResponse) obj;
        return hasSummaries() == other.hasSummaries() && Objects.equals(summaries(), other.summaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStackSetOperationResultsResponse").add("Summaries", hasSummaries() ? summaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Summaries":
            return Optional.ofNullable(clazz.cast(summaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStackSetOperationResultsResponse, T> g) {
        return obj -> g.apply((ListStackSetOperationResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStackSetOperationResultsResponse> {
        /**
         * <p>
         * A list of <code>StackSetOperationResultSummary</code> structures that contain information about the specified
         * operation results, for accounts and Amazon Web Services Regions that are included in the operation.
         * </p>
         * 
         * @param summaries
         *        A list of <code>StackSetOperationResultSummary</code> structures that contain information about the
         *        specified operation results, for accounts and Amazon Web Services Regions that are included in the
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<StackSetOperationResultSummary> summaries);

        /**
         * <p>
         * A list of <code>StackSetOperationResultSummary</code> structures that contain information about the specified
         * operation results, for accounts and Amazon Web Services Regions that are included in the operation.
         * </p>
         * 
         * @param summaries
         *        A list of <code>StackSetOperationResultSummary</code> structures that contain information about the
         *        specified operation results, for accounts and Amazon Web Services Regions that are included in the
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(StackSetOperationResultSummary... summaries);

        /**
         * <p>
         * A list of <code>StackSetOperationResultSummary</code> structures that contain information about the specified
         * operation results, for accounts and Amazon Web Services Regions that are included in the operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <StackSetOperationResultSummary>.Builder} avoiding the need to create one manually via {@link List
         * <StackSetOperationResultSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackSetOperationResultSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #summaries(List<StackSetOperationResultSummary>)}.
         * 
         * @param summaries
         *        a consumer that will call methods on {@link List<StackSetOperationResultSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaries(List<StackSetOperationResultSummary>)
         */
        Builder summaries(Consumer<StackSetOperationResultSummary.Builder>... summaries);

        /**
         * <p>
         * If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the next set
         * of results, call <code>ListOperationResults</code> again and assign that token to the request object's
         * <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the
         *        next set of results, call <code>ListOperationResults</code> again and assign that token to the request
         *        object's <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code>
         *        is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackSetOperationResultSummary> summaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackSetOperationResultsResponse model) {
            super(model);
            summaries(model.summaries);
            nextToken(model.nextToken);
        }

        public final List<StackSetOperationResultSummary.Builder> getSummaries() {
            List<StackSetOperationResultSummary.Builder> result = StackSetOperationResultSummariesCopier
                    .copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaries(Collection<StackSetOperationResultSummary.BuilderImpl> summaries) {
            this.summaries = StackSetOperationResultSummariesCopier.copyFromBuilder(summaries);
        }

        @Override
        @Transient
        public final Builder summaries(Collection<StackSetOperationResultSummary> summaries) {
            this.summaries = StackSetOperationResultSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder summaries(StackSetOperationResultSummary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder summaries(Consumer<StackSetOperationResultSummary.Builder>... summaries) {
            summaries(Stream.of(summaries).map(c -> StackSetOperationResultSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStackSetOperationResultsResponse build() {
            return new ListStackSetOperationResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
