/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackResourceDriftsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackResourceDriftsResponse.Builder, DescribeStackResourceDriftsResponse> {
    private static final SdkField<List<StackResourceDrift>> STACK_RESOURCE_DRIFTS_FIELD = SdkField
            .<List<StackResourceDrift>> builder(MarshallingType.LIST)
            .memberName("StackResourceDrifts")
            .getter(getter(DescribeStackResourceDriftsResponse::stackResourceDrifts))
            .setter(setter(Builder::stackResourceDrifts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceDrifts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackResourceDrift> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackResourceDrift::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeStackResourceDriftsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_RESOURCE_DRIFTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StackResourceDrift> stackResourceDrifts;

    private final String nextToken;

    private DescribeStackResourceDriftsResponse(BuilderImpl builder) {
        super(builder);
        this.stackResourceDrifts = builder.stackResourceDrifts;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StackResourceDrifts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStackResourceDrifts() {
        return stackResourceDrifts != null && !(stackResourceDrifts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Drift information for the resources that have been checked for drift in the specified stack. This includes actual
     * and expected configuration values for resources where CloudFormation detects drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that do not
     * currently support drift detection aren't checked, and so not included. For a list of resources that support drift
     * detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackResourceDrifts} method.
     * </p>
     * 
     * @return Drift information for the resources that have been checked for drift in the specified stack. This
     *         includes actual and expected configuration values for resources where CloudFormation detects drift.</p>
     *         <p>
     *         For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has
     *         been checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that
     *         do not currently support drift detection aren't checked, and so not included. For a list of resources
     *         that support drift detection, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     *         >Resources that Support Drift Detection</a>.
     */
    public final List<StackResourceDrift> stackResourceDrifts() {
        return stackResourceDrifts;
    }

    /**
     * <p>
     * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call <code>DescribeStackResourceDrifts</code> again and assign that token to the request
     * object's <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call <code>DescribeStackResourceDrifts</code> again and assign that
     *         token to the request object's <code>NextToken</code> parameter. If the request returns all results,
     *         <code>NextToken</code> is set to <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStackResourceDrifts() ? stackResourceDrifts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourceDriftsResponse)) {
            return false;
        }
        DescribeStackResourceDriftsResponse other = (DescribeStackResourceDriftsResponse) obj;
        return hasStackResourceDrifts() == other.hasStackResourceDrifts()
                && Objects.equals(stackResourceDrifts(), other.stackResourceDrifts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStackResourceDriftsResponse")
                .add("StackResourceDrifts", hasStackResourceDrifts() ? stackResourceDrifts() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackResourceDrifts":
            return Optional.ofNullable(clazz.cast(stackResourceDrifts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackResourceDriftsResponse, T> g) {
        return obj -> g.apply((DescribeStackResourceDriftsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackResourceDriftsResponse> {
        /**
         * <p>
         * Drift information for the resources that have been checked for drift in the specified stack. This includes
         * actual and expected configuration values for resources where CloudFormation detects drift.
         * </p>
         * <p>
         * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
         * checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that do not
         * currently support drift detection aren't checked, and so not included. For a list of resources that support
         * drift detection, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
         * >Resources that Support Drift Detection</a>.
         * </p>
         * 
         * @param stackResourceDrifts
         *        Drift information for the resources that have been checked for drift in the specified stack. This
         *        includes actual and expected configuration values for resources where CloudFormation detects
         *        drift.</p>
         *        <p>
         *        For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has
         *        been checked for drift. Resources that haven't yet been checked for drift aren't included. Resources
         *        that do not currently support drift detection aren't checked, and so not included. For a list of
         *        resources that support drift detection, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
         *        >Resources that Support Drift Detection</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceDrifts(Collection<StackResourceDrift> stackResourceDrifts);

        /**
         * <p>
         * Drift information for the resources that have been checked for drift in the specified stack. This includes
         * actual and expected configuration values for resources where CloudFormation detects drift.
         * </p>
         * <p>
         * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
         * checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that do not
         * currently support drift detection aren't checked, and so not included. For a list of resources that support
         * drift detection, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
         * >Resources that Support Drift Detection</a>.
         * </p>
         * 
         * @param stackResourceDrifts
         *        Drift information for the resources that have been checked for drift in the specified stack. This
         *        includes actual and expected configuration values for resources where CloudFormation detects
         *        drift.</p>
         *        <p>
         *        For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has
         *        been checked for drift. Resources that haven't yet been checked for drift aren't included. Resources
         *        that do not currently support drift detection aren't checked, and so not included. For a list of
         *        resources that support drift detection, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
         *        >Resources that Support Drift Detection</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceDrifts(StackResourceDrift... stackResourceDrifts);

        /**
         * <p>
         * Drift information for the resources that have been checked for drift in the specified stack. This includes
         * actual and expected configuration values for resources where CloudFormation detects drift.
         * </p>
         * <p>
         * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
         * checked for drift. Resources that haven't yet been checked for drift aren't included. Resources that do not
         * currently support drift detection aren't checked, and so not included. For a list of resources that support
         * drift detection, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
         * >Resources that Support Drift Detection</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StackResourceDrift>.Builder}
         * avoiding the need to create one manually via {@link List<StackResourceDrift>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackResourceDrift>.Builder#build()} is called immediately
         * and its result is passed to {@link #stackResourceDrifts(List<StackResourceDrift>)}.
         * 
         * @param stackResourceDrifts
         *        a consumer that will call methods on {@link List<StackResourceDrift>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackResourceDrifts(List<StackResourceDrift>)
         */
        Builder stackResourceDrifts(Consumer<StackResourceDrift.Builder>... stackResourceDrifts);

        /**
         * <p>
         * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call <code>DescribeStackResourceDrifts</code> again and assign that token
         * to the request object's <code>NextToken</code> parameter. If the request returns all results,
         * <code>NextToken</code> is set to <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token.
         *        To retrieve the next set of results, call <code>DescribeStackResourceDrifts</code> again and assign
         *        that token to the request object's <code>NextToken</code> parameter. If the request returns all
         *        results, <code>NextToken</code> is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackResourceDrift> stackResourceDrifts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourceDriftsResponse model) {
            super(model);
            stackResourceDrifts(model.stackResourceDrifts);
            nextToken(model.nextToken);
        }

        public final List<StackResourceDrift.Builder> getStackResourceDrifts() {
            List<StackResourceDrift.Builder> result = StackResourceDriftsCopier.copyToBuilder(this.stackResourceDrifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackResourceDrifts(Collection<StackResourceDrift.BuilderImpl> stackResourceDrifts) {
            this.stackResourceDrifts = StackResourceDriftsCopier.copyFromBuilder(stackResourceDrifts);
        }

        @Override
        public final Builder stackResourceDrifts(Collection<StackResourceDrift> stackResourceDrifts) {
            this.stackResourceDrifts = StackResourceDriftsCopier.copy(stackResourceDrifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceDrifts(StackResourceDrift... stackResourceDrifts) {
            stackResourceDrifts(Arrays.asList(stackResourceDrifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceDrifts(Consumer<StackResourceDrift.Builder>... stackResourceDrifts) {
            stackResourceDrifts(Stream.of(stackResourceDrifts).map(c -> StackResourceDrift.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStackResourceDriftsResponse build() {
            return new DescribeStackResourceDriftsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
