/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterTypeRequest extends CloudFormationRequest implements
        ToCopyableBuilder<RegisterTypeRequest.Builder, RegisterTypeRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RegisterTypeRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(RegisterTypeRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> SCHEMA_HANDLER_PACKAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaHandlerPackage").getter(getter(RegisterTypeRequest::schemaHandlerPackage))
            .setter(setter(Builder::schemaHandlerPackage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaHandlerPackage").build())
            .build();

    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField
            .<LoggingConfig> builder(MarshallingType.SDK_POJO).memberName("LoggingConfig")
            .getter(getter(RegisterTypeRequest::loggingConfig)).setter(setter(Builder::loggingConfig))
            .constructor(LoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfig").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(RegisterTypeRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(RegisterTypeRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD,
            SCHEMA_HANDLER_PACKAGE_FIELD, LOGGING_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String type;

    private final String typeName;

    private final String schemaHandlerPackage;

    private final LoggingConfig loggingConfig;

    private final String executionRoleArn;

    private final String clientRequestToken;

    private RegisterTypeRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.schemaHandlerPackage = builder.schemaHandlerPackage;
        this.loggingConfig = builder.loggingConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.
     * @see RegistryType
     */
    public final RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.
     * @see RegistryType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the extension being registered.
     * </p>
     * <p>
     * We recommend that extension names adhere to the following patterns:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For resource types, <i>company_or_organization</i>::<i>service</i>::<i>type</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For modules, <i>company_or_organization</i>::<i>service</i>::<i>type</i>::MODULE.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The following organization namespaces are reserved and can't be used in your extension names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Alexa</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AMZN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Custom</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Dev</code>
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return The name of the extension being registered.</p>
     *         <p>
     *         We recommend that extension names adhere to the following patterns:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For resource types, <i>company_or_organization</i>::<i>service</i>::<i>type</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For modules, <i>company_or_organization</i>::<i>service</i>::<i>type</i>::MODULE.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The following organization namespaces are reserved and can't be used in your extension names:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Alexa</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AMZN</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Amazon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Custom</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Dev</code>
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * A URL to the S3 bucket containing the extension project package that contains the necessary files for the
     * extension you want to register.
     * </p>
     * <p>
     * For information on generating a schema handler package for the extension you want to register, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit</a>
     * in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The user registering the extension must be able to access the package in the S3 bucket. That's, the user needs to
     * have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> permissions for
     * the schema handler package. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys
     * for Amazon S3</a> in the <i>Identity and Access Management User Guide</i>.
     * </p>
     * </note>
     * 
     * @return A URL to the S3 bucket containing the extension project package that contains the necessary files for the
     *         extension you want to register.</p>
     *         <p>
     *         For information on generating a schema handler package for the extension you want to register, see <a
     *         href
     *         ="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit
     *         </a> in the <i>CloudFormation CLI User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         The user registering the extension must be able to access the package in the S3 bucket. That's, the user
     *         needs to have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     *         permissions for the schema handler package. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and
     *         Condition Keys for Amazon S3</a> in the <i>Identity and Access Management User Guide</i>.
     *         </p>
     */
    public final String schemaHandlerPackage() {
        return schemaHandlerPackage;
    }

    /**
     * <p>
     * Specifies logging configuration information for an extension.
     * </p>
     * 
     * @return Specifies logging configuration information for an extension.
     */
    public final LoggingConfig loggingConfig() {
        return loggingConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume when invoking the extension.
     * </p>
     * <p>
     * For CloudFormation to assume the specified execution role, the role must contain a trust relationship with the
     * CloudFormation service principle (<code>resources.cloudformation.amazonaws.com</code>). For more information on
     * adding trust relationships, see <a
     * href="IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy"
     * >Modifying a role trust policy</a> in the <i>Identity and Access Management User Guide</i>.
     * </p>
     * <p>
     * If your extension calls Amazon Web Services APIs in any of its handlers, you must create an <i> <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that includes
     * the necessary permissions to call those Amazon Web Services APIs, and provision that execution role in your
     * account. When CloudFormation needs to invoke the resource type handler, CloudFormation assumes this execution
     * role to create a temporary session token, which it then passes to the resource type handler, thereby supplying
     * your resource type with the appropriate credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume when invoking the
     *         extension.</p>
     *         <p>
     *         For CloudFormation to assume the specified execution role, the role must contain a trust relationship
     *         with the CloudFormation service principle (<code>resources.cloudformation.amazonaws.com</code>). For more
     *         information on adding trust relationships, see <a href=
     *         "IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy"
     *         >Modifying a role trust policy</a> in the <i>Identity and Access Management User Guide</i>.
     *         </p>
     *         <p>
     *         If your extension calls Amazon Web Services APIs in any of its handlers, you must create an <i> <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that
     *         includes the necessary permissions to call those Amazon Web Services APIs, and provision that execution
     *         role in your account. When CloudFormation needs to invoke the resource type handler, CloudFormation
     *         assumes this execution role to create a temporary session token, which it then passes to the resource
     *         type handler, thereby supplying your resource type with the appropriate credentials.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * A unique identifier that acts as an idempotency key for this registration request. Specifying a client request
     * token prevents CloudFormation from generating more than one version of an extension from the same registration
     * request, even if the request is submitted multiple times.
     * </p>
     * 
     * @return A unique identifier that acts as an idempotency key for this registration request. Specifying a client
     *         request token prevents CloudFormation from generating more than one version of an extension from the same
     *         registration request, even if the request is submitted multiple times.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaHandlerPackage());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTypeRequest)) {
            return false;
        }
        RegisterTypeRequest other = (RegisterTypeRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(schemaHandlerPackage(), other.schemaHandlerPackage())
                && Objects.equals(loggingConfig(), other.loggingConfig())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterTypeRequest").add("Type", typeAsString()).add("TypeName", typeName())
                .add("SchemaHandlerPackage", schemaHandlerPackage()).add("LoggingConfig", loggingConfig())
                .add("ExecutionRoleArn", executionRoleArn()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "SchemaHandlerPackage":
            return Optional.ofNullable(clazz.cast(schemaHandlerPackage()));
        case "LoggingConfig":
            return Optional.ofNullable(clazz.cast(loggingConfig()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTypeRequest, T> g) {
        return obj -> g.apply((RegisterTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterTypeRequest> {
        /**
         * <p>
         * The kind of extension.
         * </p>
         * 
         * @param type
         *        The kind of extension.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of extension.
         * </p>
         * 
         * @param type
         *        The kind of extension.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the extension being registered.
         * </p>
         * <p>
         * We recommend that extension names adhere to the following patterns:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For resource types, <i>company_or_organization</i>::<i>service</i>::<i>type</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For modules, <i>company_or_organization</i>::<i>service</i>::<i>type</i>::MODULE.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The following organization namespaces are reserved and can't be used in your extension names:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Alexa</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AMZN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Amazon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Custom</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Dev</code>
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param typeName
         *        The name of the extension being registered.</p>
         *        <p>
         *        We recommend that extension names adhere to the following patterns:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For resource types, <i>company_or_organization</i>::<i>service</i>::<i>type</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For modules, <i>company_or_organization</i>::<i>service</i>::<i>type</i>::MODULE.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The following organization namespaces are reserved and can't be used in your extension names:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Alexa</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AMZN</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Amazon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Custom</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Dev</code>
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * A URL to the S3 bucket containing the extension project package that contains the necessary files for the
         * extension you want to register.
         * </p>
         * <p>
         * For information on generating a schema handler package for the extension you want to register, see <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html"
         * >submit</a> in the <i>CloudFormation CLI User Guide</i>.
         * </p>
         * <note>
         * <p>
         * The user registering the extension must be able to access the package in the S3 bucket. That's, the user
         * needs to have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
         * permissions for the schema handler package. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition
         * Keys for Amazon S3</a> in the <i>Identity and Access Management User Guide</i>.
         * </p>
         * </note>
         * 
         * @param schemaHandlerPackage
         *        A URL to the S3 bucket containing the extension project package that contains the necessary files for
         *        the extension you want to register.</p>
         *        <p>
         *        For information on generating a schema handler package for the extension you want to register, see <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">
         *        submit</a> in the <i>CloudFormation CLI User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The user registering the extension must be able to access the package in the S3 bucket. That's, the
         *        user needs to have <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> permissions
         *        for the schema handler package. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and
         *        Condition Keys for Amazon S3</a> in the <i>Identity and Access Management User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaHandlerPackage(String schemaHandlerPackage);

        /**
         * <p>
         * Specifies logging configuration information for an extension.
         * </p>
         * 
         * @param loggingConfig
         *        Specifies logging configuration information for an extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfig(LoggingConfig loggingConfig);

        /**
         * <p>
         * Specifies logging configuration information for an extension.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfig.Builder} avoiding the need
         * to create one manually via {@link LoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingConfig(LoggingConfig)}.
         * 
         * @param loggingConfig
         *        a consumer that will call methods on {@link LoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfig(LoggingConfig)
         */
        default Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return loggingConfig(LoggingConfig.builder().applyMutation(loggingConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume when invoking the extension.
         * </p>
         * <p>
         * For CloudFormation to assume the specified execution role, the role must contain a trust relationship with
         * the CloudFormation service principle (<code>resources.cloudformation.amazonaws.com</code>). For more
         * information on adding trust relationships, see <a
         * href="IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy"
         * >Modifying a role trust policy</a> in the <i>Identity and Access Management User Guide</i>.
         * </p>
         * <p>
         * If your extension calls Amazon Web Services APIs in any of its handlers, you must create an <i> <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that
         * includes the necessary permissions to call those Amazon Web Services APIs, and provision that execution role
         * in your account. When CloudFormation needs to invoke the resource type handler, CloudFormation assumes this
         * execution role to create a temporary session token, which it then passes to the resource type handler,
         * thereby supplying your resource type with the appropriate credentials.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume when invoking the
         *        extension.</p>
         *        <p>
         *        For CloudFormation to assume the specified execution role, the role must contain a trust relationship
         *        with the CloudFormation service principle (<code>resources.cloudformation.amazonaws.com</code>). For
         *        more information on adding trust relationships, see <a href=
         *        "IAM/latest/UserGuide/roles-managingrole-editing-console.html#roles-managingrole_edit-trust-policy"
         *        >Modifying a role trust policy</a> in the <i>Identity and Access Management User Guide</i>.
         *        </p>
         *        <p>
         *        If your extension calls Amazon Web Services APIs in any of its handlers, you must create an <i> <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that
         *        includes the necessary permissions to call those Amazon Web Services APIs, and provision that
         *        execution role in your account. When CloudFormation needs to invoke the resource type handler,
         *        CloudFormation assumes this execution role to create a temporary session token, which it then passes
         *        to the resource type handler, thereby supplying your resource type with the appropriate credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * A unique identifier that acts as an idempotency key for this registration request. Specifying a client
         * request token prevents CloudFormation from generating more than one version of an extension from the same
         * registration request, even if the request is submitted multiple times.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier that acts as an idempotency key for this registration request. Specifying a client
         *        request token prevents CloudFormation from generating more than one version of an extension from the
         *        same registration request, even if the request is submitted multiple times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String type;

        private String typeName;

        private String schemaHandlerPackage;

        private LoggingConfig loggingConfig;

        private String executionRoleArn;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTypeRequest model) {
            super(model);
            type(model.type);
            typeName(model.typeName);
            schemaHandlerPackage(model.schemaHandlerPackage);
            loggingConfig(model.loggingConfig);
            executionRoleArn(model.executionRoleArn);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getSchemaHandlerPackage() {
            return schemaHandlerPackage;
        }

        public final void setSchemaHandlerPackage(String schemaHandlerPackage) {
            this.schemaHandlerPackage = schemaHandlerPackage;
        }

        @Override
        public final Builder schemaHandlerPackage(String schemaHandlerPackage) {
            this.schemaHandlerPackage = schemaHandlerPackage;
            return this;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return loggingConfig != null ? loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterTypeRequest build() {
            return new RegisterTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
