/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackInstancesRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListStackInstancesRequest.Builder, ListStackInstancesRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackSetName").getter(getter(ListStackInstancesRequest::stackSetName))
            .setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStackInstancesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListStackInstancesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<StackInstanceFilter>> FILTERS_FIELD = SdkField
            .<List<StackInstanceFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListStackInstancesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackInstanceFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackInstanceFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STACK_INSTANCE_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackInstanceAccount").getter(getter(ListStackInstancesRequest::stackInstanceAccount))
            .setter(setter(Builder::stackInstanceAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceAccount").build())
            .build();

    private static final SdkField<String> STACK_INSTANCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackInstanceRegion").getter(getter(ListStackInstancesRequest::stackInstanceRegion))
            .setter(setter(Builder::stackInstanceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceRegion").build())
            .build();

    private static final SdkField<String> CALL_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CallAs")
            .getter(getter(ListStackInstancesRequest::callAsAsString)).setter(setter(Builder::callAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, STACK_INSTANCE_ACCOUNT_FIELD, STACK_INSTANCE_REGION_FIELD,
            CALL_AS_FIELD));

    private final String stackSetName;

    private final String nextToken;

    private final Integer maxResults;

    private final List<StackInstanceFilter> filters;

    private final String stackInstanceAccount;

    private final String stackInstanceRegion;

    private final String callAs;

    private ListStackInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.stackInstanceAccount = builder.stackInstanceAccount;
        this.stackInstanceRegion = builder.stackInstanceRegion;
        this.callAs = builder.callAs;
    }

    /**
     * <p>
     * The name or unique ID of the stack set that you want to list stack instances for.
     * </p>
     * 
     * @return The name or unique ID of the stack set that you want to list stack instances for.
     */
    public final String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * If the previous request didn't return all of the remaining results, the response's <code>NextToken</code>
     * parameter value is set to a token. To retrieve the next set of results, call <code>ListStackInstances</code>
     * again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining
     * results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.
     * </p>
     * 
     * @return If the previous request didn't return all of the remaining results, the response's <code>NextToken</code>
     *         parameter value is set to a token. To retrieve the next set of results, call
     *         <code>ListStackInstances</code> again and assign that token to the request object's
     *         <code>NextToken</code> parameter. If there are no remaining results, the previous response object's
     *         <code>NextToken</code> parameter is set to <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this
     * maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code>
     * request parameter to get the next set of results.
     * </p>
     * 
     * @return The maximum number of results to be returned with a single call. If the number of available results
     *         exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
     *         <code>NextToken</code> request parameter to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status that stack instances are filtered by.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The status that stack instances are filtered by.
     */
    public final List<StackInstanceFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The name of the account that you want to list stack instances for.
     * </p>
     * 
     * @return The name of the account that you want to list stack instances for.
     */
    public final String stackInstanceAccount() {
        return stackInstanceAccount;
    }

    /**
     * <p>
     * The name of the Region where you want to list stack instances.
     * </p>
     * 
     * @return The name of the Region where you want to list stack instances.
     */
    public final String stackInstanceRegion() {
        return stackInstanceRegion;
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your account must be registered as a delegated administrator in the management account. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">
     * Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your account must be registered as a delegated administrator in the management account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final CallAs callAs() {
        return CallAs.fromValue(callAs);
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your account must be registered as a delegated administrator in the management account. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html">
     * Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your account must be registered as a delegated administrator in the management account. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final String callAsAsString() {
        return callAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stackInstanceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(stackInstanceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(callAsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackInstancesRequest)) {
            return false;
        }
        ListStackInstancesRequest other = (ListStackInstancesRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters())
                && Objects.equals(stackInstanceAccount(), other.stackInstanceAccount())
                && Objects.equals(stackInstanceRegion(), other.stackInstanceRegion())
                && Objects.equals(callAsAsString(), other.callAsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStackInstancesRequest").add("StackSetName", stackSetName()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Filters", hasFilters() ? filters() : null)
                .add("StackInstanceAccount", stackInstanceAccount()).add("StackInstanceRegion", stackInstanceRegion())
                .add("CallAs", callAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "StackInstanceAccount":
            return Optional.ofNullable(clazz.cast(stackInstanceAccount()));
        case "StackInstanceRegion":
            return Optional.ofNullable(clazz.cast(stackInstanceRegion()));
        case "CallAs":
            return Optional.ofNullable(clazz.cast(callAsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStackInstancesRequest, T> g) {
        return obj -> g.apply((ListStackInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStackInstancesRequest> {
        /**
         * <p>
         * The name or unique ID of the stack set that you want to list stack instances for.
         * </p>
         * 
         * @param stackSetName
         *        The name or unique ID of the stack set that you want to list stack instances for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * If the previous request didn't return all of the remaining results, the response's <code>NextToken</code>
         * parameter value is set to a token. To retrieve the next set of results, call <code>ListStackInstances</code>
         * again and assign that token to the request object's <code>NextToken</code> parameter. If there are no
         * remaining results, the previous response object's <code>NextToken</code> parameter is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the previous request didn't return all of the remaining results, the response's
         *        <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        <code>ListStackInstances</code> again and assign that token to the request object's
         *        <code>NextToken</code> parameter. If there are no remaining results, the previous response object's
         *        <code>NextToken</code> parameter is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to be returned with a single call. If the number of available results exceeds
         * this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         * <code>NextToken</code> request parameter to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned with a single call. If the number of available results
         *        exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         *        <code>NextToken</code> request parameter to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The status that stack instances are filtered by.
         * </p>
         * 
         * @param filters
         *        The status that stack instances are filtered by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<StackInstanceFilter> filters);

        /**
         * <p>
         * The status that stack instances are filtered by.
         * </p>
         * 
         * @param filters
         *        The status that stack instances are filtered by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(StackInstanceFilter... filters);

        /**
         * <p>
         * The status that stack instances are filtered by.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StackInstanceFilter>.Builder} avoiding the
         * need to create one manually via {@link List<StackInstanceFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackInstanceFilter>.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<StackInstanceFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<StackInstanceFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<StackInstanceFilter>)
         */
        Builder filters(Consumer<StackInstanceFilter.Builder>... filters);

        /**
         * <p>
         * The name of the account that you want to list stack instances for.
         * </p>
         * 
         * @param stackInstanceAccount
         *        The name of the account that you want to list stack instances for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceAccount(String stackInstanceAccount);

        /**
         * <p>
         * The name of the Region where you want to list stack instances.
         * </p>
         * 
         * @param stackInstanceRegion
         *        The name of the Region where you want to list stack instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceRegion(String stackInstanceRegion);

        /**
         * <p>
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         * organization's management account or as a delegated administrator in a member account.
         * </p>
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * <p>
         * Your account must be registered as a delegated administrator in the management account. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         *        organization's management account or as a delegated administrator in a member account.</p>
         *        <p>
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         *        permissions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        <p>
         *        Your account must be registered as a delegated administrator in the management account. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(String callAs);

        /**
         * <p>
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         * organization's management account or as a delegated administrator in a member account.
         * </p>
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * <p>
         * Your account must be registered as a delegated administrator in the management account. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         *        organization's management account or as a delegated administrator in a member account.</p>
         *        <p>
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         *        permissions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        <p>
         *        Your account must be registered as a delegated administrator in the management account. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(CallAs callAs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackSetName;

        private String nextToken;

        private Integer maxResults;

        private List<StackInstanceFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String stackInstanceAccount;

        private String stackInstanceRegion;

        private String callAs;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackInstancesRequest model) {
            super(model);
            stackSetName(model.stackSetName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
            stackInstanceAccount(model.stackInstanceAccount);
            stackInstanceRegion(model.stackInstanceRegion);
            callAs(model.callAs);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        @Transient
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<StackInstanceFilter.Builder> getFilters() {
            List<StackInstanceFilter.Builder> result = StackInstanceFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<StackInstanceFilter.BuilderImpl> filters) {
            this.filters = StackInstanceFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<StackInstanceFilter> filters) {
            this.filters = StackInstanceFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(StackInstanceFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<StackInstanceFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> StackInstanceFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStackInstanceAccount() {
            return stackInstanceAccount;
        }

        public final void setStackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
        }

        @Override
        @Transient
        public final Builder stackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
            return this;
        }

        public final String getStackInstanceRegion() {
            return stackInstanceRegion;
        }

        public final void setStackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
        }

        @Override
        @Transient
        public final Builder stackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
            return this;
        }

        public final String getCallAs() {
            return callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        @Transient
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        @Transient
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStackInstancesRequest build() {
            return new ListStackInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
