/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information concerning an error generated during the setting of configuration data for a CloudFormation
 * extension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeTypeConfigurationsError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDescribeTypeConfigurationsError.Builder, BatchDescribeTypeConfigurationsError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(BatchDescribeTypeConfigurationsError::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(BatchDescribeTypeConfigurationsError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<TypeConfigurationIdentifier> TYPE_CONFIGURATION_IDENTIFIER_FIELD = SdkField
            .<TypeConfigurationIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("TypeConfigurationIdentifier")
            .getter(getter(BatchDescribeTypeConfigurationsError::typeConfigurationIdentifier))
            .setter(setter(Builder::typeConfigurationIdentifier))
            .constructor(TypeConfigurationIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD, TYPE_CONFIGURATION_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorMessage;

    private final TypeConfigurationIdentifier typeConfigurationIdentifier;

    private BatchDescribeTypeConfigurationsError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.typeConfigurationIdentifier = builder.typeConfigurationIdentifier;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * 
     * @return The error code.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message.
     * </p>
     * 
     * @return The error message.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * Returns the value of the TypeConfigurationIdentifier property for this object.
     * 
     * @return The value of the TypeConfigurationIdentifier property for this object.
     */
    public final TypeConfigurationIdentifier typeConfigurationIdentifier() {
        return typeConfigurationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(typeConfigurationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeTypeConfigurationsError)) {
            return false;
        }
        BatchDescribeTypeConfigurationsError other = (BatchDescribeTypeConfigurationsError) obj;
        return Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(typeConfigurationIdentifier(), other.typeConfigurationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDescribeTypeConfigurationsError").add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).add("TypeConfigurationIdentifier", typeConfigurationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "TypeConfigurationIdentifier":
            return Optional.ofNullable(clazz.cast(typeConfigurationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeTypeConfigurationsError, T> g) {
        return obj -> g.apply((BatchDescribeTypeConfigurationsError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDescribeTypeConfigurationsError> {
        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param errorCode
         *        The error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message.
         * </p>
         * 
         * @param errorMessage
         *        The error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * Sets the value of the TypeConfigurationIdentifier property for this object.
         *
         * @param typeConfigurationIdentifier
         *        The new value for the TypeConfigurationIdentifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeConfigurationIdentifier(TypeConfigurationIdentifier typeConfigurationIdentifier);

        /**
         * Sets the value of the TypeConfigurationIdentifier property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TypeConfigurationIdentifier.Builder}
         * avoiding the need to create one manually via {@link TypeConfigurationIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypeConfigurationIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #typeConfigurationIdentifier(TypeConfigurationIdentifier)}.
         * 
         * @param typeConfigurationIdentifier
         *        a consumer that will call methods on {@link TypeConfigurationIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeConfigurationIdentifier(TypeConfigurationIdentifier)
         */
        default Builder typeConfigurationIdentifier(Consumer<TypeConfigurationIdentifier.Builder> typeConfigurationIdentifier) {
            return typeConfigurationIdentifier(TypeConfigurationIdentifier.builder().applyMutation(typeConfigurationIdentifier)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private TypeConfigurationIdentifier typeConfigurationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeTypeConfigurationsError model) {
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            typeConfigurationIdentifier(model.typeConfigurationIdentifier);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final TypeConfigurationIdentifier.Builder getTypeConfigurationIdentifier() {
            return typeConfigurationIdentifier != null ? typeConfigurationIdentifier.toBuilder() : null;
        }

        public final void setTypeConfigurationIdentifier(TypeConfigurationIdentifier.BuilderImpl typeConfigurationIdentifier) {
            this.typeConfigurationIdentifier = typeConfigurationIdentifier != null ? typeConfigurationIdentifier.build() : null;
        }

        @Override
        public final Builder typeConfigurationIdentifier(TypeConfigurationIdentifier typeConfigurationIdentifier) {
            this.typeConfigurationIdentifier = typeConfigurationIdentifier;
            return this;
        }

        @Override
        public BatchDescribeTypeConfigurationsError build() {
            return new BatchDescribeTypeConfigurationsError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
