/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackSetResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackSetResponse.Builder, DescribeStackSetResponse> {
    private static final SdkField<StackSet> STACK_SET_FIELD = SdkField.<StackSet> builder(MarshallingType.SDK_POJO)
            .memberName("StackSet").getter(getter(DescribeStackSetResponse::stackSet)).setter(setter(Builder::stackSet))
            .constructor(StackSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_FIELD));

    private final StackSet stackSet;

    private DescribeStackSetResponse(BuilderImpl builder) {
        super(builder);
        this.stackSet = builder.stackSet;
    }

    /**
     * <p>
     * The specified stack set.
     * </p>
     * 
     * @return The specified stack set.
     */
    public final StackSet stackSet() {
        return stackSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSetResponse)) {
            return false;
        }
        DescribeStackSetResponse other = (DescribeStackSetResponse) obj;
        return Objects.equals(stackSet(), other.stackSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStackSetResponse").add("StackSet", stackSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSet":
            return Optional.ofNullable(clazz.cast(stackSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackSetResponse, T> g) {
        return obj -> g.apply((DescribeStackSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStackSetResponse> {
        /**
         * <p>
         * The specified stack set.
         * </p>
         * 
         * @param stackSet
         *        The specified stack set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSet(StackSet stackSet);

        /**
         * <p>
         * The specified stack set.
         * </p>
         * This is a convenience method that creates an instance of the {@link StackSet.Builder} avoiding the need to
         * create one manually via {@link StackSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackSet.Builder#build()} is called immediately and its result is
         * passed to {@link #stackSet(StackSet)}.
         * 
         * @param stackSet
         *        a consumer that will call methods on {@link StackSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackSet(StackSet)
         */
        default Builder stackSet(Consumer<StackSet.Builder> stackSet) {
            return stackSet(StackSet.builder().applyMutation(stackSet).build());
        }
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private StackSet stackSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSetResponse model) {
            super(model);
            stackSet(model.stackSet);
        }

        public final StackSet.Builder getStackSet() {
            return stackSet != null ? stackSet.toBuilder() : null;
        }

        public final void setStackSet(StackSet.BuilderImpl stackSet) {
            this.stackSet = stackSet != null ? stackSet.build() : null;
        }

        @Override
        public final Builder stackSet(StackSet stackSet) {
            this.stackSet = stackSet;
            return this;
        }

        @Override
        public DescribeStackSetResponse build() {
            return new DescribeStackSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
