/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the module from which the resource was created, if the resource was created from a module
 * included in the stack template.
 * </p>
 * <p>
 * For more information about modules, see <a href="AWSCloudFormation/latest/UserGuide/modules.html">Using modules to
 * encapsulate and reuse resource configurations</a> in the <i>CloudFormation User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModuleInfo implements SdkPojo, Serializable, ToCopyableBuilder<ModuleInfo.Builder, ModuleInfo> {
    private static final SdkField<String> TYPE_HIERARCHY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeHierarchy").getter(getter(ModuleInfo::typeHierarchy)).setter(setter(Builder::typeHierarchy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeHierarchy").build()).build();

    private static final SdkField<String> LOGICAL_ID_HIERARCHY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalIdHierarchy").getter(getter(ModuleInfo::logicalIdHierarchy))
            .setter(setter(Builder::logicalIdHierarchy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalIdHierarchy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_HIERARCHY_FIELD,
            LOGICAL_ID_HIERARCHY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String typeHierarchy;

    private final String logicalIdHierarchy;

    private ModuleInfo(BuilderImpl builder) {
        this.typeHierarchy = builder.typeHierarchy;
        this.logicalIdHierarchy = builder.logicalIdHierarchy;
    }

    /**
     * <p>
     * A concatenated list of the module type or types containing the resource. Module types are listed starting with
     * the inner-most nested module, and separated by <code>/</code>.
     * </p>
     * <p>
     * In the following example, the resource was created from a module of type <code>AWS::First::Example::MODULE</code>
     * , that's nested inside a parent module of type <code>AWS::Second::Example::MODULE</code>.
     * </p>
     * <p>
     * <code>AWS::First::Example::MODULE/AWS::Second::Example::MODULE</code>
     * </p>
     * 
     * @return A concatenated list of the module type or types containing the resource. Module types are listed starting
     *         with the inner-most nested module, and separated by <code>/</code>.</p>
     *         <p>
     *         In the following example, the resource was created from a module of type
     *         <code>AWS::First::Example::MODULE</code>, that's nested inside a parent module of type
     *         <code>AWS::Second::Example::MODULE</code>.
     *         </p>
     *         <p>
     *         <code>AWS::First::Example::MODULE/AWS::Second::Example::MODULE</code>
     */
    public final String typeHierarchy() {
        return typeHierarchy;
    }

    /**
     * <p>
     * A concatenated list of the logical IDs of the module or modules containing the resource. Modules are listed
     * starting with the inner-most nested module, and separated by <code>/</code>.
     * </p>
     * <p>
     * In the following example, the resource was created from a module, <code>moduleA</code>, that's nested inside a
     * parent module, <code>moduleB</code>.
     * </p>
     * <p>
     * <code>moduleA/moduleB</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources">Referencing resources in a module</a>
     * in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return A concatenated list of the logical IDs of the module or modules containing the resource. Modules are
     *         listed starting with the inner-most nested module, and separated by <code>/</code>.</p>
     *         <p>
     *         In the following example, the resource was created from a module, <code>moduleA</code>, that's nested
     *         inside a parent module, <code>moduleB</code>.
     *         </p>
     *         <p>
     *         <code>moduleA/moduleB</code>
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources">Referencing resources in a
     *         module</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String logicalIdHierarchy() {
        return logicalIdHierarchy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeHierarchy());
        hashCode = 31 * hashCode + Objects.hashCode(logicalIdHierarchy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo other = (ModuleInfo) obj;
        return Objects.equals(typeHierarchy(), other.typeHierarchy())
                && Objects.equals(logicalIdHierarchy(), other.logicalIdHierarchy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModuleInfo").add("TypeHierarchy", typeHierarchy())
                .add("LogicalIdHierarchy", logicalIdHierarchy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeHierarchy":
            return Optional.ofNullable(clazz.cast(typeHierarchy()));
        case "LogicalIdHierarchy":
            return Optional.ofNullable(clazz.cast(logicalIdHierarchy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModuleInfo, T> g) {
        return obj -> g.apply((ModuleInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModuleInfo> {
        /**
         * <p>
         * A concatenated list of the module type or types containing the resource. Module types are listed starting
         * with the inner-most nested module, and separated by <code>/</code>.
         * </p>
         * <p>
         * In the following example, the resource was created from a module of type
         * <code>AWS::First::Example::MODULE</code>, that's nested inside a parent module of type
         * <code>AWS::Second::Example::MODULE</code>.
         * </p>
         * <p>
         * <code>AWS::First::Example::MODULE/AWS::Second::Example::MODULE</code>
         * </p>
         * 
         * @param typeHierarchy
         *        A concatenated list of the module type or types containing the resource. Module types are listed
         *        starting with the inner-most nested module, and separated by <code>/</code>.</p>
         *        <p>
         *        In the following example, the resource was created from a module of type
         *        <code>AWS::First::Example::MODULE</code>, that's nested inside a parent module of type
         *        <code>AWS::Second::Example::MODULE</code>.
         *        </p>
         *        <p>
         *        <code>AWS::First::Example::MODULE/AWS::Second::Example::MODULE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeHierarchy(String typeHierarchy);

        /**
         * <p>
         * A concatenated list of the logical IDs of the module or modules containing the resource. Modules are listed
         * starting with the inner-most nested module, and separated by <code>/</code>.
         * </p>
         * <p>
         * In the following example, the resource was created from a module, <code>moduleA</code>, that's nested inside
         * a parent module, <code>moduleB</code>.
         * </p>
         * <p>
         * <code>moduleA/moduleB</code>
         * </p>
         * <p>
         * For more information, see <a
         * href="AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources">Referencing resources in a
         * module</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param logicalIdHierarchy
         *        A concatenated list of the logical IDs of the module or modules containing the resource. Modules are
         *        listed starting with the inner-most nested module, and separated by <code>/</code>.</p>
         *        <p>
         *        In the following example, the resource was created from a module, <code>moduleA</code>, that's nested
         *        inside a parent module, <code>moduleB</code>.
         *        </p>
         *        <p>
         *        <code>moduleA/moduleB</code>
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="AWSCloudFormation/latest/UserGuide/modules.html#module-ref-resources">Referencing resources in a
         *        module</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalIdHierarchy(String logicalIdHierarchy);
    }

    static final class BuilderImpl implements Builder {
        private String typeHierarchy;

        private String logicalIdHierarchy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModuleInfo model) {
            typeHierarchy(model.typeHierarchy);
            logicalIdHierarchy(model.logicalIdHierarchy);
        }

        public final String getTypeHierarchy() {
            return typeHierarchy;
        }

        public final void setTypeHierarchy(String typeHierarchy) {
            this.typeHierarchy = typeHierarchy;
        }

        @Override
        public final Builder typeHierarchy(String typeHierarchy) {
            this.typeHierarchy = typeHierarchy;
            return this;
        }

        public final String getLogicalIdHierarchy() {
            return logicalIdHierarchy;
        }

        public final void setLogicalIdHierarchy(String logicalIdHierarchy) {
            this.logicalIdHierarchy = logicalIdHierarchy;
        }

        @Override
        public final Builder logicalIdHierarchy(String logicalIdHierarchy) {
            this.logicalIdHierarchy = logicalIdHierarchy;
            return this;
        }

        @Override
        public ModuleInfo build() {
            return new ModuleInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
