/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummary;

public class ListStackResourcesIterable
implements SdkIterable<ListStackResourcesResponse> {
    private final CloudFormationClient client;
    private final ListStackResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStackResourcesIterable(CloudFormationClient client, ListStackResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStackResourcesResponseFetcher();
    }

    public Iterator<ListStackResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StackResourceSummary> stackResourceSummaries() {
        Function<ListStackResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackResourceSummaries() != null) {
                return response.stackResourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStackResourcesResponseFetcher
    implements SyncPageFetcher<ListStackResourcesResponse> {
        private ListStackResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListStackResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStackResourcesResponse nextPage(ListStackResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListStackResourcesIterable.this.client.listStackResources(ListStackResourcesIterable.this.firstRequest);
            }
            return ListStackResourcesIterable.this.client.listStackResources((ListStackResourcesRequest)((Object)ListStackResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

