/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStackSetRequest extends CloudFormationRequest implements
        ToCopyableBuilder<UpdateStackSetRequest.Builder, UpdateStackSetRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackSetName").getter(getter(UpdateStackSetRequest::stackSetName)).setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateStackSetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateBody").getter(getter(UpdateStackSetRequest::templateBody)).setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateURL").getter(getter(UpdateStackSetRequest::templateURL)).setter(setter(Builder::templateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()).build();

    private static final SdkField<Boolean> USE_PREVIOUS_TEMPLATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UsePreviousTemplate").getter(getter(UpdateStackSetRequest::usePreviousTemplate))
            .setter(setter(Builder::usePreviousTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePreviousTemplate").build())
            .build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(UpdateStackSetRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Capabilities")
            .getter(getter(UpdateStackSetRequest::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(UpdateStackSetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StackSetOperationPreferences> OPERATION_PREFERENCES_FIELD = SdkField
            .<StackSetOperationPreferences> builder(MarshallingType.SDK_POJO).memberName("OperationPreferences")
            .getter(getter(UpdateStackSetRequest::operationPreferences)).setter(setter(Builder::operationPreferences))
            .constructor(StackSetOperationPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationPreferences").build())
            .build();

    private static final SdkField<String> ADMINISTRATION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdministrationRoleARN").getter(getter(UpdateStackSetRequest::administrationRoleARN))
            .setter(setter(Builder::administrationRoleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrationRoleARN").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleName").getter(getter(UpdateStackSetRequest::executionRoleName))
            .setter(setter(Builder::executionRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleName").build()).build();

    private static final SdkField<DeploymentTargets> DEPLOYMENT_TARGETS_FIELD = SdkField
            .<DeploymentTargets> builder(MarshallingType.SDK_POJO).memberName("DeploymentTargets")
            .getter(getter(UpdateStackSetRequest::deploymentTargets)).setter(setter(Builder::deploymentTargets))
            .constructor(DeploymentTargets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentTargets").build()).build();

    private static final SdkField<String> PERMISSION_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionModel").getter(getter(UpdateStackSetRequest::permissionModelAsString))
            .setter(setter(Builder::permissionModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionModel").build()).build();

    private static final SdkField<AutoDeployment> AUTO_DEPLOYMENT_FIELD = SdkField
            .<AutoDeployment> builder(MarshallingType.SDK_POJO).memberName("AutoDeployment")
            .getter(getter(UpdateStackSetRequest::autoDeployment)).setter(setter(Builder::autoDeployment))
            .constructor(AutoDeployment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeployment").build()).build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OperationId")
            .getter(getter(UpdateStackSetRequest::operationId))
            .setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Accounts")
            .getter(getter(UpdateStackSetRequest::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(UpdateStackSetRequest::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CALL_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CallAs")
            .getter(getter(UpdateStackSetRequest::callAsAsString)).setter(setter(Builder::callAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()).build();

    private static final SdkField<ManagedExecution> MANAGED_EXECUTION_FIELD = SdkField
            .<ManagedExecution> builder(MarshallingType.SDK_POJO).memberName("ManagedExecution")
            .getter(getter(UpdateStackSetRequest::managedExecution)).setter(setter(Builder::managedExecution))
            .constructor(ManagedExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedExecution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD,
            DESCRIPTION_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD, USE_PREVIOUS_TEMPLATE_FIELD, PARAMETERS_FIELD,
            CAPABILITIES_FIELD, TAGS_FIELD, OPERATION_PREFERENCES_FIELD, ADMINISTRATION_ROLE_ARN_FIELD,
            EXECUTION_ROLE_NAME_FIELD, DEPLOYMENT_TARGETS_FIELD, PERMISSION_MODEL_FIELD, AUTO_DEPLOYMENT_FIELD,
            OPERATION_ID_FIELD, ACCOUNTS_FIELD, REGIONS_FIELD, CALL_AS_FIELD, MANAGED_EXECUTION_FIELD));

    private final String stackSetName;

    private final String description;

    private final String templateBody;

    private final String templateURL;

    private final Boolean usePreviousTemplate;

    private final List<Parameter> parameters;

    private final List<String> capabilities;

    private final List<Tag> tags;

    private final StackSetOperationPreferences operationPreferences;

    private final String administrationRoleARN;

    private final String executionRoleName;

    private final DeploymentTargets deploymentTargets;

    private final String permissionModel;

    private final AutoDeployment autoDeployment;

    private final String operationId;

    private final List<String> accounts;

    private final List<String> regions;

    private final String callAs;

    private final ManagedExecution managedExecution;

    private UpdateStackSetRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.description = builder.description;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.usePreviousTemplate = builder.usePreviousTemplate;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.tags = builder.tags;
        this.operationPreferences = builder.operationPreferences;
        this.administrationRoleARN = builder.administrationRoleARN;
        this.executionRoleName = builder.executionRoleName;
        this.deploymentTargets = builder.deploymentTargets;
        this.permissionModel = builder.permissionModel;
        this.autoDeployment = builder.autoDeployment;
        this.operationId = builder.operationId;
        this.accounts = builder.accounts;
        this.regions = builder.regions;
        this.callAs = builder.callAs;
        this.managedExecution = builder.managedExecution;
    }

    /**
     * <p>
     * The name or unique ID of the stack set that you want to update.
     * </p>
     * 
     * @return The name or unique ID of the stack set that you want to update.
     */
    public final String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * A brief description of updates that you are making.
     * </p>
     * 
     * @return A brief description of updates that you are making.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200
     * bytes. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
     * <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
     * </p>
     * 
     * @return The structure that contains the template body, with a minimum length of 1 byte and a maximum length of
     *         51,200 bytes. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
     *         <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
     */
    public final String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800
     * bytes) that is located in an Amazon S3 bucket or a Systems Manager document. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
     * <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
     * </p>
     * 
     * @return The location of the file that contains the template body. The URL must point to a template (maximum size:
     *         460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
     *         <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
     */
    public final String templateURL() {
        return templateURL;
    }

    /**
     * <p>
     * Use the existing template that's associated with the stack set that you're updating.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
     * <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
     * </p>
     * 
     * @return Use the existing template that's associated with the stack set that you're updating.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
     *         <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
     */
    public final Boolean usePreviousTemplate() {
        return usePreviousTemplate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of input parameters for the stack set template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of input parameters for the stack set template.
     */
    public final List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order
     * for CloudFormation to update the stack set and its associated stack instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for
     * example, by creating new Identity and Access Management (IAM) users. For those stacks sets, you must explicitly
     * acknowledge this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some templates reference macros. If your stack set template references one or more macros, you must update the
     * stack set directly from the processed template, without first reviewing the resulting changes in a change set. To
     * update the stack set directly, you must acknowledge this capability. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation
     * Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * <important>
     * <p>
     * Stack sets with service-managed permissions do not currently support the use of macros in templates. (This
     * includes the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * >AWS::Include</a> and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
     * for a stack set with service-managed permissions, if you reference a macro in your template the stack set
     * operation will fail.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
     *         order for CloudFormation to update the stack set and its associated stack instances.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your Amazon Web Services
     *         account; for example, by creating new Identity and Access Management (IAM) users. For those stacks sets,
     *         you must explicitly acknowledge this by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we recommend that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in CloudFormation Templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some templates reference macros. If your stack set template references one or more macros, you must
     *         update the stack set directly from the processed template, without first reviewing the resulting changes
     *         in a change set. To update the stack set directly, you must acknowledge this capability. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
     *         CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *         </p>
     *         <important>
     *         <p>
     *         Stack sets with service-managed permissions do not currently support the use of macros in templates.
     *         (This includes the <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         >AWS::Include</a> and <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     *         >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this
     *         capability for a stack set with service-managed permissions, if you reference a macro in your template
     *         the stack set operation will fail.
     *         </p>
     *         </important></li>
     */
    public final List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(capabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order
     * for CloudFormation to update the stack set and its associated stack instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your Amazon Web Services account; for
     * example, by creating new Identity and Access Management (IAM) users. For those stacks sets, you must explicitly
     * acknowledge this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some templates reference macros. If your stack set template references one or more macros, you must update the
     * stack set directly from the processed template, without first reviewing the resulting changes in a change set. To
     * update the stack set directly, you must acknowledge this capability. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using CloudFormation
     * Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * <important>
     * <p>
     * Stack sets with service-managed permissions do not currently support the use of macros in templates. (This
     * includes the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * >AWS::Include</a> and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this capability
     * for a stack set with service-managed permissions, if you reference a macro in your template the stack set
     * operation will fail.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
     *         order for CloudFormation to update the stack set and its associated stack instances.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your Amazon Web Services
     *         account; for example, by creating new Identity and Access Management (IAM) users. For those stacks sets,
     *         you must explicitly acknowledge this by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we recommend that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in CloudFormation Templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some templates reference macros. If your stack set template references one or more macros, you must
     *         update the stack set directly from the processed template, without first reviewing the resulting changes
     *         in a change set. To update the stack set directly, you must acknowledge this capability. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
     *         CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *         </p>
     *         <important>
     *         <p>
     *         Stack sets with service-managed permissions do not currently support the use of macros in templates.
     *         (This includes the <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         >AWS::Include</a> and <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     *         >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this
     *         capability for a stack set with service-managed permissions, if you reference a macro in your template
     *         the stack set operation will fail.
     *         </p>
     *         </important></li>
     */
    public final List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     * propagates these tags to supported resources that are created in the stacks. You can specify a maximum number of
     * 50 tags.
     * </p>
     * <p>
     * If you specify tags for this parameter, those tags replace any list of tags that are currently associated with
     * this stack set. This means:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you don't specify this parameter, CloudFormation doesn't modify the stack's tags.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify <i>any</i> tags using this parameter, you must specify <i>all</i> the tags that you want
     * associated with this stack set, even tags you've specified before (for example, when creating the stack set or
     * during a previous update of the stack set.). Any tags that you don't include in the updated list of tags are
     * removed from the stack set, and therefore from the stacks and resources as well.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify an empty value, CloudFormation removes all currently associated tags.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify new tags as part of an <code>UpdateStackSet</code> action, CloudFormation checks to see if you
     * have the required IAM permission to tag resources. If you omit tags that are currently associated with the stack
     * set from the list of tags you specify, CloudFormation assumes that you want to remove those tags from the stack
     * set, and checks to see if you have permission to untag resources. If you don't have the necessary permission(s),
     * the entire <code>UpdateStackSet</code> action fails with an <code>access denied</code> error, and the stack set
     * is not updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
     *         propagates these tags to supported resources that are created in the stacks. You can specify a maximum
     *         number of 50 tags.</p>
     *         <p>
     *         If you specify tags for this parameter, those tags replace any list of tags that are currently associated
     *         with this stack set. This means:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you don't specify this parameter, CloudFormation doesn't modify the stack's tags.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify <i>any</i> tags using this parameter, you must specify <i>all</i> the tags that you want
     *         associated with this stack set, even tags you've specified before (for example, when creating the stack
     *         set or during a previous update of the stack set.). Any tags that you don't include in the updated list
     *         of tags are removed from the stack set, and therefore from the stacks and resources as well.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify an empty value, CloudFormation removes all currently associated tags.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify new tags as part of an <code>UpdateStackSet</code> action, CloudFormation checks to see if
     *         you have the required IAM permission to tag resources. If you omit tags that are currently associated
     *         with the stack set from the list of tags you specify, CloudFormation assumes that you want to remove
     *         those tags from the stack set, and checks to see if you have permission to untag resources. If you don't
     *         have the necessary permission(s), the entire <code>UpdateStackSet</code> action fails with an
     *         <code>access denied</code> error, and the stack set is not updated.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Preferences for how CloudFormation performs this stack set operation.
     * </p>
     * 
     * @return Preferences for how CloudFormation performs this stack set operation.
     */
    public final StackSetOperationPreferences operationPreferences() {
        return operationPreferences;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to use to update this stack set.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can
     * manage specific stack sets within the same administrator account. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting Permissions
     * for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * If you specified a customized administrator role when you created the stack set, you must specify a customized
     * administrator role, even if it is the same customized administrator role used with this stack set previously.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to use to update this stack set.</p>
     *         <p>
     *         Specify an IAM role only if you are using customized administrator roles to control which users or groups
     *         can manage specific stack sets within the same administrator account. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting
     *         Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         <p>
     *         If you specified a customized administrator role when you created the stack set, you must specify a
     *         customized administrator role, even if it is the same customized administrator role used with this stack
     *         set previously.
     */
    public final String administrationRoleARN() {
        return administrationRoleARN;
    }

    /**
     * <p>
     * The name of the IAM execution role to use to update the stack set. If you do not specify an execution role,
     * CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized execution roles to control which stack resources users and
     * groups can include in their stack sets.
     * </p>
     * <p>
     * If you specify a customized execution role, CloudFormation uses that role to update the stack. If you do not
     * specify a customized execution role, CloudFormation performs the update using the role previously associated with
     * the stack set, so long as you have permissions to perform operations on the stack set.
     * </p>
     * 
     * @return The name of the IAM execution role to use to update the stack set. If you do not specify an execution
     *         role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set
     *         operation.</p>
     *         <p>
     *         Specify an IAM role only if you are using customized execution roles to control which stack resources
     *         users and groups can include in their stack sets.
     *         </p>
     *         <p>
     *         If you specify a customized execution role, CloudFormation uses that role to update the stack. If you do
     *         not specify a customized execution role, CloudFormation performs the update using the role previously
     *         associated with the stack set, so long as you have permissions to perform operations on the stack set.
     */
    public final String executionRoleName() {
        return executionRoleName;
    }

    /**
     * <p>
     * [Service-managed permissions] The Organizations accounts in which to update associated stack instances.
     * </p>
     * <p>
     * To update all the stack instances associated with this stack set, do not specify <code>DeploymentTargets</code>
     * or <code>Regions</code>.
     * </p>
     * <p>
     * If the stack set update includes changes to the template (that is, if <code>TemplateBody</code> or
     * <code>TemplateURL</code> is specified), or the <code>Parameters</code>, CloudFormation marks all stack instances
     * with a status of <code>OUTDATED</code> prior to updating the stack instances in the specified accounts and Amazon
     * Web Services Regions. If the stack set update doesn't include changes to the template or parameters,
     * CloudFormation updates the stack instances in the specified accounts and Regions, while leaving all other stack
     * instances with their existing stack instance status.
     * </p>
     * 
     * @return [Service-managed permissions] The Organizations accounts in which to update associated stack
     *         instances.</p>
     *         <p>
     *         To update all the stack instances associated with this stack set, do not specify
     *         <code>DeploymentTargets</code> or <code>Regions</code>.
     *         </p>
     *         <p>
     *         If the stack set update includes changes to the template (that is, if <code>TemplateBody</code> or
     *         <code>TemplateURL</code> is specified), or the <code>Parameters</code>, CloudFormation marks all stack
     *         instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the specified
     *         accounts and Amazon Web Services Regions. If the stack set update doesn't include changes to the template
     *         or parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while
     *         leaving all other stack instances with their existing stack instance status.
     */
    public final DeploymentTargets deploymentTargets() {
        return deploymentTargets;
    }

    /**
     * <p>
     * Describes how the IAM roles required for stack set operations are created. You cannot modify
     * <code>PermissionModel</code> if there are stack instances associated with your stack set.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
     * deploy to target accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy
     * to accounts managed by Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     * >Grant Service-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionModel}
     * will return {@link PermissionModels#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionModelAsString}.
     * </p>
     * 
     * @return Describes how the IAM roles required for stack set operations are created. You cannot modify
     *         <code>PermissionModel</code> if there are stack instances associated with your stack set.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         With <code>self-managed</code> permissions, you must create the administrator and execution roles
     *         required to deploy to target accounts. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
     *         >Grant Self-Managed Stack Set Permissions</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
     *         deploy to accounts managed by Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     *         >Grant Service-Managed Stack Set Permissions</a>.
     *         </p>
     *         </li>
     * @see PermissionModels
     */
    public final PermissionModels permissionModel() {
        return PermissionModels.fromValue(permissionModel);
    }

    /**
     * <p>
     * Describes how the IAM roles required for stack set operations are created. You cannot modify
     * <code>PermissionModel</code> if there are stack instances associated with your stack set.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
     * deploy to target accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy
     * to accounts managed by Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     * >Grant Service-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionModel}
     * will return {@link PermissionModels#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionModelAsString}.
     * </p>
     * 
     * @return Describes how the IAM roles required for stack set operations are created. You cannot modify
     *         <code>PermissionModel</code> if there are stack instances associated with your stack set.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         With <code>self-managed</code> permissions, you must create the administrator and execution roles
     *         required to deploy to target accounts. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
     *         >Grant Self-Managed Stack Set Permissions</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
     *         deploy to accounts managed by Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     *         >Grant Service-Managed Stack Set Permissions</a>.
     *         </p>
     *         </li>
     * @see PermissionModels
     */
    public final String permissionModelAsString() {
        return permissionModel;
    }

    /**
     * <p>
     * [Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts that
     * are added to a target organization or organizational unit (OU).
     * </p>
     * <p>
     * If you specify <code>AutoDeployment</code>, don't specify <code>DeploymentTargets</code> or <code>Regions</code>.
     * </p>
     * 
     * @return [Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts
     *         that are added to a target organization or organizational unit (OU).</p>
     *         <p>
     *         If you specify <code>AutoDeployment</code>, don't specify <code>DeploymentTargets</code> or
     *         <code>Regions</code>.
     */
    public final AutoDeployment autoDeployment() {
        return autoDeployment;
    }

    /**
     * <p>
     * The unique ID for this stack set operation.
     * </p>
     * <p>
     * The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the stack set
     * operation only once, even if you retry the request multiple times. You might retry stack set operation requests
     * to ensure that CloudFormation successfully received them.
     * </p>
     * <p>
     * If you don't specify an operation ID, CloudFormation generates one automatically.
     * </p>
     * <p>
     * Repeating this stack set operation with a new operation ID retries all stack instances whose status is
     * <code>OUTDATED</code>.
     * </p>
     * 
     * @return The unique ID for this stack set operation.</p>
     *         <p>
     *         The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the stack
     *         set operation only once, even if you retry the request multiple times. You might retry stack set
     *         operation requests to ensure that CloudFormation successfully received them.
     *         </p>
     *         <p>
     *         If you don't specify an operation ID, CloudFormation generates one automatically.
     *         </p>
     *         <p>
     *         Repeating this stack set operation with a new operation ID retries all stack instances whose status is
     *         <code>OUTDATED</code>.
     */
    public final String operationId() {
        return operationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [Self-managed permissions] The accounts in which to update associated stack instances. If you specify accounts,
     * you must also specify the Amazon Web Services Regions in which to update stack set instances.
     * </p>
     * <p>
     * To update <i>all</i> the stack instances associated with this stack set, don't specify the <code>Accounts</code>
     * or <code>Regions</code> properties.
     * </p>
     * <p>
     * If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
     * <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property, CloudFormation marks
     * all stack instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the specified
     * accounts and Amazon Web Services Regions. If the stack set update does not include changes to the template or
     * parameters, CloudFormation updates the stack instances in the specified accounts and Amazon Web Services Regions,
     * while leaving all other stack instances with their existing stack instance status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return [Self-managed permissions] The accounts in which to update associated stack instances. If you specify
     *         accounts, you must also specify the Amazon Web Services Regions in which to update stack set
     *         instances.</p>
     *         <p>
     *         To update <i>all</i> the stack instances associated with this stack set, don't specify the
     *         <code>Accounts</code> or <code>Regions</code> properties.
     *         </p>
     *         <p>
     *         If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
     *         <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property,
     *         CloudFormation marks all stack instances with a status of <code>OUTDATED</code> prior to updating the
     *         stack instances in the specified accounts and Amazon Web Services Regions. If the stack set update does
     *         not include changes to the template or parameters, CloudFormation updates the stack instances in the
     *         specified accounts and Amazon Web Services Regions, while leaving all other stack instances with their
     *         existing stack instance status.
     */
    public final List<String> accounts() {
        return accounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Regions in which to update associated stack instances. If you specify Regions, you must
     * also specify accounts in which to update stack set instances.
     * </p>
     * <p>
     * To update <i>all</i> the stack instances associated with this stack set, do not specify the <code>Accounts</code>
     * or <code>Regions</code> properties.
     * </p>
     * <p>
     * If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
     * <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property, CloudFormation marks
     * all stack instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the specified
     * accounts and Regions. If the stack set update does not include changes to the template or parameters,
     * CloudFormation updates the stack instances in the specified accounts and Regions, while leaving all other stack
     * instances with their existing stack instance status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return The Amazon Web Services Regions in which to update associated stack instances. If you specify Regions,
     *         you must also specify accounts in which to update stack set instances.</p>
     *         <p>
     *         To update <i>all</i> the stack instances associated with this stack set, do not specify the
     *         <code>Accounts</code> or <code>Regions</code> properties.
     *         </p>
     *         <p>
     *         If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
     *         <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property,
     *         CloudFormation marks all stack instances with a status of <code>OUTDATED</code> prior to updating the
     *         stack instances in the specified accounts and Regions. If the stack set update does not include changes
     *         to the template or parameters, CloudFormation updates the stack instances in the specified accounts and
     *         Regions, while leaving all other stack instances with their existing stack instance status.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated administrator in the management account. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your Amazon Web Services account must be registered as a delegated administrator in the management
     *         account. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final CallAs callAs() {
        return CallAs.fromValue(callAs);
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated administrator in the management account. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your Amazon Web Services account must be registered as a delegated administrator in the management
     *         account. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final String callAsAsString() {
        return callAs;
    }

    /**
     * <p>
     * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
     * </p>
     * 
     * @return Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting
     *         operations.
     */
    public final ManagedExecution managedExecution() {
        return managedExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(usePreviousTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(administrationRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTargets());
        hashCode = 31 * hashCode + Objects.hashCode(permissionModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(callAsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(managedExecution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackSetRequest)) {
            return false;
        }
        UpdateStackSetRequest other = (UpdateStackSetRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName()) && Objects.equals(description(), other.description())
                && Objects.equals(templateBody(), other.templateBody()) && Objects.equals(templateURL(), other.templateURL())
                && Objects.equals(usePreviousTemplate(), other.usePreviousTemplate()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(operationPreferences(), other.operationPreferences())
                && Objects.equals(administrationRoleARN(), other.administrationRoleARN())
                && Objects.equals(executionRoleName(), other.executionRoleName())
                && Objects.equals(deploymentTargets(), other.deploymentTargets())
                && Objects.equals(permissionModelAsString(), other.permissionModelAsString())
                && Objects.equals(autoDeployment(), other.autoDeployment()) && Objects.equals(operationId(), other.operationId())
                && hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(callAsAsString(), other.callAsAsString())
                && Objects.equals(managedExecution(), other.managedExecution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStackSetRequest").add("StackSetName", stackSetName()).add("Description", description())
                .add("TemplateBody", templateBody()).add("TemplateURL", templateURL())
                .add("UsePreviousTemplate", usePreviousTemplate()).add("Parameters", hasParameters() ? parameters() : null)
                .add("Capabilities", hasCapabilities() ? capabilitiesAsStrings() : null).add("Tags", hasTags() ? tags() : null)
                .add("OperationPreferences", operationPreferences()).add("AdministrationRoleARN", administrationRoleARN())
                .add("ExecutionRoleName", executionRoleName()).add("DeploymentTargets", deploymentTargets())
                .add("PermissionModel", permissionModelAsString()).add("AutoDeployment", autoDeployment())
                .add("OperationId", operationId()).add("Accounts", hasAccounts() ? accounts() : null)
                .add("Regions", hasRegions() ? regions() : null).add("CallAs", callAsAsString())
                .add("ManagedExecution", managedExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateURL":
            return Optional.ofNullable(clazz.cast(templateURL()));
        case "UsePreviousTemplate":
            return Optional.ofNullable(clazz.cast(usePreviousTemplate()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "OperationPreferences":
            return Optional.ofNullable(clazz.cast(operationPreferences()));
        case "AdministrationRoleARN":
            return Optional.ofNullable(clazz.cast(administrationRoleARN()));
        case "ExecutionRoleName":
            return Optional.ofNullable(clazz.cast(executionRoleName()));
        case "DeploymentTargets":
            return Optional.ofNullable(clazz.cast(deploymentTargets()));
        case "PermissionModel":
            return Optional.ofNullable(clazz.cast(permissionModelAsString()));
        case "AutoDeployment":
            return Optional.ofNullable(clazz.cast(autoDeployment()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "CallAs":
            return Optional.ofNullable(clazz.cast(callAsAsString()));
        case "ManagedExecution":
            return Optional.ofNullable(clazz.cast(managedExecution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStackSetRequest, T> g) {
        return obj -> g.apply((UpdateStackSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStackSetRequest> {
        /**
         * <p>
         * The name or unique ID of the stack set that you want to update.
         * </p>
         * 
         * @param stackSetName
         *        The name or unique ID of the stack set that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * A brief description of updates that you are making.
         * </p>
         * 
         * @param description
         *        A brief description of updates that you are making.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200
         * bytes. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
         * <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
         * </p>
         * 
         * @param templateBody
         *        The structure that contains the template body, with a minimum length of 1 byte and a maximum length of
         *        51,200 bytes. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
         *        <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The location of the file that contains the template body. The URL must point to a template (maximum size:
         * 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document. For more information,
         * see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
         * <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
         * </p>
         * 
         * @param templateURL
         *        The location of the file that contains the template body. The URL must point to a template (maximum
         *        size: 460,800 bytes) that is located in an Amazon S3 bucket or a Systems Manager document. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
         *        <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * Use the existing template that's associated with the stack set that you're updating.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
         * <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
         * </p>
         * 
         * @param usePreviousTemplate
         *        Use the existing template that's associated with the stack set that you're updating.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or
         *        <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usePreviousTemplate(Boolean usePreviousTemplate);

        /**
         * <p>
         * A list of input parameters for the stack set template.
         * </p>
         * 
         * @param parameters
         *        A list of input parameters for the stack set template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * A list of input parameters for the stack set template.
         * </p>
         * 
         * @param parameters
         *        A list of input parameters for the stack set template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * A list of input parameters for the stack set template.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Parameter>.Builder} avoiding the
         * need to create one manually via {@link List<Parameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Parameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<Parameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
         * order for CloudFormation to update the stack set and its associated stack instances.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your Amazon Web Services account;
         * for example, by creating new Identity and Access Management (IAM) users. For those stacks sets, you must
         * explicitly acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some templates reference macros. If your stack set template references one or more macros, you must update
         * the stack set directly from the processed template, without first reviewing the resulting changes in a change
         * set. To update the stack set directly, you must acknowledge this capability. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * <important>
         * <p>
         * Stack sets with service-managed permissions do not currently support the use of macros in templates. (This
         * includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this
         * capability for a stack set with service-managed permissions, if you reference a macro in your template the
         * stack set operation will fail.
         * </p>
         * </important></li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack template contains certain capabilities
         *        in order for CloudFormation to update the stack set and its associated stack instances.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
         *        account; for example, by creating new Identity and Access Management (IAM) users. For those stacks
         *        sets, you must explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some templates reference macros. If your stack set template references one or more macros, you must
         *        update the stack set directly from the processed template, without first reviewing the resulting
         *        changes in a change set. To update the stack set directly, you must acknowledge this capability. For
         *        more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        <important>
         *        <p>
         *        Stack sets with service-managed permissions do not currently support the use of macros in templates.
         *        (This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this
         *        capability for a stack set with service-managed permissions, if you reference a macro in your template
         *        the stack set operation will fail.
         *        </p>
         *        </important></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
         * order for CloudFormation to update the stack set and its associated stack instances.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your Amazon Web Services account;
         * for example, by creating new Identity and Access Management (IAM) users. For those stacks sets, you must
         * explicitly acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some templates reference macros. If your stack set template references one or more macros, you must update
         * the stack set directly from the processed template, without first reviewing the resulting changes in a change
         * set. To update the stack set directly, you must acknowledge this capability. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * <important>
         * <p>
         * Stack sets with service-managed permissions do not currently support the use of macros in templates. (This
         * includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this
         * capability for a stack set with service-managed permissions, if you reference a macro in your template the
         * stack set operation will fail.
         * </p>
         * </important></li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack template contains certain capabilities
         *        in order for CloudFormation to update the stack set and its associated stack instances.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
         *        account; for example, by creating new Identity and Access Management (IAM) users. For those stacks
         *        sets, you must explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some templates reference macros. If your stack set template references one or more macros, you must
         *        update the stack set directly from the processed template, without first reviewing the resulting
         *        changes in a change set. To update the stack set directly, you must acknowledge this capability. For
         *        more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        <important>
         *        <p>
         *        Stack sets with service-managed permissions do not currently support the use of macros in templates.
         *        (This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this
         *        capability for a stack set with service-managed permissions, if you reference a macro in your template
         *        the stack set operation will fail.
         *        </p>
         *        </important></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
         * order for CloudFormation to update the stack set and its associated stack instances.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your Amazon Web Services account;
         * for example, by creating new Identity and Access Management (IAM) users. For those stacks sets, you must
         * explicitly acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some templates reference macros. If your stack set template references one or more macros, you must update
         * the stack set directly from the processed template, without first reviewing the resulting changes in a change
         * set. To update the stack set directly, you must acknowledge this capability. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * <important>
         * <p>
         * Stack sets with service-managed permissions do not currently support the use of macros in templates. (This
         * includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this
         * capability for a stack set with service-managed permissions, if you reference a macro in your template the
         * stack set operation will fail.
         * </p>
         * </important></li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack template contains certain capabilities
         *        in order for CloudFormation to update the stack set and its associated stack instances.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
         *        account; for example, by creating new Identity and Access Management (IAM) users. For those stacks
         *        sets, you must explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some templates reference macros. If your stack set template references one or more macros, you must
         *        update the stack set directly from the processed template, without first reviewing the resulting
         *        changes in a change set. To update the stack set directly, you must acknowledge this capability. For
         *        more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        <important>
         *        <p>
         *        Stack sets with service-managed permissions do not currently support the use of macros in templates.
         *        (This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this
         *        capability for a stack set with service-managed permissions, if you reference a macro in your template
         *        the stack set operation will fail.
         *        </p>
         *        </important></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<Capability> capabilities);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in
         * order for CloudFormation to update the stack set and its associated stack instances.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your Amazon Web Services account;
         * for example, by creating new Identity and Access Management (IAM) users. For those stacks sets, you must
         * explicitly acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some templates reference macros. If your stack set template references one or more macros, you must update
         * the stack set directly from the processed template, without first reviewing the resulting changes in a change
         * set. To update the stack set directly, you must acknowledge this capability. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * <important>
         * <p>
         * Stack sets with service-managed permissions do not currently support the use of macros in templates. (This
         * includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this
         * capability for a stack set with service-managed permissions, if you reference a macro in your template the
         * stack set operation will fail.
         * </p>
         * </important></li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack template contains certain capabilities
         *        in order for CloudFormation to update the stack set and its associated stack instances.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your Amazon Web Services
         *        account; for example, by creating new Identity and Access Management (IAM) users. For those stacks
         *        sets, you must explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some templates reference macros. If your stack set template references one or more macros, you must
         *        update the stack set directly from the processed template, without first reviewing the resulting
         *        changes in a change set. To update the stack set directly, you must acknowledge this capability. For
         *        more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        <important>
         *        <p>
         *        Stack sets with service-managed permissions do not currently support the use of macros in templates.
         *        (This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by CloudFormation.) Even if you specify this
         *        capability for a stack set with service-managed permissions, if you reference a macro in your template
         *        the stack set operation will fail.
         *        </p>
         *        </important></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
         * propagates these tags to supported resources that are created in the stacks. You can specify a maximum number
         * of 50 tags.
         * </p>
         * <p>
         * If you specify tags for this parameter, those tags replace any list of tags that are currently associated
         * with this stack set. This means:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you don't specify this parameter, CloudFormation doesn't modify the stack's tags.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <i>any</i> tags using this parameter, you must specify <i>all</i> the tags that you want
         * associated with this stack set, even tags you've specified before (for example, when creating the stack set
         * or during a previous update of the stack set.). Any tags that you don't include in the updated list of tags
         * are removed from the stack set, and therefore from the stacks and resources as well.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify an empty value, CloudFormation removes all currently associated tags.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify new tags as part of an <code>UpdateStackSet</code> action, CloudFormation checks to see if you
         * have the required IAM permission to tag resources. If you omit tags that are currently associated with the
         * stack set from the list of tags you specify, CloudFormation assumes that you want to remove those tags from
         * the stack set, and checks to see if you have permission to untag resources. If you don't have the necessary
         * permission(s), the entire <code>UpdateStackSet</code> action fails with an <code>access denied</code> error,
         * and the stack set is not updated.
         * </p>
         * 
         * @param tags
         *        The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation
         *        also propagates these tags to supported resources that are created in the stacks. You can specify a
         *        maximum number of 50 tags.</p>
         *        <p>
         *        If you specify tags for this parameter, those tags replace any list of tags that are currently
         *        associated with this stack set. This means:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you don't specify this parameter, CloudFormation doesn't modify the stack's tags.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <i>any</i> tags using this parameter, you must specify <i>all</i> the tags that you
         *        want associated with this stack set, even tags you've specified before (for example, when creating the
         *        stack set or during a previous update of the stack set.). Any tags that you don't include in the
         *        updated list of tags are removed from the stack set, and therefore from the stacks and resources as
         *        well.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify an empty value, CloudFormation removes all currently associated tags.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify new tags as part of an <code>UpdateStackSet</code> action, CloudFormation checks to see
         *        if you have the required IAM permission to tag resources. If you omit tags that are currently
         *        associated with the stack set from the list of tags you specify, CloudFormation assumes that you want
         *        to remove those tags from the stack set, and checks to see if you have permission to untag resources.
         *        If you don't have the necessary permission(s), the entire <code>UpdateStackSet</code> action fails
         *        with an <code>access denied</code> error, and the stack set is not updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
         * propagates these tags to supported resources that are created in the stacks. You can specify a maximum number
         * of 50 tags.
         * </p>
         * <p>
         * If you specify tags for this parameter, those tags replace any list of tags that are currently associated
         * with this stack set. This means:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you don't specify this parameter, CloudFormation doesn't modify the stack's tags.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <i>any</i> tags using this parameter, you must specify <i>all</i> the tags that you want
         * associated with this stack set, even tags you've specified before (for example, when creating the stack set
         * or during a previous update of the stack set.). Any tags that you don't include in the updated list of tags
         * are removed from the stack set, and therefore from the stacks and resources as well.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify an empty value, CloudFormation removes all currently associated tags.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify new tags as part of an <code>UpdateStackSet</code> action, CloudFormation checks to see if you
         * have the required IAM permission to tag resources. If you omit tags that are currently associated with the
         * stack set from the list of tags you specify, CloudFormation assumes that you want to remove those tags from
         * the stack set, and checks to see if you have permission to untag resources. If you don't have the necessary
         * permission(s), the entire <code>UpdateStackSet</code> action fails with an <code>access denied</code> error,
         * and the stack set is not updated.
         * </p>
         * 
         * @param tags
         *        The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation
         *        also propagates these tags to supported resources that are created in the stacks. You can specify a
         *        maximum number of 50 tags.</p>
         *        <p>
         *        If you specify tags for this parameter, those tags replace any list of tags that are currently
         *        associated with this stack set. This means:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you don't specify this parameter, CloudFormation doesn't modify the stack's tags.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <i>any</i> tags using this parameter, you must specify <i>all</i> the tags that you
         *        want associated with this stack set, even tags you've specified before (for example, when creating the
         *        stack set or during a previous update of the stack set.). Any tags that you don't include in the
         *        updated list of tags are removed from the stack set, and therefore from the stacks and resources as
         *        well.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify an empty value, CloudFormation removes all currently associated tags.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify new tags as part of an <code>UpdateStackSet</code> action, CloudFormation checks to see
         *        if you have the required IAM permission to tag resources. If you omit tags that are currently
         *        associated with the stack set from the list of tags you specify, CloudFormation assumes that you want
         *        to remove those tags from the stack set, and checks to see if you have permission to untag resources.
         *        If you don't have the necessary permission(s), the entire <code>UpdateStackSet</code> action fails
         *        with an <code>access denied</code> error, and the stack set is not updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key-value pairs to associate with this stack set and the stacks created from it. CloudFormation also
         * propagates these tags to supported resources that are created in the stacks. You can specify a maximum number
         * of 50 tags.
         * </p>
         * <p>
         * If you specify tags for this parameter, those tags replace any list of tags that are currently associated
         * with this stack set. This means:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you don't specify this parameter, CloudFormation doesn't modify the stack's tags.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <i>any</i> tags using this parameter, you must specify <i>all</i> the tags that you want
         * associated with this stack set, even tags you've specified before (for example, when creating the stack set
         * or during a previous update of the stack set.). Any tags that you don't include in the updated list of tags
         * are removed from the stack set, and therefore from the stacks and resources as well.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify an empty value, CloudFormation removes all currently associated tags.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify new tags as part of an <code>UpdateStackSet</code> action, CloudFormation checks to see if you
         * have the required IAM permission to tag resources. If you omit tags that are currently associated with the
         * stack set from the list of tags you specify, CloudFormation assumes that you want to remove those tags from
         * the stack set, and checks to see if you have permission to untag resources. If you don't have the necessary
         * permission(s), the entire <code>UpdateStackSet</code> action fails with an <code>access denied</code> error,
         * and the stack set is not updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Preferences for how CloudFormation performs this stack set operation.
         * </p>
         * 
         * @param operationPreferences
         *        Preferences for how CloudFormation performs this stack set operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationPreferences(StackSetOperationPreferences operationPreferences);

        /**
         * <p>
         * Preferences for how CloudFormation performs this stack set operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link StackSetOperationPreferences.Builder}
         * avoiding the need to create one manually via {@link StackSetOperationPreferences#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackSetOperationPreferences.Builder#build()} is called
         * immediately and its result is passed to {@link #operationPreferences(StackSetOperationPreferences)}.
         * 
         * @param operationPreferences
         *        a consumer that will call methods on {@link StackSetOperationPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationPreferences(StackSetOperationPreferences)
         */
        default Builder operationPreferences(Consumer<StackSetOperationPreferences.Builder> operationPreferences) {
            return operationPreferences(StackSetOperationPreferences.builder().applyMutation(operationPreferences).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to use to update this stack set.
         * </p>
         * <p>
         * Specify an IAM role only if you are using customized administrator roles to control which users or groups can
         * manage specific stack sets within the same administrator account. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting
         * Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * <p>
         * If you specified a customized administrator role when you created the stack set, you must specify a
         * customized administrator role, even if it is the same customized administrator role used with this stack set
         * previously.
         * </p>
         * 
         * @param administrationRoleARN
         *        The Amazon Resource Name (ARN) of the IAM role to use to update this stack set.</p>
         *        <p>
         *        Specify an IAM role only if you are using customized administrator roles to control which users or
         *        groups can manage specific stack sets within the same administrator account. For more information, see
         *        <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting
         *        Permissions for Stack Set Operations</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        <p>
         *        If you specified a customized administrator role when you created the stack set, you must specify a
         *        customized administrator role, even if it is the same customized administrator role used with this
         *        stack set previously.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrationRoleARN(String administrationRoleARN);

        /**
         * <p>
         * The name of the IAM execution role to use to update the stack set. If you do not specify an execution role,
         * CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
         * </p>
         * <p>
         * Specify an IAM role only if you are using customized execution roles to control which stack resources users
         * and groups can include in their stack sets.
         * </p>
         * <p>
         * If you specify a customized execution role, CloudFormation uses that role to update the stack. If you do not
         * specify a customized execution role, CloudFormation performs the update using the role previously associated
         * with the stack set, so long as you have permissions to perform operations on the stack set.
         * </p>
         * 
         * @param executionRoleName
         *        The name of the IAM execution role to use to update the stack set. If you do not specify an execution
         *        role, CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack
         *        set operation.</p>
         *        <p>
         *        Specify an IAM role only if you are using customized execution roles to control which stack resources
         *        users and groups can include in their stack sets.
         *        </p>
         *        <p>
         *        If you specify a customized execution role, CloudFormation uses that role to update the stack. If you
         *        do not specify a customized execution role, CloudFormation performs the update using the role
         *        previously associated with the stack set, so long as you have permissions to perform operations on the
         *        stack set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleName(String executionRoleName);

        /**
         * <p>
         * [Service-managed permissions] The Organizations accounts in which to update associated stack instances.
         * </p>
         * <p>
         * To update all the stack instances associated with this stack set, do not specify
         * <code>DeploymentTargets</code> or <code>Regions</code>.
         * </p>
         * <p>
         * If the stack set update includes changes to the template (that is, if <code>TemplateBody</code> or
         * <code>TemplateURL</code> is specified), or the <code>Parameters</code>, CloudFormation marks all stack
         * instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the specified
         * accounts and Amazon Web Services Regions. If the stack set update doesn't include changes to the template or
         * parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while leaving
         * all other stack instances with their existing stack instance status.
         * </p>
         * 
         * @param deploymentTargets
         *        [Service-managed permissions] The Organizations accounts in which to update associated stack
         *        instances.</p>
         *        <p>
         *        To update all the stack instances associated with this stack set, do not specify
         *        <code>DeploymentTargets</code> or <code>Regions</code>.
         *        </p>
         *        <p>
         *        If the stack set update includes changes to the template (that is, if <code>TemplateBody</code> or
         *        <code>TemplateURL</code> is specified), or the <code>Parameters</code>, CloudFormation marks all stack
         *        instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the
         *        specified accounts and Amazon Web Services Regions. If the stack set update doesn't include changes to
         *        the template or parameters, CloudFormation updates the stack instances in the specified accounts and
         *        Regions, while leaving all other stack instances with their existing stack instance status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentTargets(DeploymentTargets deploymentTargets);

        /**
         * <p>
         * [Service-managed permissions] The Organizations accounts in which to update associated stack instances.
         * </p>
         * <p>
         * To update all the stack instances associated with this stack set, do not specify
         * <code>DeploymentTargets</code> or <code>Regions</code>.
         * </p>
         * <p>
         * If the stack set update includes changes to the template (that is, if <code>TemplateBody</code> or
         * <code>TemplateURL</code> is specified), or the <code>Parameters</code>, CloudFormation marks all stack
         * instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the specified
         * accounts and Amazon Web Services Regions. If the stack set update doesn't include changes to the template or
         * parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while leaving
         * all other stack instances with their existing stack instance status.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentTargets.Builder} avoiding the
         * need to create one manually via {@link DeploymentTargets#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentTargets.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentTargets(DeploymentTargets)}.
         * 
         * @param deploymentTargets
         *        a consumer that will call methods on {@link DeploymentTargets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentTargets(DeploymentTargets)
         */
        default Builder deploymentTargets(Consumer<DeploymentTargets.Builder> deploymentTargets) {
            return deploymentTargets(DeploymentTargets.builder().applyMutation(deploymentTargets).build());
        }

        /**
         * <p>
         * Describes how the IAM roles required for stack set operations are created. You cannot modify
         * <code>PermissionModel</code> if there are stack instances associated with your stack set.
         * </p>
         * <ul>
         * <li>
         * <p>
         * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
         * deploy to target accounts. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
         * >Grant Self-Managed Stack Set Permissions</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
         * deploy to accounts managed by Organizations. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant
         * Service-Managed Stack Set Permissions</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissionModel
         *        Describes how the IAM roles required for stack set operations are created. You cannot modify
         *        <code>PermissionModel</code> if there are stack instances associated with your stack set.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        With <code>self-managed</code> permissions, you must create the administrator and execution roles
         *        required to deploy to target accounts. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
         *        >Grant Self-Managed Stack Set Permissions</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required
         *        to deploy to accounts managed by Organizations. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
         *        >Grant Service-Managed Stack Set Permissions</a>.
         *        </p>
         *        </li>
         * @see PermissionModels
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionModels
         */
        Builder permissionModel(String permissionModel);

        /**
         * <p>
         * Describes how the IAM roles required for stack set operations are created. You cannot modify
         * <code>PermissionModel</code> if there are stack instances associated with your stack set.
         * </p>
         * <ul>
         * <li>
         * <p>
         * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
         * deploy to target accounts. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
         * >Grant Self-Managed Stack Set Permissions</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
         * deploy to accounts managed by Organizations. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant
         * Service-Managed Stack Set Permissions</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissionModel
         *        Describes how the IAM roles required for stack set operations are created. You cannot modify
         *        <code>PermissionModel</code> if there are stack instances associated with your stack set.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        With <code>self-managed</code> permissions, you must create the administrator and execution roles
         *        required to deploy to target accounts. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
         *        >Grant Self-Managed Stack Set Permissions</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required
         *        to deploy to accounts managed by Organizations. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
         *        >Grant Service-Managed Stack Set Permissions</a>.
         *        </p>
         *        </li>
         * @see PermissionModels
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionModels
         */
        Builder permissionModel(PermissionModels permissionModel);

        /**
         * <p>
         * [Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts
         * that are added to a target organization or organizational unit (OU).
         * </p>
         * <p>
         * If you specify <code>AutoDeployment</code>, don't specify <code>DeploymentTargets</code> or
         * <code>Regions</code>.
         * </p>
         * 
         * @param autoDeployment
         *        [Service-managed permissions] Describes whether StackSets automatically deploys to Organizations
         *        accounts that are added to a target organization or organizational unit (OU).</p>
         *        <p>
         *        If you specify <code>AutoDeployment</code>, don't specify <code>DeploymentTargets</code> or
         *        <code>Regions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoDeployment(AutoDeployment autoDeployment);

        /**
         * <p>
         * [Service-managed permissions] Describes whether StackSets automatically deploys to Organizations accounts
         * that are added to a target organization or organizational unit (OU).
         * </p>
         * <p>
         * If you specify <code>AutoDeployment</code>, don't specify <code>DeploymentTargets</code> or
         * <code>Regions</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoDeployment.Builder} avoiding the need
         * to create one manually via {@link AutoDeployment#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoDeployment.Builder#build()} is called immediately and its
         * result is passed to {@link #autoDeployment(AutoDeployment)}.
         * 
         * @param autoDeployment
         *        a consumer that will call methods on {@link AutoDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoDeployment(AutoDeployment)
         */
        default Builder autoDeployment(Consumer<AutoDeployment.Builder> autoDeployment) {
            return autoDeployment(AutoDeployment.builder().applyMutation(autoDeployment).build());
        }

        /**
         * <p>
         * The unique ID for this stack set operation.
         * </p>
         * <p>
         * The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the stack set
         * operation only once, even if you retry the request multiple times. You might retry stack set operation
         * requests to ensure that CloudFormation successfully received them.
         * </p>
         * <p>
         * If you don't specify an operation ID, CloudFormation generates one automatically.
         * </p>
         * <p>
         * Repeating this stack set operation with a new operation ID retries all stack instances whose status is
         * <code>OUTDATED</code>.
         * </p>
         * 
         * @param operationId
         *        The unique ID for this stack set operation.</p>
         *        <p>
         *        The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the
         *        stack set operation only once, even if you retry the request multiple times. You might retry stack set
         *        operation requests to ensure that CloudFormation successfully received them.
         *        </p>
         *        <p>
         *        If you don't specify an operation ID, CloudFormation generates one automatically.
         *        </p>
         *        <p>
         *        Repeating this stack set operation with a new operation ID retries all stack instances whose status is
         *        <code>OUTDATED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * [Self-managed permissions] The accounts in which to update associated stack instances. If you specify
         * accounts, you must also specify the Amazon Web Services Regions in which to update stack set instances.
         * </p>
         * <p>
         * To update <i>all</i> the stack instances associated with this stack set, don't specify the
         * <code>Accounts</code> or <code>Regions</code> properties.
         * </p>
         * <p>
         * If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
         * <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property, CloudFormation
         * marks all stack instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the
         * specified accounts and Amazon Web Services Regions. If the stack set update does not include changes to the
         * template or parameters, CloudFormation updates the stack instances in the specified accounts and Amazon Web
         * Services Regions, while leaving all other stack instances with their existing stack instance status.
         * </p>
         * 
         * @param accounts
         *        [Self-managed permissions] The accounts in which to update associated stack instances. If you specify
         *        accounts, you must also specify the Amazon Web Services Regions in which to update stack set
         *        instances.</p>
         *        <p>
         *        To update <i>all</i> the stack instances associated with this stack set, don't specify the
         *        <code>Accounts</code> or <code>Regions</code> properties.
         *        </p>
         *        <p>
         *        If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
         *        <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property,
         *        CloudFormation marks all stack instances with a status of <code>OUTDATED</code> prior to updating the
         *        stack instances in the specified accounts and Amazon Web Services Regions. If the stack set update
         *        does not include changes to the template or parameters, CloudFormation updates the stack instances in
         *        the specified accounts and Amazon Web Services Regions, while leaving all other stack instances with
         *        their existing stack instance status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<String> accounts);

        /**
         * <p>
         * [Self-managed permissions] The accounts in which to update associated stack instances. If you specify
         * accounts, you must also specify the Amazon Web Services Regions in which to update stack set instances.
         * </p>
         * <p>
         * To update <i>all</i> the stack instances associated with this stack set, don't specify the
         * <code>Accounts</code> or <code>Regions</code> properties.
         * </p>
         * <p>
         * If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
         * <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property, CloudFormation
         * marks all stack instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the
         * specified accounts and Amazon Web Services Regions. If the stack set update does not include changes to the
         * template or parameters, CloudFormation updates the stack instances in the specified accounts and Amazon Web
         * Services Regions, while leaving all other stack instances with their existing stack instance status.
         * </p>
         * 
         * @param accounts
         *        [Self-managed permissions] The accounts in which to update associated stack instances. If you specify
         *        accounts, you must also specify the Amazon Web Services Regions in which to update stack set
         *        instances.</p>
         *        <p>
         *        To update <i>all</i> the stack instances associated with this stack set, don't specify the
         *        <code>Accounts</code> or <code>Regions</code> properties.
         *        </p>
         *        <p>
         *        If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
         *        <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property,
         *        CloudFormation marks all stack instances with a status of <code>OUTDATED</code> prior to updating the
         *        stack instances in the specified accounts and Amazon Web Services Regions. If the stack set update
         *        does not include changes to the template or parameters, CloudFormation updates the stack instances in
         *        the specified accounts and Amazon Web Services Regions, while leaving all other stack instances with
         *        their existing stack instance status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(String... accounts);

        /**
         * <p>
         * The Amazon Web Services Regions in which to update associated stack instances. If you specify Regions, you
         * must also specify accounts in which to update stack set instances.
         * </p>
         * <p>
         * To update <i>all</i> the stack instances associated with this stack set, do not specify the
         * <code>Accounts</code> or <code>Regions</code> properties.
         * </p>
         * <p>
         * If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
         * <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property, CloudFormation
         * marks all stack instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the
         * specified accounts and Regions. If the stack set update does not include changes to the template or
         * parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while leaving
         * all other stack instances with their existing stack instance status.
         * </p>
         * 
         * @param regions
         *        The Amazon Web Services Regions in which to update associated stack instances. If you specify Regions,
         *        you must also specify accounts in which to update stack set instances.</p>
         *        <p>
         *        To update <i>all</i> the stack instances associated with this stack set, do not specify the
         *        <code>Accounts</code> or <code>Regions</code> properties.
         *        </p>
         *        <p>
         *        If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
         *        <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property,
         *        CloudFormation marks all stack instances with a status of <code>OUTDATED</code> prior to updating the
         *        stack instances in the specified accounts and Regions. If the stack set update does not include
         *        changes to the template or parameters, CloudFormation updates the stack instances in the specified
         *        accounts and Regions, while leaving all other stack instances with their existing stack instance
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The Amazon Web Services Regions in which to update associated stack instances. If you specify Regions, you
         * must also specify accounts in which to update stack set instances.
         * </p>
         * <p>
         * To update <i>all</i> the stack instances associated with this stack set, do not specify the
         * <code>Accounts</code> or <code>Regions</code> properties.
         * </p>
         * <p>
         * If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
         * <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property, CloudFormation
         * marks all stack instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the
         * specified accounts and Regions. If the stack set update does not include changes to the template or
         * parameters, CloudFormation updates the stack instances in the specified accounts and Regions, while leaving
         * all other stack instances with their existing stack instance status.
         * </p>
         * 
         * @param regions
         *        The Amazon Web Services Regions in which to update associated stack instances. If you specify Regions,
         *        you must also specify accounts in which to update stack set instances.</p>
         *        <p>
         *        To update <i>all</i> the stack instances associated with this stack set, do not specify the
         *        <code>Accounts</code> or <code>Regions</code> properties.
         *        </p>
         *        <p>
         *        If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or
         *        <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property,
         *        CloudFormation marks all stack instances with a status of <code>OUTDATED</code> prior to updating the
         *        stack instances in the specified accounts and Regions. If the stack set update does not include
         *        changes to the template or parameters, CloudFormation updates the stack instances in the specified
         *        accounts and Regions, while leaving all other stack instances with their existing stack instance
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         * organization's management account or as a delegated administrator in a member account.
         * </p>
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * <p>
         * Your Amazon Web Services account must be registered as a delegated administrator in the management account.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         *        organization's management account or as a delegated administrator in a member account.</p>
         *        <p>
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         *        permissions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        <p>
         *        Your Amazon Web Services account must be registered as a delegated administrator in the management
         *        account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(String callAs);

        /**
         * <p>
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         * organization's management account or as a delegated administrator in a member account.
         * </p>
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * <p>
         * Your Amazon Web Services account must be registered as a delegated administrator in the management account.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         *        organization's management account or as a delegated administrator in a member account.</p>
         *        <p>
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         *        permissions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        <p>
         *        Your Amazon Web Services account must be registered as a delegated administrator in the management
         *        account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(CallAs callAs);

        /**
         * <p>
         * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting
         * operations.
         * </p>
         * 
         * @param managedExecution
         *        Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting
         *        operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedExecution(ManagedExecution managedExecution);

        /**
         * <p>
         * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting
         * operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedExecution.Builder} avoiding the
         * need to create one manually via {@link ManagedExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link ManagedExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #managedExecution(ManagedExecution)}.
         * 
         * @param managedExecution
         *        a consumer that will call methods on {@link ManagedExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedExecution(ManagedExecution)
         */
        default Builder managedExecution(Consumer<ManagedExecution.Builder> managedExecution) {
            return managedExecution(ManagedExecution.builder().applyMutation(managedExecution).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackSetName;

        private String description;

        private String templateBody;

        private String templateURL;

        private Boolean usePreviousTemplate;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private StackSetOperationPreferences operationPreferences;

        private String administrationRoleARN;

        private String executionRoleName;

        private DeploymentTargets deploymentTargets;

        private String permissionModel;

        private AutoDeployment autoDeployment;

        private String operationId;

        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private String callAs;

        private ManagedExecution managedExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackSetRequest model) {
            super(model);
            stackSetName(model.stackSetName);
            description(model.description);
            templateBody(model.templateBody);
            templateURL(model.templateURL);
            usePreviousTemplate(model.usePreviousTemplate);
            parameters(model.parameters);
            capabilitiesWithStrings(model.capabilities);
            tags(model.tags);
            operationPreferences(model.operationPreferences);
            administrationRoleARN(model.administrationRoleARN);
            executionRoleName(model.executionRoleName);
            deploymentTargets(model.deploymentTargets);
            permissionModel(model.permissionModel);
            autoDeployment(model.autoDeployment);
            operationId(model.operationId);
            accounts(model.accounts);
            regions(model.regions);
            callAs(model.callAs);
            managedExecution(model.managedExecution);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final Boolean getUsePreviousTemplate() {
            return usePreviousTemplate;
        }

        public final void setUsePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
        }

        @Override
        public final Builder usePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final StackSetOperationPreferences.Builder getOperationPreferences() {
            return operationPreferences != null ? operationPreferences.toBuilder() : null;
        }

        public final void setOperationPreferences(StackSetOperationPreferences.BuilderImpl operationPreferences) {
            this.operationPreferences = operationPreferences != null ? operationPreferences.build() : null;
        }

        @Override
        public final Builder operationPreferences(StackSetOperationPreferences operationPreferences) {
            this.operationPreferences = operationPreferences;
            return this;
        }

        public final String getAdministrationRoleARN() {
            return administrationRoleARN;
        }

        public final void setAdministrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
        }

        @Override
        public final Builder administrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
            return this;
        }

        public final String getExecutionRoleName() {
            return executionRoleName;
        }

        public final void setExecutionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
        }

        @Override
        public final Builder executionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        public final DeploymentTargets.Builder getDeploymentTargets() {
            return deploymentTargets != null ? deploymentTargets.toBuilder() : null;
        }

        public final void setDeploymentTargets(DeploymentTargets.BuilderImpl deploymentTargets) {
            this.deploymentTargets = deploymentTargets != null ? deploymentTargets.build() : null;
        }

        @Override
        public final Builder deploymentTargets(DeploymentTargets deploymentTargets) {
            this.deploymentTargets = deploymentTargets;
            return this;
        }

        public final String getPermissionModel() {
            return permissionModel;
        }

        public final void setPermissionModel(String permissionModel) {
            this.permissionModel = permissionModel;
        }

        @Override
        public final Builder permissionModel(String permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        @Override
        public final Builder permissionModel(PermissionModels permissionModel) {
            this.permissionModel(permissionModel == null ? null : permissionModel.toString());
            return this;
        }

        public final AutoDeployment.Builder getAutoDeployment() {
            return autoDeployment != null ? autoDeployment.toBuilder() : null;
        }

        public final void setAutoDeployment(AutoDeployment.BuilderImpl autoDeployment) {
            this.autoDeployment = autoDeployment != null ? autoDeployment.build() : null;
        }

        @Override
        public final Builder autoDeployment(AutoDeployment autoDeployment) {
            this.autoDeployment = autoDeployment;
            return this;
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final Collection<String> getAccounts() {
            if (accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return accounts;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final String getCallAs() {
            return callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        public final ManagedExecution.Builder getManagedExecution() {
            return managedExecution != null ? managedExecution.toBuilder() : null;
        }

        public final void setManagedExecution(ManagedExecution.BuilderImpl managedExecution) {
            this.managedExecution = managedExecution != null ? managedExecution.build() : null;
        }

        @Override
        public final Builder managedExecution(ManagedExecution managedExecution) {
            this.managedExecution = managedExecution;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackSetRequest build() {
            return new UpdateStackSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
