/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>DescribeAccountLimits</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountLimitsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeAccountLimitsResponse.Builder, DescribeAccountLimitsResponse> {
    private static final SdkField<List<AccountLimit>> ACCOUNT_LIMITS_FIELD = SdkField
            .<List<AccountLimit>> builder(MarshallingType.LIST)
            .memberName("AccountLimits")
            .getter(getter(DescribeAccountLimitsResponse::accountLimits))
            .setter(setter(Builder::accountLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAccountLimitsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_LIMITS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AccountLimit> accountLimits;

    private final String nextToken;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.accountLimits = builder.accountLimits;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountLimits property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountLimits() {
        return accountLimits != null && !(accountLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An account limit structure that contain a list of CloudFormation account limits and their values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountLimits} method.
     * </p>
     * 
     * @return An account limit structure that contain a list of CloudFormation account limits and their values.
     */
    public final List<AccountLimit> accountLimits() {
        return accountLimits;
    }

    /**
     * <p>
     * If the output exceeds 1 MB in size, a string that identifies the next page of limits. If no additional page
     * exists, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB in size, a string that identifies the next page of limits. If no additional
     *         page exists, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountLimits() ? accountLimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse) obj;
        return hasAccountLimits() == other.hasAccountLimits() && Objects.equals(accountLimits(), other.accountLimits())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountLimitsResponse")
                .add("AccountLimits", hasAccountLimits() ? accountLimits() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountLimits":
            return Optional.ofNullable(clazz.cast(accountLimits()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountLimitsResponse, T> g) {
        return obj -> g.apply((DescribeAccountLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        /**
         * <p>
         * An account limit structure that contain a list of CloudFormation account limits and their values.
         * </p>
         * 
         * @param accountLimits
         *        An account limit structure that contain a list of CloudFormation account limits and their values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLimits(Collection<AccountLimit> accountLimits);

        /**
         * <p>
         * An account limit structure that contain a list of CloudFormation account limits and their values.
         * </p>
         * 
         * @param accountLimits
         *        An account limit structure that contain a list of CloudFormation account limits and their values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLimits(AccountLimit... accountLimits);

        /**
         * <p>
         * An account limit structure that contain a list of CloudFormation account limits and their values.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AccountLimit>.Builder} avoiding the
         * need to create one manually via {@link List<AccountLimit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountLimit>.Builder#build()} is called immediately and its
         * result is passed to {@link #accountLimits(List<AccountLimit>)}.
         * 
         * @param accountLimits
         *        a consumer that will call methods on {@link List<AccountLimit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountLimits(List<AccountLimit>)
         */
        Builder accountLimits(Consumer<AccountLimit.Builder>... accountLimits);

        /**
         * <p>
         * If the output exceeds 1 MB in size, a string that identifies the next page of limits. If no additional page
         * exists, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB in size, a string that identifies the next page of limits. If no additional
         *        page exists, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<AccountLimit> accountLimits = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            super(model);
            accountLimits(model.accountLimits);
            nextToken(model.nextToken);
        }

        public final List<AccountLimit.Builder> getAccountLimits() {
            List<AccountLimit.Builder> result = AccountLimitListCopier.copyToBuilder(this.accountLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountLimits(Collection<AccountLimit.BuilderImpl> accountLimits) {
            this.accountLimits = AccountLimitListCopier.copyFromBuilder(accountLimits);
        }

        @Override
        public final Builder accountLimits(Collection<AccountLimit> accountLimits) {
            this.accountLimits = AccountLimitListCopier.copy(accountLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountLimits(AccountLimit... accountLimits) {
            accountLimits(Arrays.asList(accountLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountLimits(Consumer<AccountLimit.Builder>... accountLimits) {
            accountLimits(Stream.of(accountLimits).map(c -> AccountLimit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
