/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterPublisherRequest extends CloudFormationRequest implements
        ToCopyableBuilder<RegisterPublisherRequest.Builder, RegisterPublisherRequest> {
    private static final SdkField<Boolean> ACCEPT_TERMS_AND_CONDITIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AcceptTermsAndConditions")
            .getter(getter(RegisterPublisherRequest::acceptTermsAndConditions)).setter(setter(Builder::acceptTermsAndConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptTermsAndConditions").build())
            .build();

    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(RegisterPublisherRequest::connectionArn))
            .setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCEPT_TERMS_AND_CONDITIONS_FIELD, CONNECTION_ARN_FIELD));

    private final Boolean acceptTermsAndConditions;

    private final String connectionArn;

    private RegisterPublisherRequest(BuilderImpl builder) {
        super(builder);
        this.acceptTermsAndConditions = builder.acceptTermsAndConditions;
        this.connectionArn = builder.connectionArn;
    }

    /**
     * <p>
     * Whether you accept the terms and conditions for publishing extensions in the CloudFormation registry. You must
     * accept the terms and conditions in order to register to publish public extensions to the CloudFormation registry.
     * </p>
     * <p>
     * The default is <code>false</code>.
     * </p>
     * 
     * @return Whether you accept the terms and conditions for publishing extensions in the CloudFormation registry. You
     *         must accept the terms and conditions in order to register to publish public extensions to the
     *         CloudFormation registry.</p>
     *         <p>
     *         The default is <code>false</code>.
     */
    public final Boolean acceptTermsAndConditions() {
        return acceptTermsAndConditions;
    }

    /**
     * <p>
     * If you are using a Bitbucket or GitHub account for identity verification, the Amazon Resource Name (ARN) for your
     * connection to that account.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs"
     * >Registering your account to publish CloudFormation extensions</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * 
     * @return If you are using a Bitbucket or GitHub account for identity verification, the Amazon Resource Name (ARN)
     *         for your connection to that account.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs"
     *         >Registering your account to publish CloudFormation extensions</a> in the <i>CloudFormation CLI User
     *         Guide</i>.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptTermsAndConditions());
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterPublisherRequest)) {
            return false;
        }
        RegisterPublisherRequest other = (RegisterPublisherRequest) obj;
        return Objects.equals(acceptTermsAndConditions(), other.acceptTermsAndConditions())
                && Objects.equals(connectionArn(), other.connectionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterPublisherRequest").add("AcceptTermsAndConditions", acceptTermsAndConditions())
                .add("ConnectionArn", connectionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptTermsAndConditions":
            return Optional.ofNullable(clazz.cast(acceptTermsAndConditions()));
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterPublisherRequest, T> g) {
        return obj -> g.apply((RegisterPublisherRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterPublisherRequest> {
        /**
         * <p>
         * Whether you accept the terms and conditions for publishing extensions in the CloudFormation registry. You
         * must accept the terms and conditions in order to register to publish public extensions to the CloudFormation
         * registry.
         * </p>
         * <p>
         * The default is <code>false</code>.
         * </p>
         * 
         * @param acceptTermsAndConditions
         *        Whether you accept the terms and conditions for publishing extensions in the CloudFormation registry.
         *        You must accept the terms and conditions in order to register to publish public extensions to the
         *        CloudFormation registry.</p>
         *        <p>
         *        The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptTermsAndConditions(Boolean acceptTermsAndConditions);

        /**
         * <p>
         * If you are using a Bitbucket or GitHub account for identity verification, the Amazon Resource Name (ARN) for
         * your connection to that account.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs"
         * >Registering your account to publish CloudFormation extensions</a> in the <i>CloudFormation CLI User
         * Guide</i>.
         * </p>
         * 
         * @param connectionArn
         *        If you are using a Bitbucket or GitHub account for identity verification, the Amazon Resource Name
         *        (ARN) for your connection to that account.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs"
         *        >Registering your account to publish CloudFormation extensions</a> in the <i>CloudFormation CLI User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private Boolean acceptTermsAndConditions;

        private String connectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterPublisherRequest model) {
            super(model);
            acceptTermsAndConditions(model.acceptTermsAndConditions);
            connectionArn(model.connectionArn);
        }

        public final Boolean getAcceptTermsAndConditions() {
            return acceptTermsAndConditions;
        }

        @Override
        public final Builder acceptTermsAndConditions(Boolean acceptTermsAndConditions) {
            this.acceptTermsAndConditions = acceptTermsAndConditions;
            return this;
        }

        public final void setAcceptTermsAndConditions(Boolean acceptTermsAndConditions) {
            this.acceptTermsAndConditions = acceptTermsAndConditions;
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterPublisherRequest build() {
            return new RegisterPublisherRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
