/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detailed status of the stack instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StackInstanceComprehensiveStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<StackInstanceComprehensiveStatus.Builder, StackInstanceComprehensiveStatus> {
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedStatus").getter(getter(StackInstanceComprehensiveStatus::detailedStatusAsString))
            .setter(setter(Builder::detailedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILED_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detailedStatus;

    private StackInstanceComprehensiveStatus(BuilderImpl builder) {
        this.detailedStatus = builder.detailedStatus;
    }

    /**
     * <ul>
     * <li>
     * <p>
     * <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either
     * because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation
     * has been exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation fails
     * in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be
     * exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
     * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might
     * need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
     * <code>true</code>, to delete the stack instance, and then delete the stack manually.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: The operation in the specified account and Region has yet to start.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailedStatus}
     * will return {@link StackInstanceDetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #detailedStatusAsString}.
     * </p>
     * 
     * @return <li>
     *         <p>
     *         <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is
     *         either because a user has stopped the stack set operation, or because the failure tolerance of the stack
     *         set operation has been exceeded.
     *         </p>
     *         </li> <li>
     *         <p>
     *         <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation
     *         fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole
     *         might be exceeded.
     *         </p>
     *         </li> <li>
     *         <p>
     *         <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in
     *         an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations.
     *         You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code>
     *         set to <code>true</code>, to delete the stack instance, and then delete the stack manually.
     *         </p>
     *         </li> <li>
     *         <p>
     *         <code>PENDING</code>: The operation in the specified account and Region has yet to start.
     *         </p>
     *         </li> <li>
     *         <p>
     *         <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
     *         </p>
     *         </li> <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
     *         </p>
     *         </li>
     * @see StackInstanceDetailedStatus
     */
    public final StackInstanceDetailedStatus detailedStatus() {
        return StackInstanceDetailedStatus.fromValue(detailedStatus);
    }

    /**
     * <ul>
     * <li>
     * <p>
     * <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either
     * because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation
     * has been exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation fails
     * in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be
     * exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
     * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might
     * need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
     * <code>true</code>, to delete the stack instance, and then delete the stack manually.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: The operation in the specified account and Region has yet to start.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailedStatus}
     * will return {@link StackInstanceDetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #detailedStatusAsString}.
     * </p>
     * 
     * @return <li>
     *         <p>
     *         <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is
     *         either because a user has stopped the stack set operation, or because the failure tolerance of the stack
     *         set operation has been exceeded.
     *         </p>
     *         </li> <li>
     *         <p>
     *         <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation
     *         fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole
     *         might be exceeded.
     *         </p>
     *         </li> <li>
     *         <p>
     *         <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in
     *         an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations.
     *         You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code>
     *         set to <code>true</code>, to delete the stack instance, and then delete the stack manually.
     *         </p>
     *         </li> <li>
     *         <p>
     *         <code>PENDING</code>: The operation in the specified account and Region has yet to start.
     *         </p>
     *         </li> <li>
     *         <p>
     *         <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
     *         </p>
     *         </li> <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
     *         </p>
     *         </li>
     * @see StackInstanceDetailedStatus
     */
    public final String detailedStatusAsString() {
        return detailedStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackInstanceComprehensiveStatus)) {
            return false;
        }
        StackInstanceComprehensiveStatus other = (StackInstanceComprehensiveStatus) obj;
        return Objects.equals(detailedStatusAsString(), other.detailedStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StackInstanceComprehensiveStatus").add("DetailedStatus", detailedStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetailedStatus":
            return Optional.ofNullable(clazz.cast(detailedStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackInstanceComprehensiveStatus, T> g) {
        return obj -> g.apply((StackInstanceComprehensiveStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StackInstanceComprehensiveStatus> {
        /**
         * <ul>
         * <li>
         * <p>
         * <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either
         * because a user has stopped the stack set operation, or because the failure tolerance of the stack set
         * operation has been exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation
         * fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might
         * be exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
         * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You
         * might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
         * <code>true</code>, to delete the stack instance, and then delete the stack manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: The operation in the specified account and Region has yet to start.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param detailedStatus
         *        <li>
         *        <p>
         *        <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is
         *        either because a user has stopped the stack set operation, or because the failure tolerance of the
         *        stack set operation has been exceeded.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set
         *        operation fails in enough accounts within a Region, the failure tolerance for the stack set operation
         *        as a whole might be exceeded.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack
         *        in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code>
         *        operations. You might need to perform a <code>DeleteStackInstances</code> operation, with
         *        <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the
         *        stack manually.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>PENDING</code>: The operation in the specified account and Region has yet to start.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
         *        </p>
         *        </li>
         * @see StackInstanceDetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackInstanceDetailedStatus
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <ul>
         * <li>
         * <p>
         * <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either
         * because a user has stopped the stack set operation, or because the failure tolerance of the stack set
         * operation has been exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation
         * fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might
         * be exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
         * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You
         * might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
         * <code>true</code>, to delete the stack instance, and then delete the stack manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: The operation in the specified account and Region has yet to start.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param detailedStatus
         *        <li>
         *        <p>
         *        <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is
         *        either because a user has stopped the stack set operation, or because the failure tolerance of the
         *        stack set operation has been exceeded.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set
         *        operation fails in enough accounts within a Region, the failure tolerance for the stack set operation
         *        as a whole might be exceeded.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack
         *        in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code>
         *        operations. You might need to perform a <code>DeleteStackInstances</code> operation, with
         *        <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the
         *        stack manually.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>PENDING</code>: The operation in the specified account and Region has yet to start.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.
         *        </p>
         *        </li> <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.
         *        </p>
         *        </li>
         * @see StackInstanceDetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackInstanceDetailedStatus
         */
        Builder detailedStatus(StackInstanceDetailedStatus detailedStatus);
    }

    static final class BuilderImpl implements Builder {
        private String detailedStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StackInstanceComprehensiveStatus model) {
            detailedStatus(model.detailedStatus);
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        @Transient
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder detailedStatus(StackInstanceDetailedStatus detailedStatus) {
            this.detailedStatus(detailedStatus == null ? null : detailedStatus.toString());
            return this;
        }

        @Override
        public StackInstanceComprehensiveStatus build() {
            return new StackInstanceComprehensiveStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
