/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishTypeRequest extends CloudFormationRequest implements
        ToCopyableBuilder<PublishTypeRequest.Builder, PublishTypeRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(PublishTypeRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(PublishTypeRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(PublishTypeRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> PUBLIC_VERSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicVersionNumber").getter(getter(PublishTypeRequest::publicVersionNumber))
            .setter(setter(Builder::publicVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ARN_FIELD,
            TYPE_NAME_FIELD, PUBLIC_VERSION_NUMBER_FIELD));

    private final String type;

    private final String arn;

    private final String typeName;

    private final String publicVersionNumber;

    private PublishTypeRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.arn = builder.arn;
        this.typeName = builder.typeName;
        this.publicVersionNumber = builder.publicVersionNumber;
    }

    /**
     * <p>
     * The type of the extension.
     * </p>
     * <p>
     * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThirdPartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the extension.</p>
     *         <p>
     *         Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * @see ThirdPartyType
     */
    public final ThirdPartyType type() {
        return ThirdPartyType.fromValue(type);
    }

    /**
     * <p>
     * The type of the extension.
     * </p>
     * <p>
     * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThirdPartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the extension.</p>
     *         <p>
     *         Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * @see ThirdPartyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the extension.
     * </p>
     * <p>
     * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the extension.</p>
     *         <p>
     *         Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * <p>
     * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     * </p>
     * 
     * @return The name of the extension.</p>
     *         <p>
     *         Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The version number to assign to this version of the extension.
     * </p>
     * <p>
     * Use the following format, and adhere to semantic versioning when assigning a version number to your extension:
     * </p>
     * <p>
     * <code>MAJOR.MINOR.PATCH</code>
     * </p>
     * <p>
     * For more information, see <a href="https://semver.org/">Semantic Versioning 2.0.0</a>.
     * </p>
     * <p>
     * If you do not specify a version number, CloudFormation increments the version number by one minor version
     * release.
     * </p>
     * <p>
     * The first time you publish a type, CloudFormation sets the version number to <code>1.0.0</code>, regardless of
     * the value you specify.
     * </p>
     * 
     * @return The version number to assign to this version of the extension.</p>
     *         <p>
     *         Use the following format, and adhere to semantic versioning when assigning a version number to your
     *         extension:
     *         </p>
     *         <p>
     *         <code>MAJOR.MINOR.PATCH</code>
     *         </p>
     *         <p>
     *         For more information, see <a href="https://semver.org/">Semantic Versioning 2.0.0</a>.
     *         </p>
     *         <p>
     *         If you do not specify a version number, CloudFormation increments the version number by one minor version
     *         release.
     *         </p>
     *         <p>
     *         The first time you publish a type, CloudFormation sets the version number to <code>1.0.0</code>,
     *         regardless of the value you specify.
     */
    public final String publicVersionNumber() {
        return publicVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(publicVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishTypeRequest)) {
            return false;
        }
        PublishTypeRequest other = (PublishTypeRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(typeName(), other.typeName())
                && Objects.equals(publicVersionNumber(), other.publicVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishTypeRequest").add("Type", typeAsString()).add("Arn", arn()).add("TypeName", typeName())
                .add("PublicVersionNumber", publicVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "PublicVersionNumber":
            return Optional.ofNullable(clazz.cast(publicVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishTypeRequest, T> g) {
        return obj -> g.apply((PublishTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, PublishTypeRequest> {
        /**
         * <p>
         * The type of the extension.
         * </p>
         * <p>
         * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * </p>
         * 
         * @param type
         *        The type of the extension.</p>
         *        <p>
         *        Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * @see ThirdPartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the extension.
         * </p>
         * <p>
         * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * </p>
         * 
         * @param type
         *        The type of the extension.</p>
         *        <p>
         *        Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * @see ThirdPartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyType
         */
        Builder type(ThirdPartyType type);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the extension.
         * </p>
         * <p>
         * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Number (ARN) of the extension.</p>
         *        <p>
         *        Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the extension.
         * </p>
         * <p>
         * Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * </p>
         * 
         * @param typeName
         *        The name of the extension.</p>
         *        <p>
         *        Conditional: You must specify <code>Arn</code>, or <code>TypeName</code> and <code>Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The version number to assign to this version of the extension.
         * </p>
         * <p>
         * Use the following format, and adhere to semantic versioning when assigning a version number to your
         * extension:
         * </p>
         * <p>
         * <code>MAJOR.MINOR.PATCH</code>
         * </p>
         * <p>
         * For more information, see <a href="https://semver.org/">Semantic Versioning 2.0.0</a>.
         * </p>
         * <p>
         * If you do not specify a version number, CloudFormation increments the version number by one minor version
         * release.
         * </p>
         * <p>
         * The first time you publish a type, CloudFormation sets the version number to <code>1.0.0</code>, regardless
         * of the value you specify.
         * </p>
         * 
         * @param publicVersionNumber
         *        The version number to assign to this version of the extension.</p>
         *        <p>
         *        Use the following format, and adhere to semantic versioning when assigning a version number to your
         *        extension:
         *        </p>
         *        <p>
         *        <code>MAJOR.MINOR.PATCH</code>
         *        </p>
         *        <p>
         *        For more information, see <a href="https://semver.org/">Semantic Versioning 2.0.0</a>.
         *        </p>
         *        <p>
         *        If you do not specify a version number, CloudFormation increments the version number by one minor
         *        version release.
         *        </p>
         *        <p>
         *        The first time you publish a type, CloudFormation sets the version number to <code>1.0.0</code>,
         *        regardless of the value you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicVersionNumber(String publicVersionNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String type;

        private String arn;

        private String typeName;

        private String publicVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishTypeRequest model) {
            super(model);
            type(model.type);
            arn(model.arn);
            typeName(model.typeName);
            publicVersionNumber(model.publicVersionNumber);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ThirdPartyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        @Transient
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getPublicVersionNumber() {
            return publicVersionNumber;
        }

        public final void setPublicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
        }

        @Override
        @Transient
        public final Builder publicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishTypeRequest build() {
            return new PublishTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
