/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectStackDriftRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DetectStackDriftRequest.Builder, DetectStackDriftRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(DetectStackDriftRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<List<String>> LOGICAL_RESOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogicalResourceIds")
            .getter(getter(DetectStackDriftRequest::logicalResourceIds))
            .setter(setter(Builder::logicalResourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            LOGICAL_RESOURCE_IDS_FIELD));

    private final String stackName;

    private final List<String> logicalResourceIds;

    private DetectStackDriftRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.logicalResourceIds = builder.logicalResourceIds;
    }

    /**
     * <p>
     * The name of the stack for which you want to detect drift.
     * </p>
     * 
     * @return The name of the stack for which you want to detect drift.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogicalResourceIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogicalResourceIds() {
        return logicalResourceIds != null && !(logicalResourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The logical names of any resources you want to use as filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogicalResourceIds} method.
     * </p>
     * 
     * @return The logical names of any resources you want to use as filters.
     */
    public final List<String> logicalResourceIds() {
        return logicalResourceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogicalResourceIds() ? logicalResourceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectStackDriftRequest)) {
            return false;
        }
        DetectStackDriftRequest other = (DetectStackDriftRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && hasLogicalResourceIds() == other.hasLogicalResourceIds()
                && Objects.equals(logicalResourceIds(), other.logicalResourceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectStackDriftRequest").add("StackName", stackName())
                .add("LogicalResourceIds", hasLogicalResourceIds() ? logicalResourceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "LogicalResourceIds":
            return Optional.ofNullable(clazz.cast(logicalResourceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectStackDriftRequest, T> g) {
        return obj -> g.apply((DetectStackDriftRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetectStackDriftRequest> {
        /**
         * <p>
         * The name of the stack for which you want to detect drift.
         * </p>
         * 
         * @param stackName
         *        The name of the stack for which you want to detect drift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The logical names of any resources you want to use as filters.
         * </p>
         * 
         * @param logicalResourceIds
         *        The logical names of any resources you want to use as filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceIds(Collection<String> logicalResourceIds);

        /**
         * <p>
         * The logical names of any resources you want to use as filters.
         * </p>
         * 
         * @param logicalResourceIds
         *        The logical names of any resources you want to use as filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceIds(String... logicalResourceIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private List<String> logicalResourceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectStackDriftRequest model) {
            super(model);
            stackName(model.stackName);
            logicalResourceIds(model.logicalResourceIds);
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        @Transient
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final Collection<String> getLogicalResourceIds() {
            if (logicalResourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return logicalResourceIds;
        }

        public final void setLogicalResourceIds(Collection<String> logicalResourceIds) {
            this.logicalResourceIds = LogicalResourceIdsCopier.copy(logicalResourceIds);
        }

        @Override
        @Transient
        public final Builder logicalResourceIds(Collection<String> logicalResourceIds) {
            this.logicalResourceIds = LogicalResourceIdsCopier.copy(logicalResourceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logicalResourceIds(String... logicalResourceIds) {
            logicalResourceIds(Arrays.asList(logicalResourceIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectStackDriftRequest build() {
            return new DetectStackDriftRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
