/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetTypeConfigurationRequest extends CloudFormationRequest implements
        ToCopyableBuilder<SetTypeConfigurationRequest.Builder, SetTypeConfigurationRequest> {
    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeArn").getter(getter(SetTypeConfigurationRequest::typeArn)).setter(setter(Builder::typeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()).build();

    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Configuration").getter(getter(SetTypeConfigurationRequest::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<String> CONFIGURATION_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationAlias").getter(getter(SetTypeConfigurationRequest::configurationAlias))
            .setter(setter(Builder::configurationAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAlias").build())
            .build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(SetTypeConfigurationRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SetTypeConfigurationRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_ARN_FIELD,
            CONFIGURATION_FIELD, CONFIGURATION_ALIAS_FIELD, TYPE_NAME_FIELD, TYPE_FIELD));

    private final String typeArn;

    private final String configuration;

    private final String configurationAlias;

    private final String typeName;

    private final String type;

    private SetTypeConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.typeArn = builder.typeArn;
        this.configuration = builder.configuration;
        this.configurationAlias = builder.configurationAlias;
        this.typeName = builder.typeName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the extension, in this account and region.
     * </p>
     * <p>
     * For public extensions, this will be the ARN assigned when you <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the
     * type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the
     * type</a> in this account and region.
     * </p>
     * <p>
     * Do not include the extension versions suffix at the end of the ARN. You can set the configuration for an
     * extension, but not for a specific extension version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
     *         <p>
     *         For public extensions, this will be the ARN assigned when you <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate
     *         the type</a> in this account and region. For private extensions, this will be the ARN assigned when you
     *         <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register
     *         the type</a> in this account and region.
     *         </p>
     *         <p>
     *         Do not include the extension versions suffix at the end of the ARN. You can set the configuration for an
     *         extension, but not for a specific extension version.
     */
    public final String typeArn() {
        return typeArn;
    }

    /**
     * <p>
     * The configuration data for the extension, in this account and region.
     * </p>
     * <p>
     * The configuration data must be formatted as JSON, and validate against the schema returned in the
     * <code>ConfigurationSchema</code> response element of <a
     * href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">API_DescribeType</a>. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration"
     * >Defining account-level configuration data for an extension</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * 
     * @return The configuration data for the extension, in this account and region. </p>
     *         <p>
     *         The configuration data must be formatted as JSON, and validate against the schema returned in the
     *         <code>ConfigurationSchema</code> response element of <a
     *         href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">API_DescribeType</a>. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration"
     *         >Defining account-level configuration data for an extension</a> in the <i>CloudFormation CLI User
     *         Guide</i>.
     */
    public final String configuration() {
        return configuration;
    }

    /**
     * <p>
     * An alias by which to refer to this extension configuration data.
     * </p>
     * <p>
     * Conditional: Specifying a configuration alias is required when setting a configuration for a resource type
     * extension.
     * </p>
     * 
     * @return An alias by which to refer to this extension configuration data.</p>
     *         <p>
     *         Conditional: Specifying a configuration alias is required when setting a configuration for a resource
     *         type extension.
     */
    public final String configurationAlias() {
        return configurationAlias;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * <p>
     * Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and <code>TypeName</code>.
     * </p>
     * 
     * @return The name of the extension.</p>
     *         <p>
     *         Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
     *         <code>TypeName</code>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The type of extension.
     * </p>
     * <p>
     * Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and <code>TypeName</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThirdPartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of extension.</p>
     *         <p>
     *         Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
     *         <code>TypeName</code>.
     * @see ThirdPartyType
     */
    public final ThirdPartyType type() {
        return ThirdPartyType.fromValue(type);
    }

    /**
     * <p>
     * The type of extension.
     * </p>
     * <p>
     * Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and <code>TypeName</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThirdPartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of extension.</p>
     *         <p>
     *         Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
     *         <code>TypeName</code>.
     * @see ThirdPartyType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(configurationAlias());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTypeConfigurationRequest)) {
            return false;
        }
        SetTypeConfigurationRequest other = (SetTypeConfigurationRequest) obj;
        return Objects.equals(typeArn(), other.typeArn()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(configurationAlias(), other.configurationAlias())
                && Objects.equals(typeName(), other.typeName()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetTypeConfigurationRequest").add("TypeArn", typeArn()).add("Configuration", configuration())
                .add("ConfigurationAlias", configurationAlias()).add("TypeName", typeName()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeArn":
            return Optional.ofNullable(clazz.cast(typeArn()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "ConfigurationAlias":
            return Optional.ofNullable(clazz.cast(configurationAlias()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetTypeConfigurationRequest, T> g) {
        return obj -> g.apply((SetTypeConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetTypeConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the extension, in this account and region.
         * </p>
         * <p>
         * For public extensions, this will be the ARN assigned when you <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the
         * type</a> in this account and region. For private extensions, this will be the ARN assigned when you <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the
         * type</a> in this account and region.
         * </p>
         * <p>
         * Do not include the extension versions suffix at the end of the ARN. You can set the configuration for an
         * extension, but not for a specific extension version.
         * </p>
         * 
         * @param typeArn
         *        The Amazon Resource Name (ARN) for the extension, in this account and region.</p>
         *        <p>
         *        For public extensions, this will be the ARN assigned when you <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html"
         *        >activate the type</a> in this account and region. For private extensions, this will be the ARN
         *        assigned when you <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         *        >register the type</a> in this account and region.
         *        </p>
         *        <p>
         *        Do not include the extension versions suffix at the end of the ARN. You can set the configuration for
         *        an extension, but not for a specific extension version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeArn(String typeArn);

        /**
         * <p>
         * The configuration data for the extension, in this account and region.
         * </p>
         * <p>
         * The configuration data must be formatted as JSON, and validate against the schema returned in the
         * <code>ConfigurationSchema</code> response element of <a
         * href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">API_DescribeType</a>. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration"
         * >Defining account-level configuration data for an extension</a> in the <i>CloudFormation CLI User Guide</i>.
         * </p>
         * 
         * @param configuration
         *        The configuration data for the extension, in this account and region. </p>
         *        <p>
         *        The configuration data must be formatted as JSON, and validate against the schema returned in the
         *        <code>ConfigurationSchema</code> response element of <a
         *        href="AWSCloudFormation/latest/APIReference/API_DescribeType.html">API_DescribeType</a>. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration"
         *        >Defining account-level configuration data for an extension</a> in the <i>CloudFormation CLI User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(String configuration);

        /**
         * <p>
         * An alias by which to refer to this extension configuration data.
         * </p>
         * <p>
         * Conditional: Specifying a configuration alias is required when setting a configuration for a resource type
         * extension.
         * </p>
         * 
         * @param configurationAlias
         *        An alias by which to refer to this extension configuration data.</p>
         *        <p>
         *        Conditional: Specifying a configuration alias is required when setting a configuration for a resource
         *        type extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAlias(String configurationAlias);

        /**
         * <p>
         * The name of the extension.
         * </p>
         * <p>
         * Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and <code>TypeName</code>.
         * </p>
         * 
         * @param typeName
         *        The name of the extension.</p>
         *        <p>
         *        Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
         *        <code>TypeName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The type of extension.
         * </p>
         * <p>
         * Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and <code>TypeName</code>.
         * </p>
         * 
         * @param type
         *        The type of extension.</p>
         *        <p>
         *        Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
         *        <code>TypeName</code>.
         * @see ThirdPartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of extension.
         * </p>
         * <p>
         * Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and <code>TypeName</code>.
         * </p>
         * 
         * @param type
         *        The type of extension.</p>
         *        <p>
         *        Conditional: You must specify <code>ConfigurationArn</code>, or <code>Type</code> and
         *        <code>TypeName</code>.
         * @see ThirdPartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyType
         */
        Builder type(ThirdPartyType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String typeArn;

        private String configuration;

        private String configurationAlias;

        private String typeName;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTypeConfigurationRequest model) {
            super(model);
            typeArn(model.typeArn);
            configuration(model.configuration);
            configurationAlias(model.configurationAlias);
            typeName(model.typeName);
            type(model.type);
        }

        public final String getTypeArn() {
            return typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        @Transient
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final String getConfiguration() {
            return configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        @Transient
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getConfigurationAlias() {
            return configurationAlias;
        }

        public final void setConfigurationAlias(String configurationAlias) {
            this.configurationAlias = configurationAlias;
        }

        @Override
        @Transient
        public final Builder configurationAlias(String configurationAlias) {
            this.configurationAlias = configurationAlias;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        @Transient
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ThirdPartyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetTypeConfigurationRequest build() {
            return new SetTypeConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
