/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CallAs;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemplateSummaryRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, GetTemplateSummaryRequest> {
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::templateBody)).setter(GetTemplateSummaryRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateURL").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::templateURL)).setter(GetTemplateSummaryRequest.setter(Builder::templateURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::stackName)).setter(GetTemplateSummaryRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetName").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::stackSetName)).setter(GetTemplateSummaryRequest.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<String> CALL_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAs").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::callAsAsString)).setter(GetTemplateSummaryRequest.setter(Builder::callAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD, STACK_NAME_FIELD, STACK_SET_NAME_FIELD, CALL_AS_FIELD));
    private final String templateBody;
    private final String templateURL;
    private final String stackName;
    private final String stackSetName;
    private final String callAs;

    private GetTemplateSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.stackName = builder.stackName;
        this.stackSetName = builder.stackSetName;
        this.callAs = builder.callAs;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final String templateURL() {
        return this.templateURL;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final CallAs callAs() {
        return CallAs.fromValue(this.callAs);
    }

    public final String callAsAsString() {
        return this.callAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.callAsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryRequest)) {
            return false;
        }
        GetTemplateSummaryRequest other = (GetTemplateSummaryRequest)((Object)obj);
        return Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateURL(), other.templateURL()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.callAsAsString(), other.callAsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetTemplateSummaryRequest").add("TemplateBody", (Object)this.templateBody()).add("TemplateURL", (Object)this.templateURL()).add("StackName", (Object)this.stackName()).add("StackSetName", (Object)this.stackSetName()).add("CallAs", (Object)this.callAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "TemplateURL": {
                return Optional.ofNullable(clazz.cast(this.templateURL()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "CallAs": {
                return Optional.ofNullable(clazz.cast(this.callAsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateSummaryRequest, T> g) {
        return obj -> g.apply((GetTemplateSummaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String templateBody;
        private String templateURL;
        private String stackName;
        private String stackSetName;
        private String callAs;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryRequest model) {
            super(model);
            this.templateBody(model.templateBody);
            this.templateURL(model.templateURL);
            this.stackName(model.stackName);
            this.stackSetName(model.stackSetName);
            this.callAs(model.callAs);
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        @Transient
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        @Transient
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        @Transient
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        @Transient
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getCallAs() {
            return this.callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        @Transient
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        @Transient
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTemplateSummaryRequest build() {
            return new GetTemplateSummaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemplateSummaryRequest> {
        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder stackName(String var1);

        public Builder stackSetName(String var1);

        public Builder callAs(String var1);

        public Builder callAs(CallAs var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

