/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains logging configuration information for an extension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfig implements SdkPojo, Serializable, ToCopyableBuilder<LoggingConfig.Builder, LoggingConfig> {
    private static final SdkField<String> LOG_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogRoleArn").getter(getter(LoggingConfig::logRoleArn)).setter(setter(Builder::logRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogRoleArn").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupName").getter(getter(LoggingConfig::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_ROLE_ARN_FIELD,
            LOG_GROUP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logRoleArn;

    private final String logGroupName;

    private LoggingConfig(BuilderImpl builder) {
        this.logRoleArn = builder.logRoleArn;
        this.logGroupName = builder.logGroupName;
    }

    /**
     * <p>
     * The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
     * </p>
     * 
     * @return The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
     */
    public final String logRoleArn() {
        return logRoleArn;
    }

    /**
     * <p>
     * The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the
     * extension's handlers.
     * </p>
     * 
     * @return The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the
     *         extension's handlers.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig) obj;
        return Objects.equals(logRoleArn(), other.logRoleArn()) && Objects.equals(logGroupName(), other.logGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingConfig").add("LogRoleArn", logRoleArn()).add("LogGroupName", logGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogRoleArn":
            return Optional.ofNullable(clazz.cast(logRoleArn()));
        case "LogGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfig, T> g) {
        return obj -> g.apply((LoggingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfig> {
        /**
         * <p>
         * The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
         * </p>
         * 
         * @param logRoleArn
         *        The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logRoleArn(String logRoleArn);

        /**
         * <p>
         * The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the
         * extension's handlers.
         * </p>
         * 
         * @param logGroupName
         *        The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking
         *        the extension's handlers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);
    }

    static final class BuilderImpl implements Builder {
        private String logRoleArn;

        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfig model) {
            logRoleArn(model.logRoleArn);
            logGroupName(model.logGroupName);
        }

        public final String getLogRoleArn() {
            return logRoleArn;
        }

        public final void setLogRoleArn(String logRoleArn) {
            this.logRoleArn = logRoleArn;
        }

        @Override
        @Transient
        public final Builder logRoleArn(String logRoleArn) {
            this.logRoleArn = logRoleArn;
            return this;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        @Transient
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        @Override
        public LoggingConfig build() {
            return new LoggingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
