/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackResourceDriftsRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DescribeStackResourceDriftsRequest.Builder, DescribeStackResourceDriftsRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(DescribeStackResourceDriftsRequest::stackName))
            .setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<List<String>> STACK_RESOURCE_DRIFT_STATUS_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StackResourceDriftStatusFilters")
            .getter(getter(DescribeStackResourceDriftsRequest::stackResourceDriftStatusFiltersAsStrings))
            .setter(setter(Builder::stackResourceDriftStatusFiltersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceDriftStatusFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeStackResourceDriftsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeStackResourceDriftsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            STACK_RESOURCE_DRIFT_STATUS_FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String stackName;

    private final List<String> stackResourceDriftStatusFilters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeStackResourceDriftsRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.stackResourceDriftStatusFilters = builder.stackResourceDriftStatusFilters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name of the stack for which you want drift information.
     * </p>
     * 
     * @return The name of the stack for which you want drift information.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The resource drift status values to use as filters for the resource drift results returned.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has been
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackResourceDriftStatusFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The resource drift status values to use as filters for the resource drift results returned.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETED</code>: The resource differs from its expected template configuration in that the resource
     *         has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
     *         </p>
     *         </li>
     */
    public final List<StackResourceDriftStatus> stackResourceDriftStatusFilters() {
        return StackResourceDriftStatusFiltersCopier.copyStringToEnum(stackResourceDriftStatusFilters);
    }

    /**
     * Returns true if the StackResourceDriftStatusFilters property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasStackResourceDriftStatusFilters() {
        return stackResourceDriftStatusFilters != null && !(stackResourceDriftStatusFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource drift status values to use as filters for the resource drift results returned.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has been
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackResourceDriftStatusFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The resource drift status values to use as filters for the resource drift results returned.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETED</code>: The resource differs from its expected template configuration in that the resource
     *         has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
     *         </p>
     *         </li>
     */
    public final List<String> stackResourceDriftStatusFiltersAsStrings() {
        return stackResourceDriftStatusFilters;
    }

    /**
     * <p>
     * A string that identifies the next page of stack resource drift results.
     * </p>
     * 
     * @return A string that identifies the next page of stack resource drift results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this
     * maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code>
     * request parameter to get the next set of results.
     * </p>
     * 
     * @return The maximum number of results to be returned with a single call. If the number of available results
     *         exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
     *         <code>NextToken</code> request parameter to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasStackResourceDriftStatusFilters() ? stackResourceDriftStatusFiltersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourceDriftsRequest)) {
            return false;
        }
        DescribeStackResourceDriftsRequest other = (DescribeStackResourceDriftsRequest) obj;
        return Objects.equals(stackName(), other.stackName())
                && hasStackResourceDriftStatusFilters() == other.hasStackResourceDriftStatusFilters()
                && Objects.equals(stackResourceDriftStatusFiltersAsStrings(), other.stackResourceDriftStatusFiltersAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeStackResourceDriftsRequest")
                .add("StackName", stackName())
                .add("StackResourceDriftStatusFilters",
                        hasStackResourceDriftStatusFilters() ? stackResourceDriftStatusFiltersAsStrings() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "StackResourceDriftStatusFilters":
            return Optional.ofNullable(clazz.cast(stackResourceDriftStatusFiltersAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackResourceDriftsRequest, T> g) {
        return obj -> g.apply((DescribeStackResourceDriftsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackResourceDriftsRequest> {
        /**
         * <p>
         * The name of the stack for which you want drift information.
         * </p>
         * 
         * @param stackName
         *        The name of the stack for which you want drift information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The resource drift status values to use as filters for the resource drift results returned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackResourceDriftStatusFilters
         *        The resource drift status values to use as filters for the resource drift results returned.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETED</code>: The resource differs from its expected template configuration in that the
         *        resource has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The resources's actual configuration matches its expected template
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceDriftStatusFiltersWithStrings(Collection<String> stackResourceDriftStatusFilters);

        /**
         * <p>
         * The resource drift status values to use as filters for the resource drift results returned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackResourceDriftStatusFilters
         *        The resource drift status values to use as filters for the resource drift results returned.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETED</code>: The resource differs from its expected template configuration in that the
         *        resource has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The resources's actual configuration matches its expected template
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceDriftStatusFiltersWithStrings(String... stackResourceDriftStatusFilters);

        /**
         * <p>
         * The resource drift status values to use as filters for the resource drift results returned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackResourceDriftStatusFilters
         *        The resource drift status values to use as filters for the resource drift results returned.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETED</code>: The resource differs from its expected template configuration in that the
         *        resource has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The resources's actual configuration matches its expected template
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceDriftStatusFilters(Collection<StackResourceDriftStatus> stackResourceDriftStatusFilters);

        /**
         * <p>
         * The resource drift status values to use as filters for the resource drift results returned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The resources's actual configuration matches its expected template configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackResourceDriftStatusFilters
         *        The resource drift status values to use as filters for the resource drift results returned.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETED</code>: The resource differs from its expected template configuration in that the
         *        resource has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The resources's actual configuration matches its expected template
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation does not currently return this value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceDriftStatusFilters(StackResourceDriftStatus... stackResourceDriftStatusFilters);

        /**
         * <p>
         * A string that identifies the next page of stack resource drift results.
         * </p>
         * 
         * @param nextToken
         *        A string that identifies the next page of stack resource drift results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to be returned with a single call. If the number of available results exceeds
         * this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         * <code>NextToken</code> request parameter to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned with a single call. If the number of available results
         *        exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         *        <code>NextToken</code> request parameter to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private List<String> stackResourceDriftStatusFilters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourceDriftsRequest model) {
            super(model);
            stackName(model.stackName);
            stackResourceDriftStatusFiltersWithStrings(model.stackResourceDriftStatusFilters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final Collection<String> getStackResourceDriftStatusFilters() {
            if (stackResourceDriftStatusFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return stackResourceDriftStatusFilters;
        }

        @Override
        public final Builder stackResourceDriftStatusFiltersWithStrings(Collection<String> stackResourceDriftStatusFilters) {
            this.stackResourceDriftStatusFilters = StackResourceDriftStatusFiltersCopier.copy(stackResourceDriftStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceDriftStatusFiltersWithStrings(String... stackResourceDriftStatusFilters) {
            stackResourceDriftStatusFiltersWithStrings(Arrays.asList(stackResourceDriftStatusFilters));
            return this;
        }

        @Override
        public final Builder stackResourceDriftStatusFilters(Collection<StackResourceDriftStatus> stackResourceDriftStatusFilters) {
            this.stackResourceDriftStatusFilters = StackResourceDriftStatusFiltersCopier
                    .copyEnumToString(stackResourceDriftStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceDriftStatusFilters(StackResourceDriftStatus... stackResourceDriftStatusFilters) {
            stackResourceDriftStatusFilters(Arrays.asList(stackResourceDriftStatusFilters));
            return this;
        }

        public final void setStackResourceDriftStatusFilters(Collection<String> stackResourceDriftStatusFilters) {
            this.stackResourceDriftStatusFilters = StackResourceDriftStatusFiltersCopier.copy(stackResourceDriftStatusFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStackResourceDriftsRequest build() {
            return new DescribeStackResourceDriftsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
