/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTypeResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeTypeResponse.Builder, DescribeTypeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeTypeResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeTypeResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(DescribeTypeResponse::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultVersionId").getter(getter(DescribeTypeResponse::defaultVersionId))
            .setter(setter(Builder::defaultVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefaultVersion").getter(getter(DescribeTypeResponse::isDefaultVersion))
            .setter(setter(Builder::isDefaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultVersion").build()).build();

    private static final SdkField<String> TYPE_TESTS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeTestsStatus").getter(getter(DescribeTypeResponse::typeTestsStatusAsString))
            .setter(setter(Builder::typeTestsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeTestsStatus").build()).build();

    private static final SdkField<String> TYPE_TESTS_STATUS_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TypeTestsStatusDescription")
            .getter(getter(DescribeTypeResponse::typeTestsStatusDescription))
            .setter(setter(Builder::typeTestsStatusDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeTestsStatusDescription").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeTypeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Schema")
            .getter(getter(DescribeTypeResponse::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> PROVISIONING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningType").getter(getter(DescribeTypeResponse::provisioningTypeAsString))
            .setter(setter(Builder::provisioningType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningType").build()).build();

    private static final SdkField<String> DEPRECATED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeprecatedStatus").getter(getter(DescribeTypeResponse::deprecatedStatusAsString))
            .setter(setter(Builder::deprecatedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecatedStatus").build()).build();

    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField
            .<LoggingConfig> builder(MarshallingType.SDK_POJO).memberName("LoggingConfig")
            .getter(getter(DescribeTypeResponse::loggingConfig)).setter(setter(Builder::loggingConfig))
            .constructor(LoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfig").build()).build();

    private static final SdkField<List<RequiredActivatedType>> REQUIRED_ACTIVATED_TYPES_FIELD = SdkField
            .<List<RequiredActivatedType>> builder(MarshallingType.LIST)
            .memberName("RequiredActivatedTypes")
            .getter(getter(DescribeTypeResponse::requiredActivatedTypes))
            .setter(setter(Builder::requiredActivatedTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredActivatedTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequiredActivatedType> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequiredActivatedType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(DescribeTypeResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(DescribeTypeResponse::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceUrl").getter(getter(DescribeTypeResponse::sourceUrl)).setter(setter(Builder::sourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build()).build();

    private static final SdkField<String> DOCUMENTATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentationUrl").getter(getter(DescribeTypeResponse::documentationUrl))
            .setter(setter(Builder::documentationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationUrl").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(DescribeTypeResponse::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<Instant> TIME_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TimeCreated").getter(getter(DescribeTypeResponse::timeCreated)).setter(setter(Builder::timeCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCreated").build()).build();

    private static final SdkField<String> CONFIGURATION_SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSchema").getter(getter(DescribeTypeResponse::configurationSchema))
            .setter(setter(Builder::configurationSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSchema").build())
            .build();

    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherId").getter(getter(DescribeTypeResponse::publisherId)).setter(setter(Builder::publisherId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()).build();

    private static final SdkField<String> ORIGINAL_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginalTypeName").getter(getter(DescribeTypeResponse::originalTypeName))
            .setter(setter(Builder::originalTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTypeName").build()).build();

    private static final SdkField<String> ORIGINAL_TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginalTypeArn").getter(getter(DescribeTypeResponse::originalTypeArn))
            .setter(setter(Builder::originalTypeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTypeArn").build()).build();

    private static final SdkField<String> PUBLIC_VERSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicVersionNumber").getter(getter(DescribeTypeResponse::publicVersionNumber))
            .setter(setter(Builder::publicVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicVersionNumber").build())
            .build();

    private static final SdkField<String> LATEST_PUBLIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestPublicVersion").getter(getter(DescribeTypeResponse::latestPublicVersion))
            .setter(setter(Builder::latestPublicVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestPublicVersion").build())
            .build();

    private static final SdkField<Boolean> IS_ACTIVATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsActivated").getter(getter(DescribeTypeResponse::isActivated)).setter(setter(Builder::isActivated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsActivated").build()).build();

    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoUpdate").getter(getter(DescribeTypeResponse::autoUpdate)).setter(setter(Builder::autoUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD,
            TYPE_NAME_FIELD, DEFAULT_VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD, TYPE_TESTS_STATUS_FIELD,
            TYPE_TESTS_STATUS_DESCRIPTION_FIELD, DESCRIPTION_FIELD, SCHEMA_FIELD, PROVISIONING_TYPE_FIELD,
            DEPRECATED_STATUS_FIELD, LOGGING_CONFIG_FIELD, REQUIRED_ACTIVATED_TYPES_FIELD, EXECUTION_ROLE_ARN_FIELD,
            VISIBILITY_FIELD, SOURCE_URL_FIELD, DOCUMENTATION_URL_FIELD, LAST_UPDATED_FIELD, TIME_CREATED_FIELD,
            CONFIGURATION_SCHEMA_FIELD, PUBLISHER_ID_FIELD, ORIGINAL_TYPE_NAME_FIELD, ORIGINAL_TYPE_ARN_FIELD,
            PUBLIC_VERSION_NUMBER_FIELD, LATEST_PUBLIC_VERSION_FIELD, IS_ACTIVATED_FIELD, AUTO_UPDATE_FIELD));

    private final String arn;

    private final String type;

    private final String typeName;

    private final String defaultVersionId;

    private final Boolean isDefaultVersion;

    private final String typeTestsStatus;

    private final String typeTestsStatusDescription;

    private final String description;

    private final String schema;

    private final String provisioningType;

    private final String deprecatedStatus;

    private final LoggingConfig loggingConfig;

    private final List<RequiredActivatedType> requiredActivatedTypes;

    private final String executionRoleArn;

    private final String visibility;

    private final String sourceUrl;

    private final String documentationUrl;

    private final Instant lastUpdated;

    private final Instant timeCreated;

    private final String configurationSchema;

    private final String publisherId;

    private final String originalTypeName;

    private final String originalTypeArn;

    private final String publicVersionNumber;

    private final String latestPublicVersion;

    private final Boolean isActivated;

    private final Boolean autoUpdate;

    private DescribeTypeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.defaultVersionId = builder.defaultVersionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.typeTestsStatus = builder.typeTestsStatus;
        this.typeTestsStatusDescription = builder.typeTestsStatusDescription;
        this.description = builder.description;
        this.schema = builder.schema;
        this.provisioningType = builder.provisioningType;
        this.deprecatedStatus = builder.deprecatedStatus;
        this.loggingConfig = builder.loggingConfig;
        this.requiredActivatedTypes = builder.requiredActivatedTypes;
        this.executionRoleArn = builder.executionRoleArn;
        this.visibility = builder.visibility;
        this.sourceUrl = builder.sourceUrl;
        this.documentationUrl = builder.documentationUrl;
        this.lastUpdated = builder.lastUpdated;
        this.timeCreated = builder.timeCreated;
        this.configurationSchema = builder.configurationSchema;
        this.publisherId = builder.publisherId;
        this.originalTypeName = builder.originalTypeName;
        this.originalTypeArn = builder.originalTypeArn;
        this.publicVersionNumber = builder.publicVersionNumber;
        this.latestPublicVersion = builder.latestPublicVersion;
        this.isActivated = builder.isActivated;
        this.autoUpdate = builder.autoUpdate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the extension.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the extension.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.
     * @see RegistryType
     */
    public final RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.
     * @see RegistryType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * <p>
     * If the extension is a public third-party type you have activated with a type name alias, CloudFormation returns
     * the type name alias. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType</a>.
     * </p>
     * 
     * @return The name of the extension.</p>
     *         <p>
     *         If the extension is a public third-party type you have activated with a type name alias, CloudFormation
     *         returns the type name alias. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html"
     *         >ActivateType</a>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The ID of the default version of the extension. The default version is used when the extension version is not
     * specified.
     * </p>
     * <p>
     * This applies only to private extensions you have registered in your account. For public extensions, both those
     * provided by Amazon and published by third parties, CloudFormation returns <code>null</code>. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * <p>
     * To set the default version of an extension, use <code> <a>SetTypeDefaultVersion</a> </code>.
     * </p>
     * 
     * @return The ID of the default version of the extension. The default version is used when the extension version is
     *         not specified.</p>
     *         <p>
     *         This applies only to private extensions you have registered in your account. For public extensions, both
     *         those provided by Amazon and published by third parties, CloudFormation returns <code>null</code>. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
     *         >RegisterType</a>.
     *         </p>
     *         <p>
     *         To set the default version of an extension, use <code> <a>SetTypeDefaultVersion</a> </code>.
     */
    public final String defaultVersionId() {
        return defaultVersionId;
    }

    /**
     * <p>
     * Whether the specified extension version is set as the default version.
     * </p>
     * <p>
     * This applies only to private extensions you have registered in your account, and extensions published by Amazon.
     * For public third-party extensions, whether or not they are activated in your account, CloudFormation returns
     * <code>null</code>.
     * </p>
     * 
     * @return Whether the specified extension version is set as the default version.</p>
     *         <p>
     *         This applies only to private extensions you have registered in your account, and extensions published by
     *         Amazon. For public third-party extensions, whether or not they are activated in your account,
     *         CloudFormation returns <code>null</code>.
     */
    public final Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    /**
     * <p>
     * The contract test status of the registered extension version. To return the extension test status of a specifc
     * extension version, you must specify <code>VersionId</code>.
     * </p>
     * <p>
     * This applies only to registered private extension versions. CloudFormation does not return this information for
     * public extensions, whether or not they are activated in your account.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PASSED</code>: The extension has passed all its contract tests.
     * </p>
     * <p>
     * An extension must have a test status of <code>PASSED</code> before it can be published. For more information, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface User
     * Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The extension has failed one or more contract tests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>: Contract tests are currently being performed on the extension.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_TESTED</code>: Contract tests have not been performed on the extension.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeTestsStatus}
     * will return {@link TypeTestsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeTestsStatusAsString}.
     * </p>
     * 
     * @return The contract test status of the registered extension version. To return the extension test status of a
     *         specifc extension version, you must specify <code>VersionId</code>. </p>
     *         <p>
     *         This applies only to registered private extension versions. CloudFormation does not return this
     *         information for public extensions, whether or not they are activated in your account.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PASSED</code>: The extension has passed all its contract tests.
     *         </p>
     *         <p>
     *         An extension must have a test status of <code>PASSED</code> before it can be published. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html"
     *         >Publishing extensions to make them available for public use</a> in the <i>CloudFormation Command Line
     *         Interface User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The extension has failed one or more contract tests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>: Contract tests are currently being performed on the extension.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_TESTED</code>: Contract tests have not been performed on the extension.
     *         </p>
     *         </li>
     * @see TypeTestsStatus
     */
    public final TypeTestsStatus typeTestsStatus() {
        return TypeTestsStatus.fromValue(typeTestsStatus);
    }

    /**
     * <p>
     * The contract test status of the registered extension version. To return the extension test status of a specifc
     * extension version, you must specify <code>VersionId</code>.
     * </p>
     * <p>
     * This applies only to registered private extension versions. CloudFormation does not return this information for
     * public extensions, whether or not they are activated in your account.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PASSED</code>: The extension has passed all its contract tests.
     * </p>
     * <p>
     * An extension must have a test status of <code>PASSED</code> before it can be published. For more information, see
     * <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing
     * extensions to make them available for public use</a> in the <i>CloudFormation Command Line Interface User
     * Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The extension has failed one or more contract tests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>: Contract tests are currently being performed on the extension.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_TESTED</code>: Contract tests have not been performed on the extension.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeTestsStatus}
     * will return {@link TypeTestsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeTestsStatusAsString}.
     * </p>
     * 
     * @return The contract test status of the registered extension version. To return the extension test status of a
     *         specifc extension version, you must specify <code>VersionId</code>. </p>
     *         <p>
     *         This applies only to registered private extension versions. CloudFormation does not return this
     *         information for public extensions, whether or not they are activated in your account.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PASSED</code>: The extension has passed all its contract tests.
     *         </p>
     *         <p>
     *         An extension must have a test status of <code>PASSED</code> before it can be published. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html"
     *         >Publishing extensions to make them available for public use</a> in the <i>CloudFormation Command Line
     *         Interface User Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The extension has failed one or more contract tests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>: Contract tests are currently being performed on the extension.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_TESTED</code>: Contract tests have not been performed on the extension.
     *         </p>
     *         </li>
     * @see TypeTestsStatus
     */
    public final String typeTestsStatusAsString() {
        return typeTestsStatus;
    }

    /**
     * <p>
     * The description of the test status. To return the extension test status of a specifc extension version, you must
     * specify <code>VersionId</code>.
     * </p>
     * <p>
     * This applies only to registered private extension versions. CloudFormation does not return this information for
     * public extensions, whether or not they are activated in your account.
     * </p>
     * 
     * @return The description of the test status. To return the extension test status of a specifc extension version,
     *         you must specify <code>VersionId</code>. </p>
     *         <p>
     *         This applies only to registered private extension versions. CloudFormation does not return this
     *         information for public extensions, whether or not they are activated in your account.
     */
    public final String typeTestsStatusDescription() {
        return typeTestsStatusDescription;
    }

    /**
     * <p>
     * The description of the extension.
     * </p>
     * 
     * @return The description of the extension.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The schema that defines the extension.
     * </p>
     * <p>
     * For more information on extension schemas, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource
     * Provider Schema</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * 
     * @return The schema that defines the extension.</p>
     *         <p>
     *         For more information on extension schemas, see <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource
     *         Provider Schema</a> in the <i>CloudFormation CLI User Guide</i>.
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * For resource type extensions, the provisioning behavior of the resource type. CloudFormation determines the
     * provisioning type during registration, based on the types of handlers in the schema handler package submitted.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULLY_MUTABLE</code>: The resource type includes an update handler to process updates to the type during
     * stack update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMMUTABLE</code>: The resource type does not include an update handler, so the type cannot be updated and
     * must instead be replaced during stack update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_PROVISIONABLE</code>: The resource type does not include all of the following handlers, and therefore
     * cannot actually be provisioned.
     * </p>
     * <ul>
     * <li>
     * <p>
     * create
     * </p>
     * </li>
     * <li>
     * <p>
     * read
     * </p>
     * </li>
     * <li>
     * <p>
     * delete
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioningType}
     * will return {@link ProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisioningTypeAsString}.
     * </p>
     * 
     * @return For resource type extensions, the provisioning behavior of the resource type. CloudFormation determines
     *         the provisioning type during registration, based on the types of handlers in the schema handler package
     *         submitted.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULLY_MUTABLE</code>: The resource type includes an update handler to process updates to the type
     *         during stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMMUTABLE</code>: The resource type does not include an update handler, so the type cannot be
     *         updated and must instead be replaced during stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_PROVISIONABLE</code>: The resource type does not include all of the following handlers, and
     *         therefore cannot actually be provisioned.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         create
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         read
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         delete
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see ProvisioningType
     */
    public final ProvisioningType provisioningType() {
        return ProvisioningType.fromValue(provisioningType);
    }

    /**
     * <p>
     * For resource type extensions, the provisioning behavior of the resource type. CloudFormation determines the
     * provisioning type during registration, based on the types of handlers in the schema handler package submitted.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULLY_MUTABLE</code>: The resource type includes an update handler to process updates to the type during
     * stack update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMMUTABLE</code>: The resource type does not include an update handler, so the type cannot be updated and
     * must instead be replaced during stack update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_PROVISIONABLE</code>: The resource type does not include all of the following handlers, and therefore
     * cannot actually be provisioned.
     * </p>
     * <ul>
     * <li>
     * <p>
     * create
     * </p>
     * </li>
     * <li>
     * <p>
     * read
     * </p>
     * </li>
     * <li>
     * <p>
     * delete
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioningType}
     * will return {@link ProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisioningTypeAsString}.
     * </p>
     * 
     * @return For resource type extensions, the provisioning behavior of the resource type. CloudFormation determines
     *         the provisioning type during registration, based on the types of handlers in the schema handler package
     *         submitted.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULLY_MUTABLE</code>: The resource type includes an update handler to process updates to the type
     *         during stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMMUTABLE</code>: The resource type does not include an update handler, so the type cannot be
     *         updated and must instead be replaced during stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_PROVISIONABLE</code>: The resource type does not include all of the following handlers, and
     *         therefore cannot actually be provisioned.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         create
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         read
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         delete
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see ProvisioningType
     */
    public final String provisioningTypeAsString() {
        return provisioningType;
    }

    /**
     * <p>
     * The deprecation status of the extension version.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LIVE</code>: The extension is activated or registered and can be used in CloudFormation operations,
     * dependent on its provisioning behavior and visibility scope.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code>: The extension has been deactivated or deregistered and can no longer be used in
     * CloudFormation operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For public third-party extensions, CloudFormation returns <code>null</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deprecatedStatus}
     * will return {@link DeprecatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deprecatedStatusAsString}.
     * </p>
     * 
     * @return The deprecation status of the extension version.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LIVE</code>: The extension is activated or registered and can be used in CloudFormation operations,
     *         dependent on its provisioning behavior and visibility scope.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code>: The extension has been deactivated or deregistered and can no longer be used in
     *         CloudFormation operations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For public third-party extensions, CloudFormation returns <code>null</code>.
     * @see DeprecatedStatus
     */
    public final DeprecatedStatus deprecatedStatus() {
        return DeprecatedStatus.fromValue(deprecatedStatus);
    }

    /**
     * <p>
     * The deprecation status of the extension version.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LIVE</code>: The extension is activated or registered and can be used in CloudFormation operations,
     * dependent on its provisioning behavior and visibility scope.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code>: The extension has been deactivated or deregistered and can no longer be used in
     * CloudFormation operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For public third-party extensions, CloudFormation returns <code>null</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deprecatedStatus}
     * will return {@link DeprecatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deprecatedStatusAsString}.
     * </p>
     * 
     * @return The deprecation status of the extension version.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LIVE</code>: The extension is activated or registered and can be used in CloudFormation operations,
     *         dependent on its provisioning behavior and visibility scope.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code>: The extension has been deactivated or deregistered and can no longer be used in
     *         CloudFormation operations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For public third-party extensions, CloudFormation returns <code>null</code>.
     * @see DeprecatedStatus
     */
    public final String deprecatedStatusAsString() {
        return deprecatedStatus;
    }

    /**
     * <p>
     * Contains logging configuration information for private extensions. This applies only to private extensions you
     * have registered in your account. For public extensions, both those provided by Amazon and published by third
     * parties, CloudFormation returns <code>null</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * 
     * @return Contains logging configuration information for private extensions. This applies only to private
     *         extensions you have registered in your account. For public extensions, both those provided by Amazon and
     *         published by third parties, CloudFormation returns <code>null</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
     *         >RegisterType</a>.
     */
    public final LoggingConfig loggingConfig() {
        return loggingConfig;
    }

    /**
     * Returns true if the RequiredActivatedTypes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRequiredActivatedTypes() {
        return requiredActivatedTypes != null && !(requiredActivatedTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For extensions that are modules, the public third-party extensions that must be activated in your account in
     * order for the module itself to be activated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequiredActivatedTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For extensions that are modules, the public third-party extensions that must be activated in your account
     *         in order for the module itself to be activated.
     */
    public final List<RequiredActivatedType> requiredActivatedTypes() {
        return requiredActivatedTypes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM execution role used to register the extension. This applies only to
     * private extensions you have registered in your account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * <p/>
     * <p>
     * If the registered extension calls any Amazon Web Services APIs, you must create an <i> <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that includes
     * the necessary permissions to call those Amazon Web Services APIs, and provision that execution role in your
     * account. CloudFormation then assumes that execution role to provide your extension with the appropriate
     * credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM execution role used to register the extension. This applies
     *         only to private extensions you have registered in your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
     *         >RegisterType</a>.</p>
     *         <p/>
     *         <p>
     *         If the registered extension calls any Amazon Web Services APIs, you must create an <i> <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that
     *         includes the necessary permissions to call those Amazon Web Services APIs, and provision that execution
     *         role in your account. CloudFormation then assumes that execution role to provide your extension with the
     *         appropriate credentials.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The scope at which the extension is visible and usable in CloudFormation operations.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PRIVATE</code>: The extension is only visible and usable within the account in which it is registered.
     * CloudFormation marks any extensions you register as <code>PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC</code>: The extension is publically visible and usable within any Amazon account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The scope at which the extension is visible and usable in CloudFormation operations.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PRIVATE</code>: The extension is only visible and usable within the account in which it is
     *         registered. CloudFormation marks any extensions you register as <code>PRIVATE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC</code>: The extension is publically visible and usable within any Amazon account.
     *         </p>
     *         </li>
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The scope at which the extension is visible and usable in CloudFormation operations.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PRIVATE</code>: The extension is only visible and usable within the account in which it is registered.
     * CloudFormation marks any extensions you register as <code>PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC</code>: The extension is publically visible and usable within any Amazon account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The scope at which the extension is visible and usable in CloudFormation operations.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PRIVATE</code>: The extension is only visible and usable within the account in which it is
     *         registered. CloudFormation marks any extensions you register as <code>PRIVATE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC</code>: The extension is publically visible and usable within any Amazon account.
     *         </p>
     *         </li>
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The URL of the source code for the extension.
     * </p>
     * 
     * @return The URL of the source code for the extension.
     */
    public final String sourceUrl() {
        return sourceUrl;
    }

    /**
     * <p>
     * The URL of a page providing detailed documentation for this extension.
     * </p>
     * 
     * @return The URL of a page providing detailed documentation for this extension.
     */
    public final String documentationUrl() {
        return documentationUrl;
    }

    /**
     * <p>
     * When the specified extension version was registered. This applies only to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Private extensions you have registered in your account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Public extensions you have activated in your account with auto-update specified. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return When the specified extension version was registered. This applies only to:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Private extensions you have registered in your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
     *         >RegisterType</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Public extensions you have activated in your account with auto-update specified. For more information,
     *         see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">
     *         ActivateType</a>.
     *         </p>
     *         </li>
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * When the specified private extension version was registered or activated in your account.
     * </p>
     * 
     * @return When the specified private extension version was registered or activated in your account.
     */
    public final Instant timeCreated() {
        return timeCreated;
    }

    /**
     * <p>
     * A JSON string that represent the current configuration data for the extension in this account and region.
     * </p>
     * <p>
     * To set the configuration data for an extension, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     * >SetTypeConfiguration</a>. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return A JSON string that represent the current configuration data for the extension in this account and
     *         region.</p>
     *         <p>
     *         To set the configuration data for an extension, use <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
     *         >SetTypeConfiguration</a>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
     *         >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String configurationSchema() {
        return configurationSchema;
    }

    /**
     * <p>
     * The publisher ID of the extension publisher.
     * </p>
     * <p>
     * This applies only to public third-party extensions. For private registered extensions, and extensions provided by
     * Amazon, CloudFormation returns <code>null</code>.
     * </p>
     * 
     * @return The publisher ID of the extension publisher.</p>
     *         <p>
     *         This applies only to public third-party extensions. For private registered extensions, and extensions
     *         provided by Amazon, CloudFormation returns <code>null</code>.
     */
    public final String publisherId() {
        return publisherId;
    }

    /**
     * <p>
     * For public extensions that have been activated for this account and region, the type name of the public
     * extension.
     * </p>
     * <p>
     * If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region,
     * CloudFormation treats that alias as the extension's type name within the account and region, not the type name of
     * the public extension. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
     * >Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return For public extensions that have been activated for this account and region, the type name of the public
     *         extension.</p>
     *         <p>
     *         If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region,
     *         CloudFormation treats that alias as the extension's type name within the account and region, not the type
     *         name of the public extension. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
     *         >Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String originalTypeName() {
        return originalTypeName;
    }

    /**
     * <p>
     * For public extensions that have been activated for this account and region, the Amazon Resource Name (ARN) of the
     * public extension.
     * </p>
     * 
     * @return For public extensions that have been activated for this account and region, the Amazon Resource Name
     *         (ARN) of the public extension.
     */
    public final String originalTypeArn() {
        return originalTypeArn;
    }

    /**
     * <p>
     * The version number of a public third-party extension.
     * </p>
     * <p>
     * This applies only if you specify a public extension you have activated in your account, or specify a public
     * extension without specifying a version. For all other extensions, CloudFormation returns <code>null</code>.
     * </p>
     * 
     * @return The version number of a public third-party extension.</p>
     *         <p>
     *         This applies only if you specify a public extension you have activated in your account, or specify a
     *         public extension without specifying a version. For all other extensions, CloudFormation returns
     *         <code>null</code>.
     */
    public final String publicVersionNumber() {
        return publicVersionNumber;
    }

    /**
     * <p>
     * The latest version of a public extension <i>that is available</i> for use.
     * </p>
     * <p>
     * This only applies if you specify a public extension, and you do not specify a version. For all other requests,
     * CloudFormation returns <code>null</code>.
     * </p>
     * 
     * @return The latest version of a public extension <i>that is available</i> for use.</p>
     *         <p>
     *         This only applies if you specify a public extension, and you do not specify a version. For all other
     *         requests, CloudFormation returns <code>null</code>.
     */
    public final String latestPublicVersion() {
        return latestPublicVersion;
    }

    /**
     * <p>
     * Whether or not the extension is activated in the account and region.
     * </p>
     * <p>
     * This only applies to public third-party extensions. For all other extensions, CloudFormation returns
     * <code>null</code>.
     * </p>
     * 
     * @return Whether or not the extension is activated in the account and region.</p>
     *         <p>
     *         This only applies to public third-party extensions. For all other extensions, CloudFormation returns
     *         <code>null</code>.
     */
    public final Boolean isActivated() {
        return isActivated;
    }

    /**
     * <p>
     * Whether CloudFormation automatically updates the extension in this account and region when a new <i>minor</i>
     * version is published by the extension publisher. Major versions released by the publisher must be manually
     * updated. For more information, see <a
     * href="AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable">Activating public
     * extensions for use in your account</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return Whether CloudFormation automatically updates the extension in this account and region when a new
     *         <i>minor</i> version is published by the extension publisher. Major versions released by the publisher
     *         must be manually updated. For more information, see <a
     *         href="AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable">Activating public
     *         extensions for use in your account</a> in the <i>CloudFormation User Guide</i>.
     */
    public final Boolean autoUpdate() {
        return autoUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(typeTestsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeTestsStatusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deprecatedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequiredActivatedTypes() ? requiredActivatedTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(documentationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSchema());
        hashCode = 31 * hashCode + Objects.hashCode(publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(originalTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(originalTypeArn());
        hashCode = 31 * hashCode + Objects.hashCode(publicVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(latestPublicVersion());
        hashCode = 31 * hashCode + Objects.hashCode(isActivated());
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTypeResponse)) {
            return false;
        }
        DescribeTypeResponse other = (DescribeTypeResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(typeName(), other.typeName()) && Objects.equals(defaultVersionId(), other.defaultVersionId())
                && Objects.equals(isDefaultVersion(), other.isDefaultVersion())
                && Objects.equals(typeTestsStatusAsString(), other.typeTestsStatusAsString())
                && Objects.equals(typeTestsStatusDescription(), other.typeTestsStatusDescription())
                && Objects.equals(description(), other.description()) && Objects.equals(schema(), other.schema())
                && Objects.equals(provisioningTypeAsString(), other.provisioningTypeAsString())
                && Objects.equals(deprecatedStatusAsString(), other.deprecatedStatusAsString())
                && Objects.equals(loggingConfig(), other.loggingConfig())
                && hasRequiredActivatedTypes() == other.hasRequiredActivatedTypes()
                && Objects.equals(requiredActivatedTypes(), other.requiredActivatedTypes())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(sourceUrl(), other.sourceUrl()) && Objects.equals(documentationUrl(), other.documentationUrl())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(timeCreated(), other.timeCreated())
                && Objects.equals(configurationSchema(), other.configurationSchema())
                && Objects.equals(publisherId(), other.publisherId())
                && Objects.equals(originalTypeName(), other.originalTypeName())
                && Objects.equals(originalTypeArn(), other.originalTypeArn())
                && Objects.equals(publicVersionNumber(), other.publicVersionNumber())
                && Objects.equals(latestPublicVersion(), other.latestPublicVersion())
                && Objects.equals(isActivated(), other.isActivated()) && Objects.equals(autoUpdate(), other.autoUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTypeResponse").add("Arn", arn()).add("Type", typeAsString()).add("TypeName", typeName())
                .add("DefaultVersionId", defaultVersionId()).add("IsDefaultVersion", isDefaultVersion())
                .add("TypeTestsStatus", typeTestsStatusAsString())
                .add("TypeTestsStatusDescription", typeTestsStatusDescription()).add("Description", description())
                .add("Schema", schema()).add("ProvisioningType", provisioningTypeAsString())
                .add("DeprecatedStatus", deprecatedStatusAsString()).add("LoggingConfig", loggingConfig())
                .add("RequiredActivatedTypes", hasRequiredActivatedTypes() ? requiredActivatedTypes() : null)
                .add("ExecutionRoleArn", executionRoleArn()).add("Visibility", visibilityAsString())
                .add("SourceUrl", sourceUrl()).add("DocumentationUrl", documentationUrl()).add("LastUpdated", lastUpdated())
                .add("TimeCreated", timeCreated()).add("ConfigurationSchema", configurationSchema())
                .add("PublisherId", publisherId()).add("OriginalTypeName", originalTypeName())
                .add("OriginalTypeArn", originalTypeArn()).add("PublicVersionNumber", publicVersionNumber())
                .add("LatestPublicVersion", latestPublicVersion()).add("IsActivated", isActivated())
                .add("AutoUpdate", autoUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "DefaultVersionId":
            return Optional.ofNullable(clazz.cast(defaultVersionId()));
        case "IsDefaultVersion":
            return Optional.ofNullable(clazz.cast(isDefaultVersion()));
        case "TypeTestsStatus":
            return Optional.ofNullable(clazz.cast(typeTestsStatusAsString()));
        case "TypeTestsStatusDescription":
            return Optional.ofNullable(clazz.cast(typeTestsStatusDescription()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "ProvisioningType":
            return Optional.ofNullable(clazz.cast(provisioningTypeAsString()));
        case "DeprecatedStatus":
            return Optional.ofNullable(clazz.cast(deprecatedStatusAsString()));
        case "LoggingConfig":
            return Optional.ofNullable(clazz.cast(loggingConfig()));
        case "RequiredActivatedTypes":
            return Optional.ofNullable(clazz.cast(requiredActivatedTypes()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "SourceUrl":
            return Optional.ofNullable(clazz.cast(sourceUrl()));
        case "DocumentationUrl":
            return Optional.ofNullable(clazz.cast(documentationUrl()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "TimeCreated":
            return Optional.ofNullable(clazz.cast(timeCreated()));
        case "ConfigurationSchema":
            return Optional.ofNullable(clazz.cast(configurationSchema()));
        case "PublisherId":
            return Optional.ofNullable(clazz.cast(publisherId()));
        case "OriginalTypeName":
            return Optional.ofNullable(clazz.cast(originalTypeName()));
        case "OriginalTypeArn":
            return Optional.ofNullable(clazz.cast(originalTypeArn()));
        case "PublicVersionNumber":
            return Optional.ofNullable(clazz.cast(publicVersionNumber()));
        case "LatestPublicVersion":
            return Optional.ofNullable(clazz.cast(latestPublicVersion()));
        case "IsActivated":
            return Optional.ofNullable(clazz.cast(isActivated()));
        case "AutoUpdate":
            return Optional.ofNullable(clazz.cast(autoUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTypeResponse, T> g) {
        return obj -> g.apply((DescribeTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTypeResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the extension.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The kind of extension.
         * </p>
         * 
         * @param type
         *        The kind of extension.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of extension.
         * </p>
         * 
         * @param type
         *        The kind of extension.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the extension.
         * </p>
         * <p>
         * If the extension is a public third-party type you have activated with a type name alias, CloudFormation
         * returns the type name alias. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html"
         * >ActivateType</a>.
         * </p>
         * 
         * @param typeName
         *        The name of the extension.</p>
         *        <p>
         *        If the extension is a public third-party type you have activated with a type name alias,
         *        CloudFormation returns the type name alias. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html"
         *        >ActivateType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The ID of the default version of the extension. The default version is used when the extension version is not
         * specified.
         * </p>
         * <p>
         * This applies only to private extensions you have registered in your account. For public extensions, both
         * those provided by Amazon and published by third parties, CloudFormation returns <code>null</code>. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         * >RegisterType</a>.
         * </p>
         * <p>
         * To set the default version of an extension, use <code> <a>SetTypeDefaultVersion</a> </code>.
         * </p>
         * 
         * @param defaultVersionId
         *        The ID of the default version of the extension. The default version is used when the extension version
         *        is not specified.</p>
         *        <p>
         *        This applies only to private extensions you have registered in your account. For public extensions,
         *        both those provided by Amazon and published by third parties, CloudFormation returns <code>null</code>
         *        . For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         *        >RegisterType</a>.
         *        </p>
         *        <p>
         *        To set the default version of an extension, use <code> <a>SetTypeDefaultVersion</a> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionId(String defaultVersionId);

        /**
         * <p>
         * Whether the specified extension version is set as the default version.
         * </p>
         * <p>
         * This applies only to private extensions you have registered in your account, and extensions published by
         * Amazon. For public third-party extensions, whether or not they are activated in your account, CloudFormation
         * returns <code>null</code>.
         * </p>
         * 
         * @param isDefaultVersion
         *        Whether the specified extension version is set as the default version.</p>
         *        <p>
         *        This applies only to private extensions you have registered in your account, and extensions published
         *        by Amazon. For public third-party extensions, whether or not they are activated in your account,
         *        CloudFormation returns <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);

        /**
         * <p>
         * The contract test status of the registered extension version. To return the extension test status of a
         * specifc extension version, you must specify <code>VersionId</code>.
         * </p>
         * <p>
         * This applies only to registered private extension versions. CloudFormation does not return this information
         * for public extensions, whether or not they are activated in your account.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PASSED</code>: The extension has passed all its contract tests.
         * </p>
         * <p>
         * An extension must have a test status of <code>PASSED</code> before it can be published. For more information,
         * see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">
         * Publishing extensions to make them available for public use</a> in the <i>CloudFormation Command Line
         * Interface User Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The extension has failed one or more contract tests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: Contract tests are currently being performed on the extension.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_TESTED</code>: Contract tests have not been performed on the extension.
         * </p>
         * </li>
         * </ul>
         * 
         * @param typeTestsStatus
         *        The contract test status of the registered extension version. To return the extension test status of a
         *        specifc extension version, you must specify <code>VersionId</code>. </p>
         *        <p>
         *        This applies only to registered private extension versions. CloudFormation does not return this
         *        information for public extensions, whether or not they are activated in your account.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PASSED</code>: The extension has passed all its contract tests.
         *        </p>
         *        <p>
         *        An extension must have a test status of <code>PASSED</code> before it can be published. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html"
         *        >Publishing extensions to make them available for public use</a> in the <i>CloudFormation Command Line
         *        Interface User Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The extension has failed one or more contract tests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: Contract tests are currently being performed on the extension.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_TESTED</code>: Contract tests have not been performed on the extension.
         *        </p>
         *        </li>
         * @see TypeTestsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypeTestsStatus
         */
        Builder typeTestsStatus(String typeTestsStatus);

        /**
         * <p>
         * The contract test status of the registered extension version. To return the extension test status of a
         * specifc extension version, you must specify <code>VersionId</code>.
         * </p>
         * <p>
         * This applies only to registered private extension versions. CloudFormation does not return this information
         * for public extensions, whether or not they are activated in your account.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PASSED</code>: The extension has passed all its contract tests.
         * </p>
         * <p>
         * An extension must have a test status of <code>PASSED</code> before it can be published. For more information,
         * see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">
         * Publishing extensions to make them available for public use</a> in the <i>CloudFormation Command Line
         * Interface User Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The extension has failed one or more contract tests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: Contract tests are currently being performed on the extension.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_TESTED</code>: Contract tests have not been performed on the extension.
         * </p>
         * </li>
         * </ul>
         * 
         * @param typeTestsStatus
         *        The contract test status of the registered extension version. To return the extension test status of a
         *        specifc extension version, you must specify <code>VersionId</code>. </p>
         *        <p>
         *        This applies only to registered private extension versions. CloudFormation does not return this
         *        information for public extensions, whether or not they are activated in your account.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PASSED</code>: The extension has passed all its contract tests.
         *        </p>
         *        <p>
         *        An extension must have a test status of <code>PASSED</code> before it can be published. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html"
         *        >Publishing extensions to make them available for public use</a> in the <i>CloudFormation Command Line
         *        Interface User Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The extension has failed one or more contract tests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: Contract tests are currently being performed on the extension.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_TESTED</code>: Contract tests have not been performed on the extension.
         *        </p>
         *        </li>
         * @see TypeTestsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypeTestsStatus
         */
        Builder typeTestsStatus(TypeTestsStatus typeTestsStatus);

        /**
         * <p>
         * The description of the test status. To return the extension test status of a specifc extension version, you
         * must specify <code>VersionId</code>.
         * </p>
         * <p>
         * This applies only to registered private extension versions. CloudFormation does not return this information
         * for public extensions, whether or not they are activated in your account.
         * </p>
         * 
         * @param typeTestsStatusDescription
         *        The description of the test status. To return the extension test status of a specifc extension
         *        version, you must specify <code>VersionId</code>. </p>
         *        <p>
         *        This applies only to registered private extension versions. CloudFormation does not return this
         *        information for public extensions, whether or not they are activated in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeTestsStatusDescription(String typeTestsStatusDescription);

        /**
         * <p>
         * The description of the extension.
         * </p>
         * 
         * @param description
         *        The description of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The schema that defines the extension.
         * </p>
         * <p>
         * For more information on extension schemas, see <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource
         * Provider Schema</a> in the <i>CloudFormation CLI User Guide</i>.
         * </p>
         * 
         * @param schema
         *        The schema that defines the extension.</p>
         *        <p>
         *        For more information on extension schemas, see <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html"
         *        >Resource Provider Schema</a> in the <i>CloudFormation CLI User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * For resource type extensions, the provisioning behavior of the resource type. CloudFormation determines the
         * provisioning type during registration, based on the types of handlers in the schema handler package
         * submitted.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULLY_MUTABLE</code>: The resource type includes an update handler to process updates to the type
         * during stack update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMMUTABLE</code>: The resource type does not include an update handler, so the type cannot be updated
         * and must instead be replaced during stack update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_PROVISIONABLE</code>: The resource type does not include all of the following handlers, and
         * therefore cannot actually be provisioned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * create
         * </p>
         * </li>
         * <li>
         * <p>
         * read
         * </p>
         * </li>
         * <li>
         * <p>
         * delete
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param provisioningType
         *        For resource type extensions, the provisioning behavior of the resource type. CloudFormation
         *        determines the provisioning type during registration, based on the types of handlers in the schema
         *        handler package submitted.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULLY_MUTABLE</code>: The resource type includes an update handler to process updates to the
         *        type during stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMMUTABLE</code>: The resource type does not include an update handler, so the type cannot be
         *        updated and must instead be replaced during stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_PROVISIONABLE</code>: The resource type does not include all of the following handlers, and
         *        therefore cannot actually be provisioned.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        read
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        delete
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see ProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningType
         */
        Builder provisioningType(String provisioningType);

        /**
         * <p>
         * For resource type extensions, the provisioning behavior of the resource type. CloudFormation determines the
         * provisioning type during registration, based on the types of handlers in the schema handler package
         * submitted.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULLY_MUTABLE</code>: The resource type includes an update handler to process updates to the type
         * during stack update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMMUTABLE</code>: The resource type does not include an update handler, so the type cannot be updated
         * and must instead be replaced during stack update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_PROVISIONABLE</code>: The resource type does not include all of the following handlers, and
         * therefore cannot actually be provisioned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * create
         * </p>
         * </li>
         * <li>
         * <p>
         * read
         * </p>
         * </li>
         * <li>
         * <p>
         * delete
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param provisioningType
         *        For resource type extensions, the provisioning behavior of the resource type. CloudFormation
         *        determines the provisioning type during registration, based on the types of handlers in the schema
         *        handler package submitted.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULLY_MUTABLE</code>: The resource type includes an update handler to process updates to the
         *        type during stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMMUTABLE</code>: The resource type does not include an update handler, so the type cannot be
         *        updated and must instead be replaced during stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_PROVISIONABLE</code>: The resource type does not include all of the following handlers, and
         *        therefore cannot actually be provisioned.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        read
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        delete
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see ProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningType
         */
        Builder provisioningType(ProvisioningType provisioningType);

        /**
         * <p>
         * The deprecation status of the extension version.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LIVE</code>: The extension is activated or registered and can be used in CloudFormation operations,
         * dependent on its provisioning behavior and visibility scope.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code>: The extension has been deactivated or deregistered and can no longer be used in
         * CloudFormation operations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For public third-party extensions, CloudFormation returns <code>null</code>.
         * </p>
         * 
         * @param deprecatedStatus
         *        The deprecation status of the extension version.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LIVE</code>: The extension is activated or registered and can be used in CloudFormation
         *        operations, dependent on its provisioning behavior and visibility scope.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code>: The extension has been deactivated or deregistered and can no longer be used
         *        in CloudFormation operations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For public third-party extensions, CloudFormation returns <code>null</code>.
         * @see DeprecatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeprecatedStatus
         */
        Builder deprecatedStatus(String deprecatedStatus);

        /**
         * <p>
         * The deprecation status of the extension version.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LIVE</code>: The extension is activated or registered and can be used in CloudFormation operations,
         * dependent on its provisioning behavior and visibility scope.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code>: The extension has been deactivated or deregistered and can no longer be used in
         * CloudFormation operations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For public third-party extensions, CloudFormation returns <code>null</code>.
         * </p>
         * 
         * @param deprecatedStatus
         *        The deprecation status of the extension version.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LIVE</code>: The extension is activated or registered and can be used in CloudFormation
         *        operations, dependent on its provisioning behavior and visibility scope.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code>: The extension has been deactivated or deregistered and can no longer be used
         *        in CloudFormation operations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For public third-party extensions, CloudFormation returns <code>null</code>.
         * @see DeprecatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeprecatedStatus
         */
        Builder deprecatedStatus(DeprecatedStatus deprecatedStatus);

        /**
         * <p>
         * Contains logging configuration information for private extensions. This applies only to private extensions
         * you have registered in your account. For public extensions, both those provided by Amazon and published by
         * third parties, CloudFormation returns <code>null</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         * >RegisterType</a>.
         * </p>
         * 
         * @param loggingConfig
         *        Contains logging configuration information for private extensions. This applies only to private
         *        extensions you have registered in your account. For public extensions, both those provided by Amazon
         *        and published by third parties, CloudFormation returns <code>null</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">
         *        RegisterType</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfig(LoggingConfig loggingConfig);

        /**
         * <p>
         * Contains logging configuration information for private extensions. This applies only to private extensions
         * you have registered in your account. For public extensions, both those provided by Amazon and published by
         * third parties, CloudFormation returns <code>null</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         * >RegisterType</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingConfig.Builder} avoiding the need to
         * create one manually via {@link LoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingConfig(LoggingConfig)}.
         * 
         * @param loggingConfig
         *        a consumer that will call methods on {@link LoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfig(LoggingConfig)
         */
        default Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return loggingConfig(LoggingConfig.builder().applyMutation(loggingConfig).build());
        }

        /**
         * <p>
         * For extensions that are modules, the public third-party extensions that must be activated in your account in
         * order for the module itself to be activated.
         * </p>
         * 
         * @param requiredActivatedTypes
         *        For extensions that are modules, the public third-party extensions that must be activated in your
         *        account in order for the module itself to be activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredActivatedTypes(Collection<RequiredActivatedType> requiredActivatedTypes);

        /**
         * <p>
         * For extensions that are modules, the public third-party extensions that must be activated in your account in
         * order for the module itself to be activated.
         * </p>
         * 
         * @param requiredActivatedTypes
         *        For extensions that are modules, the public third-party extensions that must be activated in your
         *        account in order for the module itself to be activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredActivatedTypes(RequiredActivatedType... requiredActivatedTypes);

        /**
         * <p>
         * For extensions that are modules, the public third-party extensions that must be activated in your account in
         * order for the module itself to be activated.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RequiredActivatedType>.Builder} avoiding
         * the need to create one manually via {@link List<RequiredActivatedType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RequiredActivatedType>.Builder#build()} is called
         * immediately and its result is passed to {@link #requiredActivatedTypes(List<RequiredActivatedType>)}.
         * 
         * @param requiredActivatedTypes
         *        a consumer that will call methods on {@link List<RequiredActivatedType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requiredActivatedTypes(List<RequiredActivatedType>)
         */
        Builder requiredActivatedTypes(Consumer<RequiredActivatedType.Builder>... requiredActivatedTypes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM execution role used to register the extension. This applies only to
         * private extensions you have registered in your account. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         * >RegisterType</a>.
         * </p>
         * <p/>
         * <p>
         * If the registered extension calls any Amazon Web Services APIs, you must create an <i> <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that
         * includes the necessary permissions to call those Amazon Web Services APIs, and provision that execution role
         * in your account. CloudFormation then assumes that execution role to provide your extension with the
         * appropriate credentials.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM execution role used to register the extension. This applies
         *        only to private extensions you have registered in your account. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         *        >RegisterType</a>.</p>
         *        <p/>
         *        <p>
         *        If the registered extension calls any Amazon Web Services APIs, you must create an <i> <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that
         *        includes the necessary permissions to call those Amazon Web Services APIs, and provision that
         *        execution role in your account. CloudFormation then assumes that execution role to provide your
         *        extension with the appropriate credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The scope at which the extension is visible and usable in CloudFormation operations.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PRIVATE</code>: The extension is only visible and usable within the account in which it is registered.
         * CloudFormation marks any extensions you register as <code>PRIVATE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC</code>: The extension is publically visible and usable within any Amazon account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param visibility
         *        The scope at which the extension is visible and usable in CloudFormation operations.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PRIVATE</code>: The extension is only visible and usable within the account in which it is
         *        registered. CloudFormation marks any extensions you register as <code>PRIVATE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC</code>: The extension is publically visible and usable within any Amazon account.
         *        </p>
         *        </li>
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The scope at which the extension is visible and usable in CloudFormation operations.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PRIVATE</code>: The extension is only visible and usable within the account in which it is registered.
         * CloudFormation marks any extensions you register as <code>PRIVATE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC</code>: The extension is publically visible and usable within any Amazon account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param visibility
         *        The scope at which the extension is visible and usable in CloudFormation operations.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PRIVATE</code>: The extension is only visible and usable within the account in which it is
         *        registered. CloudFormation marks any extensions you register as <code>PRIVATE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC</code>: The extension is publically visible and usable within any Amazon account.
         *        </p>
         *        </li>
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The URL of the source code for the extension.
         * </p>
         * 
         * @param sourceUrl
         *        The URL of the source code for the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(String sourceUrl);

        /**
         * <p>
         * The URL of a page providing detailed documentation for this extension.
         * </p>
         * 
         * @param documentationUrl
         *        The URL of a page providing detailed documentation for this extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationUrl(String documentationUrl);

        /**
         * <p>
         * When the specified extension version was registered. This applies only to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Private extensions you have registered in your account. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         * >RegisterType</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Public extensions you have activated in your account with auto-update specified. For more information, see <a
         * href
         * ="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">ActivateType</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastUpdated
         *        When the specified extension version was registered. This applies only to:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Private extensions you have registered in your account. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         *        >RegisterType</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Public extensions you have activated in your account with auto-update specified. For more information,
         *        see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">
         *        ActivateType</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * When the specified private extension version was registered or activated in your account.
         * </p>
         * 
         * @param timeCreated
         *        When the specified private extension version was registered or activated in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCreated(Instant timeCreated);

        /**
         * <p>
         * A JSON string that represent the current configuration data for the extension in this account and region.
         * </p>
         * <p>
         * To set the configuration data for an extension, use <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
         * >SetTypeConfiguration</a>. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
         * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param configurationSchema
         *        A JSON string that represent the current configuration data for the extension in this account and
         *        region.</p>
         *        <p>
         *        To set the configuration data for an extension, use <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html"
         *        >SetTypeConfiguration</a>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
         *        >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSchema(String configurationSchema);

        /**
         * <p>
         * The publisher ID of the extension publisher.
         * </p>
         * <p>
         * This applies only to public third-party extensions. For private registered extensions, and extensions
         * provided by Amazon, CloudFormation returns <code>null</code>.
         * </p>
         * 
         * @param publisherId
         *        The publisher ID of the extension publisher.</p>
         *        <p>
         *        This applies only to public third-party extensions. For private registered extensions, and extensions
         *        provided by Amazon, CloudFormation returns <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisherId(String publisherId);

        /**
         * <p>
         * For public extensions that have been activated for this account and region, the type name of the public
         * extension.
         * </p>
         * <p>
         * If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region,
         * CloudFormation treats that alias as the extension's type name within the account and region, not the type
         * name of the public extension. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
         * >Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param originalTypeName
         *        For public extensions that have been activated for this account and region, the type name of the
         *        public extension.</p>
         *        <p>
         *        If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and region,
         *        CloudFormation treats that alias as the extension's type name within the account and region, not the
         *        type name of the public extension. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
         *        >Specifying aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalTypeName(String originalTypeName);

        /**
         * <p>
         * For public extensions that have been activated for this account and region, the Amazon Resource Name (ARN) of
         * the public extension.
         * </p>
         * 
         * @param originalTypeArn
         *        For public extensions that have been activated for this account and region, the Amazon Resource Name
         *        (ARN) of the public extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalTypeArn(String originalTypeArn);

        /**
         * <p>
         * The version number of a public third-party extension.
         * </p>
         * <p>
         * This applies only if you specify a public extension you have activated in your account, or specify a public
         * extension without specifying a version. For all other extensions, CloudFormation returns <code>null</code>.
         * </p>
         * 
         * @param publicVersionNumber
         *        The version number of a public third-party extension.</p>
         *        <p>
         *        This applies only if you specify a public extension you have activated in your account, or specify a
         *        public extension without specifying a version. For all other extensions, CloudFormation returns
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicVersionNumber(String publicVersionNumber);

        /**
         * <p>
         * The latest version of a public extension <i>that is available</i> for use.
         * </p>
         * <p>
         * This only applies if you specify a public extension, and you do not specify a version. For all other
         * requests, CloudFormation returns <code>null</code>.
         * </p>
         * 
         * @param latestPublicVersion
         *        The latest version of a public extension <i>that is available</i> for use.</p>
         *        <p>
         *        This only applies if you specify a public extension, and you do not specify a version. For all other
         *        requests, CloudFormation returns <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestPublicVersion(String latestPublicVersion);

        /**
         * <p>
         * Whether or not the extension is activated in the account and region.
         * </p>
         * <p>
         * This only applies to public third-party extensions. For all other extensions, CloudFormation returns
         * <code>null</code>.
         * </p>
         * 
         * @param isActivated
         *        Whether or not the extension is activated in the account and region.</p>
         *        <p>
         *        This only applies to public third-party extensions. For all other extensions, CloudFormation returns
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActivated(Boolean isActivated);

        /**
         * <p>
         * Whether CloudFormation automatically updates the extension in this account and region when a new <i>minor</i>
         * version is published by the extension publisher. Major versions released by the publisher must be manually
         * updated. For more information, see <a
         * href="AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable">Activating public
         * extensions for use in your account</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param autoUpdate
         *        Whether CloudFormation automatically updates the extension in this account and region when a new
         *        <i>minor</i> version is published by the extension publisher. Major versions released by the publisher
         *        must be manually updated. For more information, see <a
         *        href="AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable">Activating
         *        public extensions for use in your account</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdate(Boolean autoUpdate);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String arn;

        private String type;

        private String typeName;

        private String defaultVersionId;

        private Boolean isDefaultVersion;

        private String typeTestsStatus;

        private String typeTestsStatusDescription;

        private String description;

        private String schema;

        private String provisioningType;

        private String deprecatedStatus;

        private LoggingConfig loggingConfig;

        private List<RequiredActivatedType> requiredActivatedTypes = DefaultSdkAutoConstructList.getInstance();

        private String executionRoleArn;

        private String visibility;

        private String sourceUrl;

        private String documentationUrl;

        private Instant lastUpdated;

        private Instant timeCreated;

        private String configurationSchema;

        private String publisherId;

        private String originalTypeName;

        private String originalTypeArn;

        private String publicVersionNumber;

        private String latestPublicVersion;

        private Boolean isActivated;

        private Boolean autoUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTypeResponse model) {
            super(model);
            arn(model.arn);
            type(model.type);
            typeName(model.typeName);
            defaultVersionId(model.defaultVersionId);
            isDefaultVersion(model.isDefaultVersion);
            typeTestsStatus(model.typeTestsStatus);
            typeTestsStatusDescription(model.typeTestsStatusDescription);
            description(model.description);
            schema(model.schema);
            provisioningType(model.provisioningType);
            deprecatedStatus(model.deprecatedStatus);
            loggingConfig(model.loggingConfig);
            requiredActivatedTypes(model.requiredActivatedTypes);
            executionRoleArn(model.executionRoleArn);
            visibility(model.visibility);
            sourceUrl(model.sourceUrl);
            documentationUrl(model.documentationUrl);
            lastUpdated(model.lastUpdated);
            timeCreated(model.timeCreated);
            configurationSchema(model.configurationSchema);
            publisherId(model.publisherId);
            originalTypeName(model.originalTypeName);
            originalTypeArn(model.originalTypeArn);
            publicVersionNumber(model.publicVersionNumber);
            latestPublicVersion(model.latestPublicVersion);
            isActivated(model.isActivated);
            autoUpdate(model.autoUpdate);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getDefaultVersionId() {
            return defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public final String getTypeTestsStatus() {
            return typeTestsStatus;
        }

        @Override
        public final Builder typeTestsStatus(String typeTestsStatus) {
            this.typeTestsStatus = typeTestsStatus;
            return this;
        }

        @Override
        public final Builder typeTestsStatus(TypeTestsStatus typeTestsStatus) {
            this.typeTestsStatus(typeTestsStatus == null ? null : typeTestsStatus.toString());
            return this;
        }

        public final void setTypeTestsStatus(String typeTestsStatus) {
            this.typeTestsStatus = typeTestsStatus;
        }

        public final String getTypeTestsStatusDescription() {
            return typeTestsStatusDescription;
        }

        @Override
        public final Builder typeTestsStatusDescription(String typeTestsStatusDescription) {
            this.typeTestsStatusDescription = typeTestsStatusDescription;
            return this;
        }

        public final void setTypeTestsStatusDescription(String typeTestsStatusDescription) {
            this.typeTestsStatusDescription = typeTestsStatusDescription;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchema() {
            return schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final String getProvisioningType() {
            return provisioningType;
        }

        @Override
        public final Builder provisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
            return this;
        }

        @Override
        public final Builder provisioningType(ProvisioningType provisioningType) {
            this.provisioningType(provisioningType == null ? null : provisioningType.toString());
            return this;
        }

        public final void setProvisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
        }

        public final String getDeprecatedStatus() {
            return deprecatedStatus;
        }

        @Override
        public final Builder deprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
            return this;
        }

        @Override
        public final Builder deprecatedStatus(DeprecatedStatus deprecatedStatus) {
            this.deprecatedStatus(deprecatedStatus == null ? null : deprecatedStatus.toString());
            return this;
        }

        public final void setDeprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return loggingConfig != null ? loggingConfig.toBuilder() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        public final List<RequiredActivatedType.Builder> getRequiredActivatedTypes() {
            List<RequiredActivatedType.Builder> result = RequiredActivatedTypesCopier.copyToBuilder(this.requiredActivatedTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder requiredActivatedTypes(Collection<RequiredActivatedType> requiredActivatedTypes) {
            this.requiredActivatedTypes = RequiredActivatedTypesCopier.copy(requiredActivatedTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredActivatedTypes(RequiredActivatedType... requiredActivatedTypes) {
            requiredActivatedTypes(Arrays.asList(requiredActivatedTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredActivatedTypes(Consumer<RequiredActivatedType.Builder>... requiredActivatedTypes) {
            requiredActivatedTypes(Stream.of(requiredActivatedTypes)
                    .map(c -> RequiredActivatedType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRequiredActivatedTypes(Collection<RequiredActivatedType.BuilderImpl> requiredActivatedTypes) {
            this.requiredActivatedTypes = RequiredActivatedTypesCopier.copyFromBuilder(requiredActivatedTypes);
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getVisibility() {
            return visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final String getSourceUrl() {
            return sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        public final String getDocumentationUrl() {
            return documentationUrl;
        }

        @Override
        public final Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public final void setDocumentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Instant getTimeCreated() {
            return timeCreated;
        }

        @Override
        public final Builder timeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final String getConfigurationSchema() {
            return configurationSchema;
        }

        @Override
        public final Builder configurationSchema(String configurationSchema) {
            this.configurationSchema = configurationSchema;
            return this;
        }

        public final void setConfigurationSchema(String configurationSchema) {
            this.configurationSchema = configurationSchema;
        }

        public final String getPublisherId() {
            return publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        public final String getOriginalTypeName() {
            return originalTypeName;
        }

        @Override
        public final Builder originalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
            return this;
        }

        public final void setOriginalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
        }

        public final String getOriginalTypeArn() {
            return originalTypeArn;
        }

        @Override
        public final Builder originalTypeArn(String originalTypeArn) {
            this.originalTypeArn = originalTypeArn;
            return this;
        }

        public final void setOriginalTypeArn(String originalTypeArn) {
            this.originalTypeArn = originalTypeArn;
        }

        public final String getPublicVersionNumber() {
            return publicVersionNumber;
        }

        @Override
        public final Builder publicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
            return this;
        }

        public final void setPublicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
        }

        public final String getLatestPublicVersion() {
            return latestPublicVersion;
        }

        @Override
        public final Builder latestPublicVersion(String latestPublicVersion) {
            this.latestPublicVersion = latestPublicVersion;
            return this;
        }

        public final void setLatestPublicVersion(String latestPublicVersion) {
            this.latestPublicVersion = latestPublicVersion;
        }

        public final Boolean getIsActivated() {
            return isActivated;
        }

        @Override
        public final Builder isActivated(Boolean isActivated) {
            this.isActivated = isActivated;
            return this;
        }

        public final void setIsActivated(Boolean isActivated) {
            this.isActivated = isActivated;
        }

        public final Boolean getAutoUpdate() {
            return autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public DescribeTypeResponse build() {
            return new DescribeTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
