/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information concerning the specification of a CloudFormation extension in a given account and Region.
 * </p>
 * <p>
 * For more information, see <a href=
 * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration"
 * >Configuring extensions at the account level</a> in the <i>CloudFormation User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypeConfigurationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<TypeConfigurationDetails.Builder, TypeConfigurationDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TypeConfigurationDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(TypeConfigurationDetails::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Configuration").getter(getter(TypeConfigurationDetails::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(TypeConfigurationDetails::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeArn").getter(getter(TypeConfigurationDetails::typeArn)).setter(setter(Builder::typeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(TypeConfigurationDetails::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_CONFIGURATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefaultConfiguration").getter(getter(TypeConfigurationDetails::isDefaultConfiguration))
            .setter(setter(Builder::isDefaultConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ALIAS_FIELD,
            CONFIGURATION_FIELD, LAST_UPDATED_FIELD, TYPE_ARN_FIELD, TYPE_NAME_FIELD, IS_DEFAULT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String alias;

    private final String configuration;

    private final Instant lastUpdated;

    private final String typeArn;

    private final String typeName;

    private final Boolean isDefaultConfiguration;

    private TypeConfigurationDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.alias = builder.alias;
        this.configuration = builder.configuration;
        this.lastUpdated = builder.lastUpdated;
        this.typeArn = builder.typeArn;
        this.typeName = builder.typeName;
        this.isDefaultConfiguration = builder.isDefaultConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the configuration data, in this account and Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the configuration data, in this account and Region.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The alias specified for this configuration, if one was specified when the configuration was set.
     * </p>
     * 
     * @return The alias specified for this configuration, if one was specified when the configuration was set.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * A JSON string specifying the configuration data for the extension, in this account and Region.
     * </p>
     * <p>
     * If a configuration hasn't been set for a specified extension, CloudFormation returns <code>{}</code>.
     * </p>
     * 
     * @return A JSON string specifying the configuration data for the extension, in this account and Region.</p>
     *         <p>
     *         If a configuration hasn't been set for a specified extension, CloudFormation returns <code>{}</code>.
     */
    public final String configuration() {
        return configuration;
    }

    /**
     * <p>
     * When the configuration data was last updated for this extension.
     * </p>
     * <p>
     * If a configuration hasn't been set for a specified extension, CloudFormation returns <code>null</code>.
     * </p>
     * 
     * @return When the configuration data was last updated for this extension.</p>
     *         <p>
     *         If a configuration hasn't been set for a specified extension, CloudFormation returns <code>null</code>.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the extension, in this account and Region.
     * </p>
     * <p>
     * For public extensions, this will be the ARN assigned when you <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the
     * type</a> in this account and Region. For private extensions, this will be the ARN assigned when you <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the
     * type</a> in this account and Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the extension, in this account and Region.</p>
     *         <p>
     *         For public extensions, this will be the ARN assigned when you <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate
     *         the type</a> in this account and Region. For private extensions, this will be the ARN assigned when you
     *         <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register
     *         the type</a> in this account and Region.
     */
    public final String typeArn() {
        return typeArn;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * 
     * @return The name of the extension.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * Whether this configuration data is the default configuration for the extension.
     * </p>
     * 
     * @return Whether this configuration data is the default configuration for the extension.
     */
    public final Boolean isDefaultConfiguration() {
        return isDefaultConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeConfigurationDetails)) {
            return false;
        }
        TypeConfigurationDetails other = (TypeConfigurationDetails) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(alias(), other.alias())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(lastUpdated(), other.lastUpdated())
                && Objects.equals(typeArn(), other.typeArn()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(isDefaultConfiguration(), other.isDefaultConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypeConfigurationDetails").add("Arn", arn()).add("Alias", alias())
                .add("Configuration", configuration()).add("LastUpdated", lastUpdated()).add("TypeArn", typeArn())
                .add("TypeName", typeName()).add("IsDefaultConfiguration", isDefaultConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "TypeArn":
            return Optional.ofNullable(clazz.cast(typeArn()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "IsDefaultConfiguration":
            return Optional.ofNullable(clazz.cast(isDefaultConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypeConfigurationDetails, T> g) {
        return obj -> g.apply((TypeConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypeConfigurationDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the configuration data, in this account and Region.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the configuration data, in this account and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The alias specified for this configuration, if one was specified when the configuration was set.
         * </p>
         * 
         * @param alias
         *        The alias specified for this configuration, if one was specified when the configuration was set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * A JSON string specifying the configuration data for the extension, in this account and Region.
         * </p>
         * <p>
         * If a configuration hasn't been set for a specified extension, CloudFormation returns <code>{}</code>.
         * </p>
         * 
         * @param configuration
         *        A JSON string specifying the configuration data for the extension, in this account and Region.</p>
         *        <p>
         *        If a configuration hasn't been set for a specified extension, CloudFormation returns <code>{}</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(String configuration);

        /**
         * <p>
         * When the configuration data was last updated for this extension.
         * </p>
         * <p>
         * If a configuration hasn't been set for a specified extension, CloudFormation returns <code>null</code>.
         * </p>
         * 
         * @param lastUpdated
         *        When the configuration data was last updated for this extension.</p>
         *        <p>
         *        If a configuration hasn't been set for a specified extension, CloudFormation returns <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the extension, in this account and Region.
         * </p>
         * <p>
         * For public extensions, this will be the ARN assigned when you <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the
         * type</a> in this account and Region. For private extensions, this will be the ARN assigned when you <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the
         * type</a> in this account and Region.
         * </p>
         * 
         * @param typeArn
         *        The Amazon Resource Name (ARN) for the extension, in this account and Region.</p>
         *        <p>
         *        For public extensions, this will be the ARN assigned when you <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html"
         *        >activate the type</a> in this account and Region. For private extensions, this will be the ARN
         *        assigned when you <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html"
         *        >register the type</a> in this account and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeArn(String typeArn);

        /**
         * <p>
         * The name of the extension.
         * </p>
         * 
         * @param typeName
         *        The name of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * Whether this configuration data is the default configuration for the extension.
         * </p>
         * 
         * @param isDefaultConfiguration
         *        Whether this configuration data is the default configuration for the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultConfiguration(Boolean isDefaultConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String alias;

        private String configuration;

        private Instant lastUpdated;

        private String typeArn;

        private String typeName;

        private Boolean isDefaultConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeConfigurationDetails model) {
            arn(model.arn);
            alias(model.alias);
            configuration(model.configuration);
            lastUpdated(model.lastUpdated);
            typeArn(model.typeArn);
            typeName(model.typeName);
            isDefaultConfiguration(model.isDefaultConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getConfiguration() {
            return configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getTypeArn() {
            return typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final Boolean getIsDefaultConfiguration() {
            return isDefaultConfiguration;
        }

        public final void setIsDefaultConfiguration(Boolean isDefaultConfiguration) {
            this.isDefaultConfiguration = isDefaultConfiguration;
        }

        @Override
        public final Builder isDefaultConfiguration(Boolean isDefaultConfiguration) {
            this.isDefaultConfiguration = isDefaultConfiguration;
            return this;
        }

        @Override
        public TypeConfigurationDetails build() {
            return new TypeConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
