/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the resource scan. This is returned by the <code>ListResourceScan</code> API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceScanSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceScanSummary.Builder, ResourceScanSummary> {
    private static final SdkField<String> RESOURCE_SCAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceScanId").getter(getter(ResourceScanSummary::resourceScanId))
            .setter(setter(Builder::resourceScanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceScanId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ResourceScanSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(ResourceScanSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ResourceScanSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ResourceScanSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Double> PERCENTAGE_COMPLETED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("PercentageCompleted").getter(getter(ResourceScanSummary::percentageCompleted))
            .setter(setter(Builder::percentageCompleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageCompleted").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SCAN_ID_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERCENTAGE_COMPLETED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceScanId;

    private final String status;

    private final String statusReason;

    private final Instant startTime;

    private final Instant endTime;

    private final Double percentageCompleted;

    private ResourceScanSummary(BuilderImpl builder) {
        this.resourceScanId = builder.resourceScanId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.percentageCompleted = builder.percentageCompleted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource scan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource scan.
     */
    public final String resourceScanId() {
        return resourceScanId;
    }

    /**
     * <p>
     * Status of the resource scan.
     * </p>
     * <dl>
     * <dt>INPROGRESS</dt>
     * <dd>
     * <p>
     * The resource scan is still in progress.
     * </p>
     * </dd>
     * <dt>COMPLETE</dt>
     * <dd>
     * <p>
     * The resource scan is complete.
     * </p>
     * </dd>
     * <dt>EXPIRED</dt>
     * <dd>
     * <p>
     * The resource scan has expired.
     * </p>
     * </dd>
     * <dt>FAILED</dt>
     * <dd>
     * <p>
     * The resource scan has failed.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceScanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the resource scan.</p>
     *         <dl>
     *         <dt>INPROGRESS</dt>
     *         <dd>
     *         <p>
     *         The resource scan is still in progress.
     *         </p>
     *         </dd>
     *         <dt>COMPLETE</dt>
     *         <dd>
     *         <p>
     *         The resource scan is complete.
     *         </p>
     *         </dd>
     *         <dt>EXPIRED</dt>
     *         <dd>
     *         <p>
     *         The resource scan has expired.
     *         </p>
     *         </dd>
     *         <dt>FAILED</dt>
     *         <dd>
     *         <p>
     *         The resource scan has failed.
     *         </p>
     *         </dd>
     * @see ResourceScanStatus
     */
    public final ResourceScanStatus status() {
        return ResourceScanStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the resource scan.
     * </p>
     * <dl>
     * <dt>INPROGRESS</dt>
     * <dd>
     * <p>
     * The resource scan is still in progress.
     * </p>
     * </dd>
     * <dt>COMPLETE</dt>
     * <dd>
     * <p>
     * The resource scan is complete.
     * </p>
     * </dd>
     * <dt>EXPIRED</dt>
     * <dd>
     * <p>
     * The resource scan has expired.
     * </p>
     * </dd>
     * <dt>FAILED</dt>
     * <dd>
     * <p>
     * The resource scan has failed.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceScanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the resource scan.</p>
     *         <dl>
     *         <dt>INPROGRESS</dt>
     *         <dd>
     *         <p>
     *         The resource scan is still in progress.
     *         </p>
     *         </dd>
     *         <dt>COMPLETE</dt>
     *         <dd>
     *         <p>
     *         The resource scan is complete.
     *         </p>
     *         </dd>
     *         <dt>EXPIRED</dt>
     *         <dd>
     *         <p>
     *         The resource scan has expired.
     *         </p>
     *         </dd>
     *         <dt>FAILED</dt>
     *         <dd>
     *         <p>
     *         The resource scan has failed.
     *         </p>
     *         </dd>
     * @see ResourceScanStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the resource scan status, providing more information if a failure happened.
     * </p>
     * 
     * @return The reason for the resource scan status, providing more information if a failure happened.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The time that the resource scan was started.
     * </p>
     * 
     * @return The time that the resource scan was started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time that the resource scan was finished.
     * </p>
     * 
     * @return The time that the resource scan was finished.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The percentage of the resource scan that has been completed.
     * </p>
     * 
     * @return The percentage of the resource scan that has been completed.
     */
    public final Double percentageCompleted() {
        return percentageCompleted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceScanId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(percentageCompleted());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceScanSummary)) {
            return false;
        }
        ResourceScanSummary other = (ResourceScanSummary) obj;
        return Objects.equals(resourceScanId(), other.resourceScanId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(percentageCompleted(), other.percentageCompleted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceScanSummary").add("ResourceScanId", resourceScanId()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("PercentageCompleted", percentageCompleted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceScanId":
            return Optional.ofNullable(clazz.cast(resourceScanId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "PercentageCompleted":
            return Optional.ofNullable(clazz.cast(percentageCompleted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceScanSummary, T> g) {
        return obj -> g.apply((ResourceScanSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceScanSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource scan.
         * </p>
         * 
         * @param resourceScanId
         *        The Amazon Resource Name (ARN) of the resource scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceScanId(String resourceScanId);

        /**
         * <p>
         * Status of the resource scan.
         * </p>
         * <dl>
         * <dt>INPROGRESS</dt>
         * <dd>
         * <p>
         * The resource scan is still in progress.
         * </p>
         * </dd>
         * <dt>COMPLETE</dt>
         * <dd>
         * <p>
         * The resource scan is complete.
         * </p>
         * </dd>
         * <dt>EXPIRED</dt>
         * <dd>
         * <p>
         * The resource scan has expired.
         * </p>
         * </dd>
         * <dt>FAILED</dt>
         * <dd>
         * <p>
         * The resource scan has failed.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        Status of the resource scan.</p>
         *        <dl>
         *        <dt>INPROGRESS</dt>
         *        <dd>
         *        <p>
         *        The resource scan is still in progress.
         *        </p>
         *        </dd>
         *        <dt>COMPLETE</dt>
         *        <dd>
         *        <p>
         *        The resource scan is complete.
         *        </p>
         *        </dd>
         *        <dt>EXPIRED</dt>
         *        <dd>
         *        <p>
         *        The resource scan has expired.
         *        </p>
         *        </dd>
         *        <dt>FAILED</dt>
         *        <dd>
         *        <p>
         *        The resource scan has failed.
         *        </p>
         *        </dd>
         * @see ResourceScanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceScanStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the resource scan.
         * </p>
         * <dl>
         * <dt>INPROGRESS</dt>
         * <dd>
         * <p>
         * The resource scan is still in progress.
         * </p>
         * </dd>
         * <dt>COMPLETE</dt>
         * <dd>
         * <p>
         * The resource scan is complete.
         * </p>
         * </dd>
         * <dt>EXPIRED</dt>
         * <dd>
         * <p>
         * The resource scan has expired.
         * </p>
         * </dd>
         * <dt>FAILED</dt>
         * <dd>
         * <p>
         * The resource scan has failed.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        Status of the resource scan.</p>
         *        <dl>
         *        <dt>INPROGRESS</dt>
         *        <dd>
         *        <p>
         *        The resource scan is still in progress.
         *        </p>
         *        </dd>
         *        <dt>COMPLETE</dt>
         *        <dd>
         *        <p>
         *        The resource scan is complete.
         *        </p>
         *        </dd>
         *        <dt>EXPIRED</dt>
         *        <dd>
         *        <p>
         *        The resource scan has expired.
         *        </p>
         *        </dd>
         *        <dt>FAILED</dt>
         *        <dd>
         *        <p>
         *        The resource scan has failed.
         *        </p>
         *        </dd>
         * @see ResourceScanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceScanStatus
         */
        Builder status(ResourceScanStatus status);

        /**
         * <p>
         * The reason for the resource scan status, providing more information if a failure happened.
         * </p>
         * 
         * @param statusReason
         *        The reason for the resource scan status, providing more information if a failure happened.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The time that the resource scan was started.
         * </p>
         * 
         * @param startTime
         *        The time that the resource scan was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time that the resource scan was finished.
         * </p>
         * 
         * @param endTime
         *        The time that the resource scan was finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The percentage of the resource scan that has been completed.
         * </p>
         * 
         * @param percentageCompleted
         *        The percentage of the resource scan that has been completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageCompleted(Double percentageCompleted);
    }

    static final class BuilderImpl implements Builder {
        private String resourceScanId;

        private String status;

        private String statusReason;

        private Instant startTime;

        private Instant endTime;

        private Double percentageCompleted;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceScanSummary model) {
            resourceScanId(model.resourceScanId);
            status(model.status);
            statusReason(model.statusReason);
            startTime(model.startTime);
            endTime(model.endTime);
            percentageCompleted(model.percentageCompleted);
        }

        public final String getResourceScanId() {
            return resourceScanId;
        }

        public final void setResourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
        }

        @Override
        public final Builder resourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceScanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Double getPercentageCompleted() {
            return percentageCompleted;
        }

        public final void setPercentageCompleted(Double percentageCompleted) {
            this.percentageCompleted = percentageCompleted;
        }

        @Override
        public final Builder percentageCompleted(Double percentageCompleted) {
            this.percentageCompleted = percentageCompleted;
            return this;
        }

        @Override
        public ResourceScanSummary build() {
            return new ResourceScanSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
