/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The StackEvent data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StackEvent implements SdkPojo, Serializable, ToCopyableBuilder<StackEvent.Builder, StackEvent> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(StackEvent::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventId").getter(getter(StackEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(StackEvent::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalResourceId").getter(getter(StackEvent::logicalResourceId))
            .setter(setter(Builder::logicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()).build();

    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhysicalResourceId").getter(getter(StackEvent::physicalResourceId))
            .setter(setter(Builder::physicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(StackEvent::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(StackEvent::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceStatus").getter(getter(StackEvent::resourceStatusAsString))
            .setter(setter(Builder::resourceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()).build();

    private static final SdkField<String> RESOURCE_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceStatusReason").getter(getter(StackEvent::resourceStatusReason))
            .setter(setter(Builder::resourceStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatusReason").build())
            .build();

    private static final SdkField<String> RESOURCE_PROPERTIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceProperties").getter(getter(StackEvent::resourceProperties))
            .setter(setter(Builder::resourceProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceProperties").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(StackEvent::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<String> HOOK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookType").getter(getter(StackEvent::hookType)).setter(setter(Builder::hookType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookType").build()).build();

    private static final SdkField<String> HOOK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookStatus").getter(getter(StackEvent::hookStatusAsString)).setter(setter(Builder::hookStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatus").build()).build();

    private static final SdkField<String> HOOK_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookStatusReason").getter(getter(StackEvent::hookStatusReason))
            .setter(setter(Builder::hookStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatusReason").build()).build();

    private static final SdkField<String> HOOK_INVOCATION_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookInvocationPoint").getter(getter(StackEvent::hookInvocationPointAsString))
            .setter(setter(Builder::hookInvocationPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookInvocationPoint").build())
            .build();

    private static final SdkField<String> HOOK_FAILURE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookFailureMode").getter(getter(StackEvent::hookFailureModeAsString))
            .setter(setter(Builder::hookFailureMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookFailureMode").build()).build();

    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedStatus").getter(getter(StackEvent::detailedStatusAsString))
            .setter(setter(Builder::detailedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            EVENT_ID_FIELD, STACK_NAME_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD,
            TIMESTAMP_FIELD, RESOURCE_STATUS_FIELD, RESOURCE_STATUS_REASON_FIELD, RESOURCE_PROPERTIES_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, HOOK_TYPE_FIELD, HOOK_STATUS_FIELD, HOOK_STATUS_REASON_FIELD,
            HOOK_INVOCATION_POINT_FIELD, HOOK_FAILURE_MODE_FIELD, DETAILED_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stackId;

    private final String eventId;

    private final String stackName;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private final String resourceType;

    private final Instant timestamp;

    private final String resourceStatus;

    private final String resourceStatusReason;

    private final String resourceProperties;

    private final String clientRequestToken;

    private final String hookType;

    private final String hookStatus;

    private final String hookStatusReason;

    private final String hookInvocationPoint;

    private final String hookFailureMode;

    private final String detailedStatus;

    private StackEvent(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.eventId = builder.eventId;
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.timestamp = builder.timestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.resourceProperties = builder.resourceProperties;
        this.clientRequestToken = builder.clientRequestToken;
        this.hookType = builder.hookType;
        this.hookStatus = builder.hookStatus;
        this.hookStatusReason = builder.hookStatusReason;
        this.hookInvocationPoint = builder.hookInvocationPoint;
        this.hookFailureMode = builder.hookFailureMode;
        this.detailedStatus = builder.detailedStatus;
    }

    /**
     * <p>
     * The unique ID name of the instance of the stack.
     * </p>
     * 
     * @return The unique ID name of the instance of the stack.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The unique ID of this event.
     * </p>
     * 
     * @return The unique ID of this event.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The name associated with a stack.
     * </p>
     * 
     * @return The name associated with a stack.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The logical name of the resource specified in the template.
     * </p>
     * 
     * @return The logical name of the resource specified in the template.
     */
    public final String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The name or unique identifier associated with the physical instance of the resource.
     * </p>
     * 
     * @return The name or unique identifier associated with the physical instance of the resource.
     */
    public final String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * Type of resource. (For more information, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon
     * Web Services Resource Types Reference</a> in the <i>CloudFormation User Guide</i>.)
     * </p>
     * 
     * @return Type of resource. (For more information, go to <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >Amazon Web Services Resource Types Reference</a> in the <i>CloudFormation User Guide</i>.)
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Time the status was updated.
     * </p>
     * 
     * @return Time the status was updated.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Current status of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Current status of the resource.
     * @see ResourceStatus
     */
    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(resourceStatus);
    }

    /**
     * <p>
     * Current status of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusAsString}.
     * </p>
     * 
     * @return Current status of the resource.
     * @see ResourceStatus
     */
    public final String resourceStatusAsString() {
        return resourceStatus;
    }

    /**
     * <p>
     * Success/failure message associated with the resource.
     * </p>
     * 
     * @return Success/failure message associated with the resource.
     */
    public final String resourceStatusReason() {
        return resourceStatusReason;
    }

    /**
     * <p>
     * BLOB of the properties used to create the resource.
     * </p>
     * 
     * @return BLOB of the properties used to create the resource.
     */
    public final String resourceProperties() {
        return resourceProperties;
    }

    /**
     * <p>
     * The token passed to the operation that generated this event.
     * </p>
     * <p>
     * All events triggered by a given stack operation are assigned the same client request token, which you can use to
     * track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     * <code>ClientRequestToken</code> set as <code>token1</code>.
     * </p>
     * <p>
     * In the console, stack operations display the client request token on the Events tab. Stack operations that are
     * initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify
     * the stack operation . For example, if you create a stack using the console, each stack event would be assigned
     * the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     * </p>
     * 
     * @return The token passed to the operation that generated this event.</p>
     *         <p>
     *         All events triggered by a given stack operation are assigned the same client request token, which you can
     *         use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     *         <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     *         <code>ClientRequestToken</code> set as <code>token1</code>.
     *         </p>
     *         <p>
     *         In the console, stack operations display the client request token on the Events tab. Stack operations
     *         that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
     *         you easily identify the stack operation . For example, if you create a stack using the console, each
     *         stack event would be assigned the same token in the following format:
     *         <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The name of the hook.
     * </p>
     * 
     * @return The name of the hook.
     */
    public final String hookType() {
        return hookType;
    }

    /**
     * <p>
     * Provides the status of the change set hook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hookStatus} will
     * return {@link HookStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hookStatusAsString}.
     * </p>
     * 
     * @return Provides the status of the change set hook.
     * @see HookStatus
     */
    public final HookStatus hookStatus() {
        return HookStatus.fromValue(hookStatus);
    }

    /**
     * <p>
     * Provides the status of the change set hook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hookStatus} will
     * return {@link HookStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hookStatusAsString}.
     * </p>
     * 
     * @return Provides the status of the change set hook.
     * @see HookStatus
     */
    public final String hookStatusAsString() {
        return hookStatus;
    }

    /**
     * <p>
     * Provides the reason for the hook status.
     * </p>
     * 
     * @return Provides the reason for the hook status.
     */
    public final String hookStatusReason() {
        return hookStatusReason;
    }

    /**
     * <p>
     * Invocation points are points in provisioning logic where hooks are initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hookInvocationPoint} will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #hookInvocationPointAsString}.
     * </p>
     * 
     * @return Invocation points are points in provisioning logic where hooks are initiated.
     * @see HookInvocationPoint
     */
    public final HookInvocationPoint hookInvocationPoint() {
        return HookInvocationPoint.fromValue(hookInvocationPoint);
    }

    /**
     * <p>
     * Invocation points are points in provisioning logic where hooks are initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hookInvocationPoint} will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #hookInvocationPointAsString}.
     * </p>
     * 
     * @return Invocation points are points in provisioning logic where hooks are initiated.
     * @see HookInvocationPoint
     */
    public final String hookInvocationPointAsString() {
        return hookInvocationPoint;
    }

    /**
     * <p>
     * Specify the hook failure mode for non-compliant resources in the followings ways.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAIL</code> Stops provisioning resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARN</code> Allows provisioning to continue with a warning message.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hookFailureMode}
     * will return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hookFailureModeAsString}.
     * </p>
     * 
     * @return Specify the hook failure mode for non-compliant resources in the followings ways.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAIL</code> Stops provisioning resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARN</code> Allows provisioning to continue with a warning message.
     *         </p>
     *         </li>
     * @see HookFailureMode
     */
    public final HookFailureMode hookFailureMode() {
        return HookFailureMode.fromValue(hookFailureMode);
    }

    /**
     * <p>
     * Specify the hook failure mode for non-compliant resources in the followings ways.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAIL</code> Stops provisioning resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARN</code> Allows provisioning to continue with a warning message.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hookFailureMode}
     * will return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hookFailureModeAsString}.
     * </p>
     * 
     * @return Specify the hook failure mode for non-compliant resources in the followings ways.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAIL</code> Stops provisioning resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARN</code> Allows provisioning to continue with a warning message.
     *         </p>
     *         </li>
     * @see HookFailureMode
     */
    public final String hookFailureModeAsString() {
        return hookFailureMode;
    }

    /**
     * <p>
     * An optional field containing information about the detailed status of the stack event.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONFIGURATION_COMPLETE</code> - all of the resources in the stack have reached that event. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >CloudFormation stack deployment</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>VALIDATION_FAILED</code> - template validation failed because of invalid properties in the template. The
     * <code>ResourceStatusReason</code> field shows what properties are defined incorrectly.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailedStatus}
     * will return {@link DetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #detailedStatusAsString}.
     * </p>
     * 
     * @return An optional field containing information about the detailed status of the stack event.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONFIGURATION_COMPLETE</code> - all of the resources in the stack have reached that event. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     *         >CloudFormation stack deployment</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VALIDATION_FAILED</code> - template validation failed because of invalid properties in the
     *         template. The <code>ResourceStatusReason</code> field shows what properties are defined incorrectly.
     *         </p>
     *         </li>
     * @see DetailedStatus
     */
    public final DetailedStatus detailedStatus() {
        return DetailedStatus.fromValue(detailedStatus);
    }

    /**
     * <p>
     * An optional field containing information about the detailed status of the stack event.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CONFIGURATION_COMPLETE</code> - all of the resources in the stack have reached that event. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     * >CloudFormation stack deployment</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>VALIDATION_FAILED</code> - template validation failed because of invalid properties in the template. The
     * <code>ResourceStatusReason</code> field shows what properties are defined incorrectly.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailedStatus}
     * will return {@link DetailedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #detailedStatusAsString}.
     * </p>
     * 
     * @return An optional field containing information about the detailed status of the stack event.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CONFIGURATION_COMPLETE</code> - all of the resources in the stack have reached that event. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
     *         >CloudFormation stack deployment</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VALIDATION_FAILED</code> - template validation failed because of invalid properties in the
     *         template. The <code>ResourceStatusReason</code> field shows what properties are defined incorrectly.
     *         </p>
     *         </li>
     * @see DetailedStatus
     */
    public final String detailedStatusAsString() {
        return detailedStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(resourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hookType());
        hashCode = 31 * hashCode + Objects.hashCode(hookStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hookStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hookInvocationPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hookFailureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackEvent)) {
            return false;
        }
        StackEvent other = (StackEvent) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(stackName(), other.stackName())
                && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(resourceStatusAsString(), other.resourceStatusAsString())
                && Objects.equals(resourceStatusReason(), other.resourceStatusReason())
                && Objects.equals(resourceProperties(), other.resourceProperties())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(hookType(), other.hookType())
                && Objects.equals(hookStatusAsString(), other.hookStatusAsString())
                && Objects.equals(hookStatusReason(), other.hookStatusReason())
                && Objects.equals(hookInvocationPointAsString(), other.hookInvocationPointAsString())
                && Objects.equals(hookFailureModeAsString(), other.hookFailureModeAsString())
                && Objects.equals(detailedStatusAsString(), other.detailedStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StackEvent").add("StackId", stackId()).add("EventId", eventId()).add("StackName", stackName())
                .add("LogicalResourceId", logicalResourceId()).add("PhysicalResourceId", physicalResourceId())
                .add("ResourceType", resourceType()).add("Timestamp", timestamp())
                .add("ResourceStatus", resourceStatusAsString()).add("ResourceStatusReason", resourceStatusReason())
                .add("ResourceProperties", resourceProperties()).add("ClientRequestToken", clientRequestToken())
                .add("HookType", hookType()).add("HookStatus", hookStatusAsString()).add("HookStatusReason", hookStatusReason())
                .add("HookInvocationPoint", hookInvocationPointAsString()).add("HookFailureMode", hookFailureModeAsString())
                .add("DetailedStatus", detailedStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "LogicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "PhysicalResourceId":
            return Optional.ofNullable(clazz.cast(physicalResourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "ResourceStatus":
            return Optional.ofNullable(clazz.cast(resourceStatusAsString()));
        case "ResourceStatusReason":
            return Optional.ofNullable(clazz.cast(resourceStatusReason()));
        case "ResourceProperties":
            return Optional.ofNullable(clazz.cast(resourceProperties()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "HookType":
            return Optional.ofNullable(clazz.cast(hookType()));
        case "HookStatus":
            return Optional.ofNullable(clazz.cast(hookStatusAsString()));
        case "HookStatusReason":
            return Optional.ofNullable(clazz.cast(hookStatusReason()));
        case "HookInvocationPoint":
            return Optional.ofNullable(clazz.cast(hookInvocationPointAsString()));
        case "HookFailureMode":
            return Optional.ofNullable(clazz.cast(hookFailureModeAsString()));
        case "DetailedStatus":
            return Optional.ofNullable(clazz.cast(detailedStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackEvent, T> g) {
        return obj -> g.apply((StackEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StackEvent> {
        /**
         * <p>
         * The unique ID name of the instance of the stack.
         * </p>
         * 
         * @param stackId
         *        The unique ID name of the instance of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The unique ID of this event.
         * </p>
         * 
         * @param eventId
         *        The unique ID of this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The name associated with a stack.
         * </p>
         * 
         * @param stackName
         *        The name associated with a stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The logical name of the resource specified in the template.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical name of the resource specified in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The name or unique identifier associated with the physical instance of the resource.
         * </p>
         * 
         * @param physicalResourceId
         *        The name or unique identifier associated with the physical instance of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * Type of resource. (For more information, go to <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >Amazon Web Services Resource Types Reference</a> in the <i>CloudFormation User Guide</i>.)
         * </p>
         * 
         * @param resourceType
         *        Type of resource. (For more information, go to <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >Amazon Web Services Resource Types Reference</a> in the <i>CloudFormation User Guide</i>.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Time the status was updated.
         * </p>
         * 
         * @param timestamp
         *        Time the status was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(String resourceStatus);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * Success/failure message associated with the resource.
         * </p>
         * 
         * @param resourceStatusReason
         *        Success/failure message associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatusReason(String resourceStatusReason);

        /**
         * <p>
         * BLOB of the properties used to create the resource.
         * </p>
         * 
         * @param resourceProperties
         *        BLOB of the properties used to create the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceProperties(String resourceProperties);

        /**
         * <p>
         * The token passed to the operation that generated this event.
         * </p>
         * <p>
         * All events triggered by a given stack operation are assigned the same client request token, which you can use
         * to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
         * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         * <code>ClientRequestToken</code> set as <code>token1</code>.
         * </p>
         * <p>
         * In the console, stack operations display the client request token on the Events tab. Stack operations that
         * are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily
         * identify the stack operation . For example, if you create a stack using the console, each stack event would
         * be assigned the same token in the following format:
         * <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * </p>
         * 
         * @param clientRequestToken
         *        The token passed to the operation that generated this event.</p>
         *        <p>
         *        All events triggered by a given stack operation are assigned the same client request token, which you
         *        can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the
         *        token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         *        <code>ClientRequestToken</code> set as <code>token1</code>.
         *        </p>
         *        <p>
         *        In the console, stack operations display the client request token on the Events tab. Stack operations
         *        that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
         *        you easily identify the stack operation . For example, if you create a stack using the console, each
         *        stack event would be assigned the same token in the following format:
         *        <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The name of the hook.
         * </p>
         * 
         * @param hookType
         *        The name of the hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookType(String hookType);

        /**
         * <p>
         * Provides the status of the change set hook.
         * </p>
         * 
         * @param hookStatus
         *        Provides the status of the change set hook.
         * @see HookStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookStatus
         */
        Builder hookStatus(String hookStatus);

        /**
         * <p>
         * Provides the status of the change set hook.
         * </p>
         * 
         * @param hookStatus
         *        Provides the status of the change set hook.
         * @see HookStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookStatus
         */
        Builder hookStatus(HookStatus hookStatus);

        /**
         * <p>
         * Provides the reason for the hook status.
         * </p>
         * 
         * @param hookStatusReason
         *        Provides the reason for the hook status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookStatusReason(String hookStatusReason);

        /**
         * <p>
         * Invocation points are points in provisioning logic where hooks are initiated.
         * </p>
         * 
         * @param hookInvocationPoint
         *        Invocation points are points in provisioning logic where hooks are initiated.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder hookInvocationPoint(String hookInvocationPoint);

        /**
         * <p>
         * Invocation points are points in provisioning logic where hooks are initiated.
         * </p>
         * 
         * @param hookInvocationPoint
         *        Invocation points are points in provisioning logic where hooks are initiated.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder hookInvocationPoint(HookInvocationPoint hookInvocationPoint);

        /**
         * <p>
         * Specify the hook failure mode for non-compliant resources in the followings ways.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAIL</code> Stops provisioning resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARN</code> Allows provisioning to continue with a warning message.
         * </p>
         * </li>
         * </ul>
         * 
         * @param hookFailureMode
         *        Specify the hook failure mode for non-compliant resources in the followings ways.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAIL</code> Stops provisioning resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARN</code> Allows provisioning to continue with a warning message.
         *        </p>
         *        </li>
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder hookFailureMode(String hookFailureMode);

        /**
         * <p>
         * Specify the hook failure mode for non-compliant resources in the followings ways.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAIL</code> Stops provisioning resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARN</code> Allows provisioning to continue with a warning message.
         * </p>
         * </li>
         * </ul>
         * 
         * @param hookFailureMode
         *        Specify the hook failure mode for non-compliant resources in the followings ways.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAIL</code> Stops provisioning resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARN</code> Allows provisioning to continue with a warning message.
         *        </p>
         *        </li>
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder hookFailureMode(HookFailureMode hookFailureMode);

        /**
         * <p>
         * An optional field containing information about the detailed status of the stack event.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONFIGURATION_COMPLETE</code> - all of the resources in the stack have reached that event. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
         * >CloudFormation stack deployment</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>VALIDATION_FAILED</code> - template validation failed because of invalid properties in the template.
         * The <code>ResourceStatusReason</code> field shows what properties are defined incorrectly.
         * </p>
         * </li>
         * </ul>
         * 
         * @param detailedStatus
         *        An optional field containing information about the detailed status of the stack event.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONFIGURATION_COMPLETE</code> - all of the resources in the stack have reached that event. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
         *        >CloudFormation stack deployment</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VALIDATION_FAILED</code> - template validation failed because of invalid properties in the
         *        template. The <code>ResourceStatusReason</code> field shows what properties are defined incorrectly.
         *        </p>
         *        </li>
         * @see DetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailedStatus
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * An optional field containing information about the detailed status of the stack event.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CONFIGURATION_COMPLETE</code> - all of the resources in the stack have reached that event. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
         * >CloudFormation stack deployment</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>VALIDATION_FAILED</code> - template validation failed because of invalid properties in the template.
         * The <code>ResourceStatusReason</code> field shows what properties are defined incorrectly.
         * </p>
         * </li>
         * </ul>
         * 
         * @param detailedStatus
         *        An optional field containing information about the detailed status of the stack event.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CONFIGURATION_COMPLETE</code> - all of the resources in the stack have reached that event. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stack-resource-configuration-complete.html"
         *        >CloudFormation stack deployment</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VALIDATION_FAILED</code> - template validation failed because of invalid properties in the
         *        template. The <code>ResourceStatusReason</code> field shows what properties are defined incorrectly.
         *        </p>
         *        </li>
         * @see DetailedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailedStatus
         */
        Builder detailedStatus(DetailedStatus detailedStatus);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String eventId;

        private String stackName;

        private String logicalResourceId;

        private String physicalResourceId;

        private String resourceType;

        private Instant timestamp;

        private String resourceStatus;

        private String resourceStatusReason;

        private String resourceProperties;

        private String clientRequestToken;

        private String hookType;

        private String hookStatus;

        private String hookStatusReason;

        private String hookInvocationPoint;

        private String hookFailureMode;

        private String detailedStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StackEvent model) {
            stackId(model.stackId);
            eventId(model.eventId);
            stackName(model.stackName);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
            resourceType(model.resourceType);
            timestamp(model.timestamp);
            resourceStatus(model.resourceStatus);
            resourceStatusReason(model.resourceStatusReason);
            resourceProperties(model.resourceProperties);
            clientRequestToken(model.clientRequestToken);
            hookType(model.hookType);
            hookStatus(model.hookStatus);
            hookStatusReason(model.hookStatusReason);
            hookInvocationPoint(model.hookInvocationPoint);
            hookFailureMode(model.hookFailureMode);
            detailedStatus(model.detailedStatus);
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getResourceStatus() {
            return resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getResourceStatusReason() {
            return resourceStatusReason;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final String getResourceProperties() {
            return resourceProperties;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getHookType() {
            return hookType;
        }

        public final void setHookType(String hookType) {
            this.hookType = hookType;
        }

        @Override
        public final Builder hookType(String hookType) {
            this.hookType = hookType;
            return this;
        }

        public final String getHookStatus() {
            return hookStatus;
        }

        public final void setHookStatus(String hookStatus) {
            this.hookStatus = hookStatus;
        }

        @Override
        public final Builder hookStatus(String hookStatus) {
            this.hookStatus = hookStatus;
            return this;
        }

        @Override
        public final Builder hookStatus(HookStatus hookStatus) {
            this.hookStatus(hookStatus == null ? null : hookStatus.toString());
            return this;
        }

        public final String getHookStatusReason() {
            return hookStatusReason;
        }

        public final void setHookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
        }

        @Override
        public final Builder hookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
            return this;
        }

        public final String getHookInvocationPoint() {
            return hookInvocationPoint;
        }

        public final void setHookInvocationPoint(String hookInvocationPoint) {
            this.hookInvocationPoint = hookInvocationPoint;
        }

        @Override
        public final Builder hookInvocationPoint(String hookInvocationPoint) {
            this.hookInvocationPoint = hookInvocationPoint;
            return this;
        }

        @Override
        public final Builder hookInvocationPoint(HookInvocationPoint hookInvocationPoint) {
            this.hookInvocationPoint(hookInvocationPoint == null ? null : hookInvocationPoint.toString());
            return this;
        }

        public final String getHookFailureMode() {
            return hookFailureMode;
        }

        public final void setHookFailureMode(String hookFailureMode) {
            this.hookFailureMode = hookFailureMode;
        }

        @Override
        public final Builder hookFailureMode(String hookFailureMode) {
            this.hookFailureMode = hookFailureMode;
            return this;
        }

        @Override
        public final Builder hookFailureMode(HookFailureMode hookFailureMode) {
            this.hookFailureMode(hookFailureMode == null ? null : hookFailureMode.toString());
            return this;
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        @Override
        public final Builder detailedStatus(DetailedStatus detailedStatus) {
            this.detailedStatus(detailedStatus == null ? null : detailedStatus.toString());
            return this;
        }

        @Override
        public StackEvent build() {
            return new StackEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
