/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGeneratedTemplateResponse extends CloudFormationResponse implements
        ToCopyableBuilder<GetGeneratedTemplateResponse.Builder, GetGeneratedTemplateResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetGeneratedTemplateResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateBody").getter(getter(GetGeneratedTemplateResponse::templateBody))
            .setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            TEMPLATE_BODY_FIELD));

    private final String status;

    private final String templateBody;

    private GetGeneratedTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.templateBody = builder.templateBody;
    }

    /**
     * <p>
     * The status of the template generation. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreatePending</code> - the creation of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateInProgress</code> - the creation of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeletePending</code> - the deletion of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteInProgress</code> - the deletion of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdatePending</code> - the update of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdateInProgress</code> - the update of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - the template operation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Complete</code> - the template operation is complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GeneratedTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the template generation. Supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreatePending</code> - the creation of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateInProgress</code> - the creation of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeletePending</code> - the deletion of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteInProgress</code> - the deletion of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdatePending</code> - the update of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateInProgress</code> - the update of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - the template operation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Complete</code> - the template operation is complete.
     *         </p>
     *         </li>
     * @see GeneratedTemplateStatus
     */
    public final GeneratedTemplateStatus status() {
        return GeneratedTemplateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the template generation. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreatePending</code> - the creation of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateInProgress</code> - the creation of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeletePending</code> - the deletion of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteInProgress</code> - the deletion of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdatePending</code> - the update of the template is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UpdateInProgress</code> - the update of the template is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - the template operation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Complete</code> - the template operation is complete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GeneratedTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the template generation. Supported values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreatePending</code> - the creation of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateInProgress</code> - the creation of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeletePending</code> - the deletion of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteInProgress</code> - the deletion of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdatePending</code> - the update of the template is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UpdateInProgress</code> - the update of the template is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - the template operation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Complete</code> - the template operation is complete.
     *         </p>
     *         </li>
     * @see GeneratedTemplateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The template body of the generated template, in the language specified by the <code>Language</code> parameter.
     * </p>
     * 
     * @return The template body of the generated template, in the language specified by the <code>Language</code>
     *         parameter.
     */
    public final String templateBody() {
        return templateBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeneratedTemplateResponse)) {
            return false;
        }
        GetGeneratedTemplateResponse other = (GetGeneratedTemplateResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(templateBody(), other.templateBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGeneratedTemplateResponse").add("Status", statusAsString())
                .add("TemplateBody", templateBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGeneratedTemplateResponse, T> g) {
        return obj -> g.apply((GetGeneratedTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetGeneratedTemplateResponse> {
        /**
         * <p>
         * The status of the template generation. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreatePending</code> - the creation of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateInProgress</code> - the creation of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeletePending</code> - the deletion of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteInProgress</code> - the deletion of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdatePending</code> - the update of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdateInProgress</code> - the update of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - the template operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Complete</code> - the template operation is complete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the template generation. Supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreatePending</code> - the creation of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateInProgress</code> - the creation of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeletePending</code> - the deletion of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteInProgress</code> - the deletion of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdatePending</code> - the update of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateInProgress</code> - the update of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - the template operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Complete</code> - the template operation is complete.
         *        </p>
         *        </li>
         * @see GeneratedTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedTemplateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the template generation. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreatePending</code> - the creation of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateInProgress</code> - the creation of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeletePending</code> - the deletion of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteInProgress</code> - the deletion of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdatePending</code> - the update of the template is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UpdateInProgress</code> - the update of the template is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - the template operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Complete</code> - the template operation is complete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the template generation. Supported values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreatePending</code> - the creation of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateInProgress</code> - the creation of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeletePending</code> - the deletion of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteInProgress</code> - the deletion of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdatePending</code> - the update of the template is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UpdateInProgress</code> - the update of the template is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - the template operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Complete</code> - the template operation is complete.
         *        </p>
         *        </li>
         * @see GeneratedTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedTemplateStatus
         */
        Builder status(GeneratedTemplateStatus status);

        /**
         * <p>
         * The template body of the generated template, in the language specified by the <code>Language</code>
         * parameter.
         * </p>
         * 
         * @param templateBody
         *        The template body of the generated template, in the language specified by the <code>Language</code>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String status;

        private String templateBody;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeneratedTemplateResponse model) {
            super(model);
            status(model.status);
            templateBody(model.templateBody);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GeneratedTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        @Override
        public GetGeneratedTemplateResponse build() {
            return new GetGeneratedTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
