/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.waiters;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Waiter utility class that polls a resource until a desired state is reached or until it is determined that the
 * resource will never enter into the desired state. This can be created using the static {@link #builder()} method
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
@Immutable
public interface CloudFormationWaiter extends SdkAutoCloseable {
    /**
     * Polls {@link CloudFormationClient#describeChangeSet} API until the desired condition
     * {@code ChangeSetCreateComplete} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeChangeSetRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeChangeSetResponse> waitUntilChangeSetCreateComplete(
            DescribeChangeSetRequest describeChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeChangeSet} API until the desired condition
     * {@code ChangeSetCreateComplete} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeChangeSetRequest#builder()}
     *
     * @param describeChangeSetRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeChangeSetResponse> waitUntilChangeSetCreateComplete(
            Consumer<DescribeChangeSetRequest.Builder> describeChangeSetRequest) {
        return waitUntilChangeSetCreateComplete(DescribeChangeSetRequest.builder().applyMutation(describeChangeSetRequest)
                .build());
    }

    /**
     * Polls {@link CloudFormationClient#describeChangeSet} API until the desired condition
     * {@code ChangeSetCreateComplete} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeChangeSetRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeChangeSetResponse> waitUntilChangeSetCreateComplete(
            DescribeChangeSetRequest describeChangeSetRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeChangeSet} API until the desired condition
     * {@code ChangeSetCreateComplete} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeChangeSetRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeChangeSetResponse> waitUntilChangeSetCreateComplete(
            Consumer<DescribeChangeSetRequest.Builder> describeChangeSetRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilChangeSetCreateComplete(DescribeChangeSetRequest.builder().applyMutation(describeChangeSetRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackCreateComplete} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackCreateComplete(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackCreateComplete} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeStacksRequest#builder()}
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackCreateComplete(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return waitUntilStackCreateComplete(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackCreateComplete} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackCreateComplete(DescribeStacksRequest describeStacksRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackCreateComplete} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackCreateComplete(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilStackCreateComplete(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackDeleteComplete} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackDeleteComplete(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackDeleteComplete} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeStacksRequest#builder()}
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackDeleteComplete(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return waitUntilStackDeleteComplete(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackDeleteComplete} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackDeleteComplete(DescribeStacksRequest describeStacksRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackDeleteComplete} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackDeleteComplete(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilStackDeleteComplete(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackExists} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackExists(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackExists} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeStacksRequest#builder()}
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackExists(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return waitUntilStackExists(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackExists} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackExists(DescribeStacksRequest describeStacksRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackExists} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackExists(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilStackExists(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackImportComplete} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackImportComplete(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackImportComplete} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeStacksRequest#builder()}
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackImportComplete(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return waitUntilStackImportComplete(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackImportComplete} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackImportComplete(DescribeStacksRequest describeStacksRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackImportComplete} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackImportComplete(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilStackImportComplete(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackRollbackComplete}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackRollbackComplete(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackRollbackComplete}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeStacksRequest#builder()}
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackRollbackComplete(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return waitUntilStackRollbackComplete(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackRollbackComplete}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackRollbackComplete(DescribeStacksRequest describeStacksRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackRollbackComplete}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackRollbackComplete(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilStackRollbackComplete(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackUpdateComplete} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackUpdateComplete(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackUpdateComplete} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeStacksRequest#builder()}
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackUpdateComplete(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return waitUntilStackUpdateComplete(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackUpdateComplete} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeStacksRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackUpdateComplete(DescribeStacksRequest describeStacksRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeStacks} API until the desired condition {@code StackUpdateComplete} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeStacksRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeStacksResponse> waitUntilStackUpdateComplete(
            Consumer<DescribeStacksRequest.Builder> describeStacksRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilStackUpdateComplete(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeTypeRegistration} API until the desired condition
     * {@code TypeRegistrationComplete} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeTypeRegistrationRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeTypeRegistrationResponse> waitUntilTypeRegistrationComplete(
            DescribeTypeRegistrationRequest describeTypeRegistrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeTypeRegistration} API until the desired condition
     * {@code TypeRegistrationComplete} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeTypeRegistrationRequest#builder()}
     *
     * @param describeTypeRegistrationRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeTypeRegistrationResponse> waitUntilTypeRegistrationComplete(
            Consumer<DescribeTypeRegistrationRequest.Builder> describeTypeRegistrationRequest) {
        return waitUntilTypeRegistrationComplete(DescribeTypeRegistrationRequest.builder()
                .applyMutation(describeTypeRegistrationRequest).build());
    }

    /**
     * Polls {@link CloudFormationClient#describeTypeRegistration} API until the desired condition
     * {@code TypeRegistrationComplete} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeTypeRegistrationRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeTypeRegistrationResponse> waitUntilTypeRegistrationComplete(
            DescribeTypeRegistrationRequest describeTypeRegistrationRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link CloudFormationClient#describeTypeRegistration} API until the desired condition
     * {@code TypeRegistrationComplete} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeTypeRegistrationRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeTypeRegistrationResponse> waitUntilTypeRegistrationComplete(
            Consumer<DescribeTypeRegistrationRequest.Builder> describeTypeRegistrationRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilTypeRegistrationComplete(
                DescribeTypeRegistrationRequest.builder().applyMutation(describeTypeRegistrationRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFormationWaiter}.
     *
     * @return a builder
     */
    static Builder builder() {
        return DefaultCloudFormationWaiter.builder();
    }

    /**
     * Create an instance of {@link CloudFormationWaiter} with the default configuration.
     * <p>
     * <b>A default {@link CloudFormationClient} will be created to poll resources. It is recommended to share a single
     * instance of the waiter created via this method. If it is not desirable to share a waiter instance, invoke
     * {@link #close()} to release the resources once the waiter is not needed.</b>
     *
     * @return an instance of {@link CloudFormationWaiter}
     */
    static CloudFormationWaiter create() {
        return DefaultCloudFormationWaiter.builder().build();
    }

    interface Builder {
        /**
         * Defines overrides to the default SDK waiter configuration that should be used for waiters created from this
         * builder
         *
         * @param overrideConfiguration
         *        the override configuration to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration);

        /**
         * This is a convenient method to pass the override configuration without the need to create an instance
         * manually via {@link WaiterOverrideConfiguration#builder()}
         *
         * @param overrideConfiguration
         *        The consumer that will configure the overrideConfiguration
         * @return a reference to this object so that method calls can be chained together.
         * @see #overrideConfiguration(WaiterOverrideConfiguration)
         */
        default Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return overrideConfiguration(builder.build());
        }

        /**
         * Sets a custom {@link CloudFormationClient} that will be used to poll the resource
         * <p>
         * This SDK client must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * client when the waiter is closed
         *
         * @param client
         *        the client to send the request
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder client(CloudFormationClient client);

        /**
         * Builds an instance of {@link CloudFormationWaiter} based on the configurations supplied to this builder
         *
         * @return An initialized {@link CloudFormationWaiter}
         */
        CloudFormationWaiter build();
    }
}
