/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>GetTemplateSummary</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemplateSummaryRequest extends CloudFormationRequest implements
        ToCopyableBuilder<GetTemplateSummaryRequest.Builder, GetTemplateSummaryRequest> {
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateBody").getter(getter(GetTemplateSummaryRequest::templateBody))
            .setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateURL").getter(getter(GetTemplateSummaryRequest::templateURL))
            .setter(setter(Builder::templateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(GetTemplateSummaryRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackSetName").getter(getter(GetTemplateSummaryRequest::stackSetName))
            .setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()).build();

    private static final SdkField<String> CALL_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CallAs")
            .getter(getter(GetTemplateSummaryRequest::callAsAsString)).setter(setter(Builder::callAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()).build();

    private static final SdkField<TemplateSummaryConfig> TEMPLATE_SUMMARY_CONFIG_FIELD = SdkField
            .<TemplateSummaryConfig> builder(MarshallingType.SDK_POJO).memberName("TemplateSummaryConfig")
            .getter(getter(GetTemplateSummaryRequest::templateSummaryConfig)).setter(setter(Builder::templateSummaryConfig))
            .constructor(TemplateSummaryConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateSummaryConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_BODY_FIELD,
            TEMPLATE_URL_FIELD, STACK_NAME_FIELD, STACK_SET_NAME_FIELD, CALL_AS_FIELD, TEMPLATE_SUMMARY_CONFIG_FIELD));

    private final String templateBody;

    private final String templateURL;

    private final String stackName;

    private final String stackSetName;

    private final String callAs;

    private final TemplateSummaryConfig templateSummaryConfig;

    private GetTemplateSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.stackName = builder.stackName;
        this.stackSetName = builder.stackSetName;
        this.callAs = builder.callAs;
        this.templateSummaryConfig = builder.templateSummaryConfig;
    }

    /**
     * <p>
     * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For
     * more information about templates, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template anatomy</a>
     * in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
     *         bytes. For more information about templates, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         anatomy</a> in the <i>CloudFormation User Guide</i>.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public final String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that's
     * located in an Amazon S3 bucket or a Systems Manager document. For more information about templates, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template anatomy</a>
     * in the <i>CloudFormation User Guide</i>. The location for an Amazon S3 bucket must start with
     * <code>https://</code>.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
     *         that's located in an Amazon S3 bucket or a Systems Manager document. For more information about
     *         templates, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         anatomy</a> in the <i>CloudFormation User Guide</i>. The location for an Amazon S3 bucket must start with
     *         <code>https://</code>.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public final String templateURL() {
        return templateURL;
    }

    /**
     * <p>
     * The name or the stack ID that's associated with the stack, which aren't always interchangeable. For running
     * stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you must specify the
     * unique stack ID.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return The name or the stack ID that's associated with the stack, which aren't always interchangeable. For
     *         running stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you
     *         must specify the unique stack ID.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name or unique ID of the stack set from which the stack was created.
     * </p>
     * <p>
     * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     * </p>
     * 
     * @return The name or unique ID of the stack set from which the stack was created.</p>
     *         <p>
     *         Conditional: You must specify only one of the following parameters: <code>StackName</code>,
     *         <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
     */
    public final String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated administrator in the management account. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your Amazon Web Services account must be registered as a delegated administrator in the management
     *         account. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final CallAs callAs() {
        return CallAs.fromValue(callAs);
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated administrator in the management account. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your Amazon Web Services account must be registered as a delegated administrator in the management
     *         account. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final String callAsAsString() {
        return callAs;
    }

    /**
     * <p>
     * Specifies options for the <code>GetTemplateSummary</code> API action.
     * </p>
     * 
     * @return Specifies options for the <code>GetTemplateSummary</code> API action.
     */
    public final TemplateSummaryConfig templateSummaryConfig() {
        return templateSummaryConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(callAsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templateSummaryConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryRequest)) {
            return false;
        }
        GetTemplateSummaryRequest other = (GetTemplateSummaryRequest) obj;
        return Objects.equals(templateBody(), other.templateBody()) && Objects.equals(templateURL(), other.templateURL())
                && Objects.equals(stackName(), other.stackName()) && Objects.equals(stackSetName(), other.stackSetName())
                && Objects.equals(callAsAsString(), other.callAsAsString())
                && Objects.equals(templateSummaryConfig(), other.templateSummaryConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTemplateSummaryRequest").add("TemplateBody", templateBody())
                .add("TemplateURL", templateURL()).add("StackName", stackName()).add("StackSetName", stackSetName())
                .add("CallAs", callAsAsString()).add("TemplateSummaryConfig", templateSummaryConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateURL":
            return Optional.ofNullable(clazz.cast(templateURL()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "StackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "CallAs":
            return Optional.ofNullable(clazz.cast(callAsAsString()));
        case "TemplateSummaryConfig":
            return Optional.ofNullable(clazz.cast(templateSummaryConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateSummaryRequest, T> g) {
        return obj -> g.apply((GetTemplateSummaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTemplateSummaryRequest> {
        /**
         * <p>
         * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         * For more information about templates, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * anatomy</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param templateBody
         *        Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200
         *        bytes. For more information about templates, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        anatomy</a> in the <i>CloudFormation User Guide</i>.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes)
         * that's located in an Amazon S3 bucket or a Systems Manager document. For more information about templates,
         * see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * anatomy</a> in the <i>CloudFormation User Guide</i>. The location for an Amazon S3 bucket must start with
         * <code>https://</code>.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param templateURL
         *        Location of file containing the template body. The URL must point to a template (max size: 460,800
         *        bytes) that's located in an Amazon S3 bucket or a Systems Manager document. For more information about
         *        templates, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        anatomy</a> in the <i>CloudFormation User Guide</i>. The location for an Amazon S3 bucket must start
         *        with <code>https://</code>.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * The name or the stack ID that's associated with the stack, which aren't always interchangeable. For running
         * stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you must specify
         * the unique stack ID.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param stackName
         *        The name or the stack ID that's associated with the stack, which aren't always interchangeable. For
         *        running stacks, you can specify either the stack's name or its unique stack ID. For deleted stack, you
         *        must specify the unique stack ID.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name or unique ID of the stack set from which the stack was created.
         * </p>
         * <p>
         * Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         * <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * </p>
         * 
         * @param stackSetName
         *        The name or unique ID of the stack set from which the stack was created.</p>
         *        <p>
         *        Conditional: You must specify only one of the following parameters: <code>StackName</code>,
         *        <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         * organization's management account or as a delegated administrator in a member account.
         * </p>
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * <p>
         * Your Amazon Web Services account must be registered as a delegated administrator in the management account.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         *        organization's management account or as a delegated administrator in a member account.</p>
         *        <p>
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         *        permissions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        <p>
         *        Your Amazon Web Services account must be registered as a delegated administrator in the management
         *        account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(String callAs);

        /**
         * <p>
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         * organization's management account or as a delegated administrator in a member account.
         * </p>
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * <p>
         * Your Amazon Web Services account must be registered as a delegated administrator in the management account.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         *        organization's management account or as a delegated administrator in a member account.</p>
         *        <p>
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for stack sets with self-managed
         *        permissions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        <p>
         *        Your Amazon Web Services account must be registered as a delegated administrator in the management
         *        account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(CallAs callAs);

        /**
         * <p>
         * Specifies options for the <code>GetTemplateSummary</code> API action.
         * </p>
         * 
         * @param templateSummaryConfig
         *        Specifies options for the <code>GetTemplateSummary</code> API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSummaryConfig(TemplateSummaryConfig templateSummaryConfig);

        /**
         * <p>
         * Specifies options for the <code>GetTemplateSummary</code> API action.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateSummaryConfig.Builder} avoiding
         * the need to create one manually via {@link TemplateSummaryConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateSummaryConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #templateSummaryConfig(TemplateSummaryConfig)}.
         * 
         * @param templateSummaryConfig
         *        a consumer that will call methods on {@link TemplateSummaryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateSummaryConfig(TemplateSummaryConfig)
         */
        default Builder templateSummaryConfig(Consumer<TemplateSummaryConfig.Builder> templateSummaryConfig) {
            return templateSummaryConfig(TemplateSummaryConfig.builder().applyMutation(templateSummaryConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String templateBody;

        private String templateURL;

        private String stackName;

        private String stackSetName;

        private String callAs;

        private TemplateSummaryConfig templateSummaryConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryRequest model) {
            super(model);
            templateBody(model.templateBody);
            templateURL(model.templateURL);
            stackName(model.stackName);
            stackSetName(model.stackSetName);
            callAs(model.callAs);
            templateSummaryConfig(model.templateSummaryConfig);
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getCallAs() {
            return callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        public final TemplateSummaryConfig.Builder getTemplateSummaryConfig() {
            return templateSummaryConfig != null ? templateSummaryConfig.toBuilder() : null;
        }

        public final void setTemplateSummaryConfig(TemplateSummaryConfig.BuilderImpl templateSummaryConfig) {
            this.templateSummaryConfig = templateSummaryConfig != null ? templateSummaryConfig.build() : null;
        }

        @Override
        public final Builder templateSummaryConfig(TemplateSummaryConfig templateSummaryConfig) {
            this.templateSummaryConfig = templateSummaryConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTemplateSummaryRequest build() {
            return new GetTemplateSummaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
