/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of a generated template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateConfiguration.Builder, TemplateConfiguration> {
    private static final SdkField<String> DELETION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionPolicy").getter(getter(TemplateConfiguration::deletionPolicyAsString))
            .setter(setter(Builder::deletionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionPolicy").build()).build();

    private static final SdkField<String> UPDATE_REPLACE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateReplacePolicy").getter(getter(TemplateConfiguration::updateReplacePolicyAsString))
            .setter(setter(Builder::updateReplacePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateReplacePolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_POLICY_FIELD,
            UPDATE_REPLACE_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deletionPolicy;

    private final String updateReplacePolicy;

    private TemplateConfiguration(BuilderImpl builder) {
        this.deletionPolicy = builder.deletionPolicy;
        this.updateReplacePolicy = builder.updateReplacePolicy;
    }

    /**
     * <p>
     * The <code>DeletionPolicy</code> assigned to resources in the generated template. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETE</code> - delete all resources when the stack is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RETAIN</code> - retain all resources when the stack is deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html"
     * >DeletionPolicy attribute</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deletionPolicy}
     * will return {@link GeneratedTemplateDeletionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deletionPolicyAsString}.
     * </p>
     * 
     * @return The <code>DeletionPolicy</code> assigned to resources in the generated template. Supported values
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETE</code> - delete all resources when the stack is deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RETAIN</code> - retain all resources when the stack is deleted.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html"
     *         >DeletionPolicy attribute</a> in the <i>CloudFormation User Guide</i>.
     * @see GeneratedTemplateDeletionPolicy
     */
    public final GeneratedTemplateDeletionPolicy deletionPolicy() {
        return GeneratedTemplateDeletionPolicy.fromValue(deletionPolicy);
    }

    /**
     * <p>
     * The <code>DeletionPolicy</code> assigned to resources in the generated template. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETE</code> - delete all resources when the stack is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RETAIN</code> - retain all resources when the stack is deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html"
     * >DeletionPolicy attribute</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deletionPolicy}
     * will return {@link GeneratedTemplateDeletionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deletionPolicyAsString}.
     * </p>
     * 
     * @return The <code>DeletionPolicy</code> assigned to resources in the generated template. Supported values
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETE</code> - delete all resources when the stack is deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RETAIN</code> - retain all resources when the stack is deleted.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html"
     *         >DeletionPolicy attribute</a> in the <i>CloudFormation User Guide</i>.
     * @see GeneratedTemplateDeletionPolicy
     */
    public final String deletionPolicyAsString() {
        return deletionPolicy;
    }

    /**
     * <p>
     * The <code>UpdateReplacePolicy</code> assigned to resources in the generated template. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETE</code> - delete all resources when the resource is replaced during an update operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RETAIN</code> - retain all resources when the resource is replaced during an update operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"
     * >UpdateReplacePolicy attribute</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #updateReplacePolicy} will return {@link GeneratedTemplateUpdateReplacePolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #updateReplacePolicyAsString}.
     * </p>
     * 
     * @return The <code>UpdateReplacePolicy</code> assigned to resources in the generated template. Supported values
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETE</code> - delete all resources when the resource is replaced during an update operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RETAIN</code> - retain all resources when the resource is replaced during an update operation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"
     *         >UpdateReplacePolicy attribute</a> in the <i>CloudFormation User Guide</i>.
     * @see GeneratedTemplateUpdateReplacePolicy
     */
    public final GeneratedTemplateUpdateReplacePolicy updateReplacePolicy() {
        return GeneratedTemplateUpdateReplacePolicy.fromValue(updateReplacePolicy);
    }

    /**
     * <p>
     * The <code>UpdateReplacePolicy</code> assigned to resources in the generated template. Supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETE</code> - delete all resources when the resource is replaced during an update operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RETAIN</code> - retain all resources when the resource is replaced during an update operation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"
     * >UpdateReplacePolicy attribute</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #updateReplacePolicy} will return {@link GeneratedTemplateUpdateReplacePolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #updateReplacePolicyAsString}.
     * </p>
     * 
     * @return The <code>UpdateReplacePolicy</code> assigned to resources in the generated template. Supported values
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETE</code> - delete all resources when the resource is replaced during an update operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RETAIN</code> - retain all resources when the resource is replaced during an update operation.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"
     *         >UpdateReplacePolicy attribute</a> in the <i>CloudFormation User Guide</i>.
     * @see GeneratedTemplateUpdateReplacePolicy
     */
    public final String updateReplacePolicyAsString() {
        return updateReplacePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deletionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateReplacePolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateConfiguration)) {
            return false;
        }
        TemplateConfiguration other = (TemplateConfiguration) obj;
        return Objects.equals(deletionPolicyAsString(), other.deletionPolicyAsString())
                && Objects.equals(updateReplacePolicyAsString(), other.updateReplacePolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateConfiguration").add("DeletionPolicy", deletionPolicyAsString())
                .add("UpdateReplacePolicy", updateReplacePolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletionPolicy":
            return Optional.ofNullable(clazz.cast(deletionPolicyAsString()));
        case "UpdateReplacePolicy":
            return Optional.ofNullable(clazz.cast(updateReplacePolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateConfiguration, T> g) {
        return obj -> g.apply((TemplateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateConfiguration> {
        /**
         * <p>
         * The <code>DeletionPolicy</code> assigned to resources in the generated template. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE</code> - delete all resources when the stack is deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RETAIN</code> - retain all resources when the stack is deleted.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html"
         * >DeletionPolicy attribute</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param deletionPolicy
         *        The <code>DeletionPolicy</code> assigned to resources in the generated template. Supported values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE</code> - delete all resources when the stack is deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RETAIN</code> - retain all resources when the stack is deleted.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html"
         *        >DeletionPolicy attribute</a> in the <i>CloudFormation User Guide</i>.
         * @see GeneratedTemplateDeletionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedTemplateDeletionPolicy
         */
        Builder deletionPolicy(String deletionPolicy);

        /**
         * <p>
         * The <code>DeletionPolicy</code> assigned to resources in the generated template. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE</code> - delete all resources when the stack is deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RETAIN</code> - retain all resources when the stack is deleted.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html"
         * >DeletionPolicy attribute</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param deletionPolicy
         *        The <code>DeletionPolicy</code> assigned to resources in the generated template. Supported values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE</code> - delete all resources when the stack is deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RETAIN</code> - retain all resources when the stack is deleted.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html"
         *        >DeletionPolicy attribute</a> in the <i>CloudFormation User Guide</i>.
         * @see GeneratedTemplateDeletionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedTemplateDeletionPolicy
         */
        Builder deletionPolicy(GeneratedTemplateDeletionPolicy deletionPolicy);

        /**
         * <p>
         * The <code>UpdateReplacePolicy</code> assigned to resources in the generated template. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE</code> - delete all resources when the resource is replaced during an update operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RETAIN</code> - retain all resources when the resource is replaced during an update operation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"
         * >UpdateReplacePolicy attribute</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param updateReplacePolicy
         *        The <code>UpdateReplacePolicy</code> assigned to resources in the generated template. Supported values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE</code> - delete all resources when the resource is replaced during an update operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RETAIN</code> - retain all resources when the resource is replaced during an update operation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"
         *        >UpdateReplacePolicy attribute</a> in the <i>CloudFormation User Guide</i>.
         * @see GeneratedTemplateUpdateReplacePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedTemplateUpdateReplacePolicy
         */
        Builder updateReplacePolicy(String updateReplacePolicy);

        /**
         * <p>
         * The <code>UpdateReplacePolicy</code> assigned to resources in the generated template. Supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETE</code> - delete all resources when the resource is replaced during an update operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RETAIN</code> - retain all resources when the resource is replaced during an update operation.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"
         * >UpdateReplacePolicy attribute</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param updateReplacePolicy
         *        The <code>UpdateReplacePolicy</code> assigned to resources in the generated template. Supported values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETE</code> - delete all resources when the resource is replaced during an update operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RETAIN</code> - retain all resources when the resource is replaced during an update operation.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html"
         *        >UpdateReplacePolicy attribute</a> in the <i>CloudFormation User Guide</i>.
         * @see GeneratedTemplateUpdateReplacePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedTemplateUpdateReplacePolicy
         */
        Builder updateReplacePolicy(GeneratedTemplateUpdateReplacePolicy updateReplacePolicy);
    }

    static final class BuilderImpl implements Builder {
        private String deletionPolicy;

        private String updateReplacePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateConfiguration model) {
            deletionPolicy(model.deletionPolicy);
            updateReplacePolicy(model.updateReplacePolicy);
        }

        public final String getDeletionPolicy() {
            return deletionPolicy;
        }

        public final void setDeletionPolicy(String deletionPolicy) {
            this.deletionPolicy = deletionPolicy;
        }

        @Override
        public final Builder deletionPolicy(String deletionPolicy) {
            this.deletionPolicy = deletionPolicy;
            return this;
        }

        @Override
        public final Builder deletionPolicy(GeneratedTemplateDeletionPolicy deletionPolicy) {
            this.deletionPolicy(deletionPolicy == null ? null : deletionPolicy.toString());
            return this;
        }

        public final String getUpdateReplacePolicy() {
            return updateReplacePolicy;
        }

        public final void setUpdateReplacePolicy(String updateReplacePolicy) {
            this.updateReplacePolicy = updateReplacePolicy;
        }

        @Override
        public final Builder updateReplacePolicy(String updateReplacePolicy) {
            this.updateReplacePolicy = updateReplacePolicy;
            return this;
        }

        @Override
        public final Builder updateReplacePolicy(GeneratedTemplateUpdateReplacePolicy updateReplacePolicy) {
            this.updateReplacePolicy(updateReplacePolicy == null ? null : updateReplacePolicy.toString());
            return this;
        }

        @Override
        public TemplateConfiguration build() {
            return new TemplateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
