/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field that CloudFormation will change, such as the name of a resource's property, and whether the resource will
 * be recreated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceTargetDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceTargetDefinition.Builder, ResourceTargetDefinition> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Attribute").getter(getter(ResourceTargetDefinition::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ResourceTargetDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REQUIRES_RECREATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequiresRecreation").getter(getter(ResourceTargetDefinition::requiresRecreationAsString))
            .setter(setter(Builder::requiresRecreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresRecreation").build())
            .build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(ResourceTargetDefinition::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> BEFORE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BeforeValue").getter(getter(ResourceTargetDefinition::beforeValue)).setter(setter(Builder::beforeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeforeValue").build()).build();

    private static final SdkField<String> AFTER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AfterValue").getter(getter(ResourceTargetDefinition::afterValue)).setter(setter(Builder::afterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterValue").build()).build();

    private static final SdkField<String> ATTRIBUTE_CHANGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeChangeType").getter(getter(ResourceTargetDefinition::attributeChangeTypeAsString))
            .setter(setter(Builder::attributeChangeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeChangeType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, NAME_FIELD,
            REQUIRES_RECREATION_FIELD, PATH_FIELD, BEFORE_VALUE_FIELD, AFTER_VALUE_FIELD, ATTRIBUTE_CHANGE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final String name;

    private final String requiresRecreation;

    private final String path;

    private final String beforeValue;

    private final String afterValue;

    private final String attributeChangeType;

    private ResourceTargetDefinition(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.name = builder.name;
        this.requiresRecreation = builder.requiresRecreation;
        this.path = builder.path;
        this.beforeValue = builder.beforeValue;
        this.afterValue = builder.afterValue;
        this.attributeChangeType = builder.attributeChangeType;
    }

    /**
     * <p>
     * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
     * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ResourceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return Indicates which resource attribute is triggering this update, such as a change in the resource
     *         attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * @see ResourceAttribute
     */
    public final ResourceAttribute attribute() {
        return ResourceAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
     * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ResourceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return Indicates which resource attribute is triggering this update, such as a change in the resource
     *         attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * @see ResourceAttribute
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other
     * attributes, the value is null.
     * </p>
     * 
     * @return If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other
     *         attributes, the value is null.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
     * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
     * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
     * update behavior for that property in the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon
     * Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #requiresRecreation} will return {@link RequiresRecreation#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #requiresRecreationAsString}.
     * </p>
     * 
     * @return If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
     *         property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>,
     *         or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation,
     *         see the update behavior for that property in the <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>.
     * @see RequiresRecreation
     */
    public final RequiresRecreation requiresRecreation() {
        return RequiresRecreation.fromValue(requiresRecreation);
    }

    /**
     * <p>
     * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
     * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
     * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
     * update behavior for that property in the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon
     * Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #requiresRecreation} will return {@link RequiresRecreation#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #requiresRecreationAsString}.
     * </p>
     * 
     * @return If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
     *         property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>,
     *         or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation,
     *         see the update behavior for that property in the <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>.
     * @see RequiresRecreation
     */
    public final String requiresRecreationAsString() {
        return requiresRecreation;
    }

    /**
     * <p>
     * The property path of the property.
     * </p>
     * 
     * @return The property path of the property.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The value of the property before the change is executed. Large values can be truncated.
     * </p>
     * 
     * @return The value of the property before the change is executed. Large values can be truncated.
     */
    public final String beforeValue() {
        return beforeValue;
    }

    /**
     * <p>
     * The value of the property after the change is executed. Large values can be truncated.
     * </p>
     * 
     * @return The value of the property after the change is executed. Large values can be truncated.
     */
    public final String afterValue() {
        return afterValue;
    }

    /**
     * <p>
     * The type of change to be made to the property if the change is executed.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Add</code> The item will be added.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Remove</code> The item will be removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Modify</code> The item will be modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeChangeType} will return {@link AttributeChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeChangeTypeAsString}.
     * </p>
     * 
     * @return The type of change to be made to the property if the change is executed.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Add</code> The item will be added.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Remove</code> The item will be removed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Modify</code> The item will be modified.
     *         </p>
     *         </li>
     * @see AttributeChangeType
     */
    public final AttributeChangeType attributeChangeType() {
        return AttributeChangeType.fromValue(attributeChangeType);
    }

    /**
     * <p>
     * The type of change to be made to the property if the change is executed.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Add</code> The item will be added.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Remove</code> The item will be removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Modify</code> The item will be modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeChangeType} will return {@link AttributeChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeChangeTypeAsString}.
     * </p>
     * 
     * @return The type of change to be made to the property if the change is executed.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Add</code> The item will be added.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Remove</code> The item will be removed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Modify</code> The item will be modified.
     *         </p>
     *         </li>
     * @see AttributeChangeType
     */
    public final String attributeChangeTypeAsString() {
        return attributeChangeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requiresRecreationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(beforeValue());
        hashCode = 31 * hashCode + Objects.hashCode(afterValue());
        hashCode = 31 * hashCode + Objects.hashCode(attributeChangeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTargetDefinition)) {
            return false;
        }
        ResourceTargetDefinition other = (ResourceTargetDefinition) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(requiresRecreationAsString(), other.requiresRecreationAsString())
                && Objects.equals(path(), other.path()) && Objects.equals(beforeValue(), other.beforeValue())
                && Objects.equals(afterValue(), other.afterValue())
                && Objects.equals(attributeChangeTypeAsString(), other.attributeChangeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceTargetDefinition").add("Attribute", attributeAsString()).add("Name", name())
                .add("RequiresRecreation", requiresRecreationAsString()).add("Path", path()).add("BeforeValue", beforeValue())
                .add("AfterValue", afterValue()).add("AttributeChangeType", attributeChangeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RequiresRecreation":
            return Optional.ofNullable(clazz.cast(requiresRecreationAsString()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "BeforeValue":
            return Optional.ofNullable(clazz.cast(beforeValue()));
        case "AfterValue":
            return Optional.ofNullable(clazz.cast(afterValue()));
        case "AttributeChangeType":
            return Optional.ofNullable(clazz.cast(attributeChangeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceTargetDefinition, T> g) {
        return obj -> g.apply((ResourceTargetDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceTargetDefinition> {
        /**
         * <p>
         * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
         * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param attribute
         *        Indicates which resource attribute is triggering this update, such as a change in the resource
         *        attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * @see ResourceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
         * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param attribute
         *        Indicates which resource attribute is triggering this update, such as a change in the resource
         *        attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * @see ResourceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder attribute(ResourceAttribute attribute);

        /**
         * <p>
         * If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other
         * attributes, the value is null.
         * </p>
         * 
         * @param name
         *        If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all
         *        other attributes, the value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
         * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
         * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
         * update behavior for that property in the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param requiresRecreation
         *        If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
         *        property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>
         *        , or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code>
         *        recreation, see the update behavior for that property in the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User
         *        Guide</i>.
         * @see RequiresRecreation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiresRecreation
         */
        Builder requiresRecreation(String requiresRecreation);

        /**
         * <p>
         * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
         * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
         * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
         * update behavior for that property in the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param requiresRecreation
         *        If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
         *        property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>
         *        , or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code>
         *        recreation, see the update behavior for that property in the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User
         *        Guide</i>.
         * @see RequiresRecreation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiresRecreation
         */
        Builder requiresRecreation(RequiresRecreation requiresRecreation);

        /**
         * <p>
         * The property path of the property.
         * </p>
         * 
         * @param path
         *        The property path of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The value of the property before the change is executed. Large values can be truncated.
         * </p>
         * 
         * @param beforeValue
         *        The value of the property before the change is executed. Large values can be truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeValue(String beforeValue);

        /**
         * <p>
         * The value of the property after the change is executed. Large values can be truncated.
         * </p>
         * 
         * @param afterValue
         *        The value of the property after the change is executed. Large values can be truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterValue(String afterValue);

        /**
         * <p>
         * The type of change to be made to the property if the change is executed.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Add</code> The item will be added.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Remove</code> The item will be removed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Modify</code> The item will be modified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeChangeType
         *        The type of change to be made to the property if the change is executed.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Add</code> The item will be added.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Remove</code> The item will be removed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Modify</code> The item will be modified.
         *        </p>
         *        </li>
         * @see AttributeChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeChangeType
         */
        Builder attributeChangeType(String attributeChangeType);

        /**
         * <p>
         * The type of change to be made to the property if the change is executed.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Add</code> The item will be added.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Remove</code> The item will be removed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Modify</code> The item will be modified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeChangeType
         *        The type of change to be made to the property if the change is executed.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Add</code> The item will be added.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Remove</code> The item will be removed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Modify</code> The item will be modified.
         *        </p>
         *        </li>
         * @see AttributeChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeChangeType
         */
        Builder attributeChangeType(AttributeChangeType attributeChangeType);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String name;

        private String requiresRecreation;

        private String path;

        private String beforeValue;

        private String afterValue;

        private String attributeChangeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTargetDefinition model) {
            attribute(model.attribute);
            name(model.name);
            requiresRecreation(model.requiresRecreation);
            path(model.path);
            beforeValue(model.beforeValue);
            afterValue(model.afterValue);
            attributeChangeType(model.attributeChangeType);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResourceAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequiresRecreation() {
            return requiresRecreation;
        }

        public final void setRequiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
        }

        @Override
        public final Builder requiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
            return this;
        }

        @Override
        public final Builder requiresRecreation(RequiresRecreation requiresRecreation) {
            this.requiresRecreation(requiresRecreation == null ? null : requiresRecreation.toString());
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getBeforeValue() {
            return beforeValue;
        }

        public final void setBeforeValue(String beforeValue) {
            this.beforeValue = beforeValue;
        }

        @Override
        public final Builder beforeValue(String beforeValue) {
            this.beforeValue = beforeValue;
            return this;
        }

        public final String getAfterValue() {
            return afterValue;
        }

        public final void setAfterValue(String afterValue) {
            this.afterValue = afterValue;
        }

        @Override
        public final Builder afterValue(String afterValue) {
            this.afterValue = afterValue;
            return this;
        }

        public final String getAttributeChangeType() {
            return attributeChangeType;
        }

        public final void setAttributeChangeType(String attributeChangeType) {
            this.attributeChangeType = attributeChangeType;
        }

        @Override
        public final Builder attributeChangeType(String attributeChangeType) {
            this.attributeChangeType = attributeChangeType;
            return this;
        }

        @Override
        public final Builder attributeChangeType(AttributeChangeType attributeChangeType) {
            this.attributeChangeType(attributeChangeType == null ? null : attributeChangeType.toString());
            return this;
        }

        @Override
        public ResourceTargetDefinition build() {
            return new ResourceTargetDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
