/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains any warnings returned by the <code>GetTemplateSummary</code> API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Warnings implements SdkPojo, Serializable, ToCopyableBuilder<Warnings.Builder, Warnings> {
    private static final SdkField<List<String>> UNRECOGNIZED_RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UnrecognizedResourceTypes")
            .getter(getter(Warnings::unrecognizedResourceTypes))
            .setter(setter(Builder::unrecognizedResourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnrecognizedResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(UNRECOGNIZED_RESOURCE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("UnrecognizedResourceTypes", UNRECOGNIZED_RESOURCE_TYPES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> unrecognizedResourceTypes;

    private Warnings(BuilderImpl builder) {
        this.unrecognizedResourceTypes = builder.unrecognizedResourceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnrecognizedResourceTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnrecognizedResourceTypes() {
        return unrecognizedResourceTypes != null && !(unrecognizedResourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all of the unrecognized resource types. This is only returned if the <code>TemplateSummaryConfig</code>
     * parameter has the <code>TreatUnrecognizedResourceTypesAsWarning</code> configuration set to <code>True</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnrecognizedResourceTypes} method.
     * </p>
     * 
     * @return A list of all of the unrecognized resource types. This is only returned if the
     *         <code>TemplateSummaryConfig</code> parameter has the <code>TreatUnrecognizedResourceTypesAsWarning</code>
     *         configuration set to <code>True</code>.
     */
    public final List<String> unrecognizedResourceTypes() {
        return unrecognizedResourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUnrecognizedResourceTypes() ? unrecognizedResourceTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Warnings)) {
            return false;
        }
        Warnings other = (Warnings) obj;
        return hasUnrecognizedResourceTypes() == other.hasUnrecognizedResourceTypes()
                && Objects.equals(unrecognizedResourceTypes(), other.unrecognizedResourceTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Warnings")
                .add("UnrecognizedResourceTypes", hasUnrecognizedResourceTypes() ? unrecognizedResourceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnrecognizedResourceTypes":
            return Optional.ofNullable(clazz.cast(unrecognizedResourceTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Warnings, T> g) {
        return obj -> g.apply((Warnings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Warnings> {
        /**
         * <p>
         * A list of all of the unrecognized resource types. This is only returned if the
         * <code>TemplateSummaryConfig</code> parameter has the <code>TreatUnrecognizedResourceTypesAsWarning</code>
         * configuration set to <code>True</code>.
         * </p>
         * 
         * @param unrecognizedResourceTypes
         *        A list of all of the unrecognized resource types. This is only returned if the
         *        <code>TemplateSummaryConfig</code> parameter has the
         *        <code>TreatUnrecognizedResourceTypesAsWarning</code> configuration set to <code>True</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unrecognizedResourceTypes(Collection<String> unrecognizedResourceTypes);

        /**
         * <p>
         * A list of all of the unrecognized resource types. This is only returned if the
         * <code>TemplateSummaryConfig</code> parameter has the <code>TreatUnrecognizedResourceTypesAsWarning</code>
         * configuration set to <code>True</code>.
         * </p>
         * 
         * @param unrecognizedResourceTypes
         *        A list of all of the unrecognized resource types. This is only returned if the
         *        <code>TemplateSummaryConfig</code> parameter has the
         *        <code>TreatUnrecognizedResourceTypesAsWarning</code> configuration set to <code>True</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unrecognizedResourceTypes(String... unrecognizedResourceTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> unrecognizedResourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Warnings model) {
            unrecognizedResourceTypes(model.unrecognizedResourceTypes);
        }

        public final Collection<String> getUnrecognizedResourceTypes() {
            if (unrecognizedResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return unrecognizedResourceTypes;
        }

        public final void setUnrecognizedResourceTypes(Collection<String> unrecognizedResourceTypes) {
            this.unrecognizedResourceTypes = ResourceTypesCopier.copy(unrecognizedResourceTypes);
        }

        @Override
        public final Builder unrecognizedResourceTypes(Collection<String> unrecognizedResourceTypes) {
            this.unrecognizedResourceTypes = ResourceTypesCopier.copy(unrecognizedResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unrecognizedResourceTypes(String... unrecognizedResourceTypes) {
            unrecognizedResourceTypes(Arrays.asList(unrecognizedResourceTypes));
            return this;
        }

        @Override
        public Warnings build() {
            return new Warnings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
