/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTypeRegistrationsRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListTypeRegistrationsRequest.Builder, ListTypeRegistrationsRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListTypeRegistrationsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(ListTypeRegistrationsRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeArn").getter(getter(ListTypeRegistrationsRequest::typeArn)).setter(setter(Builder::typeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()).build();

    private static final SdkField<String> REGISTRATION_STATUS_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationStatusFilter")
            .getter(getter(ListTypeRegistrationsRequest::registrationStatusFilterAsString))
            .setter(setter(Builder::registrationStatusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationStatusFilter").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTypeRegistrationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTypeRegistrationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD,
            TYPE_ARN_FIELD, REGISTRATION_STATUS_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Type", TYPE_FIELD);
                    put("TypeName", TYPE_NAME_FIELD);
                    put("TypeArn", TYPE_ARN_FIELD);
                    put("RegistrationStatusFilter", REGISTRATION_STATUS_FILTER_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String type;

    private final String typeName;

    private final String typeArn;

    private final String registrationStatusFilter;

    private final Integer maxResults;

    private final String nextToken;

    private ListTypeRegistrationsRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.typeArn = builder.typeArn;
        this.registrationStatusFilter = builder.registrationStatusFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * @see RegistryType
     */
    public final RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of extension.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of extension.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * @see RegistryType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the extension.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * 
     * @return The name of the extension.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the extension.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the extension.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     */
    public final String typeArn() {
        return typeArn;
    }

    /**
     * <p>
     * The current status of the extension registration request.
     * </p>
     * <p>
     * The default is <code>IN_PROGRESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatusFilter} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #registrationStatusFilterAsString}.
     * </p>
     * 
     * @return The current status of the extension registration request.</p>
     *         <p>
     *         The default is <code>IN_PROGRESS</code>.
     * @see RegistrationStatus
     */
    public final RegistrationStatus registrationStatusFilter() {
        return RegistrationStatus.fromValue(registrationStatusFilter);
    }

    /**
     * <p>
     * The current status of the extension registration request.
     * </p>
     * <p>
     * The default is <code>IN_PROGRESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #registrationStatusFilter} will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #registrationStatusFilterAsString}.
     * </p>
     * 
     * @return The current status of the extension registration request.</p>
     *         <p>
     *         The default is <code>IN_PROGRESS</code>.
     * @see RegistrationStatus
     */
    public final String registrationStatusFilterAsString() {
        return registrationStatusFilter;
    }

    /**
     * <p>
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this
     * maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code>
     * request parameter to get the next set of results.
     * </p>
     * 
     * @return The maximum number of results to be returned with a single call. If the number of available results
     *         exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
     *         <code>NextToken</code> request parameter to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous paginated request didn't return all the remaining results, the response object's
     * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action
     * again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining
     * results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.
     * </p>
     * 
     * @return If the previous paginated request didn't return all the remaining results, the response object's
     *         <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this
     *         action again and assign that token to the request object's <code>NextToken</code> parameter. If there are
     *         no remaining results, the previous response object's <code>NextToken</code> parameter is set to
     *         <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(registrationStatusFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypeRegistrationsRequest)) {
            return false;
        }
        ListTypeRegistrationsRequest other = (ListTypeRegistrationsRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(typeArn(), other.typeArn())
                && Objects.equals(registrationStatusFilterAsString(), other.registrationStatusFilterAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTypeRegistrationsRequest").add("Type", typeAsString()).add("TypeName", typeName())
                .add("TypeArn", typeArn()).add("RegistrationStatusFilter", registrationStatusFilterAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "TypeArn":
            return Optional.ofNullable(clazz.cast(typeArn()));
        case "RegistrationStatusFilter":
            return Optional.ofNullable(clazz.cast(registrationStatusFilterAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTypeRegistrationsRequest, T> g) {
        return obj -> g.apply((ListTypeRegistrationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTypeRegistrationsRequest> {
        /**
         * <p>
         * The kind of extension.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param type
         *        The kind of extension.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of extension.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param type
         *        The kind of extension.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the extension.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param typeName
         *        The name of the extension.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the extension.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param typeArn
         *        The Amazon Resource Name (ARN) of the extension.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeArn(String typeArn);

        /**
         * <p>
         * The current status of the extension registration request.
         * </p>
         * <p>
         * The default is <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param registrationStatusFilter
         *        The current status of the extension registration request.</p>
         *        <p>
         *        The default is <code>IN_PROGRESS</code>.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatusFilter(String registrationStatusFilter);

        /**
         * <p>
         * The current status of the extension registration request.
         * </p>
         * <p>
         * The default is <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param registrationStatusFilter
         *        The current status of the extension registration request.</p>
         *        <p>
         *        The default is <code>IN_PROGRESS</code>.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder registrationStatusFilter(RegistrationStatus registrationStatusFilter);

        /**
         * <p>
         * The maximum number of results to be returned with a single call. If the number of available results exceeds
         * this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         * <code>NextToken</code> request parameter to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned with a single call. If the number of available results
         *        exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         *        <code>NextToken</code> request parameter to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous paginated request didn't return all the remaining results, the response object's
         * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this
         * action again and assign that token to the request object's <code>NextToken</code> parameter. If there are no
         * remaining results, the previous response object's <code>NextToken</code> parameter is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request didn't return all the remaining results, the response object's
         *        <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        this action again and assign that token to the request object's <code>NextToken</code> parameter. If
         *        there are no remaining results, the previous response object's <code>NextToken</code> parameter is set
         *        to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String type;

        private String typeName;

        private String typeArn;

        private String registrationStatusFilter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypeRegistrationsRequest model) {
            super(model);
            type(model.type);
            typeName(model.typeName);
            typeArn(model.typeArn);
            registrationStatusFilter(model.registrationStatusFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeArn() {
            return typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final String getRegistrationStatusFilter() {
            return registrationStatusFilter;
        }

        public final void setRegistrationStatusFilter(String registrationStatusFilter) {
            this.registrationStatusFilter = registrationStatusFilter;
        }

        @Override
        public final Builder registrationStatusFilter(String registrationStatusFilter) {
            this.registrationStatusFilter = registrationStatusFilter;
            return this;
        }

        @Override
        public final Builder registrationStatusFilter(RegistrationStatus registrationStatusFilter) {
            this.registrationStatusFilter(registrationStatusFilter == null ? null : registrationStatusFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTypeRegistrationsRequest build() {
            return new ListTypeRegistrationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
