/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes whether StackSets performs non-conflicting operations concurrently and queues conflicting operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedExecution.Builder, ManagedExecution> {
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Active").getter(getter(ManagedExecution::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Active", ACTIVE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean active;

    private ManagedExecution(BuilderImpl builder) {
        this.active = builder.active;
    }

    /**
     * <p>
     * When <code>true</code>, StackSets performs non-conflicting operations concurrently and queues conflicting
     * operations. After conflicting operations finish, StackSets starts queued operations in request order.
     * </p>
     * <note>
     * <p>
     * If there are already running or queued operations, StackSets queues all incoming operations even if they are
     * non-conflicting.
     * </p>
     * <p>
     * You can't modify your stack set's execution configuration while there are running or queued operations for that
     * stack set.
     * </p>
     * </note>
     * <p>
     * When <code>false</code> (default), StackSets performs one operation at a time in request order.
     * </p>
     * 
     * @return When <code>true</code>, StackSets performs non-conflicting operations concurrently and queues conflicting
     *         operations. After conflicting operations finish, StackSets starts queued operations in request order.</p>
     *         <note>
     *         <p>
     *         If there are already running or queued operations, StackSets queues all incoming operations even if they
     *         are non-conflicting.
     *         </p>
     *         <p>
     *         You can't modify your stack set's execution configuration while there are running or queued operations
     *         for that stack set.
     *         </p>
     *         </note>
     *         <p>
     *         When <code>false</code> (default), StackSets performs one operation at a time in request order.
     */
    public final Boolean active() {
        return active;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(active());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedExecution)) {
            return false;
        }
        ManagedExecution other = (ManagedExecution) obj;
        return Objects.equals(active(), other.active());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedExecution").add("Active", active()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Active":
            return Optional.ofNullable(clazz.cast(active()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ManagedExecution, T> g) {
        return obj -> g.apply((ManagedExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedExecution> {
        /**
         * <p>
         * When <code>true</code>, StackSets performs non-conflicting operations concurrently and queues conflicting
         * operations. After conflicting operations finish, StackSets starts queued operations in request order.
         * </p>
         * <note>
         * <p>
         * If there are already running or queued operations, StackSets queues all incoming operations even if they are
         * non-conflicting.
         * </p>
         * <p>
         * You can't modify your stack set's execution configuration while there are running or queued operations for
         * that stack set.
         * </p>
         * </note>
         * <p>
         * When <code>false</code> (default), StackSets performs one operation at a time in request order.
         * </p>
         * 
         * @param active
         *        When <code>true</code>, StackSets performs non-conflicting operations concurrently and queues
         *        conflicting operations. After conflicting operations finish, StackSets starts queued operations in
         *        request order.</p> <note>
         *        <p>
         *        If there are already running or queued operations, StackSets queues all incoming operations even if
         *        they are non-conflicting.
         *        </p>
         *        <p>
         *        You can't modify your stack set's execution configuration while there are running or queued operations
         *        for that stack set.
         *        </p>
         *        </note>
         *        <p>
         *        When <code>false</code> (default), StackSets performs one operation at a time in request order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);
    }

    static final class BuilderImpl implements Builder {
        private Boolean active;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedExecution model) {
            active(model.active);
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        @Override
        public ManagedExecution build() {
            return new ManagedExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
