/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHookResultsRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListHookResultsRequest.Builder, ListHookResultsRequest> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(ListHookResultsRequest::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(ListHookResultsRequest::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHookResultsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD,
            TARGET_ID_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TargetType", TARGET_TYPE_FIELD);
                    put("TargetId", TARGET_ID_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String targetType;

    private final String targetId;

    private final String nextToken;

    private ListHookResultsRequest(BuilderImpl builder) {
        super(builder);
        this.targetType = builder.targetType;
        this.targetId = builder.targetId;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The type of operation being targeted by the Hook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link ListHookResultsTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of operation being targeted by the Hook.
     * @see ListHookResultsTargetType
     */
    public final ListHookResultsTargetType targetType() {
        return ListHookResultsTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of operation being targeted by the Hook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link ListHookResultsTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of operation being targeted by the Hook.
     * @see ListHookResultsTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * The logical ID of the target the operation is acting on by the Hook. If the target is a change set, it's the ARN
     * of the change set.
     * </p>
     * <p>
     * If the target is a Cloud Control API operation, this will be the <code>HookRequestToken</code> returned by the
     * Cloud Control API operation request. For more information on the <code>HookRequestToken</code>, see <a
     * href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html">ProgressEvent</a>.
     * </p>
     * 
     * @return The logical ID of the target the operation is acting on by the Hook. If the target is a change set, it's
     *         the ARN of the change set.</p>
     *         <p>
     *         If the target is a Cloud Control API operation, this will be the <code>HookRequestToken</code> returned
     *         by the Cloud Control API operation request. For more information on the <code>HookRequestToken</code>,
     *         see <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html">
     *         ProgressEvent</a>.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * A string that identifies the next page of events that you want to retrieve.
     * </p>
     * 
     * @return A string that identifies the next page of events that you want to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHookResultsRequest)) {
            return false;
        }
        ListHookResultsRequest other = (ListHookResultsRequest) obj;
        return Objects.equals(targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(targetId(), other.targetId())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHookResultsRequest").add("TargetType", targetTypeAsString()).add("TargetId", targetId())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListHookResultsRequest, T> g) {
        return obj -> g.apply((ListHookResultsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListHookResultsRequest> {
        /**
         * <p>
         * The type of operation being targeted by the Hook.
         * </p>
         * 
         * @param targetType
         *        The type of operation being targeted by the Hook.
         * @see ListHookResultsTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListHookResultsTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of operation being targeted by the Hook.
         * </p>
         * 
         * @param targetType
         *        The type of operation being targeted by the Hook.
         * @see ListHookResultsTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListHookResultsTargetType
         */
        Builder targetType(ListHookResultsTargetType targetType);

        /**
         * <p>
         * The logical ID of the target the operation is acting on by the Hook. If the target is a change set, it's the
         * ARN of the change set.
         * </p>
         * <p>
         * If the target is a Cloud Control API operation, this will be the <code>HookRequestToken</code> returned by
         * the Cloud Control API operation request. For more information on the <code>HookRequestToken</code>, see <a
         * href
         * ="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html">ProgressEvent</a>.
         * </p>
         * 
         * @param targetId
         *        The logical ID of the target the operation is acting on by the Hook. If the target is a change set,
         *        it's the ARN of the change set.</p>
         *        <p>
         *        If the target is a Cloud Control API operation, this will be the <code>HookRequestToken</code>
         *        returned by the Cloud Control API operation request. For more information on the
         *        <code>HookRequestToken</code>, see <a
         *        href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ProgressEvent.html"
         *        >ProgressEvent</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * A string that identifies the next page of events that you want to retrieve.
         * </p>
         * 
         * @param nextToken
         *        A string that identifies the next page of events that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String targetType;

        private String targetId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHookResultsRequest model) {
            super(model);
            targetType(model.targetType);
            targetId(model.targetId);
            nextToken(model.nextToken);
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(ListHookResultsTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHookResultsRequest build() {
            return new ListHookResultsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
