/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For extensions that are modules, a public third-party extension that must be activated in your account in order for
 * the module itself to be activated.
 * </p>
 * <p>
 * For more information, see <a href=
 * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/module-versioning.html#requirements-for-modules"
 * >Requirements for activating third-party public modules</a> in the <i>CloudFormation User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequiredActivatedType implements SdkPojo, Serializable,
        ToCopyableBuilder<RequiredActivatedType.Builder, RequiredActivatedType> {
    private static final SdkField<String> TYPE_NAME_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeNameAlias").getter(getter(RequiredActivatedType::typeNameAlias))
            .setter(setter(Builder::typeNameAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeNameAlias").build()).build();

    private static final SdkField<String> ORIGINAL_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginalTypeName").getter(getter(RequiredActivatedType::originalTypeName))
            .setter(setter(Builder::originalTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTypeName").build()).build();

    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublisherId").getter(getter(RequiredActivatedType::publisherId)).setter(setter(Builder::publisherId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()).build();

    private static final SdkField<List<Integer>> SUPPORTED_MAJOR_VERSIONS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("SupportedMajorVersions")
            .getter(getter(RequiredActivatedType::supportedMajorVersions))
            .setter(setter(Builder::supportedMajorVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedMajorVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_ALIAS_FIELD,
            ORIGINAL_TYPE_NAME_FIELD, PUBLISHER_ID_FIELD, SUPPORTED_MAJOR_VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TypeNameAlias", TYPE_NAME_ALIAS_FIELD);
                    put("OriginalTypeName", ORIGINAL_TYPE_NAME_FIELD);
                    put("PublisherId", PUBLISHER_ID_FIELD);
                    put("SupportedMajorVersions", SUPPORTED_MAJOR_VERSIONS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String typeNameAlias;

    private final String originalTypeName;

    private final String publisherId;

    private final List<Integer> supportedMajorVersions;

    private RequiredActivatedType(BuilderImpl builder) {
        this.typeNameAlias = builder.typeNameAlias;
        this.originalTypeName = builder.originalTypeName;
        this.publisherId = builder.publisherId;
        this.supportedMajorVersions = builder.supportedMajorVersions;
    }

    /**
     * <p>
     * An alias assigned to the public extension, in this account and Region. If you specify an alias for the extension,
     * CloudFormation treats the alias as the extension type name within this account and Region. You must use the alias
     * to refer to the extension in your templates, API calls, and CloudFormation console.
     * </p>
     * 
     * @return An alias assigned to the public extension, in this account and Region. If you specify an alias for the
     *         extension, CloudFormation treats the alias as the extension type name within this account and Region. You
     *         must use the alias to refer to the extension in your templates, API calls, and CloudFormation console.
     */
    public final String typeNameAlias() {
        return typeNameAlias;
    }

    /**
     * <p>
     * The type name of the public extension.
     * </p>
     * <p>
     * If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and Region,
     * CloudFormation treats that alias as the extension's type name within the account and Region, not the type name of
     * the public extension. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
     * >Use aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return The type name of the public extension.</p>
     *         <p>
     *         If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and Region,
     *         CloudFormation treats that alias as the extension's type name within the account and Region, not the type
     *         name of the public extension. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
     *         >Use aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
     */
    public final String originalTypeName() {
        return originalTypeName;
    }

    /**
     * <p>
     * The publisher ID of the extension publisher.
     * </p>
     * 
     * @return The publisher ID of the extension publisher.
     */
    public final String publisherId() {
        return publisherId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedMajorVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedMajorVersions() {
        return supportedMajorVersions != null && !(supportedMajorVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the major versions of the extension type that the macro supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedMajorVersions} method.
     * </p>
     * 
     * @return A list of the major versions of the extension type that the macro supports.
     */
    public final List<Integer> supportedMajorVersions() {
        return supportedMajorVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeNameAlias());
        hashCode = 31 * hashCode + Objects.hashCode(originalTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedMajorVersions() ? supportedMajorVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequiredActivatedType)) {
            return false;
        }
        RequiredActivatedType other = (RequiredActivatedType) obj;
        return Objects.equals(typeNameAlias(), other.typeNameAlias())
                && Objects.equals(originalTypeName(), other.originalTypeName())
                && Objects.equals(publisherId(), other.publisherId())
                && hasSupportedMajorVersions() == other.hasSupportedMajorVersions()
                && Objects.equals(supportedMajorVersions(), other.supportedMajorVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequiredActivatedType").add("TypeNameAlias", typeNameAlias())
                .add("OriginalTypeName", originalTypeName()).add("PublisherId", publisherId())
                .add("SupportedMajorVersions", hasSupportedMajorVersions() ? supportedMajorVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeNameAlias":
            return Optional.ofNullable(clazz.cast(typeNameAlias()));
        case "OriginalTypeName":
            return Optional.ofNullable(clazz.cast(originalTypeName()));
        case "PublisherId":
            return Optional.ofNullable(clazz.cast(publisherId()));
        case "SupportedMajorVersions":
            return Optional.ofNullable(clazz.cast(supportedMajorVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RequiredActivatedType, T> g) {
        return obj -> g.apply((RequiredActivatedType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequiredActivatedType> {
        /**
         * <p>
         * An alias assigned to the public extension, in this account and Region. If you specify an alias for the
         * extension, CloudFormation treats the alias as the extension type name within this account and Region. You
         * must use the alias to refer to the extension in your templates, API calls, and CloudFormation console.
         * </p>
         * 
         * @param typeNameAlias
         *        An alias assigned to the public extension, in this account and Region. If you specify an alias for the
         *        extension, CloudFormation treats the alias as the extension type name within this account and Region.
         *        You must use the alias to refer to the extension in your templates, API calls, and CloudFormation
         *        console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeNameAlias(String typeNameAlias);

        /**
         * <p>
         * The type name of the public extension.
         * </p>
         * <p>
         * If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and Region,
         * CloudFormation treats that alias as the extension's type name within the account and Region, not the type
         * name of the public extension. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
         * >Use aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param originalTypeName
         *        The type name of the public extension.</p>
         *        <p>
         *        If you specified a <code>TypeNameAlias</code> when enabling the extension in this account and Region,
         *        CloudFormation treats that alias as the extension's type name within the account and Region, not the
         *        type name of the public extension. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias"
         *        >Use aliases to refer to extensions</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalTypeName(String originalTypeName);

        /**
         * <p>
         * The publisher ID of the extension publisher.
         * </p>
         * 
         * @param publisherId
         *        The publisher ID of the extension publisher.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisherId(String publisherId);

        /**
         * <p>
         * A list of the major versions of the extension type that the macro supports.
         * </p>
         * 
         * @param supportedMajorVersions
         *        A list of the major versions of the extension type that the macro supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedMajorVersions(Collection<Integer> supportedMajorVersions);

        /**
         * <p>
         * A list of the major versions of the extension type that the macro supports.
         * </p>
         * 
         * @param supportedMajorVersions
         *        A list of the major versions of the extension type that the macro supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedMajorVersions(Integer... supportedMajorVersions);
    }

    static final class BuilderImpl implements Builder {
        private String typeNameAlias;

        private String originalTypeName;

        private String publisherId;

        private List<Integer> supportedMajorVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequiredActivatedType model) {
            typeNameAlias(model.typeNameAlias);
            originalTypeName(model.originalTypeName);
            publisherId(model.publisherId);
            supportedMajorVersions(model.supportedMajorVersions);
        }

        public final String getTypeNameAlias() {
            return typeNameAlias;
        }

        public final void setTypeNameAlias(String typeNameAlias) {
            this.typeNameAlias = typeNameAlias;
        }

        @Override
        public final Builder typeNameAlias(String typeNameAlias) {
            this.typeNameAlias = typeNameAlias;
            return this;
        }

        public final String getOriginalTypeName() {
            return originalTypeName;
        }

        public final void setOriginalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
        }

        @Override
        public final Builder originalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
            return this;
        }

        public final String getPublisherId() {
            return publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final Collection<Integer> getSupportedMajorVersions() {
            if (supportedMajorVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedMajorVersions;
        }

        public final void setSupportedMajorVersions(Collection<Integer> supportedMajorVersions) {
            this.supportedMajorVersions = SupportedMajorVersionsCopier.copy(supportedMajorVersions);
        }

        @Override
        public final Builder supportedMajorVersions(Collection<Integer> supportedMajorVersions) {
            this.supportedMajorVersions = SupportedMajorVersionsCopier.copy(supportedMajorVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedMajorVersions(Integer... supportedMajorVersions) {
            supportedMajorVersions(Arrays.asList(supportedMajorVersions));
            return this;
        }

        @Override
        public RequiredActivatedType build() {
            return new RequiredActivatedType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
