/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGeneratedTemplateRequest extends CloudFormationRequest implements
        ToCopyableBuilder<CreateGeneratedTemplateRequest.Builder, CreateGeneratedTemplateRequest> {
    private static final SdkField<List<ResourceDefinition>> RESOURCES_FIELD = SdkField
            .<List<ResourceDefinition>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(CreateGeneratedTemplateRequest::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GENERATED_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedTemplateName").getter(getter(CreateGeneratedTemplateRequest::generatedTemplateName))
            .setter(setter(Builder::generatedTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateName").build())
            .build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(CreateGeneratedTemplateRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<TemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("TemplateConfiguration")
            .getter(getter(CreateGeneratedTemplateRequest::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(TemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_FIELD,
            GENERATED_TEMPLATE_NAME_FIELD, STACK_NAME_FIELD, TEMPLATE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Resources", RESOURCES_FIELD);
                    put("GeneratedTemplateName", GENERATED_TEMPLATE_NAME_FIELD);
                    put("StackName", STACK_NAME_FIELD);
                    put("TemplateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
                }
            });

    private final List<ResourceDefinition> resources;

    private final String generatedTemplateName;

    private final String stackName;

    private final TemplateConfiguration templateConfiguration;

    private CreateGeneratedTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.resources = builder.resources;
        this.generatedTemplateName = builder.generatedTemplateName;
        this.stackName = builder.stackName;
        this.templateConfiguration = builder.templateConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of resources to be included in the generated template.
     * </p>
     * <p>
     * If no resources are specified,the template will be created without any resources. Resources can be added to the
     * template using the <code>UpdateGeneratedTemplate</code> API action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return An optional list of resources to be included in the generated template.</p>
     *         <p>
     *         If no resources are specified,the template will be created without any resources. Resources can be added
     *         to the template using the <code>UpdateGeneratedTemplate</code> API action.
     */
    public final List<ResourceDefinition> resources() {
        return resources;
    }

    /**
     * <p>
     * The name assigned to the generated template.
     * </p>
     * 
     * @return The name assigned to the generated template.
     */
    public final String generatedTemplateName() {
        return generatedTemplateName;
    }

    /**
     * <p>
     * An optional name or ARN of a stack to use as the base stack for the generated template.
     * </p>
     * 
     * @return An optional name or ARN of a stack to use as the base stack for the generated template.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The configuration details of the generated template, including the <code>DeletionPolicy</code> and
     * <code>UpdateReplacePolicy</code>.
     * </p>
     * 
     * @return The configuration details of the generated template, including the <code>DeletionPolicy</code> and
     *         <code>UpdateReplacePolicy</code>.
     */
    public final TemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(generatedTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGeneratedTemplateRequest)) {
            return false;
        }
        CreateGeneratedTemplateRequest other = (CreateGeneratedTemplateRequest) obj;
        return hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(generatedTemplateName(), other.generatedTemplateName())
                && Objects.equals(stackName(), other.stackName())
                && Objects.equals(templateConfiguration(), other.templateConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGeneratedTemplateRequest").add("Resources", hasResources() ? resources() : null)
                .add("GeneratedTemplateName", generatedTemplateName()).add("StackName", stackName())
                .add("TemplateConfiguration", templateConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "GeneratedTemplateName":
            return Optional.ofNullable(clazz.cast(generatedTemplateName()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "TemplateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGeneratedTemplateRequest, T> g) {
        return obj -> g.apply((CreateGeneratedTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGeneratedTemplateRequest> {
        /**
         * <p>
         * An optional list of resources to be included in the generated template.
         * </p>
         * <p>
         * If no resources are specified,the template will be created without any resources. Resources can be added to
         * the template using the <code>UpdateGeneratedTemplate</code> API action.
         * </p>
         * 
         * @param resources
         *        An optional list of resources to be included in the generated template.</p>
         *        <p>
         *        If no resources are specified,the template will be created without any resources. Resources can be
         *        added to the template using the <code>UpdateGeneratedTemplate</code> API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<ResourceDefinition> resources);

        /**
         * <p>
         * An optional list of resources to be included in the generated template.
         * </p>
         * <p>
         * If no resources are specified,the template will be created without any resources. Resources can be added to
         * the template using the <code>UpdateGeneratedTemplate</code> API action.
         * </p>
         * 
         * @param resources
         *        An optional list of resources to be included in the generated template.</p>
         *        <p>
         *        If no resources are specified,the template will be created without any resources. Resources can be
         *        added to the template using the <code>UpdateGeneratedTemplate</code> API action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(ResourceDefinition... resources);

        /**
         * <p>
         * An optional list of resources to be included in the generated template.
         * </p>
         * <p>
         * If no resources are specified,the template will be created without any resources. Resources can be added to
         * the template using the <code>UpdateGeneratedTemplate</code> API action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceDefinition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.ResourceDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #resources(List<ResourceDefinition>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.ResourceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<ResourceDefinition>)
         */
        Builder resources(Consumer<ResourceDefinition.Builder>... resources);

        /**
         * <p>
         * The name assigned to the generated template.
         * </p>
         * 
         * @param generatedTemplateName
         *        The name assigned to the generated template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTemplateName(String generatedTemplateName);

        /**
         * <p>
         * An optional name or ARN of a stack to use as the base stack for the generated template.
         * </p>
         * 
         * @param stackName
         *        An optional name or ARN of a stack to use as the base stack for the generated template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The configuration details of the generated template, including the <code>DeletionPolicy</code> and
         * <code>UpdateReplacePolicy</code>.
         * </p>
         * 
         * @param templateConfiguration
         *        The configuration details of the generated template, including the <code>DeletionPolicy</code> and
         *        <code>UpdateReplacePolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(TemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The configuration details of the generated template, including the <code>DeletionPolicy</code> and
         * <code>UpdateReplacePolicy</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateConfiguration.Builder} avoiding
         * the need to create one manually via {@link TemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #templateConfiguration(TemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link TemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(TemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(TemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private List<ResourceDefinition> resources = DefaultSdkAutoConstructList.getInstance();

        private String generatedTemplateName;

        private String stackName;

        private TemplateConfiguration templateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGeneratedTemplateRequest model) {
            super(model);
            resources(model.resources);
            generatedTemplateName(model.generatedTemplateName);
            stackName(model.stackName);
            templateConfiguration(model.templateConfiguration);
        }

        public final List<ResourceDefinition.Builder> getResources() {
            List<ResourceDefinition.Builder> result = ResourceDefinitionsCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourceDefinition.BuilderImpl> resources) {
            this.resources = ResourceDefinitionsCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ResourceDefinition> resources) {
            this.resources = ResourceDefinitionsCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ResourceDefinition... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ResourceDefinition.Builder>... resources) {
            resources(Stream.of(resources).map(c -> ResourceDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getGeneratedTemplateName() {
            return generatedTemplateName;
        }

        public final void setGeneratedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
        }

        @Override
        public final Builder generatedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGeneratedTemplateRequest build() {
            return new CreateGeneratedTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
